/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.types;

import com.intellij.lang.javascript.psi.JSDefinitionExpression;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSRecordType;
import com.intellij.lang.javascript.psi.JSResolvedTypeId;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeWithIncompleteSubstitution;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.resolve.JSComplexityAwareRecursionGuard;
import com.intellij.lang.javascript.psi.resolve.JSImportHandlingUtil;
import com.intellij.lang.javascript.psi.resolve.JSTypeEvaluator;
import com.intellij.lang.javascript.psi.stubs.JSImplicitElement;
import com.intellij.lang.javascript.psi.types.JSGenericTypeImpl;
import com.intellij.lang.javascript.psi.types.JSRecordTypeImpl;
import com.intellij.lang.javascript.psi.types.JSTypeBaseImpl;
import com.intellij.lang.javascript.psi.types.JSTypeCastUtil;
import com.intellij.lang.javascript.psi.types.JSTypeImpl;
import com.intellij.lang.javascript.psi.types.TypeScriptTypeParser;
import com.intellij.lang.javascript.psi.types.primitives.JSObjectType;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JSResolvedTypeIdCache {
    @NotNull
    private final ConcurrentMap<JSResolvedTypeId, JSComplexityAwareRecursionGuard.JSComplexityAwareCachedValue<JSRecordType>> myCachedRecordTypes = ContainerUtil.createConcurrentWeakKeySoftValueMap();
    private static final JSComplexityAwareRecursionGuard<Object> ourRecordTypesGuard = new JSComplexityAwareRecursionGuard("js.record.type.guard");
    @NotNull
    private final ConcurrentMap<JSResolvedTypeId, Map<?, ?>> myCachedValues = ContainerUtil.createConcurrentWeakKeySoftValueMap();
    private static final JSComplexityAwareRecursionGuard<Pair<JSResolvedTypeId, Key<?>>> ourValuesGuard = new JSComplexityAwareRecursionGuard("js.values.guard");

    @Nullable
    public <T> T getLocalCachedValue(@NotNull JSResolvedTypeId id, @NotNull Key<T> key, @NotNull Supplier<? extends T> supplier) {
        Map<Key<T>, JSComplexityAwareRecursionGuard.JSComplexityAwareCachedValue<T>> oldMap;
        Map<Object, Object> map;
        if (id == null) {
            JSResolvedTypeIdCache.$$$reportNull$$$0(0);
        }
        if (key == null) {
            JSResolvedTypeIdCache.$$$reportNull$$$0(1);
        }
        if (supplier == null) {
            JSResolvedTypeIdCache.$$$reportNull$$$0(2);
        }
        if ((map = this.getGet(id)) == null && (oldMap = this.putIfAbsent(id, map = ContainerUtil.createConcurrentWeakKeySoftValueMap())) != null) {
            map = oldMap;
        }
        ConcurrentMap finalMap = map;
        Supplier getValueFromCache = () -> (JSComplexityAwareRecursionGuard.JSComplexityAwareCachedValue)finalMap.get(key);
        Consumer cacheNewValue = result2 -> {
            if (result2 != null) {
                finalMap.put(key, result2);
            }
        };
        JSType owner = id.getOwnerType();
        Object value = ourValuesGuard.getCachedValue(Pair.create((Object)id, key), JSTypeEvaluator.getComplexityTracker(), getValueFromCache, cacheNewValue, it -> {
            Object fromSupplier = supplier.get();
            return fromSupplier == owner ? JSTypeBaseImpl.getSelfNoTransformationType() : fromSupplier;
        });
        return (T)(value == JSTypeBaseImpl.getSelfNoTransformationType() ? owner : value);
    }

    private <T> Map<Key<T>, JSComplexityAwareRecursionGuard.JSComplexityAwareCachedValue<T>> getGet(@NotNull JSResolvedTypeId id) {
        if (id == null) {
            JSResolvedTypeIdCache.$$$reportNull$$$0(3);
        }
        return (Map)this.myCachedValues.get(id);
    }

    private <T> Map<Key<T>, JSComplexityAwareRecursionGuard.JSComplexityAwareCachedValue<T>> putIfAbsent(@NotNull JSResolvedTypeId id, @NotNull Map<Key<T>, JSComplexityAwareRecursionGuard.JSComplexityAwareCachedValue<T>> map) {
        if (id == null) {
            JSResolvedTypeIdCache.$$$reportNull$$$0(4);
        }
        if (map == null) {
            JSResolvedTypeIdCache.$$$reportNull$$$0(5);
        }
        return this.myCachedValues.putIfAbsent(id, map);
    }

    @NotNull
    public JSRecordType buildRecordType(@NotNull JSType type, @NotNull PsiElement sourceElement) {
        if (type == null) {
            JSResolvedTypeIdCache.$$$reportNull$$$0(6);
        }
        if (sourceElement == null) {
            JSResolvedTypeIdCache.$$$reportNull$$$0(7);
        }
        JSResolvedTypeId id = type.getResolvedTypeId();
        Supplier getValueFromCache = () -> (JSComplexityAwareRecursionGuard.JSComplexityAwareCachedValue)this.myCachedRecordTypes.get(id);
        Consumer cacheNewValue = it -> {
            if (it != null) {
                this.myCachedRecordTypes.put(id, (JSComplexityAwareRecursionGuard.JSComplexityAwareCachedValue<JSRecordType>)it);
            }
        };
        Object idForPreventingRecursion = JSResolvedTypeIdCache.getIdForPreventingRecursion(type);
        JSRecordType candidate = ourRecordTypesGuard.getCachedValue(idForPreventingRecursion, JSTypeEvaluator.getComplexityTracker(), getValueFromCache, cacheNewValue, it -> JSResolvedTypeIdCache.buildRecordTypeNoCache(type, sourceElement));
        if (candidate == null) {
            return type.isJavaScript() ? JSTypeCastUtil.NO_RECORD_TYPE : new JSRecordTypeImpl(type.getSource(), ContainerUtil.emptyList());
        }
        return JSResolvedTypeIdCache.copyWithStrict(type, candidate);
    }

    @NotNull
    private static Object getIdForPreventingRecursion(@NotNull JSType type) {
        if (type == null) {
            JSResolvedTypeIdCache.$$$reportNull$$$0(8);
        }
        if (type instanceof JSGenericTypeImpl) {
            Pair pair = Pair.create((Object)((JSGenericTypeImpl)type).getType().getResolvedTypeId(), type.getClass());
            if (pair == null) {
                JSResolvedTypeIdCache.$$$reportNull$$$0(9);
            }
            return pair;
        }
        JSResolvedTypeId jSResolvedTypeId = type.getResolvedTypeId();
        if (jSResolvedTypeId == null) {
            JSResolvedTypeIdCache.$$$reportNull$$$0(10);
        }
        return jSResolvedTypeId;
    }

    @NotNull
    private static JSRecordType copyWithStrict(@NotNull JSType original, @NotNull JSRecordType recordType) {
        if (original == null) {
            JSResolvedTypeIdCache.$$$reportNull$$$0(11);
        }
        if (recordType == null) {
            JSResolvedTypeIdCache.$$$reportNull$$$0(12);
        }
        if (recordType == JSTypeCastUtil.NO_RECORD_TYPE) {
            JSRecordType jSRecordType = recordType;
            if (jSRecordType == null) {
                JSResolvedTypeIdCache.$$$reportNull$$$0(13);
            }
            return jSRecordType;
        }
        JSRecordType jSRecordType = (JSRecordType)recordType.copyWithStrict(original.isSourceStrict());
        if (jSRecordType == null) {
            JSResolvedTypeIdCache.$$$reportNull$$$0(14);
        }
        return jSRecordType;
    }

    @NotNull
    private static JSRecordType buildRecordTypeNoCache(@NotNull JSType type, @NotNull PsiElement element) {
        if (type == null) {
            JSResolvedTypeIdCache.$$$reportNull$$$0(15);
        }
        if (element == null) {
            JSResolvedTypeIdCache.$$$reportNull$$$0(16);
        }
        JSType substitute = JSTypeWithIncompleteSubstitution.substituteCompletely((JSType)type);
        ProgressManager.checkCanceled();
        if (substitute != type) {
            JSRecordType jSRecordType = substitute.asRecordType();
            if (jSRecordType == null) {
                JSResolvedTypeIdCache.$$$reportNull$$$0(17);
            }
            return jSRecordType;
        }
        Collection<? extends PsiElement> resolvedElements = JSResolvedTypeIdCache.resolveElementsForRecordType(type, element);
        if (type.isJavaScript() && (type instanceof JSObjectType || resolvedElements.isEmpty() || (type instanceof JSTypeImpl || type instanceof JSGenericTypeImpl && ((JSGenericTypeImpl)type).getType() instanceof JSTypeImpl) && resolvedElements.stream().allMatch(el -> el instanceof JSFunction || el instanceof JSVariable || el instanceof JSDefinitionExpression || el instanceof JSImplicitElement))) {
            JSRecordType jSRecordType = JSTypeCastUtil.NO_RECORD_TYPE;
            if (jSRecordType == null) {
                JSResolvedTypeIdCache.$$$reportNull$$$0(18);
            }
            return jSRecordType;
        }
        JSRecordType jSRecordType = TypeScriptTypeParser.buildResolvedType(resolvedElements, type);
        if (jSRecordType == null) {
            JSResolvedTypeIdCache.$$$reportNull$$$0(19);
        }
        return jSRecordType;
    }

    @NotNull
    private static Collection<? extends PsiElement> resolveElementsForRecordType(@NotNull JSType type, @NotNull PsiElement sourceElement) {
        if (type == null) {
            JSResolvedTypeIdCache.$$$reportNull$$$0(20);
        }
        if (sourceElement == null) {
            JSResolvedTypeIdCache.$$$reportNull$$$0(21);
        }
        Collection<? extends PsiElement> collection = JSImportHandlingUtil.resolveElementsByType(type, sourceElement);
        if (collection == null) {
            JSResolvedTypeIdCache.$$$reportNull$$$0(22);
        }
        return collection;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 9: 
            case 10: 
            case 13: 
            case 14: 
            case 17: 
            case 18: 
            case 19: 
            case 22: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 9: 
            case 10: 
            case 13: 
            case 14: 
            case 17: 
            case 18: 
            case 19: 
            case 22: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "supplier";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "map";
                break;
            }
            case 6: 
            case 8: 
            case 15: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 7: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceElement";
                break;
            }
            case 9: 
            case 10: 
            case 13: 
            case 14: 
            case 17: 
            case 18: 
            case 19: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/types/JSResolvedTypeIdCache";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "original";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "recordType";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/types/JSResolvedTypeIdCache";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getIdForPreventingRecursion";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "copyWithStrict";
                break;
            }
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "buildRecordTypeNoCache";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveElementsForRecordType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getLocalCachedValue";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getGet";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "putIfAbsent";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "buildRecordType";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getIdForPreventingRecursion";
                break;
            }
            case 9: 
            case 10: 
            case 13: 
            case 14: 
            case 17: 
            case 18: 
            case 19: 
            case 22: {
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "copyWithStrict";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "buildRecordTypeNoCache";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "resolveElementsForRecordType";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 9: 
            case 10: 
            case 13: 
            case 14: 
            case 17: 
            case 18: 
            case 19: 
            case 22: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

