/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.stubs.impl;

import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.javascript.JSExtendedLanguagesTokenSetProvider;
import com.intellij.lang.javascript.ecmascript6.TypeScriptUtil;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.stubs.JSEmbeddedContentStub;
import com.intellij.lang.javascript.psi.stubs.TypeScriptModuleStub;
import com.intellij.lang.javascript.psi.stubs.impl.JSFileCachedData;
import com.intellij.lang.javascript.psi.stubs.impl.JSFileStubImpl;
import com.intellij.lang.javascript.types.JSFileElementType;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.psi.stubs.PsiFileStub;
import com.intellij.psi.stubs.StubBase;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.ListIterator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StubTreeUtil {
    @Nullable
    public static StubElement getNextSibling(StubElement<?> stub) {
        return StubTreeUtil.getNextSibling(stub, null);
    }

    @Nullable
    public static StubElement getNextSibling(StubElement<?> stub, @Nullable TokenSet filter) {
        ListIterator<StubElement> iterator = StubTreeUtil.getIteratorBeforeElement(stub);
        iterator.next();
        while (iterator.hasNext()) {
            StubElement next = iterator.next();
            if (!StubTreeUtil.isAcceptable(filter, next)) continue;
            return next;
        }
        return null;
    }

    @NotNull
    private static ListIterator<StubElement> getIteratorBeforeElement(@NotNull StubElement<?> stub) {
        StubElement parentStub;
        List children;
        if (stub == null) {
            StubTreeUtil.$$$reportNull$$$0(0);
        }
        if (StubTreeUtil.areTooManyChildren(children = (parentStub = stub.getParentStub()).getChildrenStubs())) {
            int indexOfStub = Collections.binarySearch(children, stub, Comparator.comparing(stubElement -> ((StubBase)stubElement).getStubId()));
            assert (indexOfStub >= 0) : "Can't find stub in it's parent children";
            ListIterator<StubElement> listIterator = children.listIterator(indexOfStub);
            if (listIterator == null) {
                StubTreeUtil.$$$reportNull$$$0(1);
            }
            return listIterator;
        }
        ListIterator<StubElement> listIterator = children.listIterator();
        while (listIterator.hasNext()) {
            StubElement next = (StubElement)listIterator.next();
            if (next != stub) continue;
            listIterator.previous();
            ListIterator<StubElement> listIterator2 = listIterator;
            if (listIterator2 == null) {
                StubTreeUtil.$$$reportNull$$$0(2);
            }
            return listIterator2;
        }
        throw new AssertionError((Object)"Can't find stub in it's parent children");
    }

    private static boolean areTooManyChildren(List<StubElement> children) {
        return children.size() > 10;
    }

    private static boolean isAcceptable(@Nullable TokenSet filter, @NotNull StubElement child) {
        if (child == null) {
            StubTreeUtil.$$$reportNull$$$0(3);
        }
        return filter == null || filter.contains((IElementType)child.getStubType());
    }

    @Nullable
    public static StubElement getPrevSibling(StubElement<?> stub) {
        ListIterator<StubElement> iterator = StubTreeUtil.getIteratorBeforeElement(stub);
        return iterator.hasPrevious() ? iterator.previous() : null;
    }

    @Nullable
    public static Language getJSLanguage(@NotNull StubElement<?> stub) {
        if (stub == null) {
            StubTreeUtil.$$$reportNull$$$0(4);
        }
        for (StubElement parent = stub; parent != null; parent = parent.getParentStub()) {
            stub = parent;
        }
        return stub instanceof JSFileStubImpl ? ((JSFileStubImpl)stub).getLanguage() : null;
    }

    @Nullable
    public static StubElement findChildStubByType(@NotNull StubElement<?> parent, @NotNull TokenSet types2) {
        if (parent == null) {
            StubTreeUtil.$$$reportNull$$$0(5);
        }
        if (types2 == null) {
            StubTreeUtil.$$$reportNull$$$0(6);
        }
        List children = parent.getChildrenStubs();
        for (StubElement child : children) {
            if (!types2.contains((IElementType)child.getStubType())) continue;
            return child;
        }
        return null;
    }

    public static boolean isFromGlobalNamespace(StubElement startElement) {
        for (StubElement parentStub = startElement.getParentStub(); parentStub != null; parentStub = parentStub.getParentStub()) {
            if (parentStub instanceof PsiFileStub) {
                if (parentStub instanceof JSFileStubImpl) {
                    JSFileStubImpl fileStub = (JSFileStubImpl)parentStub;
                    JSFileCachedData data = fileStub.getCachedData();
                    if (data == null) {
                        return true;
                    }
                    JSFile.ModuleStatus status = data.getModuleStatus();
                    return status != JSFile.ModuleStatus.ES6 && status != JSFile.ModuleStatus.COMMONJS;
                }
                return true;
            }
            if (parentStub instanceof TypeScriptModuleStub) {
                StubElement possibleFileElement = parentStub.getParentStub();
                if (!(possibleFileElement instanceof JSFileStubImpl)) continue;
                String name = ((TypeScriptModuleStub)parentStub).getName();
                return TypeScriptUtil.convertToExternalModuleText(name) == null;
            }
            if (!(parentStub instanceof JSEmbeddedContentStub)) continue;
            IStubElementType type = parentStub.getStubType();
            return !JSExtendedLanguagesTokenSetProvider.MODULE_EMBEDDED_CONTENTS.contains((IElementType)type);
        }
        return true;
    }

    public static boolean checkParentStubShouldCreate(@NotNull ASTNode node) {
        ASTNode owner;
        if (node == null) {
            StubTreeUtil.$$$reportNull$$$0(7);
        }
        if ((owner = node.getTreeParent()) != null) {
            IElementType ownerType = owner.getElementType();
            if (ownerType instanceof IStubElementType) {
                return ((IStubElementType)ownerType).shouldCreateStub(owner);
            }
            if (ownerType instanceof JSFileElementType) {
                return true;
            }
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stub";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/stubs/impl/StubTreeUtil";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "child";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "types";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/stubs/impl/StubTreeUtil";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getIteratorBeforeElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getIteratorBeforeElement";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isAcceptable";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getJSLanguage";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "findChildStubByType";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "checkParentStubShouldCreate";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

