/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi;

import com.intellij.lang.javascript.psi.JSNamespace;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.resolve.JSEvaluateContext;
import com.intellij.lang.javascript.psi.resolve.JSEvaluationResultContext;
import com.intellij.lang.javascript.psi.resolve.JSSimpleTypeProcessor;
import com.intellij.lang.javascript.psi.resolve.JSTypeProcessor;
import com.intellij.psi.PsiElement;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ProcessingContext;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ComparatorUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JSTypeEvaluationResult {
    @Nullable
    List<JSTypeEvaluationResultElement> myResults;

    public void applyToProcessor(@NotNull JSTypeProcessor processor) {
        if (processor == null) {
            JSTypeEvaluationResult.$$$reportNull$$$0(0);
        }
        if (this.myResults == null) {
            return;
        }
        for (JSTypeEvaluationResultElement result2 : this.myResults) {
            JSEvaluateContext evaluateContext = JSEvaluateContext.fromEvaluationResultContext(result2.getEvaluationContext());
            if (result2.getType() != null) {
                processor.process(result2.getType(), evaluateContext, result2.getSource());
                continue;
            }
            if (result2.getNamespace() != null) {
                processor.processNamespace(result2.getNamespace(), evaluateContext, result2.getSource());
                continue;
            }
            PsiElement source = result2.getSource();
            assert (source != null);
            if (result2.myIsForUnknownElement) {
                processor.setUnknownElement(source);
                continue;
            }
            processor.processResolvedElement(result2.getSource(), evaluateContext);
        }
    }

    @Contract(value="null, null, null, _, _ -> fail")
    public void addResultElement(@Nullable JSType type, @Nullable JSNamespace namespace, @Nullable PsiElement source, boolean isForUnknownElement, @Nullable JSEvaluationResultContext context) {
        if (this.myResults == null) {
            this.myResults = new SmartList();
        }
        JSEvaluationResultContext notNullContext = (JSEvaluationResultContext)ObjectUtils.notNull((Object)context, (Object)JSEvaluationResultContext.EMPTY);
        if (type != null) {
            List types2 = ContainerUtil.mapNotNull(this.myResults, element -> element.getType());
            List<JSType> newTypes = JSTypeUtils.addPossibleOption(types2, type);
            for (JSType newType : newTypes) {
                this.myResults.add(new JSTypeEvaluationResultElement(newType, namespace, source, isForUnknownElement, notNullContext));
            }
            return;
        }
        JSTypeEvaluationResultElement e = new JSTypeEvaluationResultElement(null, namespace, source, isForUnknownElement, notNullContext);
        for (JSTypeEvaluationResultElement result2 : this.myResults) {
            if (!e.isEquivalentTo(result2)) continue;
            return;
        }
        this.myResults.add(e);
    }

    @NotNull
    public List<JSTypeEvaluationResultElement> getResults() {
        List<JSTypeEvaluationResultElement> list2 = this.myResults != null ? this.myResults : Collections.emptyList();
        if (list2 == null) {
            JSTypeEvaluationResult.$$$reportNull$$$0(1);
        }
        return list2;
    }

    @Deprecated
    @kotlin.Deprecated(message="Use applyToProcessor instead")
    @ApiStatus.ScheduledForRemoval(inVersion="2020.2")
    @Nullable
    public JSType getType() {
        JSSimpleTypeProcessor processor = new JSSimpleTypeProcessor();
        this.applyToProcessor(processor);
        return processor.getType();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/JSTypeEvaluationResult";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/JSTypeEvaluationResult";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getResults";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "applyToProcessor";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static final class JSTypeEvaluationResultElement {
        @Nullable
        private final JSType myType;
        @Nullable
        private final JSNamespace myNamespace;
        @Nullable
        private final PsiElement mySource;
        @NotNull
        private final JSEvaluationResultContext myEvaluationContext;
        private final boolean myIsForUnknownElement;

        public JSTypeEvaluationResultElement(@Nullable JSType type, @Nullable JSNamespace namespace, @Nullable PsiElement source, boolean isForUnknownElement, @NotNull JSEvaluationResultContext evaluationContext) {
            if (evaluationContext == null) {
                JSTypeEvaluationResultElement.$$$reportNull$$$0(0);
            }
            assert (type != null || namespace != null || source != null);
            this.myType = type;
            this.myNamespace = namespace;
            this.mySource = source;
            this.myIsForUnknownElement = isForUnknownElement;
            this.myEvaluationContext = evaluationContext;
        }

        @Nullable
        public JSType getType() {
            return this.myType;
        }

        @Nullable
        public JSNamespace getNamespace() {
            return this.myNamespace;
        }

        @Nullable
        public PsiElement getSource() {
            return this.mySource;
        }

        public boolean isForUnknownElement() {
            return this.myIsForUnknownElement;
        }

        @NotNull
        public JSEvaluationResultContext getEvaluationContext() {
            JSEvaluationResultContext jSEvaluationResultContext = this.myEvaluationContext;
            if (jSEvaluationResultContext == null) {
                JSTypeEvaluationResultElement.$$$reportNull$$$0(1);
            }
            return jSEvaluationResultContext;
        }

        public boolean isEquivalentTo(@NotNull JSTypeEvaluationResultElement other) {
            if (other == null) {
                JSTypeEvaluationResultElement.$$$reportNull$$$0(2);
            }
            if (!ComparatorUtil.equalsNullable((Object)this.mySource, (Object)other.mySource)) {
                return false;
            }
            if (this.myType == null ? other.myType != null : other.myType == null || !this.myType.isEquivalentTo(other.myType, new ProcessingContext(), false)) {
                return false;
            }
            if (this.myNamespace == null ? other.myNamespace != null : other.myNamespace == null || !this.myNamespace.isEquivalentTo((JSType)other.myNamespace, new ProcessingContext())) {
                return false;
            }
            if (this.myIsForUnknownElement != other.myIsForUnknownElement) {
                return false;
            }
            return this.myEvaluationContext.isEquivalentTo(other.myEvaluationContext);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "evaluationContext";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/javascript/psi/JSTypeEvaluationResult$JSTypeEvaluationResultElement";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "other";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/javascript/psi/JSTypeEvaluationResult$JSTypeEvaluationResultElement";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getEvaluationContext";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "isEquivalentTo";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

