/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.inspections;

import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.inspections.JSInspection;
import com.intellij.lang.javascript.intentions.ES6CoolRefactoring;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSElementVisitor;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.JSParenthesizedExpression;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import org.jetbrains.annotations.NotNull;

public class ES6BindWithArrowFunctionInspection
extends JSInspection
implements ES6CoolRefactoring {
    @Override
    @NotNull
    protected PsiElementVisitor createVisitor(final ProblemsHolder holder, LocalInspectionToolSession session) {
        return new JSElementVisitor(){

            public void visitJSFunctionExpression(@NotNull JSFunctionExpression function2) {
                Pair pair;
                if (function2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (!ES6CoolRefactoring.isEs6Compatible((PsiElement)function2)) {
                    return;
                }
                boolean anonymousArrow = function2.isArrowFunction();
                if (anonymousArrow && (pair = ES6BindWithArrowFunctionInspection.checkForBindingFunctions(function2)) != null && pair.getFirst() != null && pair.getSecond() != null) {
                    JSExpression expression = ((JSCallExpression)pair.getSecond()).getMethodExpression();
                    holder.registerProblem((PsiElement)(expression instanceof JSReferenceExpression ? ((JSReferenceExpression)expression).getReferenceNameElement() : expression), JavaScriptBundle.message((String)"js.suspicious.bind.with.arrow.function", (Object[])new Object[0]), new LocalQuickFix[0]);
                }
                super.visitJSFunctionExpression(function2);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "function", "com/intellij/lang/javascript/inspections/ES6BindWithArrowFunctionInspection$1", "visitJSFunctionExpression"));
            }
        };
    }

    private static Pair<String, JSCallExpression> checkForBindingFunctions(@NotNull JSFunctionExpression function2) {
        JSCallExpression callExpression;
        JSExpression[] arguments;
        PsiElement parent;
        if (function2 == null) {
            ES6BindWithArrowFunctionInspection.$$$reportNull$$$0(0);
        }
        if ((parent = function2.getParent()) instanceof JSParenthesizedExpression) {
            parent = parent.getParent();
        }
        if (parent instanceof JSReferenceExpression && parent.getParent() instanceof JSCallExpression && "bind".equals(ES6BindWithArrowFunctionInspection.getCallExpressionName((JSCallExpression)parent.getParent())) && (arguments = (callExpression = (JSCallExpression)parent.getParent()).getArguments()).length == 1) {
            return Pair.create((Object)"bind", (Object)callExpression);
        }
        return null;
    }

    private static String getCallExpressionName(@NotNull JSCallExpression call) {
        if (call == null) {
            ES6BindWithArrowFunctionInspection.$$$reportNull$$$0(1);
        }
        if (call.getMethodExpression() instanceof JSReferenceExpression) {
            return ((JSReferenceExpression)call.getMethodExpression()).getReferenceName();
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "call";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/javascript/inspections/ES6BindWithArrowFunctionInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "checkForBindingFunctions";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getCallExpressionName";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

