/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.highlighting;

import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.psi.JSDefinitionExpression;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionItem;
import com.intellij.lang.javascript.psi.JSPsiElementBase;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeInfoOwner;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeListOwner;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.types.JSAnyType;
import com.intellij.lang.javascript.psi.types.JSFunctionTypeImpl;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import java.util.Arrays;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSMethodToImplement {
    private final boolean myIsAbstractMethod;
    private final boolean myIsGetAccessor;
    private final boolean myIsSetAccessor;
    private final boolean myIsGenerator;
    private final boolean myIsAsync;
    private final boolean myIsFunction;
    private final String myBaseClassName;
    private final String myParameterList;
    private final JSType myReturnType;
    private final String myName;
    private final MethodKey myKey;
    private final SmartPsiElementPointer<JSPsiElementBase> myElementPointer;

    public boolean isAbstractMethod() {
        return this.myIsAbstractMethod;
    }

    public String getBaseClassName() {
        return this.myBaseClassName;
    }

    public String getParameterList() {
        return this.myParameterList;
    }

    public JSType getReturnType() {
        return this.myReturnType;
    }

    public String getName() {
        return this.myName;
    }

    public MethodKey getKey() {
        return this.myKey;
    }

    public JSPsiElementBase getElement() {
        return (JSPsiElementBase)this.myElementPointer.getElement();
    }

    public boolean isGetAccessor() {
        return this.myIsGetAccessor;
    }

    public boolean isSetAccessor() {
        return this.myIsSetAccessor;
    }

    public boolean isGenerator() {
        return this.myIsGenerator;
    }

    public boolean isAsync() {
        return this.myIsAsync;
    }

    public boolean isFunction() {
        return this.myIsFunction;
    }

    public JSMethodToImplement(JSPsiElementBase member, boolean isAbstractMethod, String baseClassName) {
        JSType memberType = member instanceof JSFunctionItem ? null : JSMethodToImplement.getMemberType(member);
        this.myIsFunction = member instanceof JSFunctionItem || member instanceof JSDefinitionExpression || memberType instanceof JSFunctionTypeImpl;
        this.myIsAbstractMethod = isAbstractMethod;
        this.myBaseClassName = baseClassName;
        this.myParameterList = memberType instanceof JSFunctionTypeImpl ? JSMethodToImplement.buildParameterList((JSFunctionTypeImpl)memberType) : (this.myIsFunction ? JSMethodToImplement.buildParameterList(member) : null);
        this.myReturnType = memberType instanceof JSFunctionTypeImpl ? ((JSFunctionTypeImpl)memberType).getReturnType() : this.getMemberTypeOrReturnType(member);
        this.myName = member.getName();
        this.myElementPointer = SmartPointerManager.createPointer((PsiElement)member);
        this.myIsGetAccessor = this.myIsFunction && JSMethodToImplement.isGetAccessor((JSElement)member);
        this.myIsSetAccessor = this.myIsFunction && JSMethodToImplement.isSetAccessor((JSElement)member);
        this.myIsGenerator = member instanceof JSFunction && ((JSFunction)member).isGenerator();
        this.myIsAsync = member instanceof JSFunction && JSPsiImplUtils.hasModifier((JSAttributeListOwner)((JSFunction)member), JSAttributeList.ModifierType.ASYNC);
        this.myKey = MethodKey.create((JSElement)member);
    }

    @Nullable
    private JSType getMemberTypeOrReturnType(JSPsiElementBase member) {
        if (this.myIsFunction) {
            return JSMethodToImplement.getReturnType(member);
        }
        return JSMethodToImplement.getMemberType(member);
    }

    private static JSType getMemberType(JSPsiElementBase member) {
        return member instanceof JSTypeInfoOwner ? ((JSTypeInfoOwner)member).getJSType() : JSAnyType.get((PsiElement)member, DialectDetector.isTypeScript((PsiElement)member));
    }

    public static boolean isSetAccessor(JSElement member) {
        return member instanceof JSFunctionItem && ((JSFunctionItem)member).isSetProperty();
    }

    public static boolean isGetAccessor(JSElement member) {
        return member instanceof JSFunctionItem && ((JSFunctionItem)member).isGetProperty();
    }

    private static String buildParameterList(@NotNull JSFunctionTypeImpl functionType) {
        if (functionType == null) {
            JSMethodToImplement.$$$reportNull$$$0(0);
        }
        StringBuilder builder = new StringBuilder("(");
        Ref i = Ref.create((Object)0);
        builder.append(functionType.getParameters().stream().map(p -> {
            String name = "p" + i.get();
            i.set((Object)((Integer)i.get() + 1));
            return (p.isRest() ? "..." : "") + name;
        }).reduce((p1, p2) -> p1 + ", " + p2).orElse(""));
        builder.append(")");
        return builder.toString();
    }

    private static String buildParameterList(JSPsiElementBase member) {
        JSFunctionItem function2 = JSPsiImplUtils.getPossibleFunctionItem((PsiElement)member);
        StringBuilder builder = new StringBuilder("(");
        if (function2 != null) {
            builder.append(Arrays.stream(function2.getParameters()).map(p -> (p.isRest() ? "..." : "") + p.getName()).reduce((p1, p2) -> p1 + ", " + p2).orElse(""));
        }
        builder.append(")");
        return builder.toString();
    }

    @Nullable
    private static JSType getReturnType(JSPsiElementBase member) {
        return member instanceof JSFunctionItem ? ((JSFunctionItem)member).getReturnType() : null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "functionType", "com/intellij/lang/javascript/highlighting/JSMethodToImplement", "buildParameterList"));
    }

    public static class MethodKey {
        String name;
        boolean isGetter;
        boolean isSetter;

        public String getName() {
            return this.name;
        }

        public static MethodKey create(JSElement element) {
            return new MethodKey(element.getName(), JSMethodToImplement.isGetAccessor(element), JSMethodToImplement.isSetAccessor(element));
        }

        private MethodKey(String name, boolean isGetter, boolean isSetter) {
            this.name = name;
            this.isGetter = isGetter;
            this.isSetter = isSetter;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            MethodKey key = (MethodKey)o;
            return this.isGetter == key.isGetter && this.isSetter == key.isSetter && Objects.equals(this.name, key.name);
        }

        public int hashCode() {
            return Objects.hash(this.name, this.isGetter, this.isSetter);
        }

        public String toString() {
            return this.name;
        }
    }
}

