/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.frameworks.react;

import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.LegacyCompletionContributor;
import com.intellij.codeInsight.completion.PrefixMatcher;
import com.intellij.codeInsight.completion.XmlTagInsertHandler;
import com.intellij.codeInsight.editorActions.XmlTagNameSynchronizer;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.lang.ecmascript6.psi.ES6ExportSpecifier;
import com.intellij.lang.ecmascript6.psi.JSExportAssignment;
import com.intellij.lang.ecmascript6.psi.impl.ES6CreateImportUtil;
import com.intellij.lang.ecmascript6.psi.impl.ES6ImportPsiUtil;
import com.intellij.lang.ecmascript6.resolve.ES6PsiUtil;
import com.intellij.lang.ecmascript6.resolve.JSFileReferencesUtil;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.JSLanguageDialect;
import com.intellij.lang.javascript.completion.JSImportCompletionUtil;
import com.intellij.lang.javascript.dialects.JSDialectSpecificHandlersFactory;
import com.intellij.lang.javascript.ecmascript6.TypeScriptUtil;
import com.intellij.lang.javascript.frameworks.react.ReactXmlExtension;
import com.intellij.lang.javascript.frameworks.react.references.JSXNamespaceReference;
import com.intellij.lang.javascript.frameworks.react.references.JSXResolveUtil;
import com.intellij.lang.javascript.frameworks.react.tsx.TypeScriptReactComponentUtil;
import com.intellij.lang.javascript.modules.JSImportPlaceInfo;
import com.intellij.lang.javascript.psi.JSCallLikeExpression;
import com.intellij.lang.javascript.psi.JSDefinitionExpression;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSInitializerOwner;
import com.intellij.lang.javascript.psi.JSNamedElement;
import com.intellij.lang.javascript.psi.JSPsiElementBase;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.resolve.CompletionResultSink;
import com.intellij.lang.javascript.psi.resolve.JSClassResolver;
import com.intellij.lang.javascript.psi.resolve.JSResolveResult;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.resolve.JSTypeEvaluator;
import com.intellij.lang.javascript.psi.resolve.QualifiedItemProcessor;
import com.intellij.lang.javascript.psi.resolve.ResolveProcessor;
import com.intellij.lang.javascript.psi.resolve.ResultSink;
import com.intellij.lang.javascript.psi.resolve.processors.JSModuleElementsResolveProcessor;
import com.intellij.lang.javascript.psi.resolve.processors.JSResolveProcessor;
import com.intellij.lang.javascript.psi.types.JSGenericTypeImpl;
import com.intellij.lang.javascript.psi.types.JSTypeImpl;
import com.intellij.lang.javascript.psi.types.evaluable.JSApplyCallType;
import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.ResolveState;
import com.intellij.psi.impl.source.xml.TagNameReference;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.search.DelegatingGlobalSearchScope;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.Consumer;
import com.intellij.util.PairProcessor;
import com.intellij.util.Processor;
import com.intellij.util.ThreeState;
import com.intellij.util.containers.ContainerUtil;
import icons.JavaScriptLanguageIcons;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ReactComponentCompletionContributor
extends CompletionContributor {
    public void fillCompletionVariants(@NotNull CompletionParameters parameters, @NotNull CompletionResultSet result2) {
        String prefix;
        boolean needComponents;
        if (parameters == null) {
            ReactComponentCompletionContributor.$$$reportNull$$$0(0);
        }
        if (result2 == null) {
            ReactComponentCompletionContributor.$$$reportNull$$$0(1);
        }
        boolean bl = needComponents = StringUtil.isEmpty((String)(prefix = result2.getPrefixMatcher().getPrefix())) || JSXResolveUtil.isComponentName(prefix);
        if (!needComponents) {
            return;
        }
        LegacyCompletionContributor.processReferences((CompletionParameters)parameters, (CompletionResultSet)result2, (reference, set) -> {
            if (!(reference instanceof TagNameReference)) {
                return;
            }
            TagNameReference tagNameReference = (TagNameReference)reference;
            PsiElement element = tagNameReference.getElement();
            if (element instanceof XmlTag && tagNameReference.isStartTagFlag() && !ReactXmlExtension.nonJsxTag((XmlTag)element)) {
                HashSet<String> collectedNames = new HashSet<String>();
                XmlTag tag = (XmlTag)element;
                boolean isTypeScript = DialectDetector.isTypeScript(element);
                if (ReactXmlExtension.hasQualifiedName(tag)) {
                    ReactComponentCompletionContributor.addExportedComponentForNamespace(result2, tag, collectedNames, isTypeScript);
                } else {
                    ReactComponentCompletionContributor.addLocalVariants(result2, tag, collectedNames);
                    ReactComponentCompletionContributor.addExportedComponents(result2, tag, collectedNames, isTypeScript);
                }
            }
        });
    }

    private static void addExportedComponentForNamespace(@NotNull CompletionResultSet result2, @NotNull XmlTag tag, Set<String> collectedNames, boolean isStrict) {
        JSXNamespaceReference reference;
        if (result2 == null) {
            ReactComponentCompletionContributor.$$$reportNull$$$0(2);
        }
        if (tag == null) {
            ReactComponentCompletionContributor.$$$reportNull$$$0(3);
        }
        if ((reference = ReactXmlExtension.getQualifierReference(tag)) == null) {
            return;
        }
        Collection<PsiElement> elements = JSXResolveUtil.expandReferenceElements((PsiElement)tag, reference);
        if (elements.isEmpty()) {
            return;
        }
        JSResolveProcessor processor = ReactComponentCompletionContributor.createCompletionProcessor(result2, collectedNames);
        ReactComponentCompletionContributor.processNestedComponentInScopes(tag, reference, processor, elements);
        if (!isStrict) {
            ReactComponentCompletionContributor.processNestedComponentsFromIndex(tag, processor);
        }
    }

    private static void processNestedComponentsFromIndex(@NotNull XmlTag tag, @NotNull JSResolveProcessor processor) {
        GlobalSearchScope scope;
        if (tag == null) {
            ReactComponentCompletionContributor.$$$reportNull$$$0(4);
        }
        if (processor == null) {
            ReactComponentCompletionContributor.$$$reportNull$$$0(5);
        }
        if ((scope = ReactXmlExtension.getResolveScopeForIndexProcessing(tag, true)) == null) {
            return;
        }
        String parentQualifier = tag.getNamespacePrefix();
        if (!StringUtil.isEmpty((String)parentQualifier)) {
            JSClassResolver.getInstance().processNamespaceMembers(parentQualifier, scope, (Processor<JSPsiElementBase>)((Processor)el -> processor.execute((PsiElement)el, ResolveState.initial())));
        }
    }

    private static void processNestedComponentInScopes(@NotNull XmlTag tag, @NotNull JSXNamespaceReference prevRef, @NotNull PsiScopeProcessor processor, @NotNull Collection<PsiElement> elements) {
        List<PsiElement> results;
        if (tag == null) {
            ReactComponentCompletionContributor.$$$reportNull$$$0(6);
        }
        if (prevRef == null) {
            ReactComponentCompletionContributor.$$$reportNull$$$0(7);
        }
        if (processor == null) {
            ReactComponentCompletionContributor.$$$reportNull$$$0(8);
        }
        if (elements == null) {
            ReactComponentCompletionContributor.$$$reportNull$$$0(9);
        }
        JSModuleElementsResolveProcessor moduleProcessor = new JSModuleElementsResolveProcessor(processor);
        QualifiedItemProcessor<?> localProcessor = ReactComponentCompletionContributor.createQualifiedLocalProcessor(tag, prevRef);
        for (PsiElement element : elements) {
            if (!ES6PsiUtil.isExportScope(element)) {
                if (element instanceof JSClass) {
                    element.processDeclarations(localProcessor, ResolveState.initial(), element, (PsiElement)tag);
                    continue;
                }
                JSTypeEvaluator.evaluateExpressionOrElementTypes(tag.getContainingFile(), localProcessor, element);
                continue;
            }
            if (ES6PsiUtil.processExportDeclarationInScope((JSElement)element, moduleProcessor)) continue;
            break;
        }
        if ((results = localProcessor.getResults()) == null) {
            return;
        }
        for (PsiElement el : results) {
            if (processor.execute(el, ResolveState.initial())) continue;
            return;
        }
    }

    @NotNull
    private static QualifiedItemProcessor<?> createQualifiedLocalProcessor(@NotNull XmlTag tag, @NotNull JSXNamespaceReference prevRef) {
        if (tag == null) {
            ReactComponentCompletionContributor.$$$reportNull$$$0(10);
        }
        if (prevRef == null) {
            ReactComponentCompletionContributor.$$$reportNull$$$0(11);
        }
        QualifiedItemProcessor<? extends ResultSink> localProcessor = JSDialectSpecificHandlersFactory.forElement((PsiElement)tag).createCompletionItemProcessor(new CompletionResultSink((PsiElement)tag, null), tag.getContainingFile());
        localProcessor.setLocalResolve(true);
        localProcessor.setSkipImplicitDeclarations(true);
        localProcessor.getAccessibilityProcessingHandler().setProcessStatics(!prevRef.isThisQualifier());
        QualifiedItemProcessor<? extends ResultSink> qualifiedItemProcessor = localProcessor;
        if (qualifiedItemProcessor == null) {
            ReactComponentCompletionContributor.$$$reportNull$$$0(12);
        }
        return qualifiedItemProcessor;
    }

    private static void addExportedComponents(@NotNull CompletionResultSet result2, @NotNull XmlTag tag, @NotNull Set<String> localNames, boolean isTypeScript) {
        if (result2 == null) {
            ReactComponentCompletionContributor.$$$reportNull$$$0(13);
        }
        if (tag == null) {
            ReactComponentCompletionContributor.$$$reportNull$$$0(14);
        }
        if (localNames == null) {
            ReactComponentCompletionContributor.$$$reportNull$$$0(15);
        }
        Project project = tag.getProject();
        GlobalSearchScope scope = ReactComponentCompletionContributor.createScope((PsiElement)tag, project);
        PrefixMatcher prefixMatcher = result2.getPrefixMatcher();
        JSImportPlaceInfo info = new JSImportPlaceInfo((PsiElement)tag);
        Predicate<String> keyFilter = name -> JSXResolveUtil.isComponentName(name) && prefixMatcher.prefixMatches(name) && !localNames.contains(name);
        JSImportCompletionUtil.processExportedES6Elements(info, JSImportCompletionUtil.ImportContext.SIMPLE, keyFilter, key -> true, scope, (PairProcessor<Collection<JSElement>, String>)((PairProcessor)(elements, name) -> {
            JSElement jsElement;
            Iterator iterator = elements.iterator();
            while (iterator.hasNext() && !ReactComponentCompletionContributor.addElement(result2, tag, name, jsElement = (JSElement)iterator.next())) {
            }
            return true;
        }));
        ReactComponentCompletionContributor.addFragmentComponent(result2, tag, localNames, isTypeScript);
    }

    private static boolean addElement(@NotNull CompletionResultSet result2, @NotNull XmlTag tag, String name, JSElement element) {
        if (result2 == null) {
            ReactComponentCompletionContributor.$$$reportNull$$$0(16);
        }
        if (tag == null) {
            ReactComponentCompletionContributor.$$$reportNull$$$0(17);
        }
        if (element instanceof JSClass) {
            JSClass jsClass = (JSClass)element;
            ThreeState state = ReactXmlExtension.isAcceptableClassComponent(jsClass);
            switch (state) {
                case YES: {
                    ReactComponentCompletionContributor.addComponentWithImportInsertHandler(result2, tag, (PsiElement)jsClass, name);
                    return true;
                }
                case NO: {
                    return false;
                }
            }
            if (ReactXmlExtension.checkClassHierarchyHasComponent(jsClass)) {
                ReactComponentCompletionContributor.addComponentWithImportInsertHandler(result2, tag, (PsiElement)jsClass, name);
                return true;
            }
            return false;
        }
        if (!DialectDetector.isJSX((PsiElement)element)) {
            if (TypeScriptUtil.isDefinitionFile(element.getContainingFile())) {
                return ReactComponentCompletionContributor.addDtsFileElement(result2, tag, element, name);
            }
            return false;
        }
        return ReactComponentCompletionContributor.addJSXFileElement(result2, tag, element, name);
    }

    private static boolean addJSXFileElement(@NotNull CompletionResultSet result2, @NotNull XmlTag tag, @NotNull JSElement element, @NotNull String name) {
        if (result2 == null) {
            ReactComponentCompletionContributor.$$$reportNull$$$0(18);
        }
        if (tag == null) {
            ReactComponentCompletionContributor.$$$reportNull$$$0(19);
        }
        if (element == null) {
            ReactComponentCompletionContributor.$$$reportNull$$$0(20);
        }
        if (name == null) {
            ReactComponentCompletionContributor.$$$reportNull$$$0(21);
        }
        if (element instanceof JSExportAssignment) {
            String originalName = ES6ImportPsiUtil.getExportedElementName(element);
            boolean passExplicitElement = !Objects.equals(originalName, name);
            ReactComponentCompletionContributor.addLookupItemWithImportInsertHandler(result2, tag, (PsiElement)element, name, true, passExplicitElement);
            return !passExplicitElement;
        }
        if (element instanceof JSVariable) {
            if (ReactComponentCompletionContributor.isAcceptableVariable((JSVariable)element)) {
                ReactComponentCompletionContributor.addComponentWithImportInsertHandler(result2, tag, (PsiElement)element, name);
                return true;
            }
            return false;
        }
        if (element instanceof ES6ExportSpecifier && ((ES6ExportSpecifier)element).getAlias() != null) {
            if (tag.getContainingFile() == element.getContainingFile()) {
                return false;
            }
            ReactComponentCompletionContributor.addComponentWithImportInsertHandler(result2, tag, (PsiElement)element, name);
            return true;
        }
        if (element instanceof JSFunction && ReactXmlExtension.isFunctionComponentBySignature((JSFunction)element)) {
            ReactComponentCompletionContributor.addComponentWithImportInsertHandler(result2, tag, (PsiElement)element, name);
            return true;
        }
        return false;
    }

    private static boolean addDtsFileElement(@NotNull CompletionResultSet result2, @NotNull XmlTag tag, @NotNull JSElement element, @NotNull String name) {
        if (result2 == null) {
            ReactComponentCompletionContributor.$$$reportNull$$$0(22);
        }
        if (tag == null) {
            ReactComponentCompletionContributor.$$$reportNull$$$0(23);
        }
        if (element == null) {
            ReactComponentCompletionContributor.$$$reportNull$$$0(24);
        }
        if (name == null) {
            ReactComponentCompletionContributor.$$$reportNull$$$0(25);
        }
        if (element instanceof JSVariable && ReactComponentCompletionContributor.isAcceptableVariableType(((JSVariable)element).getJSType())) {
            ReactComponentCompletionContributor.addComponentWithImportInsertHandler(result2, tag, (PsiElement)element, name);
            return true;
        }
        return false;
    }

    private static boolean isAcceptableVariable(@NotNull JSVariable element) {
        JSType variableType;
        if (element == null) {
            ReactComponentCompletionContributor.$$$reportNull$$$0(26);
        }
        if (ReactComponentCompletionContributor.isAcceptableVariableType(variableType = element.getJSType())) {
            return true;
        }
        JSExpression expression = JSPsiImplUtils.getRightmostInitializer((JSInitializerOwner)element);
        if (expression instanceof JSFunction && ReactXmlExtension.isFunctionComponentBySignature((JSFunction)expression)) {
            return true;
        }
        return expression instanceof JSCallLikeExpression || variableType instanceof JSApplyCallType;
    }

    private static boolean isAcceptableVariableType(@Nullable JSType variableType) {
        if (variableType instanceof JSGenericTypeImpl) {
            variableType = ((JSGenericTypeImpl)variableType).getType();
        }
        if (variableType instanceof JSTypeImpl) {
            String text = variableType.getTypeText();
            int lastDot = text.lastIndexOf(".");
            if (lastDot > 0 && text.length() > lastDot + 1) {
                text = text.substring(lastDot + 1);
            }
            return TypeScriptReactComponentUtil.REACT_SINGLE_VARIANT_COMPONENT_NAMES.contains(text);
        }
        return false;
    }

    private static void addFragmentComponent(@NotNull CompletionResultSet result2, @NotNull XmlTag tag, @NotNull Set<String> names, boolean isTypeScript) {
        if (result2 == null) {
            ReactComponentCompletionContributor.$$$reportNull$$$0(27);
        }
        if (tag == null) {
            ReactComponentCompletionContributor.$$$reportNull$$$0(28);
        }
        if (names == null) {
            ReactComponentCompletionContributor.$$$reportNull$$$0(29);
        }
        if (names.contains("Fragment")) {
            return;
        }
        Collection<PsiElement> react = JSFileReferencesUtil.resolveModuleReference((PsiElement)tag.getContainingFile(), "react");
        for (PsiElement element : react) {
            ResolveResult[] fragments;
            PsiElement item;
            if (!(element instanceof JSElement) || (item = (PsiElement)ContainerUtil.getFirstItem(JSResolveResult.toElements(fragments = ES6PsiUtil.resolveSymbolInModule("Fragment", (PsiElement)tag, (JSElement)element)))) == null) continue;
            ReactComponentCompletionContributor.addComponentWithImportInsertHandler(result2, tag, item, "Fragment", !isTypeScript);
        }
    }

    @NotNull
    public static GlobalSearchScope createScope(@NotNull PsiElement element, final Project project) {
        if (element == null) {
            ReactComponentCompletionContributor.$$$reportNull$$$0(30);
        }
        return new DelegatingGlobalSearchScope(ES6CreateImportUtil.createSymbolToImportSearchScope(project, (PsiElement)element.getContainingFile())){

            public boolean contains(@NotNull VirtualFile file2) {
                if (file2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (!super.contains(file2)) {
                    return false;
                }
                JSLanguageDialect dialect = DialectDetector.getLanguageDialect(file2, project);
                if (dialect == null) {
                    return false;
                }
                DialectOptionHolder holder = dialect.getOptionHolder();
                if (holder.isJSX) {
                    return true;
                }
                return holder.isTypeScript && TypeScriptUtil.isDefinitionFile(file2);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/javascript/frameworks/react/ReactComponentCompletionContributor$1", "contains"));
            }
        };
    }

    private static void addLocalVariants(@NotNull CompletionResultSet result2, @NotNull XmlTag tag, Set<String> collectedNames) {
        if (result2 == null) {
            ReactComponentCompletionContributor.$$$reportNull$$$0(31);
        }
        if (tag == null) {
            ReactComponentCompletionContributor.$$$reportNull$$$0(32);
        }
        JSResolveProcessor processor = ReactComponentCompletionContributor.createCompletionProcessor(result2, collectedNames);
        JSResolveUtil.treeWalkUp(processor, (PsiElement)tag, null, (PsiElement)tag);
    }

    @NotNull
    private static JSResolveProcessor createCompletionProcessor(final @NotNull CompletionResultSet result2, final @NotNull Set<String> collectedNames) {
        if (result2 == null) {
            ReactComponentCompletionContributor.$$$reportNull$$$0(33);
        }
        if (collectedNames == null) {
            ReactComponentCompletionContributor.$$$reportNull$$$0(34);
        }
        final PrefixMatcher matcher = result2.getPrefixMatcher();
        return new JSResolveProcessor(){

            @Override
            @Nullable
            public String getName() {
                return null;
            }

            public boolean execute(@NotNull PsiElement element, @NotNull ResolveState state) {
                if (element == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (state == null) {
                    2.$$$reportNull$$$0(1);
                }
                if (element instanceof JSDefinitionExpression) {
                    return true;
                }
                String name = ResolveProcessor.getName(element);
                if (JSXResolveUtil.isComponentName(name) && !collectedNames.contains(name) && matcher.prefixMatches(name) && !"React".equals(name)) {
                    Collection<PsiElement> elementsByImport = ReactXmlExtension.getElementsByImport(element);
                    collectedNames.add(name);
                    for (PsiElement candidate : elementsByImport) {
                        ProgressManager.checkCanceled();
                        boolean isComponent = element instanceof JSClass ? ReactXmlExtension.isReactComponent(candidate) : ReactXmlExtension.isPossibleReactComponent(candidate);
                        if (!isComponent) continue;
                        ReactComponentCompletionContributor.addLookupElement(candidate, name, result2);
                        break;
                    }
                }
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "element";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "state";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/lang/javascript/frameworks/react/ReactComponentCompletionContributor$2";
                objectArray[2] = "execute";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    private static void addLookupElement(PsiElement candidate, String name, CompletionResultSet result2) {
        LookupElementBuilder lookup = ReactComponentCompletionContributor.createLookup(name, candidate);
        result2.addElement((LookupElement)lookup);
    }

    private static void addComponentWithImportInsertHandler(@NotNull CompletionResultSet result2, @NotNull XmlTag tag, @NotNull PsiElement el, @NotNull String name) {
        if (result2 == null) {
            ReactComponentCompletionContributor.$$$reportNull$$$0(35);
        }
        if (tag == null) {
            ReactComponentCompletionContributor.$$$reportNull$$$0(36);
        }
        if (el == null) {
            ReactComponentCompletionContributor.$$$reportNull$$$0(37);
        }
        if (name == null) {
            ReactComponentCompletionContributor.$$$reportNull$$$0(38);
        }
        ReactComponentCompletionContributor.addComponentWithImportInsertHandler(result2, tag, el, name, false);
    }

    private static void addComponentWithImportInsertHandler(@NotNull CompletionResultSet result2, @NotNull XmlTag tag, @NotNull PsiElement el, @NotNull String name, boolean force) {
        if (result2 == null) {
            ReactComponentCompletionContributor.$$$reportNull$$$0(39);
        }
        if (tag == null) {
            ReactComponentCompletionContributor.$$$reportNull$$$0(40);
        }
        if (el == null) {
            ReactComponentCompletionContributor.$$$reportNull$$$0(41);
        }
        if (name == null) {
            ReactComponentCompletionContributor.$$$reportNull$$$0(42);
        }
        ReactComponentCompletionContributor.addLookupItemWithImportInsertHandler(result2, tag, el, name, force, force);
    }

    private static void addLookupItemWithImportInsertHandler(@NotNull CompletionResultSet result2, XmlTag tag, @NotNull PsiElement candidate, String name, boolean force, boolean passExplicitElement) {
        if (result2 == null) {
            ReactComponentCompletionContributor.$$$reportNull$$$0(43);
        }
        if (candidate == null) {
            ReactComponentCompletionContributor.$$$reportNull$$$0(44);
        }
        if (!ES6CreateImportUtil.isAvailableForImport(candidate, (PsiElement)tag) && !force) {
            return;
        }
        LookupElementBuilder lookup = ReactComponentCompletionContributor.createLookup(name, (PsiElement)(passExplicitElement ? candidate : null));
        lookup = lookup.withInsertHandler((context, item) -> {
            PsiFile originalFile = context.getFile();
            PsiElement originalElement = originalFile.findElementAt(context.getStartOffset());
            if (originalElement != null) {
                XmlTagNameSynchronizer.runWithoutCancellingSyncTagsEditing((Document)context.getDocument(), () -> JSImportCompletionUtil.insertLookupItem(context, item, item.getPsiElement(), (Consumer<? super JSElement>)((Consumer)el -> {
                    if (el != null) {
                        PsiDocumentManager.getInstance((Project)context.getProject()).commitDocument(context.getDocument());
                        PsiDocumentManager.getInstance((Project)context.getProject()).doPostponedOperationsAndUnblockDocument(context.getDocument());
                        XmlTagInsertHandler.INSTANCE.handleInsert(context, item);
                    }
                })));
            }
        });
        result2.addElement((LookupElement)lookup);
    }

    private static LookupElementBuilder createLookup(@NotNull String name, @Nullable PsiElement candidate) {
        if (name == null) {
            ReactComponentCompletionContributor.$$$reportNull$$$0(45);
        }
        ItemPresentation presentation = candidate instanceof JSNamedElement ? ((JSNamedElement)candidate).getPresentation() : null;
        LookupElementBuilder lookup = (candidate == null ? LookupElementBuilder.create((String)name) : LookupElementBuilder.create((Object)candidate, (String)name)).withTypeText(presentation != null ? presentation.getLocationString() : null, true).withIcon(JavaScriptLanguageIcons.Logos.Jsx_16);
        lookup = lookup.withInsertHandler((InsertHandler)XmlTagInsertHandler.INSTANCE);
        return lookup;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 12: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 12: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 1: 
            case 2: 
            case 13: 
            case 16: 
            case 18: 
            case 22: 
            case 27: 
            case 31: 
            case 33: 
            case 35: 
            case 39: 
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 10: 
            case 14: 
            case 17: 
            case 19: 
            case 23: 
            case 28: 
            case 32: 
            case 36: 
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tag";
                break;
            }
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 7: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prevRef";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/frameworks/react/ReactComponentCompletionContributor";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "localNames";
                break;
            }
            case 20: 
            case 24: 
            case 26: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 21: 
            case 25: 
            case 38: 
            case 42: 
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "names";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "collectedNames";
                break;
            }
            case 37: 
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "el";
                break;
            }
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "candidate";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/frameworks/react/ReactComponentCompletionContributor";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "createQualifiedLocalProcessor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "fillCompletionVariants";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "addExportedComponentForNamespace";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "processNestedComponentsFromIndex";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "processNestedComponentInScopes";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "createQualifiedLocalProcessor";
                break;
            }
            case 12: {
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "addExportedComponents";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "addElement";
                break;
            }
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "addJSXFileElement";
                break;
            }
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "addDtsFileElement";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "isAcceptableVariable";
                break;
            }
            case 27: 
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "addFragmentComponent";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "createScope";
                break;
            }
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "addLocalVariants";
                break;
            }
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "createCompletionProcessor";
                break;
            }
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "addComponentWithImportInsertHandler";
                break;
            }
            case 43: 
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "addLookupItemWithImportInsertHandler";
                break;
            }
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "createLookup";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 12: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

