/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.ecmascript6;

import com.intellij.lang.ecmascript6.resolve.ES6PsiUtil;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.ecmascript6.TypeScriptQualifiedNameResolver;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSQualifiedNameImpl;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.lang.javascript.psi.resolve.JSImportHandler;
import com.intellij.lang.javascript.psi.resolve.JSTypeResolveResult;
import com.intellij.lang.javascript.psi.types.JSContext;
import com.intellij.lang.typescript.psi.TypeScriptPsiUtil;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Objects;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.annotations.NotNull;

public class TypeScriptImportHandler
extends JSImportHandler {
    private static final TypeScriptImportHandler INSTANCE = new TypeScriptImportHandler();
    public static final Key<CachedValue<ConcurrentMap<NamespaceId, JSTypeResolveResult>>> SCOPES_CACHE = Key.create((String)"ts.scopes.cache");

    protected TypeScriptImportHandler() {
    }

    public static TypeScriptImportHandler getInstance() {
        return INSTANCE;
    }

    @Override
    public String getQualifiedNameResolvedType(@NotNull String type, @NotNull PsiElement context) {
        if (type == null) {
            TypeScriptImportHandler.$$$reportNull$$$0(0);
        }
        if (context == null) {
            TypeScriptImportHandler.$$$reportNull$$$0(1);
        }
        return this.resolveNameImpl(type, context, TypeScriptQualifiedNameResolver.StrictKind.CONTAINERS_AND_TYPES, false).getQualifiedName();
    }

    @Override
    public JSTypeResolveResult resolveMainElementName(@NotNull String type, @NotNull PsiElement context, @NotNull JSContext jsContext) {
        if (type == null) {
            TypeScriptImportHandler.$$$reportNull$$$0(2);
        }
        if (context == null) {
            TypeScriptImportHandler.$$$reportNull$$$0(3);
        }
        if (jsContext == null) {
            TypeScriptImportHandler.$$$reportNull$$$0(4);
        }
        return this.resolveNameImpl(type, context, jsContext == JSContext.INSTANCE ? TypeScriptQualifiedNameResolver.StrictKind.TYPES : TypeScriptQualifiedNameResolver.StrictKind.CONTAINERS_AND_TYPES, true);
    }

    @Override
    public JSTypeResolveResult resolveTypeName(@NotNull String type, @NotNull PsiElement context) {
        if (type == null) {
            TypeScriptImportHandler.$$$reportNull$$$0(5);
        }
        if (context == null) {
            TypeScriptImportHandler.$$$reportNull$$$0(6);
        }
        return this.resolveNameImpl(type, context, true);
    }

    @Override
    @NotNull
    public JSTypeResolveResult resolveName(@NotNull String type, @NotNull PsiElement source) {
        if (type == null) {
            TypeScriptImportHandler.$$$reportNull$$$0(7);
        }
        if (source == null) {
            TypeScriptImportHandler.$$$reportNull$$$0(8);
        }
        JSTypeResolveResult jSTypeResolveResult = this.resolveNameImpl(type, source, false);
        if (jSTypeResolveResult == null) {
            TypeScriptImportHandler.$$$reportNull$$$0(9);
        }
        return jSTypeResolveResult;
    }

    @Override
    @NotNull
    public Collection<? extends PsiElement> resolveObjectOrTypeName(@NotNull String type, @NotNull PsiElement context) {
        if (type == null) {
            TypeScriptImportHandler.$$$reportNull$$$0(10);
        }
        if (context == null) {
            TypeScriptImportHandler.$$$reportNull$$$0(11);
        }
        Collection<PsiElement> collection = new TypeScriptQualifiedNameResolver(context, true).resolveQualifiedName(type);
        if (collection == null) {
            TypeScriptImportHandler.$$$reportNull$$$0(12);
        }
        return collection;
    }

    private JSTypeResolveResult resolveNameImpl(@NotNull String type, @NotNull PsiElement sourceRaw, boolean typeContext) {
        if (type == null) {
            TypeScriptImportHandler.$$$reportNull$$$0(13);
        }
        if (sourceRaw == null) {
            TypeScriptImportHandler.$$$reportNull$$$0(14);
        }
        return this.resolveNameImpl(type, sourceRaw, typeContext ? TypeScriptQualifiedNameResolver.StrictKind.CONTAINERS_AND_TYPES : TypeScriptQualifiedNameResolver.StrictKind.OBJECTS, true);
    }

    @NotNull
    protected JSTypeResolveResult resolveNameImpl(@NotNull String type, @NotNull PsiElement sourceRaw, @NotNull TypeScriptQualifiedNameResolver.StrictKind typeContext, boolean includeAugmentations) {
        if (type == null) {
            TypeScriptImportHandler.$$$reportNull$$$0(15);
        }
        if (sourceRaw == null) {
            TypeScriptImportHandler.$$$reportNull$$$0(16);
        }
        if (typeContext == null) {
            TypeScriptImportHandler.$$$reportNull$$$0(17);
        }
        if (!DialectDetector.isTypeScript(sourceRaw)) {
            return new JSTypeResolveResult(type, null);
        }
        JSQualifiedNameImpl name = JSQualifiedNameImpl.fromQualifiedName(type);
        String topName = JSQualifiedNameImpl.getTopmostParent(name);
        Collection<JSQualifiedNamedElement> localClasses = TypeScriptQualifiedNameResolver.getLocalClassesForName(topName, sourceRaw);
        if (localClasses.isEmpty() && typeContext != TypeScriptQualifiedNameResolver.StrictKind.OBJECTS_WITH_FIELDS) {
            PsiElement scope = TypeScriptImportHandler.getSourceElement(sourceRaw);
            CachedValueProvider provider = () -> CachedValueProvider.Result.create((Object)ContainerUtil.createConcurrentSoftValueMap(), (Object[])new Object[]{JSTypeUtils.getTypeInvalidationDependency()});
            NamespaceId id = new NamespaceId(type, typeContext, includeAugmentations);
            ConcurrentMap cache = (ConcurrentMap)CachedValuesManager.getCachedValue((PsiElement)scope, SCOPES_CACHE, (CachedValueProvider)provider);
            JSTypeResolveResult result2 = (JSTypeResolveResult)cache.get(id);
            if (result2 != null) {
                JSTypeResolveResult jSTypeResolveResult = result2;
                if (jSTypeResolveResult == null) {
                    TypeScriptImportHandler.$$$reportNull$$$0(18);
                }
                return jSTypeResolveResult;
            }
            result2 = TypeScriptImportHandler.getResultWithoutCache(type, scope, typeContext, includeAugmentations, false);
            cache.putIfAbsent(id, result2);
            JSTypeResolveResult jSTypeResolveResult = result2;
            if (jSTypeResolveResult == null) {
                TypeScriptImportHandler.$$$reportNull$$$0(19);
            }
            return jSTypeResolveResult;
        }
        return TypeScriptImportHandler.getResultWithoutCache(type, sourceRaw, typeContext, includeAugmentations, true);
    }

    @NotNull
    private static JSTypeResolveResult getResultWithoutCache(@NotNull String type, @NotNull PsiElement sourceRaw, @NotNull TypeScriptQualifiedNameResolver.StrictKind typeContext, boolean includeAugmentations, boolean checkLocalClasses) {
        Collection<PsiElement> elements;
        if (type == null) {
            TypeScriptImportHandler.$$$reportNull$$$0(20);
        }
        if (sourceRaw == null) {
            TypeScriptImportHandler.$$$reportNull$$$0(21);
        }
        if (typeContext == null) {
            TypeScriptImportHandler.$$$reportNull$$$0(22);
        }
        if ((elements = new TypeScriptQualifiedNameResolver(sourceRaw, typeContext, includeAugmentations, checkLocalClasses).resolveQualifiedName(type)).isEmpty()) {
            return new JSTypeResolveResult(type, null);
        }
        String qName = TypeScriptImportHandler.getQualifiedName(elements);
        return new JSTypeResolveResult(qName, elements);
    }

    @NotNull
    private static String getQualifiedName(@NotNull Collection<? extends PsiElement> elements) {
        if (elements == null) {
            TypeScriptImportHandler.$$$reportNull$$$0(23);
        }
        for (PsiElement psiElement : elements) {
            if (!(psiElement instanceof JSQualifiedNamedElement) || TypeScriptPsiUtil.isFromAugmentationModule(psiElement)) continue;
            String string = StringUtil.notNullize((String)((JSQualifiedNamedElement)psiElement).getQualifiedName());
            if (string == null) {
                TypeScriptImportHandler.$$$reportNull$$$0(24);
            }
            return string;
        }
        PsiElement element = (PsiElement)ContainerUtil.getFirstItem(elements);
        return element instanceof JSQualifiedNamedElement ? StringUtil.notNullize((String)((JSQualifiedNamedElement)element).getQualifiedName()) : "";
    }

    @NotNull
    private static PsiElement getSourceElement(@NotNull PsiElement sourceRaw) {
        JSElement scope;
        if (sourceRaw == null) {
            TypeScriptImportHandler.$$$reportNull$$$0(25);
        }
        Object object = (scope = ES6PsiUtil.getNonStrictExportScope(sourceRaw)) == null ? sourceRaw : scope;
        if (object == null) {
            TypeScriptImportHandler.$$$reportNull$$$0(26);
        }
        return object;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 9: 
            case 12: 
            case 18: 
            case 19: 
            case 24: 
            case 26: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 9: 
            case 12: 
            case 18: 
            case 19: 
            case 24: 
            case 26: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 1: 
            case 3: 
            case 6: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jsContext";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 9: 
            case 12: 
            case 18: 
            case 19: 
            case 24: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/ecmascript6/TypeScriptImportHandler";
                break;
            }
            case 14: 
            case 16: 
            case 21: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceRaw";
                break;
            }
            case 17: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeContext";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/ecmascript6/TypeScriptImportHandler";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveName";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveObjectOrTypeName";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveNameImpl";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "getQualifiedName";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "getSourceElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getQualifiedNameResolvedType";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "resolveMainElementName";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "resolveTypeName";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "resolveName";
                break;
            }
            case 9: 
            case 12: 
            case 18: 
            case 19: 
            case 24: 
            case 26: {
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "resolveObjectOrTypeName";
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "resolveNameImpl";
                break;
            }
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getResultWithoutCache";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "getQualifiedName";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "getSourceElement";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 9: 
            case 12: 
            case 18: 
            case 19: 
            case 24: 
            case 26: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    protected static final class NamespaceId {
        @NotNull
        private final String myName;
        @NotNull
        private final TypeScriptQualifiedNameResolver.StrictKind myContext;
        private final boolean myAugmentations;

        private NamespaceId(@NotNull String qName, @NotNull TypeScriptQualifiedNameResolver.StrictKind typeContext, boolean includeAugmentations) {
            if (qName == null) {
                NamespaceId.$$$reportNull$$$0(0);
            }
            if (typeContext == null) {
                NamespaceId.$$$reportNull$$$0(1);
            }
            this.myName = qName;
            this.myContext = typeContext;
            this.myAugmentations = includeAugmentations;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            NamespaceId id = (NamespaceId)o;
            return this.myAugmentations == id.myAugmentations && Objects.equals(this.myName, id.myName) && this.myContext == id.myContext;
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.myName, this.myContext, this.myAugmentations});
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "qName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "typeContext";
                    break;
                }
            }
            objectArray[1] = "com/intellij/lang/javascript/ecmascript6/TypeScriptImportHandler$NamespaceId";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

