/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.documentation;

import com.intellij.lang.javascript.documentation.JSDocBuilderSimpleInfo;
import com.intellij.lang.javascript.documentation.JSDocBuilderSymbolInfo;
import com.intellij.lang.javascript.documentation.JSDocumentationProvider;
import com.intellij.lang.javascript.documentation.JSHtmlHighlightingUtil;
import com.intellij.lang.javascript.documentation.JSQuickNavigateBuilder;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.JSParameterItem;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.types.JSParameterTypeDecoratorImpl;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSDocBuilderParameterInfo
extends JSDocBuilderSimpleInfo {
    private final JSParameterItem parameterItem;
    boolean optional;
    boolean rest;
    String initialValue;
    String defaultValue;
    PsiElement context;
    @Nullable
    String docName;
    Map<String, JSDocBuilderParameterInfo> optionsMap;

    JSDocBuilderParameterInfo(@Nullable PsiElement contextEl) {
        this.context = contextEl;
        this.parameterItem = null;
    }

    @NotNull
    JSParameterItem getParameterItem() {
        if (this.parameterItem != null) {
            JSParameterItem jSParameterItem = this.parameterItem;
            if (jSParameterItem == null) {
                JSDocBuilderParameterInfo.$$$reportNull$$$0(0);
            }
            return jSParameterItem;
        }
        return new JSParameterTypeDecoratorImpl(null, this.type, this.optional, this.rest, true);
    }

    public JSDocBuilderParameterInfo(@Nullable JSParameterItem parameter) {
        this.parameterItem = parameter;
        this.type = parameter == null ? null : (JSType)ObjectUtils.coalesce((Object)parameter.getSimpleType(), (Object)parameter.getInferredType());
        this.optional = parameter != null && parameter.isOptional();
        this.rest = parameter != null && parameter.getTypeDecorator().isRest();
    }

    boolean hasSomeInfo() {
        return this.hasDescription() || this.optional || this.rest || this.hasType();
    }

    public void appendDoc(@Nullable String actualName, @NotNull JSDocBuilderSymbolInfo symbolInfo, @NotNull StringBuilder result2, @NotNull JSDocumentationProvider provider, @Nullable PsiElement place) {
        if (symbolInfo == null) {
            JSDocBuilderParameterInfo.$$$reportNull$$$0(1);
        }
        if (result2 == null) {
            JSDocBuilderParameterInfo.$$$reportNull$$$0(2);
        }
        if (provider == null) {
            JSDocBuilderParameterInfo.$$$reportNull$$$0(3);
        }
        result2.append("<div class='definition'><pre>");
        StringBuilder options = new StringBuilder();
        JSDocBuilderSymbolInfo.addJSDocVisibilityAndAccess(this, options);
        if (options.length() > 0) {
            result2.append((CharSequence)options).append("<br>");
        }
        if (!StringUtil.isEmpty((String)symbolInfo.namespace)) {
            result2.append(symbolInfo.namespace).append('.');
        }
        JSQuickNavigateBuilder builder = provider.getQuickNavigateBuilder();
        if (this.parameterItem instanceof JSParameter) {
            PsiElement toUse = place == null ? (PsiElement)this.parameterItem : place;
            String navInfoResult = builder.getQuickNavigateInfoForNavigationElement((PsiElement)((JSParameter)this.parameterItem), toUse, true);
            result2.append(navInfoResult);
        } else {
            result2.append(actualName);
            if (this.hasType()) {
                result2.append(": ");
                result2.append(this.getTypeString(this.context));
            }
        }
        result2.append("</pre></div>");
        int contentStart = result2.length();
        result2.append("<div class='content'>");
        result2.append(this.getDescriptionMergedWithConfigOptions());
        if (result2.length() == contentStart + "<div class='content'>".length()) {
            result2.setLength(contentStart);
        } else {
            result2.append("</div>");
        }
    }

    public String getDescriptionMergedWithConfigOptions() {
        if (this.optionsMap != null) {
            StringBuilder optionsBuilder = new StringBuilder();
            optionsBuilder.append("<table class='sections'>");
            optionsBuilder.append("<tr><td valign='top' class='section'><p>");
            optionsBuilder.append("Config options").append(":");
            optionsBuilder.append("</td><td valign='top'>");
            for (Map.Entry<String, JSDocBuilderParameterInfo> field : this.optionsMap.entrySet()) {
                optionsBuilder.append("<p>");
                field.getValue().appendOptionDescription(field.getKey(), optionsBuilder);
            }
            optionsBuilder.append("</table>");
            String description = this.getFinalDescription();
            int i = description.indexOf("<tr><td valign='top' class='section'><p>See also:</td><td valign='top'>");
            if (i != -1) {
                return new StringBuilder(description).insert(i, optionsBuilder).toString();
            }
            return description + optionsBuilder;
        }
        return this.getFinalDescription();
    }

    @NotNull
    public List<JSHtmlHighlightingUtil.TextPlaceholder> appendParameterInfoInSignature(@NotNull String actualName, @NotNull StringBuilder result2, boolean withHolders) {
        String qName;
        if (actualName == null) {
            JSDocBuilderParameterInfo.$$$reportNull$$$0(4);
        }
        if (result2 == null) {
            JSDocBuilderParameterInfo.$$$reportNull$$$0(5);
        }
        if (this.rest) {
            result2.append("...");
        }
        List holders = withHolders ? new ArrayList() : ContainerUtil.emptyList();
        String string = qName = !StringUtil.isEmpty((String)this.namespace) ? this.namespace + "." + actualName : actualName;
        if (withHolders && !StringUtil.isJavaIdentifier((String)qName)) {
            JSHtmlHighlightingUtil.TextPlaceholder holder = JSHtmlHighlightingUtil.createSimpleHolder(qName, "$$Name$$" + this.hashCode());
            holders.add(holder);
            result2.append(holder.getHolderText());
        } else {
            result2.append(qName);
        }
        if (this.optional) {
            result2.append("?");
        }
        if (this.hasType()) {
            result2.append(": ");
            if (this.type != null) {
                this.type = this.type.substitute();
            }
            if (withHolders) {
                JSHtmlHighlightingUtil.TextPlaceholder placeholder = this.getTypeWithHolder();
                holders.add(placeholder);
                result2.append(placeholder.getHolderText());
            } else {
                result2.append(this.getTypeString(this.context));
            }
            if (this.rest && !JSTypeUtils.isArrayLikeType(this.type)) {
                result2.append("[]");
            }
        }
        if (this.initialValue != null) {
            result2.append(" = ").append(this.initialValue);
        }
        List list2 = holders;
        if (list2 == null) {
            JSDocBuilderParameterInfo.$$$reportNull$$$0(6);
        }
        return list2;
    }

    @NotNull
    public JSHtmlHighlightingUtil.TextPlaceholder getTypeWithHolder() {
        JSType jsType = this.type;
        if (jsType != null) {
            jsType = jsType.substitute();
        }
        JSHtmlHighlightingUtil.TextPlaceholder textPlaceholder = JSHtmlHighlightingUtil.getTypeWithLinksPlaceholder(jsType, this.hasFiredEvents, "$$Type$$Parameter" + this.hashCode());
        if (textPlaceholder == null) {
            JSDocBuilderParameterInfo.$$$reportNull$$$0(7);
        }
        return textPlaceholder;
    }

    public void appendOptionDescription(@NotNull String name, @NotNull StringBuilder builder) {
        if (name == null) {
            JSDocBuilderParameterInfo.$$$reportNull$$$0(8);
        }
        if (builder == null) {
            JSDocBuilderParameterInfo.$$$reportNull$$$0(9);
        }
        this.appendParameterInfoInSignature(name, builder, false);
        builder.append(" &ndash; ");
        builder.append(this.getFinalDescription());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 8: 
            case 9: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 8: 
            case 9: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/documentation/JSDocBuilderParameterInfo";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "symbolInfo";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "provider";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actualName";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getParameterItem";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/documentation/JSDocBuilderParameterInfo";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "appendParameterInfoInSignature";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeWithHolder";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "appendDoc";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "appendParameterInfoInSignature";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "appendOptionDescription";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 8: 
            case 9: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

