/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.completion;

import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementPresentation;
import com.intellij.codeInsight.lookup.LookupElementRenderer;
import com.intellij.lang.javascript.completion.JSCompletionService;
import com.intellij.lang.javascript.completion.JSLookupPriority;
import com.intellij.lang.javascript.completion.JSLookupUtilImpl;
import com.intellij.lang.javascript.documentation.JSDocumentationUtils;
import com.intellij.lang.javascript.index.JSItemPresentation;
import com.intellij.lang.javascript.psi.JSElementBase;
import com.intellij.lang.javascript.psi.JSQualifiedName;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.types.JSTypeSubstitutor;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.util.ProgressIndicatorUtils;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JSLookupElementRenderer
extends LookupElementRenderer<LookupElement> {
    private final String myName;
    private final JSLookupPriority myPriority;
    private final boolean myPartial;
    private final Icon myIcon;
    private final String myTailPostfix;
    @Nullable
    private final JSTypeSubstitutor myTypeSubstitutor;
    private final boolean myParamsOnly;
    private static final String KEY = "JSLookupElementRenderer.TYPE_AND_TAIL";
    private static final Key<JSLookupUtilImpl.TypeAndTail> TYPE_AND_TAIL = new Key("JSLookupElementRenderer.TYPE_AND_TAIL");
    private static final JSLookupUtilImpl.TypeAndTail NOT_COMPUTED = new JSLookupUtilImpl.TypeAndTail("$NA$", "$NA$", "");

    public JSLookupElementRenderer(String name, @Nullable PsiElement element, @Nullable JSLookupPriority priority, boolean partial, @Nullable JSTypeSubstitutor typeSubstitutor) {
        this(name, element, priority, partial, null, null, typeSubstitutor, false);
    }

    public JSLookupElementRenderer(String name, @Nullable PsiElement element, @Nullable JSLookupPriority priority, boolean partial, @Nullable Icon icon, @Nullable String tailPostfix, @Nullable JSTypeSubstitutor typeSubstitutor, boolean paramsOnly) {
        this.myName = name;
        this.myPriority = priority;
        this.myPartial = partial;
        this.myIcon = icon;
        this.myTailPostfix = tailPostfix;
        this.myTypeSubstitutor = typeSubstitutor;
        this.myParamsOnly = paramsOnly;
        if (element != null) {
            element.putUserData(TYPE_AND_TAIL, (Object)NOT_COMPUTED);
            JSCompletionService.getInstance(element.getProject()).submitBackgroundActivity(() -> {
                AtomicReference<JSLookupUtilImpl.TypeAndTail> result2 = new AtomicReference<JSLookupUtilImpl.TypeAndTail>(NOT_COMPUTED);
                Application application = ApplicationManager.getApplication();
                if (application.isDispatchThread() || application.isUnitTestMode()) {
                    result2.set((JSLookupUtilImpl.TypeAndTail)ReadAction.compute(() -> JSLookupElementRenderer.computeTypeAndTail(element, typeSubstitutor)));
                } else {
                    ProgressIndicatorUtils.runInReadActionWithWriteActionPriority(() -> result2.set(JSLookupElementRenderer.computeTypeAndTail(element, typeSubstitutor)));
                }
                element.putUserData(TYPE_AND_TAIL, (Object)result2.get());
            });
        }
    }

    @Nullable
    private static JSLookupUtilImpl.TypeAndTail computeTypeAndTail(@NotNull PsiElement element, JSTypeSubstitutor typeSubstitutor) {
        if (element == null) {
            JSLookupElementRenderer.$$$reportNull$$$0(0);
        }
        ProgressManager.checkCanceled();
        return element.isValid() ? JSLookupUtilImpl.getTypeAndTailTexts(element, typeSubstitutor) : null;
    }

    public void renderElement(LookupElement element, LookupElementPresentation presentation) {
        JSCompletionService service;
        if (presentation instanceof JSLookupUtilImpl.BoldCheckingLookupElementPresentation) {
            return;
        }
        PsiElement value = JSLookupElementRenderer.getValidElement(element);
        if (!this.myParamsOnly) {
            presentation.setItemText(JSUtils.isPrivateSharpItem(value) && !this.myName.startsWith("this.") ? "#" + this.myName : this.myName);
        }
        boolean real = presentation.isReal();
        Icon icon = this.myIcon != null ? this.myIcon : (real ? JSLookupUtilImpl.getLookupElementIcon(value) : JSLookupUtilImpl.getEmptyIcon());
        presentation.setIcon(icon);
        JSCompletionService jSCompletionService = service = value == null ? null : JSCompletionService.getInstance(value.getProject());
        if (this.myPriority.compareTo(JSLookupPriority.MAX_PRIORITY) >= 0 || real || this.myParamsOnly) {
            if (real) {
                presentation.setStrikeout(JSDocumentationUtils.isDeprecated(value));
            }
            boolean isPartialLike = this.isPartialOrObjectMember(value);
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                presentation.setItemTextBold(!isPartialLike);
            } else if (isPartialLike && icon != null && real) {
                Color color = UIUtil.toAlpha((Color)presentation.getItemTextForeground(), (int)150);
                presentation.setItemTextForeground(color);
                presentation.setIcon(service != null ? service.getPartialIcon(icon) : icon);
            }
            if (value != null) {
                JSLookupUtilImpl.TypeAndTail data = (JSLookupUtilImpl.TypeAndTail)value.getUserData(TYPE_AND_TAIL);
                if (data == NOT_COMPUTED && service.awaitWithTimeout()) {
                    data = (JSLookupUtilImpl.TypeAndTail)value.getUserData(TYPE_AND_TAIL);
                }
                if (data == NOT_COMPUTED) {
                    presentation.setTailText("[incomplete]", true);
                } else if (data != null) {
                    this.renderTypeAndTail(presentation, data, value, isPartialLike);
                }
            } else {
                presentation.setTailText(this.myTailPostfix, false);
            }
        }
    }

    private boolean isPartialOrObjectMember(@Nullable PsiElement value) {
        if (this.myPartial) {
            return true;
        }
        if (!(value instanceof JSElementBase)) {
            return false;
        }
        JSQualifiedName namespace = ((JSElementBase)value).getNamespace();
        String name = namespace == null ? null : namespace.getQualifiedName();
        return "Object".equals(name);
    }

    private void renderTypeAndTail(@NotNull LookupElementPresentation presentation, @NotNull JSLookupUtilImpl.TypeAndTail data, @Nullable PsiElement element, boolean isPartialLike) {
        if (presentation == null) {
            JSLookupElementRenderer.$$$reportNull$$$0(1);
        }
        if (data == null) {
            JSLookupElementRenderer.$$$reportNull$$$0(2);
        }
        presentation.setTypeText(data.typeText);
        String location = isPartialLike || this.shouldShowLocation(element) && !StringUtil.isEmpty((String)data.location) ? " " + data.location : "";
        String tail = StringUtil.notNullize((String)data.tailText) + StringUtil.notNullize((String)this.myTailPostfix) + location;
        if (this.myParamsOnly) {
            presentation.setItemText(StringUtil.trimEnd((String)StringUtil.trimStart((String)tail, (String)"("), (String)")"));
        } else {
            presentation.setTailText(tail, false);
        }
    }

    private boolean shouldShowLocation(@Nullable PsiElement element) {
        if (JSItemPresentation.isLocalVariable(element) || JSItemPresentation.isLocalParameter(element)) {
            return false;
        }
        return element == null || !(JSResolveUtil.findParent(element) instanceof JSClass);
    }

    @Nullable
    private static PsiElement getValidElement(@NotNull LookupElement element) {
        PsiElement value;
        if (element == null) {
            JSLookupElementRenderer.$$$reportNull$$$0(3);
        }
        if ((value = element.getPsiElement()) != null && !value.isValid()) {
            value = null;
        }
        return value;
    }

    public LookupElementRenderer<LookupElement> copyWithIcon(@NotNull Icon icon) {
        if (icon == null) {
            JSLookupElementRenderer.$$$reportNull$$$0(4);
        }
        return new JSLookupElementRenderer(this.myName, null, this.myPriority, this.myPartial, icon, this.myTailPostfix, this.myTypeSubstitutor, this.myParamsOnly);
    }

    @NotNull
    public LookupElementRenderer<LookupElement> copyWithPartial(boolean partial) {
        return new JSLookupElementRenderer(this.myName, null, this.myPriority, partial, this.myIcon, this.myTailPostfix, this.myTypeSubstitutor, this.myParamsOnly);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "presentation";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "icon";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/javascript/completion/JSLookupElementRenderer";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "computeTypeAndTail";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "renderTypeAndTail";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "getValidElement";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "copyWithIcon";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

