/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.nodejs.documentation;

import com.intellij.codeInsight.documentation.QuickDocUtil;
import com.intellij.javascript.nodejs.PackageJsonData;
import com.intellij.javascript.nodejs.npm.AvailablePackageVersions;
import com.intellij.javascript.nodejs.npm.registry.NpmRegistryService;
import com.intellij.lang.javascript.buildTools.npm.PackageJsonUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.impl.PsiModificationTrackerImpl;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.Gray;
import com.intellij.ui.JBColor;
import com.intellij.util.ObjectUtils;
import com.intellij.util.text.SemVer;
import com.intellij.util.ui.SwingHelper;
import java.awt.Color;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NodeJsPackageDocumentation {
    private final String myPackageName;
    private final String myDescription;
    private final String myReadmeHtml;
    private final VirtualFile myPackageDir;
    private PsiElement myContextElement;

    public NodeJsPackageDocumentation(@NotNull String packageName, @Nullable String description, @Nullable String readmeHtml, @Nullable VirtualFile packageDir) {
        if (packageName == null) {
            NodeJsPackageDocumentation.$$$reportNull$$$0(0);
        }
        this.myPackageName = packageName;
        this.myDescription = description;
        this.myReadmeHtml = readmeHtml;
        this.myPackageDir = packageDir;
    }

    @NotNull
    public String getQuickInfoHtml() {
        return this.getQuickInfoHtml(this.myDescription, false, true);
    }

    @NotNull
    private String getQuickInfoHtml(@Nullable String description, boolean showInstalledVersion, boolean showLatestVersion) {
        if (showInstalledVersion) {
            return NodeJsPackageDocumentation.html(this.myPackageName, true, this.getInstalledVersion(), false, null, description);
        }
        Ref<SemVer> latestRef = showLatestVersion ? this.getLatest(this.myPackageName, description) : null;
        return NodeJsPackageDocumentation.html(this.myPackageName, false, null, showLatestVersion, latestRef != null ? (SemVer)latestRef.get() : null, description);
    }

    @Nullable
    private Ref<SemVer> getLatest(@NotNull String packageName, @Nullable String description) {
        if (packageName == null) {
            NodeJsPackageDocumentation.$$$reportNull$$$0(1);
        }
        return NodeJsPackageDocumentation.getLatest(packageName, latestVersion -> {
            if (this.myContextElement != null) {
                String html = NodeJsPackageDocumentation.html(this.myPackageName, false, null, true, latestVersion, description);
                QuickDocUtil.updateQuickDoc((Project)this.myContextElement.getProject(), (PsiElement)this.myContextElement, (String)html);
            }
        });
    }

    @Nullable
    public static Ref<SemVer> getLatest(@NotNull String packageName, @Nullable Consumer<SemVer> nonCachedLatestVersionConsumer) {
        AvailablePackageVersions availableVersions;
        if (packageName == null) {
            NodeJsPackageDocumentation.$$$reportNull$$$0(2);
        }
        if ((availableVersions = NpmRegistryService.getInstance().getCachedPackageVersions(packageName)) != null) {
            return Ref.create((Object)availableVersions.findVersionByLatestDistTag());
        }
        NpmRegistryService.getInstance().asyncUpdateAndGetPackageVersions(packageName).onProcessed(versions -> ApplicationManager.getApplication().invokeLater(() -> {
            if (nonCachedLatestVersionConsumer != null) {
                nonCachedLatestVersionConsumer.accept(versions != null ? versions.findVersionByLatestDistTag() : null);
            }
            for (Project project : ProjectManager.getInstance().getOpenProjects()) {
                PsiModificationTrackerImpl trackerImpl = (PsiModificationTrackerImpl)ObjectUtils.tryCast((Object)PsiModificationTracker.SERVICE.getInstance((Project)project), PsiModificationTrackerImpl.class);
                if (trackerImpl == null) continue;
                trackerImpl.incCounter();
            }
        }));
        return null;
    }

    @Nullable
    private SemVer getInstalledVersion() {
        VirtualFile packageJson;
        VirtualFile virtualFile = packageJson = this.myPackageDir != null ? PackageJsonUtil.findChildPackageJsonFile(this.myPackageDir) : null;
        if (packageJson != null) {
            return PackageJsonData.getOrCreate(packageJson).getVersion();
        }
        return null;
    }

    @NotNull
    private static String html(@NotNull String packageName, boolean showInstalledVersion, @Nullable SemVer installedVersion, boolean showLatestVersion, @Nullable SemVer latestVersion, @Nullable String description) {
        if (packageName == null) {
            NodeJsPackageDocumentation.$$$reportNull$$$0(3);
        }
        String versionStr = null;
        if (showInstalledVersion) {
            if (installedVersion != null) {
                versionStr = "Installed version: " + installedVersion.getRawVersion();
            }
        } else if (showLatestVersion) {
            if (latestVersion == null) {
                versionStr = "loading...";
            } else {
                versionStr = latestVersion.getRawVersion();
                if (StringUtil.isEmptyOrSpaces((String)versionStr)) {
                    versionStr = "n/a";
                }
            }
            versionStr = "Latest version: " + versionStr;
        }
        JBColor versionColor = new JBColor((Color)Gray.get((int)96), (Color)Gray.get((int)160));
        String string = "<table cellspacing='0' cellpadding='0' style='border: none;'> <tr>  <td style='text-align:left'><b>" + StringUtil.escapeXmlEntities((String)packageName) + "</b></td>" + (versionStr == null ? "" : "  <td style='width:20px'></td>  <td style='text-align:right'>    <div style='color:#" + ColorUtil.toHex((Color)versionColor) + ";'>" + StringUtil.escapeXmlEntities((String)versionStr) + "    </div>  </td>") + " </tr>" + (StringUtil.isEmptyOrSpaces((String)description) ? "" : " <tr>  <td colspan='3' style='white-space:nowrap'>" + StringUtil.escapeXmlEntities((String)description) + "</td> </tr>") + "</table>";
        if (string == null) {
            NodeJsPackageDocumentation.$$$reportNull$$$0(4);
        }
        return string;
    }

    @NotNull
    private String getBodyHtml() {
        if (this.myReadmeHtml != null) {
            String prefix = "<h1>" + this.myPackageName + "</h1>";
            if (StringUtil.startsWithIgnoreCase((String)this.myReadmeHtml, (String)prefix)) {
                String string = this.getQuickInfoHtml(null, true, false) + this.myReadmeHtml.substring(prefix.length());
                if (string == null) {
                    NodeJsPackageDocumentation.$$$reportNull$$$0(5);
                }
                return string;
            }
            String string = this.myReadmeHtml;
            if (string == null) {
                NodeJsPackageDocumentation.$$$reportNull$$$0(6);
            }
            return string;
        }
        String string = this.getQuickInfoHtml();
        if (string == null) {
            NodeJsPackageDocumentation.$$$reportNull$$$0(7);
        }
        return string;
    }

    @NotNull
    public String getFullDocHtml() {
        String html = this.getBodyHtml();
        String string = SwingHelper.buildHtml((String)"", (String)html);
        if (string == null) {
            NodeJsPackageDocumentation.$$$reportNull$$$0(8);
        }
        return string;
    }

    @NotNull
    public NodeJsPackageDocumentation setContextElement(@Nullable PsiElement contextElement) {
        this.myContextElement = contextElement;
        NodeJsPackageDocumentation nodeJsPackageDocumentation = this;
        if (nodeJsPackageDocumentation == null) {
            NodeJsPackageDocumentation.$$$reportNull$$$0(9);
        }
        return nodeJsPackageDocumentation;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageName";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javascript/nodejs/documentation/NodeJsPackageDocumentation";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javascript/nodejs/documentation/NodeJsPackageDocumentation";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "html";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getBodyHtml";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getFullDocHtml";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "setContextElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getLatest";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "html";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

