/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.monitor;

import java.applet.Applet;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.Window;
import java.util.Collection;
import java.util.LinkedHashSet;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;
import org.fest.swing.annotation.RunsInEDT;
import org.fest.swing.edt.GuiActionRunner;
import org.fest.swing.edt.GuiQuery;
import org.fest.swing.monitor.EventQueueMapping;
import org.fest.swing.monitor.WindowEventQueueMapping;
import org.fest.util.Lists;
import org.fest.util.Sets;

@ThreadSafe
class Context {
    @GuardedBy(value="lock")
    private final WindowEventQueueMapping windowEventQueueMapping;
    @GuardedBy(value="lock")
    private final EventQueueMapping eventQueueMapping;
    private final Object lock = new Object();

    Context(@Nonnull Toolkit toolkit) {
        this(toolkit, new WindowEventQueueMapping(), new EventQueueMapping());
    }

    Context(@Nonnull Toolkit toolkit, @Nonnull WindowEventQueueMapping windowEventQueueMapping, @Nonnull EventQueueMapping eventQueueMapping) {
        this.windowEventQueueMapping = windowEventQueueMapping;
        this.eventQueueMapping = eventQueueMapping;
        this.windowEventQueueMapping.addQueueFor(toolkit);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    Collection<Window> rootWindows() {
        LinkedHashSet rootWindows = Sets.newLinkedHashSet();
        Object object = this.lock;
        synchronized (object) {
            rootWindows.addAll(this.windowEventQueueMapping.windows());
        }
        rootWindows.addAll(Lists.newArrayList((Object[])Frame.getFrames()));
        rootWindows.addAll(Lists.newArrayList((Object[])Window.getOwnerlessWindows()));
        return rootWindows;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    EventQueue storedQueueFor(@Nonnull Component c) {
        Object object = this.lock;
        synchronized (object) {
            return this.eventQueueMapping.storedQueueFor(c);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeContextFor(@Nonnull Component component) {
        Object object = this.lock;
        synchronized (object) {
            this.windowEventQueueMapping.removeMappingFor(component);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addContextFor(@Nonnull Component component) {
        Object object = this.lock;
        synchronized (object) {
            this.windowEventQueueMapping.addQueueFor(component);
            this.eventQueueMapping.addQueueFor(component);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    @RunsInEDT
    EventQueue eventQueueFor(@Nonnull Component c) {
        Component component = Context.topParentOf(c);
        if (component == null) {
            return null;
        }
        Object object = this.lock;
        synchronized (object) {
            return this.eventQueueMapping.queueFor(component);
        }
    }

    @Nullable
    @RunsInEDT
    private static Component topParentOf(final @Nonnull Component c) {
        return GuiActionRunner.execute(new GuiQuery<Component>(){

            @Override
            @Nullable
            protected Component executeInEDT() {
                Component parent = c;
                while (!(parent instanceof Applet) && parent.getParent() != null) {
                    parent = parent.getParent();
                }
                return parent;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    Collection<EventQueue> allEventQueues() {
        LinkedHashSet eventQueues = Sets.newLinkedHashSet();
        Object object = this.lock;
        synchronized (object) {
            eventQueues.addAll(this.windowEventQueueMapping.eventQueues());
            eventQueues.addAll(this.eventQueueMapping.eventQueues());
        }
        return eventQueues;
    }
}

