/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.launcher;

import java.applet.Applet;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.fest.swing.annotation.RunsInEDT;
import org.fest.swing.applet.AppletViewer;
import org.fest.swing.edt.GuiActionRunner;
import org.fest.swing.edt.GuiQuery;
import org.fest.swing.exception.UnexpectedException;
import org.fest.swing.launcher.AppletParameter;
import org.fest.swing.launcher.NewAppletViewerQuery;
import org.fest.util.Maps;
import org.fest.util.Preconditions;

public class AppletLauncher {
    private final Applet applet;
    private final Map<String, String> parameters = Maps.newHashMap();

    @Nonnull
    @RunsInEDT
    public static AppletLauncher applet(@Nonnull String appletType) {
        Preconditions.checkNotNullOrEmpty((String)appletType);
        Class<?> type = AppletLauncher.load(appletType);
        if (!Applet.class.isAssignableFrom(type)) {
            String msg = String.format("The given type is not a subclass of %s", Applet.class.getName());
            throw new IllegalArgumentException(msg);
        }
        return AppletLauncher.instantiate(type);
    }

    @Nonnull
    @RunsInEDT
    private static Class<?> load(@Nonnull String typeName) {
        try {
            return Class.forName(typeName);
        }
        catch (ClassNotFoundException e) {
            throw AppletLauncher.cannotLoadType(typeName, e);
        }
        catch (Exception e) {
            throw AppletLauncher.cannotLoadType(typeName, e);
        }
    }

    private static UnexpectedException cannotLoadType(String typeName, Exception e) {
        String msg = String.format("Unable to load class %s", typeName);
        throw new UnexpectedException(msg, e);
    }

    @Nonnull
    @RunsInEDT
    public static AppletLauncher applet(@Nonnull Class<? extends Applet> appletType) {
        return AppletLauncher.instantiate((Class)Preconditions.checkNotNull(appletType));
    }

    @Nonnull
    private static AppletLauncher instantiate(final @Nonnull Class<?> appletType) {
        try {
            Object applet = GuiActionRunner.execute(new GuiQuery<Object>(){

                @Override
                @Nullable
                protected Object executeInEDT() throws Exception {
                    return appletType.newInstance();
                }
            });
            return AppletLauncher.launcherFor((Applet)Preconditions.checkNotNull((Object)((Applet)applet)));
        }
        catch (Exception e) {
            String msg = String.format("Unable to create a new instance of %s", appletType.getName());
            throw new UnexpectedException(msg, e);
        }
    }

    @Nonnull
    public static AppletLauncher launcherFor(@Nonnull Applet applet) {
        return new AppletLauncher(applet);
    }

    private AppletLauncher(@Nonnull Applet applet) {
        this.applet = (Applet)Preconditions.checkNotNull((Object)applet);
    }

    @Nonnull
    public AppletLauncher withParameters(@Nonnull Map<String, String> newParameters) {
        this.parameters.clear();
        this.parameters.putAll((Map)Preconditions.checkNotNull(newParameters));
        return this;
    }

    @Nonnull
    public AppletLauncher withParameters(AppletParameter ... newParameters) {
        Preconditions.checkNotNull((Object)newParameters);
        this.parameters.clear();
        for (AppletParameter parameter : newParameters) {
            this.add((AppletParameter)Preconditions.checkNotNull((Object)parameter));
        }
        return this;
    }

    private void add(@Nonnull AppletParameter parameter) {
        this.parameters.put(parameter.name, parameter.value);
    }

    @Nonnull
    public AppletViewer start() {
        return NewAppletViewerQuery.showAppletViewerWith(this.applet, this.parameters);
    }
}

