/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.toolwindow;

import com.intellij.internal.statistic.StatisticsBundle;
import com.intellij.internal.statistic.actions.AddTestGroupToLocalWhitelistAction;
import com.intellij.internal.statistic.actions.CleanupLocalWhitelistAction;
import com.intellij.internal.statistic.actions.ConfigureWhitelistAction;
import com.intellij.internal.statistic.actions.OpenEventLogFileAction;
import com.intellij.internal.statistic.actions.OpenLocalWhitelistFileAction;
import com.intellij.internal.statistic.actions.OpenWhitelistFileAction;
import com.intellij.internal.statistic.actions.RecordStateStatisticsEventLogAction;
import com.intellij.internal.statistic.actions.UpdateWhitelistAction;
import com.intellij.internal.statistic.eventLog.EventLogNotificationService;
import com.intellij.internal.statistic.eventLog.LogEvent;
import com.intellij.internal.statistic.eventLog.validator.ValidationResultType;
import com.intellij.internal.statistic.toolwindow.StatisticsEventLogConsole;
import com.intellij.internal.statistic.toolwindow.StatisticsEventLogMessageBuilder;
import com.intellij.internal.statistic.toolwindow.StatisticsLogFilterModel;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.SimpleToolWindowPanel;
import com.intellij.openapi.util.Disposer;
import com.intellij.ui.JBColor;
import java.awt.Component;
import java.awt.FlowLayout;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u00132\u00020\u00012\u00020\u0002:\u0001\u0013B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\b\u0010\u0010\u001a\u00020\u0011H\u0002J\b\u0010\u0012\u001a\u00020\rH\u0016R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/intellij/internal/statistic/toolwindow/StatisticsEventLogToolWindow;", "Lcom/intellij/openapi/ui/SimpleToolWindowPanel;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "recorderId", "", "(Lcom/intellij/openapi/project/Project;Ljava/lang/String;)V", "consoleLog", "Lcom/intellij/internal/statistic/toolwindow/StatisticsEventLogConsole;", "eventLogListener", "Lkotlin/Function1;", "Lcom/intellij/internal/statistic/eventLog/LogEvent;", "", "messageBuilder", "Lcom/intellij/internal/statistic/toolwindow/StatisticsEventLogMessageBuilder;", "createActionToolbar", "Ljavax/swing/JComponent;", "dispose", "Companion", "intellij.platform.statistics.devkit"})
public final class StatisticsEventLogToolWindow
extends SimpleToolWindowPanel
implements Disposable {
    private final StatisticsEventLogConsole consoleLog;
    private final StatisticsEventLogMessageBuilder messageBuilder;
    private final Function1<LogEvent, Unit> eventLogListener;
    private final String recorderId;
    @NotNull
    private static final Set<ValidationResultType> rejectedValidationTypes;
    public static final Companion Companion;

    private final JComponent createActionToolbar() {
        DefaultActionGroup topToolbarActions = new DefaultActionGroup();
        topToolbarActions.add((AnAction)new RecordStateStatisticsEventLogAction(false));
        topToolbarActions.add((AnAction)new OpenEventLogFileAction(this.recorderId));
        topToolbarActions.addSeparator(StatisticsBundle.message((String)"stats.whitelist", (Object[])new Object[0]));
        topToolbarActions.add((AnAction)new ConfigureWhitelistAction(this.recorderId));
        topToolbarActions.add((AnAction)new UpdateWhitelistAction(this.recorderId));
        topToolbarActions.add((AnAction)new OpenWhitelistFileAction(this.recorderId));
        topToolbarActions.addSeparator(StatisticsBundle.message((String)"stats.local.whitelist", (Object[])new Object[0]));
        topToolbarActions.add((AnAction)new AddTestGroupToLocalWhitelistAction());
        topToolbarActions.add((AnAction)new CleanupLocalWhitelistAction());
        topToolbarActions.add((AnAction)new OpenLocalWhitelistFileAction(this.recorderId));
        ActionToolbar actionToolbar = ActionManager.getInstance().createActionToolbar("FusEventLogToolWindow", (ActionGroup)topToolbarActions, true);
        Intrinsics.checkExpressionValueIsNotNull((Object)actionToolbar, (String)"ActionManager.getInstanc\u2026 topToolbarActions, true)");
        ActionToolbar toolbar = actionToolbar;
        toolbar.setShowSeparatorTitles(true);
        JComponent jComponent = toolbar.getComponent();
        Intrinsics.checkExpressionValueIsNotNull((Object)jComponent, (String)"toolbar.component");
        return jComponent;
    }

    public void dispose() {
        EventLogNotificationService.INSTANCE.unsubscribe(this.eventLogListener, this.recorderId);
    }

    public StatisticsEventLogToolWindow(@NotNull Project project, @NotNull String recorderId) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)recorderId, (String)"recorderId");
        super(false, true);
        this.recorderId = recorderId;
        this.consoleLog = new StatisticsEventLogConsole(project, new StatisticsLogFilterModel());
        this.messageBuilder = new StatisticsEventLogMessageBuilder();
        this.eventLogListener = (Function1)new Function1<LogEvent, Unit>(this){
            final /* synthetic */ StatisticsEventLogToolWindow this$0;

            public final void invoke(@NotNull LogEvent logEvent) {
                Intrinsics.checkParameterIsNotNull((Object)logEvent, (String)"logEvent");
                StatisticsEventLogToolWindow.access$getConsoleLog$p(this.this$0).addLogLine(StatisticsEventLogToolWindow.access$getMessageBuilder$p(this.this$0).buildLogMessage(logEvent));
            }
            {
                this.this$0 = statisticsEventLogToolWindow;
                super(1);
            }
        };
        JPanel topPanel = new JPanel(new FlowLayout(0));
        topPanel.add((Component)this.consoleLog.getFilter());
        topPanel.add(this.createActionToolbar());
        topPanel.setBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, JBColor.border()));
        this.add(topPanel, "North");
        this.setContent(this.consoleLog.getComponent());
        ActionToolbar actionToolbar = ActionManager.getInstance().createActionToolbar("FusEventLogToolWindow", this.consoleLog.getOrCreateActions(), false);
        Intrinsics.checkExpressionValueIsNotNull((Object)actionToolbar, (String)"ActionManager.getInstanc\u2026g.orCreateActions, false)");
        this.setToolbar(actionToolbar.getComponent());
        Disposer.register((Disposable)this, (Disposable)((Disposable)this.consoleLog));
        EventLogNotificationService.INSTANCE.subscribe(this.eventLogListener, this.recorderId);
    }

    static {
        Companion = new Companion(null);
        rejectedValidationTypes = SetsKt.setOf((Object[])new ValidationResultType[]{ValidationResultType.REJECTED, ValidationResultType.INCORRECT_RULE, ValidationResultType.UNDEFINED_RULE, ValidationResultType.UNREACHABLE_WHITELIST, ValidationResultType.PERFORMANCE_ISSUE});
    }

    public static final /* synthetic */ StatisticsEventLogConsole access$getConsoleLog$p(StatisticsEventLogToolWindow $this) {
        return $this.consoleLog;
    }

    public static final /* synthetic */ StatisticsEventLogMessageBuilder access$getMessageBuilder$p(StatisticsEventLogToolWindow $this) {
        return $this.messageBuilder;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/internal/statistic/toolwindow/StatisticsEventLogToolWindow$Companion;", "", "()V", "rejectedValidationTypes", "", "Lcom/intellij/internal/statistic/eventLog/validator/ValidationResultType;", "getRejectedValidationTypes", "()Ljava/util/Set;", "intellij.platform.statistics.devkit"})
    public static final class Companion {
        @NotNull
        public final Set<ValidationResultType> getRejectedValidationTypes() {
            return rejectedValidationTypes;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

