/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ws.http.request.environment;

import com.intellij.ide.scratch.ScratchUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.ws.http.request.environment.HttpRequestEnvironmentIndex;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HttpRequestIndex {
    @NotNull
    public static Collection<String> getAllEnvironments(@NotNull Project project, @Nullable PsiFile contextFile) {
        if (project == null) {
            HttpRequestIndex.$$$reportNull$$$0(0);
        }
        return HttpRequestIndex.getAllEnvironments(project, HttpRequestIndex.getSearchScope(project, contextFile));
    }

    @NotNull
    public static Collection<String> getAllEnvironments(@NotNull Project project, @NotNull GlobalSearchScope scope) {
        if (project == null) {
            HttpRequestIndex.$$$reportNull$$$0(1);
        }
        if (scope == null) {
            HttpRequestIndex.$$$reportNull$$$0(2);
        }
        FileBasedIndex index = FileBasedIndex.getInstance();
        Collection collection = index.getAllKeys(HttpRequestEnvironmentIndex.KEY, project).stream().filter(env -> !index.getContainingFiles(HttpRequestEnvironmentIndex.KEY, env, scope).isEmpty()).collect(Collectors.toSet());
        if (collection == null) {
            HttpRequestIndex.$$$reportNull$$$0(3);
        }
        return collection;
    }

    public static Collection<VirtualFile> getEnvironmentFiles(@NotNull Project project, @NotNull String env, @Nullable PsiFile contextFile) {
        if (project == null) {
            HttpRequestIndex.$$$reportNull$$$0(4);
        }
        if (env == null) {
            HttpRequestIndex.$$$reportNull$$$0(5);
        }
        GlobalSearchScope scope = HttpRequestIndex.getSearchScope(project, contextFile);
        return FileBasedIndex.getInstance().getContainingFiles(HttpRequestEnvironmentIndex.KEY, (Object)env, scope);
    }

    @NotNull
    public static Collection<String> getAllVariables(@NotNull Project project, @Nullable PsiFile contextFile) {
        GlobalSearchScope scope;
        Collection<String> environments;
        if (project == null) {
            HttpRequestIndex.$$$reportNull$$$0(6);
        }
        if ((environments = HttpRequestIndex.getAllEnvironments(project, scope = HttpRequestIndex.getSearchScope(project, contextFile))).isEmpty()) {
            Set<String> set = Collections.emptySet();
            if (set == null) {
                HttpRequestIndex.$$$reportNull$$$0(7);
            }
            return set;
        }
        HashSet<String> variables = new HashSet<String>();
        for (String env : environments) {
            List varsInEnv = FileBasedIndex.getInstance().getValues(HttpRequestEnvironmentIndex.KEY, (Object)env, scope);
            for (Set vars : varsInEnv) {
                variables.addAll(vars);
            }
        }
        HashSet<String> hashSet = variables;
        if (hashSet == null) {
            HttpRequestIndex.$$$reportNull$$$0(8);
        }
        return hashSet;
    }

    @NotNull
    public static Collection<String> getAllVariables(@NotNull Project project, @NotNull String env, @Nullable PsiFile contextFile) {
        List variables;
        if (project == null) {
            HttpRequestIndex.$$$reportNull$$$0(9);
        }
        if (env == null) {
            HttpRequestIndex.$$$reportNull$$$0(10);
        }
        Collection<String> collection = (variables = FileBasedIndex.getInstance().getValues(HttpRequestEnvironmentIndex.KEY, (Object)env, HttpRequestIndex.getSearchScope(project, contextFile))).size() == 1 ? (Collection)variables.get(0) : Collections.emptyList();
        if (collection == null) {
            HttpRequestIndex.$$$reportNull$$$0(11);
        }
        return collection;
    }

    @NotNull
    public static GlobalSearchScope getSearchScope(@NotNull Project project, @Nullable PsiFile contextFile) {
        VirtualFile dir;
        VirtualFile context;
        if (project == null) {
            HttpRequestIndex.$$$reportNull$$$0(12);
        }
        GlobalSearchScope projectScope = GlobalSearchScope.projectScope((Project)project);
        VirtualFile virtualFile = context = contextFile != null ? contextFile.getOriginalFile().getVirtualFile() : null;
        if (contextFile != null && !ScratchUtil.isScratch((VirtualFile)context) && !projectScope.contains(context) && (dir = context.getParent()) != null) {
            Object[] files = dir.getChildren();
            GlobalSearchScope globalSearchScope = GlobalSearchScope.filesScope((Project)project, (Collection)(files.length > 0 ? ContainerUtil.newArrayList((Object[])files) : Collections.emptyList()));
            if (globalSearchScope == null) {
                HttpRequestIndex.$$$reportNull$$$0(13);
            }
            return globalSearchScope;
        }
        GlobalSearchScope globalSearchScope = projectScope;
        if (globalSearchScope == null) {
            HttpRequestIndex.$$$reportNull$$$0(14);
        }
        return globalSearchScope;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 7: 
            case 8: 
            case 11: 
            case 13: 
            case 14: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 7: 
            case 8: 
            case 11: 
            case 13: 
            case 14: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 3: 
            case 7: 
            case 8: 
            case 11: 
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ws/http/request/environment/HttpRequestIndex";
                break;
            }
            case 5: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "env";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ws/http/request/environment/HttpRequestIndex";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllEnvironments";
                break;
            }
            case 7: 
            case 8: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllVariables";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getSearchScope";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getAllEnvironments";
                break;
            }
            case 3: 
            case 7: 
            case 8: 
            case 11: 
            case 13: 
            case 14: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getEnvironmentFiles";
                break;
            }
            case 6: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getAllVariables";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getSearchScope";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 7: 
            case 8: 
            case 11: 
            case 13: 
            case 14: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

