/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ws.http.request.completion;

import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.indexing.DataIndexer;
import com.intellij.util.indexing.DefaultFileTypeSpecificInputFilter;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileBasedIndexExtension;
import com.intellij.util.indexing.FileContent;
import com.intellij.util.indexing.ID;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.EnumeratorStringDescriptor;
import com.intellij.util.io.KeyDescriptor;
import com.intellij.util.io.VoidDataExternalizer;
import com.intellij.ws.http.request.HttpRequestCollectionProvider;
import com.intellij.ws.http.request.HttpRequestFileType;
import com.intellij.ws.http.request.HttpRequestPsiFile;
import com.intellij.ws.http.request.HttpRequestPsiUtils;
import com.intellij.ws.http.request.psi.HttpHost;
import com.intellij.ws.http.request.psi.HttpRequestBlock;
import com.intellij.ws.http.request.psi.HttpRequestTarget;
import com.intellij.ws.http.request.psi.HttpScheme;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class HttpRequestHostIndex
extends FileBasedIndexExtension<String, Void> {
    @NonNls
    public static final ID<String, Void> KEY = ID.create((String)"http.request.completion.host");

    @NotNull
    public ID<String, Void> getName() {
        ID<String, Void> iD = KEY;
        if (iD == null) {
            HttpRequestHostIndex.$$$reportNull$$$0(0);
        }
        return iD;
    }

    @NotNull
    public DataIndexer<String, Void, FileContent> getIndexer() {
        return new DataIndexer<String, Void, FileContent>(){

            @NotNull
            public Map<String, Void> map(@NotNull FileContent inputData) {
                PsiFile file;
                if (inputData == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (!((file = inputData.getPsiFile()) instanceof HttpRequestPsiFile)) {
                    Map<String, Void> map = Collections.emptyMap();
                    if (map == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    return map;
                }
                HashMap<String, Void> result = new HashMap<String, Void>();
                for (String s : HttpRequestHostIndex.getHostNames((HttpRequestPsiFile)file)) {
                    result.put(s, null);
                }
                HashMap<String, Void> hashMap = result;
                if (hashMap == null) {
                    1.$$$reportNull$$$0(2);
                }
                return hashMap;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 1: 
                    case 2: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 1: 
                    case 2: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "inputData";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/ws/http/request/completion/HttpRequestHostIndex$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/ws/http/request/completion/HttpRequestHostIndex$1";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "map";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "map";
                        break;
                    }
                    case 1: 
                    case 2: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 1: 
                    case 2: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        };
    }

    public static Set<String> getHostNames(@NotNull HttpRequestPsiFile file) {
        if (file == null) {
            HttpRequestHostIndex.$$$reportNull$$$0(1);
        }
        return HttpRequestHostIndex.getHostNames(file, true);
    }

    public static Set<String> getHostNames(@NotNull HttpRequestPsiFile file, boolean withScheme) {
        HttpRequestBlock[] requestBlocks;
        if (file == null) {
            HttpRequestHostIndex.$$$reportNull$$$0(2);
        }
        HashSet<String> hosts = new HashSet<String>();
        for (HttpRequestBlock block : requestBlocks = HttpRequestPsiUtils.getRequestBlocks((PsiFile)file)) {
            HttpScheme scheme;
            HttpRequestTarget target = block != null ? block.getRequest().getRequestTarget() : null;
            HttpHost host = target != null ? target.getHost() : null;
            HttpScheme httpScheme = scheme = target != null ? target.getScheme() : null;
            if (host == null) continue;
            hosts.add((withScheme && scheme != null ? scheme.getText() + "://" : "") + host.getText());
        }
        return hosts;
    }

    @NotNull
    public static Collection<String> getHostsFromIndex(@NotNull Project project) {
        if (project == null) {
            HttpRequestHostIndex.$$$reportNull$$$0(3);
        }
        FileBasedIndex index = FileBasedIndex.getInstance();
        GlobalSearchScope scope = GlobalSearchScope.projectScope((Project)project);
        Collection collection = index.getAllKeys(KEY, project).stream().filter(key -> !index.getContainingFiles(KEY, key, scope).isEmpty()).collect(Collectors.toSet());
        if (collection == null) {
            HttpRequestHostIndex.$$$reportNull$$$0(4);
        }
        return collection;
    }

    @NotNull
    public KeyDescriptor<String> getKeyDescriptor() {
        EnumeratorStringDescriptor enumeratorStringDescriptor = EnumeratorStringDescriptor.INSTANCE;
        if (enumeratorStringDescriptor == null) {
            HttpRequestHostIndex.$$$reportNull$$$0(5);
        }
        return enumeratorStringDescriptor;
    }

    @NotNull
    public DataExternalizer<Void> getValueExternalizer() {
        VoidDataExternalizer voidDataExternalizer = VoidDataExternalizer.INSTANCE;
        if (voidDataExternalizer == null) {
            HttpRequestHostIndex.$$$reportNull$$$0(6);
        }
        return voidDataExternalizer;
    }

    public int getVersion() {
        return 4;
    }

    @NotNull
    public FileBasedIndex.InputFilter getInputFilter() {
        return new DefaultFileTypeSpecificInputFilter(new FileType[]{HttpRequestFileType.INSTANCE}){

            public boolean acceptInput(@NotNull VirtualFile file) {
                if (file == null) {
                    2.$$$reportNull$$$0(0);
                }
                return super.acceptInput(file) && !this.isCollectionFile(file);
            }

            private boolean isCollectionFile(@NotNull VirtualFile file) {
                if (file == null) {
                    2.$$$reportNull$$$0(1);
                }
                VirtualFile parentDirectory = file.getParent();
                VirtualFile collectionRoot = (VirtualFile)HttpRequestCollectionProvider.COLLECTION.getValue();
                return parentDirectory != null && collectionRoot != null && parentDirectory.getUrl().equals(collectionRoot.getUrl());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "file";
                objectArray2[1] = "com/intellij/ws/http/request/completion/HttpRequestHostIndex$2";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "acceptInput";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "isCollectionFile";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    public boolean dependsOnFileContent() {
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ws/http/request/completion/HttpRequestHostIndex";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ws/http/request/completion/HttpRequestHostIndex";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getHostsFromIndex";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getKeyDescriptor";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getValueExternalizer";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getHostNames";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getHostsFromIndex";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

