/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.performancePlugin.tracing.agent;

import org.jetbrains.org.objectweb.asm.MethodVisitor;
import org.jetbrains.org.objectweb.asm.Type;
import org.jetbrains.org.objectweb.asm.commons.AdviceAdapter;

class TracingMethodVisitor
extends AdviceAdapter {
    private static final String tracerJVMName = "com.intellij.diagnostic.tracing.MethodTracer".replace('.', '/');
    private static final String tracerTypeDescriptor = "L" + tracerJVMName + ";";
    private static final String getInstance = "getInstance";
    private static final String onMethodStart = "onMethodEnter";
    private static final String onMethodExit = "onMethodExit";
    private static final String tracerGetInstanceSignature = "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)" + tracerTypeDescriptor;
    private String tracerId;
    private String className;
    private String methodName;
    private int newVarIndex;

    TracingMethodVisitor(int api, MethodVisitor mv, int access, String name, String desc, String tracerId, String className, String methodName) {
        super(api, mv, access, name, desc);
        this.tracerId = tracerId;
        this.className = className;
        this.methodName = methodName;
    }

    protected void onMethodEnter() {
        this.newVarIndex = this.newLocal(Type.getType((String)tracerTypeDescriptor));
        this.mv.visitLdcInsn((Object)this.tracerId);
        this.mv.visitLdcInsn((Object)this.className);
        this.mv.visitLdcInsn((Object)this.methodName);
        this.mv.visitMethodInsn(184, tracerJVMName, getInstance, tracerGetInstanceSignature, false);
        this.mv.visitVarInsn(58, this.newVarIndex);
        this.mv.visitVarInsn(25, this.newVarIndex);
        this.mv.visitMethodInsn(182, tracerJVMName, onMethodStart, "()V", false);
    }

    protected void onMethodExit(int opcode) {
        this.mv.visitVarInsn(25, this.newVarIndex);
        this.mv.visitMethodInsn(182, tracerJVMName, onMethodExit, "()V", false);
    }
}

