/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.performancePlugin.commands;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.playback.PlaybackContext;
import com.intellij.openapi.ui.playback.commands.AbstractCommand;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.ManagingFS;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileBasedIndexExtension;
import com.intellij.util.indexing.FileBasedIndexImpl;
import com.intellij.util.indexing.ID;
import com.intellij.util.indexing.IndexExtension;
import com.intellij.util.indexing.SingleEntryFileBasedIndexExtension;
import com.intellij.util.indexing.StorageException;
import com.intellij.util.indexing.UpdatableIndex;
import com.intellij.util.indexing.ValueContainer;
import com.intellij.util.indexing.VfsAwareMapIndexStorage;
import com.intellij.util.indexing.VfsAwareMapReduceIndex;
import com.intellij.util.indexing.impl.IndexStorage;
import com.jetbrains.performancePlugin.commands.StoreIndices;
import com.jetbrains.performancePlugin.utils.ActionCallbackProfilerStopper;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import gnu.trove.TIntHashSet;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;

public class CompareIndices
extends AbstractCommand {
    private final Project myProject;
    public static final String PREFIX = "%compareIndices";

    public CompareIndices(String text, int line, Project project) {
        super(text, line);
        this.myProject = project;
    }

    protected Promise<Object> _execute(PlaybackContext context) {
        ((FileBasedIndexImpl)FileBasedIndex.getInstance()).flushIndexes();
        ActionCallbackProfilerStopper actionCallback = new ActionCallbackProfilerStopper();
        ArrayList<ID> ids = new ArrayList<ID>();
        ids.add(ID.findByName((String)"TodoIndex"));
        ids.add(ID.findByName((String)"HashFragmentIndex"));
        for (ID id : ids) {
            ApplicationManager.getApplication().runReadAction(() -> {
                try {
                    CompareIndices.compareIndexWithSaved(id, StoreIndices.getStoredIndex(), this.myProject);
                }
                catch (StorageException | IOException e) {
                    actionCallback.reject(e.getMessage());
                }
            });
        }
        actionCallback.setDone();
        return Promises.toPromise((ActionCallback)actionCallback);
    }

    public static <K, V> void compareIndexWithSaved(@NotNull ID<K, V> id, @NotNull Path dir, @NotNull Project project) throws IOException, StorageException {
        if (id == null) {
            CompareIndices.$$$reportNull$$$0(0);
        }
        if (dir == null) {
            CompareIndices.$$$reportNull$$$0(1);
        }
        if (project == null) {
            CompareIndices.$$$reportNull$$$0(2);
        }
        FileBasedIndexExtension extension = (FileBasedIndexExtension)FileBasedIndexExtension.EXTENSION_POINT_NAME.findFirstSafe(ex -> ex.getName().equals(id));
        assert (extension != null);
        VfsAwareMapIndexStorage storage = new VfsAwareMapIndexStorage(dir.resolve(StringUtil.toLowerCase((String)id.getName())).resolve(id.getName()), extension.getKeyDescriptor(), extension.getValueExternalizer(), 1024, extension.keyIsUniqueForIndexedFile(), extension.traceKeyHashToVirtualFileMapping());
        VfsAwareMapReduceIndex index = new VfsAwareMapReduceIndex((IndexExtension)extension, (IndexStorage)storage);
        boolean isSingleEntryIndex = extension instanceof SingleEntryFileBasedIndexExtension;
        CommonProcessors.CollectProcessor allInitialKeyProcessor = new CommonProcessors.CollectProcessor();
        storage.processKeys((Processor)allInitialKeyProcessor);
        Collection allInitialKeys = allInitialKeyProcessor.getResults();
        Collection allCurrentKeys = FileBasedIndex.getInstance().getAllKeys(id, project);
        if (!allCurrentKeys.containsAll(allInitialKeys)) {
            CompareIndices.reportKeySetIsDifferent(allInitialKeys, allCurrentKeys, id);
        }
        if (isSingleEntryIndex) {
            for (Object key : allCurrentKeys) {
                Map savedData;
                int fileId = (Integer)key;
                VirtualFile vFile = ManagingFS.getInstance().findFileById(fileId);
                if (vFile == null) {
                    throw new AssertionError((Object)("file is not present for " + fileId));
                }
                Map currentData = FileBasedIndex.getInstance().getFileData(id, vFile, project);
                if (!currentData.equals(savedData = index.getIndexedFileData(fileId))) {
                    throw new AssertionError((Object)("current data = " + currentData + "\nand saved data = " + savedData + "\n are different for file " + vFile.getPath()));
                }
            }
        } else {
            FileBasedIndex.getInstance().ensureUpToDate(id, project, GlobalSearchScope.allScope((Project)project));
            UpdatableIndex currentIndex = ((FileBasedIndexImpl)FileBasedIndex.getInstance()).getIndex(id);
            for (Object key : allCurrentKeys) {
                @NotNull Map<V, TIntHashSet> currentData = CompareIndices.asMap(currentIndex.getData(key));
                @NotNull Map<V, TIntHashSet> initialData = CompareIndices.asMap(index.getData(key));
                CompareIndices.assertEquals(currentData, initialData, key, id);
            }
        }
        index.dispose();
    }

    private static <K, V> void assertEquals(@NotNull Map<V, TIntHashSet> currentData, @NotNull Map<V, TIntHashSet> expectedData, @NotNull K key, @NotNull ID<K, V> indexId) {
        THashSet expectedValues;
        THashSet currentValues;
        if (currentData == null) {
            CompareIndices.$$$reportNull$$$0(3);
        }
        if (expectedData == null) {
            CompareIndices.$$$reportNull$$$0(4);
        }
        if (key == null) {
            CompareIndices.$$$reportNull$$$0(5);
        }
        if (indexId == null) {
            CompareIndices.$$$reportNull$$$0(6);
        }
        if (!(currentValues = new THashSet(currentData.keySet())).equals(expectedValues = new THashSet(expectedData.keySet()))) {
            THashSet missedCurrentValues = new THashSet((Collection)expectedValues);
            missedCurrentValues.removeAll((Collection<?>)currentValues);
            THashSet missedExpectedValues = new THashSet((Collection)currentValues);
            missedCurrentValues.removeAll((Collection<?>)expectedValues);
            if (!missedCurrentValues.isEmpty()) {
                throw new AssertionError((Object)("Currently present indexed values are incomplete " + missedCurrentValues + " for key " + key + " in index" + indexId));
            }
            if (!missedExpectedValues.isEmpty()) {
                throw new AssertionError((Object)("Currently present indexed values are overcomplete " + missedExpectedValues + " for key " + key + " in index" + indexId));
            }
        }
    }

    @NotNull
    private static <V> Map<V, TIntHashSet> asMap(@NotNull ValueContainer<V> valueContainer) {
        if (valueContainer == null) {
            CompareIndices.$$$reportNull$$$0(7);
        }
        THashMap result = new THashMap();
        valueContainer.forEach((arg_0, arg_1) -> CompareIndices.lambda$asMap$3((Map)result, arg_0, arg_1));
        THashMap tHashMap = result;
        if (tHashMap == null) {
            CompareIndices.$$$reportNull$$$0(8);
        }
        return tHashMap;
    }

    private static void reportKeySetIsDifferent(@NotNull Collection<?> initialKeys, @NotNull Collection<?> currentKeys, @NotNull ID<?, ?> id) {
        if (initialKeys == null) {
            CompareIndices.$$$reportNull$$$0(9);
        }
        if (currentKeys == null) {
            CompareIndices.$$$reportNull$$$0(10);
        }
        if (id == null) {
            CompareIndices.$$$reportNull$$$0(11);
        }
        THashSet missedCurrentKeys = new THashSet(initialKeys);
        missedCurrentKeys.removeAll(currentKeys);
        THashSet missedInitialKeys = new THashSet(currentKeys);
        currentKeys.removeAll(initialKeys);
        if (!missedCurrentKeys.isEmpty()) {
            throw new AssertionError((Object)("Currently present indexed keys are incomplete: " + missedCurrentKeys + " for index " + id.getName()));
        }
        if (!missedInitialKeys.isEmpty()) {
            throw new AssertionError((Object)("Currently present indexed keys are overcomplete: " + missedInitialKeys + " for index " + id.getName()));
        }
    }

    private static /* synthetic */ boolean lambda$asMap$3(Map result, int id, Object value) {
        result.computeIfAbsent(value, __ -> new TIntHashSet()).add(id);
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dir";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "currentData";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expectedData";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indexId";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "valueContainer";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/performancePlugin/commands/CompareIndices";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "initialKeys";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "currentKeys";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/performancePlugin/commands/CompareIndices";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "asMap";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "compareIndexWithSaved";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "assertEquals";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "asMap";
                break;
            }
            case 8: {
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "reportKeySetIsDifferent";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

