/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.performancePlugin.commands;

import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.ui.playback.PlaybackContext;
import com.intellij.openapi.ui.playback.commands.AbstractCommand;
import com.intellij.psi.impl.cache.impl.id.IdIndex;
import com.intellij.psi.stubs.StubUpdatingIndex;
import com.intellij.util.indexing.ID;
import com.intellij.util.indexing.IndexInfrastructure;
import java.io.File;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;

public class CheckIndexesCommand
extends AbstractCommand {
    public static final String PREFIX = "%checkIndexes";
    private static final Logger LOG = Logger.getInstance(CheckIndexesCommand.class);

    public CheckIndexesCommand(@NotNull String text, int line) {
        if (text == null) {
            CheckIndexesCommand.$$$reportNull$$$0(0);
        }
        super(text, line);
    }

    protected Promise<Object> _execute(PlaybackContext context) {
        String ideaIndexSnapshotMappingsEnabled = System.getProperties().getProperty("idea.index.snapshot.mappings.enabled");
        String comIntellijCompositeIndexers = System.getProperties().getProperty("com.intellij.composite.indexers");
        String ideaSharedInputIndexEnabled = System.getProperties().getProperty("idea.shared.input.index.enabled");
        String ideaCompressionEnabled = System.getProperties().getProperty("idea.compression.enabled");
        File textContentHashes = new File(IndexInfrastructure.getPersistentIndexRoot(), "textContentHashes");
        File perFileVersionDir = new File(IndexInfrastructure.getIndexRootDir((ID)StubUpdatingIndex.INDEX_ID), ".perFileVersion");
        File inputsData = new File(PathManager.getIndexRoot(), "file_inputs.data");
        File idIndexStorageValuesS = new File(IndexInfrastructure.getIndexRootDir((ID)IdIndex.NAME), "IdIndex.storage.values.s");
        try {
            if (ideaIndexSnapshotMappingsEnabled == null || ideaIndexSnapshotMappingsEnabled.equals("true")) {
                if (!textContentHashes.exists()) {
                    throw new Exception("textContentHashes does not exist although System Property idea.index.snapshot.mappings.enabled switched on");
                }
            } else if (ideaIndexSnapshotMappingsEnabled.equals("false") && textContentHashes.exists()) {
                throw new Exception("textContentHashes exists although System Property idea.index.snapshot.mappings.enabled switched off");
            }
            if (comIntellijCompositeIndexers == null || comIntellijCompositeIndexers.equals("true")) {
                if (!perFileVersionDir.exists()) {
                    throw new Exception("PerFileVersionDir does not exist although System Property com.intellij.composite.indexers switched on");
                }
            } else if (comIntellijCompositeIndexers.equals("false") && perFileVersionDir.exists()) {
                throw new Exception("PerFileVersionDir exist although System Property com.intellij.composite.indexers switched off");
            }
            if (ideaSharedInputIndexEnabled == null || ideaSharedInputIndexEnabled.equals("false")) {
                if (inputsData.exists()) {
                    throw new Exception("InputsData exist although System Property idea.shared.input.index.enabled switched off");
                }
            } else if (ideaSharedInputIndexEnabled.equals("true") && !inputsData.exists()) {
                throw new Exception("InputsData does not exist although System Property idea.shared.input.index.enabled switched on");
            }
            if (ideaCompressionEnabled == null || ideaCompressionEnabled.equals("true")) {
                if (!idIndexStorageValuesS.exists()) {
                    throw new Exception("idIndexStorageValuesS does not exist although System Property idea.compression.enabled switched on");
                }
            } else if (ideaCompressionEnabled.equals("false") && idIndexStorageValuesS.exists()) {
                throw new Exception("idIndexStorageValuesS exist although System Property idea.compression.enabled switched off");
            }
        }
        catch (Exception ex) {
            LOG.error((Throwable)ex);
            return Promises.rejectedPromise((String)"Check Indexes failed");
        }
        return Promises.resolvedPromise((Object)"Check Indexes succeeded");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/jetbrains/performancePlugin/commands/CheckIndexesCommand", "<init>"));
    }
}

