/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.performancePlugin;

import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.performancePlugin.CommandProvider;
import com.jetbrains.performancePlugin.CreateCommand;
import com.jetbrains.performancePlugin.commands.BuildCommand;
import com.jetbrains.performancePlugin.commands.CheckIndexesCommand;
import com.jetbrains.performancePlugin.commands.CheckSharedIndices;
import com.jetbrains.performancePlugin.commands.CleanCaches;
import com.jetbrains.performancePlugin.commands.CompareIndices;
import com.jetbrains.performancePlugin.commands.CompletionCommand;
import com.jetbrains.performancePlugin.commands.DelayTypeCommand;
import com.jetbrains.performancePlugin.commands.DisablePluginCommand;
import com.jetbrains.performancePlugin.commands.DoLocalInspection;
import com.jetbrains.performancePlugin.commands.EnablePluginCommand;
import com.jetbrains.performancePlugin.commands.EnterCommand;
import com.jetbrains.performancePlugin.commands.ExitAppCommand;
import com.jetbrains.performancePlugin.commands.FindUsagesCommand;
import com.jetbrains.performancePlugin.commands.GoToCommand;
import com.jetbrains.performancePlugin.commands.InspectionCommand;
import com.jetbrains.performancePlugin.commands.InspectionCommandEx;
import com.jetbrains.performancePlugin.commands.MemoryDumpCommand;
import com.jetbrains.performancePlugin.commands.OpenFileCommand;
import com.jetbrains.performancePlugin.commands.OpenProjectView;
import com.jetbrains.performancePlugin.commands.RebuildCommand;
import com.jetbrains.performancePlugin.commands.ReformatCommand;
import com.jetbrains.performancePlugin.commands.ReplaceTextCommand;
import com.jetbrains.performancePlugin.commands.SelectCommand;
import com.jetbrains.performancePlugin.commands.ShowAltEnter;
import com.jetbrains.performancePlugin.commands.SingleInspectionCommand;
import com.jetbrains.performancePlugin.commands.StartPowerSave;
import com.jetbrains.performancePlugin.commands.StartProfileCommand;
import com.jetbrains.performancePlugin.commands.StopPowerSave;
import com.jetbrains.performancePlugin.commands.StopProfileCommand;
import com.jetbrains.performancePlugin.commands.StoreIndices;
import com.jetbrains.performancePlugin.commands.VCSCheckoutCommand;
import com.jetbrains.performancePlugin.commands.WaitForSmartCommand;
import gnu.trove.THashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class BaseCommandProvider
implements CommandProvider {
    @Override
    public List<Pair<String, CreateCommand>> getCommands(Project project) {
        THashMap map = new THashMap();
        BaseCommandProvider.initCommands((Map<String, CreateCommand>)map, project);
        return ContainerUtil.map(map.entrySet(), entry -> new Pair(entry.getKey(), entry.getValue()));
    }

    private static void initCommands(@NotNull Map<String, CreateCommand> map, Project myProject) {
        if (map == null) {
            BaseCommandProvider.$$$reportNull$$$0(0);
        }
        map.put("%openFile", (command, line) -> new OpenFileCommand(command, line, myProject));
        map.put("%startProfile", (command, line) -> new StartProfileCommand(command, line));
        map.put("%stopProfile", (command, line) -> new StopProfileCommand(command, line));
        map.put("%inspectCode", (command, line) -> new InspectionCommand(command, line, myProject));
        map.put("%InspectCodeEx", (command, line) -> new InspectionCommandEx(command, line, myProject));
        map.put("%reformat", (command, line) -> new ReformatCommand(command, line, myProject));
        map.put("%goto", (command, line) -> new GoToCommand(command, line, myProject));
        map.put("%doLocalInspection", (command, line) -> new DoLocalInspection(command, line, myProject));
        map.put("%doComplete", (command, line) -> new CompletionCommand(command, line, myProject));
        map.put("%delayType", (command, line) -> new DelayTypeCommand(command, line));
        map.put("%replaceText", (command, line) -> new ReplaceTextCommand(command, line, myProject));
        map.put("%exitApp", (command, line) -> new ExitAppCommand(command, line));
        map.put("%waitForSmart", (command, line) -> new WaitForSmartCommand(command, line, myProject));
        map.put("%runSingleInspection", (command, line) -> new SingleInspectionCommand(command, line, myProject));
        map.put("%startPowerSave", (command, line) -> new StartPowerSave(command, line, myProject));
        map.put("%stopPowerSave", (command, line) -> new StopPowerSave(command, line, myProject));
        map.put("%memoryDump", (command, line) -> new MemoryDumpCommand(command, line));
        map.put("%cleanCaches", (command, line) -> new CleanCaches(command, line));
        map.put("%findUsages", (command, line) -> new FindUsagesCommand(command, line, myProject));
        map.put("%pressKey", (command, line) -> new EnterCommand(command, line, myProject));
        map.put("%buildProject", (command, line) -> new BuildCommand(command, line, myProject));
        map.put("%rebuildProject", (command, line) -> new RebuildCommand(command, line, myProject));
        map.put("%altEnter", (command, line) -> new ShowAltEnter(command, line, myProject));
        map.put("%selectText", (command, line) -> new SelectCommand(command, line));
        map.put("%enablePlugin", (command, line) -> new EnablePluginCommand(command, line, myProject));
        map.put("%disablePlugin", (command, line) -> new DisablePluginCommand(command, line, myProject));
        map.put("%compareIndices", (command, line) -> new CompareIndices(command, line, myProject));
        map.put("%storeIndices", (command, line) -> new StoreIndices(command, line));
        if (BaseCommandProvider.isGitPluginEnabled()) {
            map.put("%vcsCheckout", (command, line) -> new VCSCheckoutCommand(command, line, myProject));
        }
        map.put("%openProjectView", (command, line) -> new OpenProjectView(command, line, myProject));
        map.put("%checkIndexes", (command, line) -> new CheckIndexesCommand(command, line));
        map.put("%checkSharedIndices", (command, line) -> new CheckSharedIndices(command, line, myProject));
    }

    private static boolean isGitPluginEnabled() {
        PluginId id = PluginId.getId((String)"Git4Idea");
        IdeaPluginDescriptor ideaPluginDescriptor = PluginManagerCore.getPlugin((PluginId)id);
        return PluginManagerCore.isPluginInstalled((PluginId)id) && ideaPluginDescriptor != null && ideaPluginDescriptor.isEnabled();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "map", "com/jetbrains/performancePlugin/BaseCommandProvider", "initCommands"));
    }
}

