/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.debugger.sourcemap;

import com.google.common.collect.BiMap;
import com.intellij.javascript.debugger.JavaScriptDebugProcessKt;
import com.intellij.javascript.debugger.sourcemap.PreloadedSourceMapList;
import com.intellij.javascript.debugger.sourcemap.SourceMapLoaderKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.SmartList;
import com.intellij.util.Url;
import com.intellij.util.Urls;
import com.intellij.util.containers.UtilKt;
import com.intellij.util.io.PathKt;
import com.intellij.util.io.URLUtil;
import java.io.Closeable;
import java.io.File;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CancellationException;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.debugger.sourcemap.SourceMap;
import org.jetbrains.debugger.sourcemap.SourceMapDecoderKt;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u001a\u0010\u0007\u001a\u00020\b2\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\nJ\u0018\u0010\r\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J@\u0010\u0012\u001a\u00020\b2\u0006\u0010\u0013\u001a\u00020\u00112\u0006\u0010\u000e\u001a\u00020\u000f2\n\b\u0002\u0010\u0014\u001a\u0004\u0018\u00010\u000b2\b\b\u0002\u0010\u0015\u001a\u00020\u00052\b\b\u0002\u0010\u0016\u001a\u00020\u00052\b\b\u0002\u0010\u0017\u001a\u00020\u0018R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/intellij/javascript/debugger/sourcemap/SourceMapCollector;", "", "list", "Lcom/intellij/javascript/debugger/sourcemap/PreloadedSourceMapList;", "trimFileScheme", "", "(Lcom/intellij/javascript/debugger/sourcemap/PreloadedSourceMapList;Z)V", "collect", "", "mappings", "Lcom/google/common/collect/BiMap;", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "processScript", "baseUrl", "Lcom/intellij/util/Url;", "file", "Ljava/nio/file/Path;", "resolveSourcemaps", "dir", "root", "checkJs", "checkMap", "level", "", "intellij.javascript.debugger"})
public final class SourceMapCollector {
    private final PreloadedSourceMapList list;
    private final boolean trimFileScheme;

    public final void collect(@NotNull BiMap<String, VirtualFile> mappings) {
        Intrinsics.checkParameterIsNotNull(mappings, (String)"mappings");
        Iterator iterator = ((Set)mappings.values()).iterator();
        while (iterator.hasNext()) {
            Url url;
            Path ioDir;
            VirtualFile file2;
            VirtualFile virtualFile = file2 = (VirtualFile)iterator.next();
            Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile, (String)"file");
            Path path = ioDir = Paths.get(virtualFile.getPath(), new String[0]);
            Intrinsics.checkExpressionValueIsNotNull((Object)path, (String)"ioDir");
            if (!PathKt.isDirectory((Path)path) || ioDir.isAbsolute() && ioDir.getParent() == null) continue;
            Object object = mappings.inverse().get((Object)file2);
            if (object == null) {
                Intrinsics.throwNpe();
            }
            if (Urls.parseFromIdea((CharSequence)((CharSequence)object)) == null) continue;
            boolean bl = false;
            boolean bl2 = false;
            Url it = url;
            boolean bl3 = false;
            SourceMapCollector.resolveSourcemaps$default(this, ioDir, it, null, false, false, 0, 60, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public final void resolveSourcemaps(@NotNull Path dir, @NotNull Url baseUrl, @Nullable String root, boolean checkJs, boolean checkMap, int level) {
        Intrinsics.checkParameterIsNotNull((Object)dir, (String)"dir");
        Intrinsics.checkParameterIsNotNull((Object)baseUrl, (String)"baseUrl");
        if (dir.isAbsolute() && dir.getParent() == null) {
            JavaScriptDebugProcessKt.getLOG().warn("Source maps are searched in FS root: " + dir);
            return;
        }
        List children2 = null;
        Path path = dir;
        Function1 filter$iv = (Function1)new Function1<Path, Boolean>(checkJs, checkMap){
            final /* synthetic */ boolean $checkJs;
            final /* synthetic */ boolean $checkMap;

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final boolean invoke(@NotNull Path it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                if (PathKt.isHidden((Path)it)) {
                    return false;
                }
                BasicFileAttributes basicFileAttributes = PathKt.basicAttributesIfExists((Path)it);
                if (basicFileAttributes == null) return false;
                BasicFileAttributes attributes = basicFileAttributes;
                if (attributes.isDirectory()) {
                    if (Intrinsics.areEqual((Object)((Object)it.getFileName()).toString(), (Object)"node_modules") ^ true) return true;
                }
                if (!attributes.isRegularFile()) return false;
                String string = ((Object)it.getFileName()).toString();
                boolean bl = false;
                boolean bl2 = false;
                String $this$run = string;
                boolean bl3 = false;
                if (this.$checkJs) {
                    if (StringsKt.endsWith$default((String)$this$run, (String)".js", (boolean)false, (int)2, null)) return true;
                }
                if (!this.$checkMap) return false;
                if (!StringsKt.endsWith$default((String)$this$run, (String)".map", (boolean)false, (int)2, null)) return false;
                return true;
            }
            {
                this.$checkJs = bl;
                this.$checkMap = bl2;
                super(1);
            }
        };
        boolean $i$f$directoryStreamIfExists = false;
        try {
            void $this$directoryStreamIfExists$iv;
            Closeable closeable = Files.newDirectoryStream((Path)$this$directoryStreamIfExists$iv, (DirectoryStream.Filter<? super Path>)new DirectoryStream.Filter<Path>(filter$iv){
                final /* synthetic */ Function1 $filter;
                {
                    this.$filter = function1;
                }

                public final boolean accept(Path it) {
                    Path path = it;
                    Intrinsics.checkExpressionValueIsNotNull((Object)path, (String)"it");
                    return (Boolean)this.$filter.invoke((Object)path);
                }
            });
            boolean bl = false;
            Throwable throwable = null;
            try {
                String string;
                boolean bl2;
                Object it;
                DirectoryStream it2 = (DirectoryStream)closeable;
                boolean bl3 = false;
                Iterator iterator = it2.iterator();
                Intrinsics.checkExpressionValueIsNotNull(iterator, (String)"it.iterator()");
                Iterator iterator2 = iterator;
                if (!iterator2.hasNext()) {
                    return;
                }
                String dirPath = ((Object)dir.toAbsolutePath()).toString();
                String string2 = root;
                if (string2 != null) {
                    String string3 = string2;
                    boolean bl4 = false;
                    boolean bl5 = false;
                    it = string3;
                    bl2 = false;
                    string = Intrinsics.stringPlus((String)FileUtilRt.getRelativePath((String)root, (String)dirPath, (char)File.separatorChar), (Object)Character.valueOf(File.separatorChar));
                } else {
                    string = null;
                }
                String dirRelativePathWithSeparator = string;
                Url baseLocalFsUrl = Urls.newLocalFileUrl((String)dirPath);
                children2 = (List)new SmartList();
                it = iterator2;
                bl2 = false;
                Object object = it;
                while (object.hasNext()) {
                    Path file2;
                    Path path2 = file2 = (Path)object.next();
                    Intrinsics.checkExpressionValueIsNotNull((Object)path2, (String)"file");
                    if (PathKt.isDirectory((Path)path2)) {
                        if (level > 4) {
                            JavaScriptDebugProcessKt.getLOG().warn("Sourcemaps are not collected in " + file2 + ": deep > 4");
                            continue;
                        }
                        Url url = baseUrl.resolve(((Object)file2.getFileName()).toString());
                        Intrinsics.checkExpressionValueIsNotNull((Object)url, (String)"baseUrl.resolve(file.fileName.toString())");
                        this.resolveSourcemaps(file2, url, root, checkJs, checkMap, level + 1);
                        continue;
                    }
                    String fileName = ((Object)file2.getFileName()).toString();
                    if (checkJs && !StringsKt.endsWith$default((String)fileName, (String)".map", (boolean)false, (int)2, null)) {
                        children2.add(file2);
                        continue;
                    }
                    Logger $this$runAndLogException$iv = JavaScriptDebugProcessKt.getLOG();
                    boolean $i$f$runAndLogException = false;
                    try {
                        SourceMap map;
                        boolean bl6 = false;
                        if (SourceMapDecoderKt.decodeSourceMapFromFile((Path)file2, (boolean)this.trimFileScheme, (Url)baseLocalFsUrl, (boolean)false) == null) {
                            continue;
                        }
                        String string4 = map.getOutFile();
                        if (string4 == null) {
                            String string5 = fileName;
                            int n = 0;
                            int n2 = fileName.length() - ".map".length();
                            boolean bl7 = false;
                            String string6 = string5;
                            if (string6 == null) {
                                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                            }
                            String string7 = string6.substring(n, n2);
                            string4 = string7;
                            Intrinsics.checkExpressionValueIsNotNull((Object)string7, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                        }
                        String scriptFileName = string4;
                        Url scriptUrl = baseUrl.resolve(scriptFileName);
                        String string8 = dirRelativePathWithSeparator;
                        String mapPath = string8 != null ? string8 + scriptFileName : null;
                        Url url = baseUrl.resolve(fileName);
                        Intrinsics.checkExpressionValueIsNotNull((Object)url, (String)"baseUrl.resolve(fileName)");
                        Url url2 = scriptUrl;
                        Intrinsics.checkExpressionValueIsNotNull((Object)url2, (String)"scriptUrl");
                        this.list.add(url, map, url2, mapPath, file2);
                    }
                    catch (ProcessCanceledException e$iv) {
                        throw (Throwable)e$iv;
                    }
                    catch (CancellationException e$iv) {
                        throw (Throwable)e$iv;
                    }
                    catch (Throwable e$iv) {
                        $this$runAndLogException$iv.error(e$iv);
                    }
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
        catch (NoSuchFileException noSuchFileException) {
        }
        if (!UtilKt.isNullOrEmpty((Collection)children2)) {
            List list = children2;
            if (list == null) {
                Intrinsics.throwNpe();
            }
            for (Path file3 : list) {
                Logger $this$runAndLogException$iv = JavaScriptDebugProcessKt.getLOG();
                boolean $i$f$runAndLogException = false;
                try {
                    boolean bl = false;
                    this.processScript(baseUrl, file3);
                }
                catch (ProcessCanceledException e$iv) {
                    throw (Throwable)e$iv;
                }
                catch (CancellationException e$iv) {
                    throw (Throwable)e$iv;
                }
                catch (Throwable e$iv) {
                    $this$runAndLogException$iv.error(e$iv);
                }
            }
        }
    }

    public static /* synthetic */ void resolveSourcemaps$default(SourceMapCollector sourceMapCollector, Path path, Url url, String string, boolean bl, boolean bl2, int n, int n2, Object object) {
        if ((n2 & 4) != 0) {
            string = null;
        }
        if ((n2 & 8) != 0) {
            bl = true;
        }
        if ((n2 & 0x10) != 0) {
            bl2 = true;
        }
        if ((n2 & 0x20) != 0) {
            n = 0;
        }
        sourceMapCollector.resolveSourcemaps(path, url, string, bl, bl2, n);
    }

    private final void processScript(Url baseUrl, Path file2) {
        block2: {
            Url scriptUrl;
            String sourceMapUrl = SourceMapLoaderKt.getSourceMapUrl(file2);
            if (sourceMapUrl == null || !URLUtil.isDataUri((String)sourceMapUrl)) break block2;
            Url url = scriptUrl = baseUrl.resolve(((Object)file2.getFileName()).toString());
            Intrinsics.checkExpressionValueIsNotNull((Object)url, (String)"scriptUrl");
            CharSequence charSequence = SourceMapLoaderKt.loadFromDataUri(sourceMapUrl, url);
            if (charSequence == null) {
                return;
            }
            CharSequence data = charSequence;
            SourceMap sourceMap = SourceMapDecoderKt.decodeSourceMapSafely((CharSequence)data, (boolean)this.trimFileScheme, (Url)baseUrl, (boolean)false);
            if (sourceMap != null) {
                SourceMap sourceMap2 = sourceMap;
                boolean bl = false;
                boolean bl2 = false;
                SourceMap it = sourceMap2;
                boolean bl3 = false;
                PreloadedSourceMapList.add$default(this.list, scriptUrl, it, scriptUrl, null, null, 24, null);
            }
        }
    }

    public SourceMapCollector(@NotNull PreloadedSourceMapList list, boolean trimFileScheme) {
        Intrinsics.checkParameterIsNotNull((Object)list, (String)"list");
        this.list = list;
        this.trimFileScheme = trimFileScheme;
    }
}

