/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diagram;

import com.intellij.diagram.DiagramBuilder;
import com.intellij.diagram.DiagramDataModel;
import com.intellij.diagram.DiagramEdge;
import com.intellij.diagram.DiagramNode;
import com.intellij.diagram.DiagramNoteEdge;
import com.intellij.diagram.DiagramNoteNode;
import com.intellij.diagram.Utils;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.graph.builder.GraphDataModel;
import com.intellij.openapi.graph.builder.NodesGroup;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DiagramDataModelWrapper
extends GraphDataModel<DiagramNode, DiagramEdge> {
    private final DiagramDataModel<?> myModel;
    private static final Key<Boolean> NOTE_MARKER = Key.create((String)"UML_NOTE_MARKER");

    public DiagramDataModelWrapper(DiagramDataModel model) {
        this.myModel = model;
        Disposer.register((Disposable)this, (Disposable)model);
    }

    public DiagramDataModel getModel() {
        return this.myModel;
    }

    @NotNull
    public Collection<DiagramNode> getNodes() {
        DiagramBuilder builder = this.myModel.getBuilder();
        ArrayList<DiagramNode> nodes = new ArrayList<DiagramNode>(this.myModel.getNodes());
        Map<DiagramNode, DiagramNoteNode> notes = this.myModel.getNotes();
        for (DiagramNode diagramNode : notes.keySet()) {
            DiagramNoteNode note = notes.get(diagramNode);
            if (nodes.contains(diagramNode)) {
                nodes.add(note);
                note.putUserData(NOTE_MARKER, true);
                continue;
            }
            note.putUserData(NOTE_MARKER, false);
        }
        for (DiagramNode<Object> diagramNode : nodes) {
            diagramNode.putUserData(Utils.GRAPH_BUILDER, builder);
        }
        ArrayList<DiagramNode> arrayList = nodes;
        if (arrayList == null) {
            DiagramDataModelWrapper.$$$reportNull$$$0(0);
        }
        return arrayList;
    }

    @NotNull
    public Collection<DiagramEdge> getEdges() {
        ArrayList<DiagramEdge> edges = new ArrayList<DiagramEdge>(this.myModel.getEdges());
        for (DiagramNoteEdge edge : this.myModel.getNoteEdges()) {
            DiagramNode target = edge.getTarget();
            Boolean enable = (Boolean)target.getUserData(NOTE_MARKER);
            if (enable == null || !enable.booleanValue()) continue;
            edges.add(edge);
        }
        ArrayList<DiagramEdge> arrayList = edges;
        if (arrayList == null) {
            DiagramDataModelWrapper.$$$reportNull$$$0(1);
        }
        return arrayList;
    }

    @NotNull
    public DiagramNode getSourceNode(DiagramEdge umlEdge) {
        if (umlEdge instanceof DiagramNoteEdge) {
            DiagramNode diagramNode = umlEdge.getSource();
            if (diagramNode == null) {
                DiagramDataModelWrapper.$$$reportNull$$$0(2);
            }
            return diagramNode;
        }
        DiagramNode<?> diagramNode = this.myModel.getSourceNode(umlEdge);
        if (diagramNode == null) {
            DiagramDataModelWrapper.$$$reportNull$$$0(3);
        }
        return diagramNode;
    }

    @NotNull
    public DiagramNode getTargetNode(DiagramEdge umlEdge) {
        if (umlEdge instanceof DiagramNoteEdge) {
            DiagramNode diagramNode = umlEdge.getTarget();
            if (diagramNode == null) {
                DiagramDataModelWrapper.$$$reportNull$$$0(4);
            }
            return diagramNode;
        }
        DiagramNode<?> diagramNode = this.myModel.getTargetNode(umlEdge);
        if (diagramNode == null) {
            DiagramDataModelWrapper.$$$reportNull$$$0(5);
        }
        return diagramNode;
    }

    @NotNull
    public String getNodeName(DiagramNode umlNode) {
        if (umlNode instanceof DiagramNoteNode) {
            return "";
        }
        String string = this.myModel.getNodeName(umlNode);
        if (string == null) {
            DiagramDataModelWrapper.$$$reportNull$$$0(6);
        }
        return string;
    }

    @NotNull
    public String getEdgeName(DiagramEdge umlEdge) {
        if (umlEdge instanceof DiagramNoteEdge) {
            return "";
        }
        String string = this.myModel.getEdgeName(umlEdge);
        if (string == null) {
            DiagramDataModelWrapper.$$$reportNull$$$0(7);
        }
        return string;
    }

    public DiagramEdge createEdge(@NotNull DiagramNode from, @NotNull DiagramNode to) {
        if (from == null) {
            DiagramDataModelWrapper.$$$reportNull$$$0(8);
        }
        if (to == null) {
            DiagramDataModelWrapper.$$$reportNull$$$0(9);
        }
        return this.myModel.createEdge(from, to);
    }

    public void dispose() {
    }

    @Nullable
    public NodesGroup getGroup(DiagramNode node) {
        return this.myModel.getGroup(node);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 8: 
            case 9: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 8: 
            case 9: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/diagram/DiagramDataModelWrapper";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "from";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "to";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getNodes";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getEdges";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getSourceNode";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getTargetNode";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getNodeName";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getEdgeName";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/diagram/DiagramDataModelWrapper";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "createEdge";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 8: 
            case 9: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

