/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.provider.ftp;

import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPFile;
import org.apache.commons.net.ftp.FTPReply;

public class FtpJBHelper {
    private FtpJBHelper() {
    }

    public static void changeModificationTimestamp(FTPClient client, String relPath, long timestamp) throws IOException {
        if (client.hasFeature("MFMT")) {
            FtpJBHelper.mfmt(client, relPath, timestamp);
        } else {
            FtpJBHelper.mdtm(client, relPath, timestamp);
        }
    }

    private static void mdtm(FTPClient client, String relPath, long timestamp) throws IOException {
        String param = FtpJBHelper.parseDateToString(timestamp);
        int code = client.sendCommand("MDTM", param + " " + relPath);
        if (code != 213) {
            String response = client.getReplyString();
            throw new IOException("Error changing MDTM: " + response);
        }
    }

    private static String parseDateToString(long timestamp) {
        String parseFormat = "yyyyMMddHHmmss";
        SimpleDateFormat df = new SimpleDateFormat(parseFormat);
        df.setTimeZone(TimeZone.getTimeZone("GMT"));
        return df.format(new Date(timestamp));
    }

    private static void mfmt(FTPClient client, String relPath, long timestamp) throws IOException {
        String date = FtpJBHelper.parseDateToString(timestamp);
        int code = client.mfmt(relPath, date);
        if (!FTPReply.isPositiveCompletion((int)code)) {
            String response = client.getReplyString();
            throw new IOException("Error changing MFMT: " + response);
        }
    }

    public static FTPFile[] listFiles(String relPath, FTPClient client, boolean forceList) throws IOException {
        if (!forceList && client.hasFeature("MLSD")) {
            return client.mlistDir(relPath);
        }
        return client.listFiles(relPath);
    }

    public static FTPFile[] listFiles(FTPClient client, boolean forceList) throws IOException {
        if (!forceList && client.hasFeature("MLSD")) {
            return client.mlistDir();
        }
        return client.listFiles();
    }
}

