/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.intellij.datalore.api;

import com.jetbrains.intellij.datalore.api.AbstractRequests;
import com.jetbrains.intellij.datalore.api.DataloreRequests$TokenRequest$;
import com.jetbrains.intellij.datalore.config.DataloreEndpointConfig;
import com.jetbrains.intellij.datalore.models.DataloreCreateWorkbookContext;
import com.jetbrains.intellij.datalore.models.DataloreSyncWorkbookContext;
import java.net.URI;
import java.nio.charset.Charset;
import kotlin.Deprecated;
import kotlin.DeprecationLevel;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.TypeCastException;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlinx.serialization.CompositeEncoder;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.MissingFieldException;
import kotlinx.serialization.SerialDescriptor;
import kotlinx.serialization.Serializable;
import kotlinx.serialization.SerializationConstructorMarker;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.json.Json;
import kotlinx.serialization.json.JsonConfiguration;
import org.apache.http.client.methods.HttpPatch;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.utils.URIBuilder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0002\u001a\u001bB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0013\u001a\u00020\u0004H\u0002J\u0016\u0010\u0014\u001a\u00020\u00042\u0006\u0010\u0015\u001a\u00020\u00042\u0006\u0010\u0016\u001a\u00020\u0004J\u000e\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0004R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\u00020\n8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\u00020\n8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\fR\u0014\u0010\u000f\u001a\u00020\n8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\fR\u0014\u0010\u0011\u001a\u00020\n8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\f\u00a8\u0006\u001c"}, d2={"Lcom/jetbrains/intellij/datalore/api/DataloreRequests;", "Lcom/jetbrains/intellij/datalore/api/AbstractRequests;", "()V", "CREATE_WORKBOOK_API_PATH", "", "CREATE_WORKBOOK_MIME_PART_NAME", "GET_WORKBOOK_API_PATH", "SYNC_WORKBOOK_API_PATH", "TOKEN_API_PATH", "createWorkbookUrl", "Ljava/net/URI;", "getCreateWorkbookUrl", "()Ljava/net/URI;", "syncWorkbookUrl", "getSyncWorkbookUrl", "tokenUrl", "getTokenUrl", "workbookBaseUrl", "getWorkbookBaseUrl", "buildBaseUrl", "getWorkbookUrl", "rootId", "fileId", "tokenRequest", "Lorg/apache/http/client/methods/HttpPost;", "email", "AuthorizedRequest", "TokenRequest", "datalore-intellij-plugin"})
public final class DataloreRequests
extends AbstractRequests {
    private static final String CREATE_WORKBOOK_API_PATH = "/create_workbook";
    private static final String SYNC_WORKBOOK_API_PATH = "/pycharm";
    private static final String GET_WORKBOOK_API_PATH = "/workbook";
    private static final String TOKEN_API_PATH = "/auth_token";
    private static final String CREATE_WORKBOOK_MIME_PART_NAME = "workbook";
    public static final DataloreRequests INSTANCE;

    private final URI getCreateWorkbookUrl() {
        return new URI(this.buildBaseUrl() + CREATE_WORKBOOK_API_PATH);
    }

    private final URI getSyncWorkbookUrl() {
        return new URI(this.buildBaseUrl() + SYNC_WORKBOOK_API_PATH);
    }

    private final URI getWorkbookBaseUrl() {
        return new URI(this.buildBaseUrl() + GET_WORKBOOK_API_PATH);
    }

    private final URI getTokenUrl() {
        return new URI(this.buildBaseUrl() + TOKEN_API_PATH);
    }

    private final String buildBaseUrl() {
        return this.buildUrl(DataloreEndpointConfig.Companion.getInstance().getDataloreEndpoint());
    }

    @NotNull
    public final String getWorkbookUrl(@NotNull String rootId, @NotNull String fileId) {
        Intrinsics.checkParameterIsNotNull((Object)rootId, (String)"rootId");
        Intrinsics.checkParameterIsNotNull((Object)fileId, (String)"fileId");
        return this.getWorkbookBaseUrl() + '/' + rootId + '/' + fileId;
    }

    @NotNull
    public final HttpPost tokenRequest(@NotNull String email) {
        Intrinsics.checkParameterIsNotNull((Object)email, (String)"email");
        HttpPost postRequest = new HttpPost(this.getTokenUrl());
        postRequest.setEntity(this.getJsonEntity(new Json(JsonConfiguration.Companion.getStable(), null, 2, null).stringify((SerializationStrategy)TokenRequest.Companion.serializer(), (Object)new TokenRequest(email))));
        return postRequest;
    }

    private DataloreRequests() {
    }

    static {
        DataloreRequests dataloreRequests;
        INSTANCE = dataloreRequests = new DataloreRequests();
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\u000bH\u0002J\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u0007\u001a\u00020\u000bJ\f\u0010\u000e\u001a\u00020\n*\u00020\nH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/jetbrains/intellij/datalore/api/DataloreRequests$AuthorizedRequest;", "", "token", "", "(Ljava/lang/String;)V", "createWorkbookRequest", "Lorg/apache/http/client/methods/HttpPost;", "context", "Lcom/jetbrains/intellij/datalore/models/DataloreCreateWorkbookContext;", "getSyncUrlWithParameters", "Ljava/net/URI;", "Lcom/jetbrains/intellij/datalore/models/DataloreSyncWorkbookContext;", "syncWorkbookRequest", "Lorg/apache/http/client/methods/HttpPatch;", "addTokenToURI", "datalore-intellij-plugin"})
    public static final class AuthorizedRequest {
        private final String token;

        @NotNull
        public final HttpPost createWorkbookRequest(@NotNull DataloreCreateWorkbookContext context) {
            Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
            HttpPost postRequest = new HttpPost(this.addTokenToURI(INSTANCE.getCreateWorkbookUrl()));
            postRequest.setEntity(INSTANCE.getBinaryMultipartEntity(DataloreRequests.CREATE_WORKBOOK_MIME_PART_NAME, context.generateJson(), context.getName()));
            return postRequest;
        }

        @NotNull
        public final HttpPatch syncWorkbookRequest(@NotNull DataloreSyncWorkbookContext context) {
            Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
            HttpPatch patchRequest = new HttpPatch(this.addTokenToURI(this.getSyncUrlWithParameters(context)));
            String string = context.getPatch();
            DataloreRequests dataloreRequests = INSTANCE;
            HttpPatch httpPatch = patchRequest;
            Charset charset = Charsets.UTF_8;
            boolean bl = false;
            String string2 = string;
            if (string2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            byte[] byArray = string2.getBytes(charset);
            Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
            byte[] byArray2 = byArray;
            httpPatch.setEntity(dataloreRequests.getBinaryEntity(byArray2));
            return patchRequest;
        }

        private final URI getSyncUrlWithParameters(DataloreSyncWorkbookContext context) {
            URI uRI = new URIBuilder(INSTANCE.getSyncWorkbookUrl()).addParameter("rootId", context.getRootId()).addParameter("fileId", context.getFileId()).build();
            Intrinsics.checkExpressionValueIsNotNull((Object)uRI, (String)"URIBuilder(syncWorkbookU\u2026, context.fileId).build()");
            return uRI;
        }

        private final URI addTokenToURI(@NotNull URI $this$addTokenToURI) {
            URI uRI = new URIBuilder($this$addTokenToURI).addParameter("token", this.token).build();
            Intrinsics.checkExpressionValueIsNotNull((Object)uRI, (String)"URIBuilder(this).addPara\u2026r(\"token\", token).build()");
            return uRI;
        }

        public AuthorizedRequest(@NotNull String token) {
            Intrinsics.checkParameterIsNotNull((Object)token, (String)"token");
            this.token = token;
        }
    }

    @Serializable
    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0006\b\u0083\b\u0018\u0000 \u00142\u00020\u0001:\u0002\u0013\u0014B#\b\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\bB\r\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\tJ\t\u0010\f\u001a\u00020\u0005H\u00c6\u0003J\u0013\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u0012\u001a\u00020\u0005H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0015"}, d2={"Lcom/jetbrains/intellij/datalore/api/DataloreRequests$TokenRequest;", "", "seen1", "", "email", "", "serializationConstructorMarker", "Lkotlinx/serialization/SerializationConstructorMarker;", "(ILjava/lang/String;Lkotlinx/serialization/SerializationConstructorMarker;)V", "(Ljava/lang/String;)V", "getEmail", "()Ljava/lang/String;", "component1", "copy", "equals", "", "other", "hashCode", "toString", "$serializer", "Companion", "datalore-intellij-plugin"})
    private static final class TokenRequest {
        @NotNull
        private final String email;
        public static final Companion Companion = new Companion(null);

        @NotNull
        public final String getEmail() {
            return this.email;
        }

        public TokenRequest(@NotNull String email) {
            Intrinsics.checkParameterIsNotNull((Object)email, (String)"email");
            this.email = email;
        }

        @NotNull
        public final String component1() {
            return this.email;
        }

        @NotNull
        public final TokenRequest copy(@NotNull String email) {
            Intrinsics.checkParameterIsNotNull((Object)email, (String)"email");
            return new TokenRequest(email);
        }

        public static /* synthetic */ TokenRequest copy$default(TokenRequest tokenRequest, String string, int n, Object object) {
            if ((n & 1) != 0) {
                string = tokenRequest.email;
            }
            return tokenRequest.copy(string);
        }

        @NotNull
        public String toString() {
            return "TokenRequest(email=" + this.email + ")";
        }

        public int hashCode() {
            String string = this.email;
            return string != null ? string.hashCode() : 0;
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof TokenRequest)) break block3;
                    TokenRequest tokenRequest = (TokenRequest)object;
                    if (!Intrinsics.areEqual((Object)this.email, (Object)tokenRequest.email)) break block3;
                }
                return true;
            }
            return false;
        }

        @Deprecated(message="This synthesized declaration should not be used directly", replaceWith=@ReplaceWith(expression="", imports={}), level=DeprecationLevel.HIDDEN)
        public /* synthetic */ TokenRequest(int seen1, @Nullable String email, @Nullable SerializationConstructorMarker serializationConstructorMarker) {
            if ((seen1 & 1) == 0) {
                throw (Throwable)new MissingFieldException("email");
            }
            this.email = email;
        }

        @JvmStatic
        public static final void write$Self(@NotNull TokenRequest self, @NotNull CompositeEncoder output, @NotNull SerialDescriptor serialDesc) {
            Intrinsics.checkParameterIsNotNull((Object)self, (String)"self");
            Intrinsics.checkParameterIsNotNull((Object)output, (String)"output");
            Intrinsics.checkParameterIsNotNull((Object)serialDesc, (String)"serialDesc");
            output.encodeStringElement(serialDesc, 0, self.email);
        }

        @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004H\u00c6\u0001\u00a8\u0006\u0006"}, d2={"Lcom/jetbrains/intellij/datalore/api/DataloreRequests$TokenRequest$Companion;", "", "()V", "serializer", "Lkotlinx/serialization/KSerializer;", "Lcom/jetbrains/intellij/datalore/api/DataloreRequests$TokenRequest;", "datalore-intellij-plugin"})
        public static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }

            @NotNull
            public final KSerializer<TokenRequest> serializer() {
                return (KSerializer)TokenRequest$$serializer.INSTANCE;
            }
        }
    }
}

