/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.completion.sorting;

import com.intellij.codeInsight.completion.CompletionFinalSorter;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupEx;
import com.intellij.codeInsight.lookup.LookupManager;
import com.intellij.codeInsight.lookup.impl.LookupImpl;
import com.intellij.completion.settings.CompletionMLRankingSettings;
import com.intellij.completion.sorting.ItemRankInfo;
import com.intellij.completion.sorting.RankingFeatures;
import com.intellij.completion.sorting.RankingModelWrapper;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.stats.PerformanceTracker;
import com.intellij.stats.completion.ItemsDiffCustomizingContributor;
import com.intellij.stats.completion.LookupExtensionsKt;
import com.intellij.stats.completion.RelevanceUtil;
import com.intellij.stats.personalization.session.SessionFactorsUtils;
import com.intellij.stats.storage.factors.MutableLookupStorage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IndexedValue;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0082\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0000\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u001d\n\u0000\n\u0002\u0010\u001c\n\u0002\b\r\u0018\u0000 72\u00020\u0001:\u000278B\u0005\u00a2\u0006\u0002\u0010\u0002JD\u0010\t\u001a\u00020\n2\u0012\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\u00042\u0006\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J9\u0010\u0015\u001a\u0004\u0018\u00010\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u0019\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002\u00a2\u0006\u0002\u0010\u001cJ`\u0010\u001d\u001a\u00020\n2\u0014\u0010\u001e\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00160\u00042\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00050 2\u0012\u0010!\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00100\"2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\"\u0010'\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0019\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0010H\u0002J4\u0010(\u001a \u0012\u0004\u0012\u00020\u0005\u0012\u0016\u0012\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0)0 0\"2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00050*H\u0016J\u0016\u0010+\u001a\u00020\b2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00050,H\u0002J\u0016\u0010-\u001a\u00020\b2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00050,H\u0002J&\u0010.\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00050,2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00050*2\u0006\u0010\u0013\u001a\u00020\u0014H\u0016JN\u0010/\u001a\b\u0012\u0004\u0012\u00020\u00050,2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00050 2\u0014\u0010\u001e\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00160\"2\u0012\u0010!\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00100\"2\u0006\u0010%\u001a\u00020&H\u0002J4\u00100\u001a\u00020\n2\u0014\u0010\u001e\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00160\u00042\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00050 2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J4\u00101\u001a\b\u0012\u0004\u0012\u00020\u00050,*\b\u0012\u0004\u0012\u00020\u00050,2\u0012\u0010!\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00100\"2\u0006\u00102\u001a\u00020\u0010H\u0002J6\u00103\u001a\b\u0012\u0004\u0012\u00020\u00050,*\b\u0012\u0004\u0012\u00020\u00050,2\u0014\u0010\u001e\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00160\"2\u0006\u00104\u001a\u00020\u0010H\u0002J\u0014\u00105\u001a\u00020\n*\u00020\u00052\u0006\u00106\u001a\u00020\u0010H\u0002R\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00069"}, d2={"Lcom/intellij/completion/sorting/MLSorter;", "Lcom/intellij/codeInsight/completion/CompletionFinalSorter;", "()V", "cachedScore", "", "Lcom/intellij/codeInsight/lookup/LookupElement;", "Lcom/intellij/completion/sorting/ItemRankInfo;", "reorderOnlyTopItems", "", "calculateAdditionalFeaturesTo", "", "additionalMap", "", "", "lookupElement", "prefixLength", "", "position", "itemsCount", "parameters", "Lcom/intellij/codeInsight/completion/CompletionParameters;", "calculateElementScore", "", "ranker", "Lcom/intellij/completion/sorting/RankingModelWrapper;", "element", "features", "Lcom/intellij/completion/sorting/RankingFeatures;", "(Lcom/intellij/completion/sorting/RankingModelWrapper;Lcom/intellij/codeInsight/lookup/LookupElement;ILcom/intellij/completion/sorting/RankingFeatures;I)Ljava/lang/Double;", "calculateScores", "element2score", "items", "", "positionsBefore", "", "lookup", "Lcom/intellij/codeInsight/lookup/impl/LookupImpl;", "lookupStorage", "Lcom/intellij/stats/storage/factors/MutableLookupStorage;", "getCachedRankInfo", "getRelevanceObjects", "Lcom/intellij/openapi/util/Pair;", "", "hasUnknownFeatures", "", "isCacheValid", "sort", "sortByMlScores", "tryFillFromCache", "addDiagnosticsIfNeeded", "reordered", "reorderByMLScores", "toReorder", "updateDiffValue", "newValue", "Companion", "ModelTimeTracker", "intellij.statsCollector"})
public final class MLSorter
extends CompletionFinalSorter {
    private final Map<LookupElement, ItemRankInfo> cachedScore = new IdentityHashMap();
    private final boolean reorderOnlyTopItems = Registry.is((String)"completion.ml.reorder.only.top.items", (boolean)true);
    private static final Logger LOG;
    private static final int REORDER_ONLY_TOP_K = 5;
    @Deprecated
    public static final Companion Companion;

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Map<LookupElement, List<com.intellij.openapi.util.Pair<String, Object>>> getRelevanceObjects(@NotNull Iterable<? extends LookupElement> items) {
        Intrinsics.checkParameterIsNotNull(items, (String)"items");
        if (this.cachedScore.isEmpty()) {
            void $this$associateTo$iv$iv;
            Iterable<? extends LookupElement> $this$associate$iv = items;
            boolean $i$f$associate = false;
            int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault($this$associate$iv, (int)10)), (int)16);
            Iterable<? extends LookupElement> iterable = $this$associate$iv;
            Map destination$iv$iv = new LinkedHashMap(capacity$iv);
            boolean $i$f$associateTo = false;
            for (Object t : $this$associateTo$iv$iv) {
                Map map = destination$iv$iv;
                LookupElement it = (LookupElement)t;
                boolean bl = false;
                it = TuplesKt.to((Object)it, (Object)CollectionsKt.listOf((Object)com.intellij.openapi.util.Pair.create((Object)"ml_rank", (Object)"NONE")));
                bl = false;
                map.put(it.getFirst(), it.getSecond());
            }
            return destination$iv$iv;
        }
        if (this.hasUnknownFeatures(items)) {
            Iterable<? extends LookupElement> $this$associate$iv = items;
            boolean $i$f$associate = false;
            int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault($this$associate$iv, (int)10)), (int)16);
            Iterable<? extends LookupElement> $this$associateTo$iv$iv = $this$associate$iv;
            Map destination$iv$iv = new LinkedHashMap(capacity$iv);
            boolean $i$f$associateTo = false;
            for (LookupElement lookupElement : $this$associateTo$iv$iv) {
                Map map = destination$iv$iv;
                LookupElement it = lookupElement;
                boolean bl = false;
                it = TuplesKt.to((Object)it, (Object)CollectionsKt.listOf((Object)com.intellij.openapi.util.Pair.create((Object)"ml_rank", (Object)"UNDEFINED")));
                bl = false;
                map.put(it.getFirst(), it.getSecond());
            }
            return destination$iv$iv;
        }
        if (!this.isCacheValid(items)) {
            Iterable<? extends LookupElement> $this$associate$iv = items;
            boolean $i$f$associate = false;
            int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault($this$associate$iv, (int)10)), (int)16);
            Iterable<? extends LookupElement> $this$associateTo$iv$iv = $this$associate$iv;
            Map destination$iv$iv = new LinkedHashMap(capacity$iv);
            boolean $i$f$associateTo = false;
            for (LookupElement lookupElement : $this$associateTo$iv$iv) {
                Map map = destination$iv$iv;
                LookupElement it = lookupElement;
                boolean bl = false;
                it = TuplesKt.to((Object)it, (Object)CollectionsKt.listOf((Object)com.intellij.openapi.util.Pair.create((Object)"ml_rank", (Object)"INVALID_CACHE")));
                bl = false;
                map.put(it.getFirst(), it.getSecond());
            }
            return destination$iv$iv;
        }
        Iterable<? extends LookupElement> $this$associate$iv = items;
        boolean $i$f$associate = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault($this$associate$iv, (int)10)), (int)16);
        Iterable<? extends LookupElement> $this$associateTo$iv$iv = $this$associate$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateTo = false;
        for (LookupElement lookupElement : $this$associateTo$iv$iv) {
            Map map = destination$iv$iv;
            LookupElement it = lookupElement;
            boolean bl = false;
            boolean bl2 = false;
            List result = new ArrayList();
            ItemRankInfo cached = this.cachedScore.get(it);
            if (cached != null) {
                com.intellij.openapi.util.Pair pair = com.intellij.openapi.util.Pair.create((Object)"ml_rank", (Object)cached.getMlRank());
                Intrinsics.checkExpressionValueIsNotNull((Object)pair, (String)"Pair.create(FeatureUtils.ML_RANK, cached.mlRank)");
                result.add(pair);
                com.intellij.openapi.util.Pair pair2 = com.intellij.openapi.util.Pair.create((Object)"before_rerank_order", (Object)cached.getPositionBefore());
                Intrinsics.checkExpressionValueIsNotNull((Object)pair2, (String)"Pair.create(FeatureUtils\u2026R, cached.positionBefore)");
                result.add(pair2);
            }
            Pair pair = TuplesKt.to((Object)it, (Object)result);
            boolean bl3 = false;
            map.put(pair.getFirst(), pair.getSecond());
        }
        return destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final boolean isCacheValid(Iterable<? extends LookupElement> items) {
        void $this$mapTo$iv$iv;
        Iterable<? extends LookupElement> $this$map$iv = items;
        boolean $i$f$map = false;
        Iterable<? extends LookupElement> iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            LookupElement lookupElement = (LookupElement)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            ItemRankInfo itemRankInfo = this.cachedScore.get(it);
            Integer n = itemRankInfo != null ? Integer.valueOf(itemRankInfo.getPrefixLength()) : null;
            collection.add(n);
        }
        return CollectionsKt.toSet((Iterable)((List)destination$iv$iv)).size() == 1;
    }

    private final boolean hasUnknownFeatures(Iterable<? extends LookupElement> items) {
        boolean bl;
        block3: {
            Iterable<? extends LookupElement> $this$any$iv = items;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                Iterator<? extends LookupElement> iterator = $this$any$iv.iterator();
                while (iterator.hasNext()) {
                    ItemRankInfo score2;
                    LookupElement element$iv;
                    LookupElement it = element$iv = iterator.next();
                    boolean bl2 = false;
                    ItemRankInfo itemRankInfo = score2 = this.cachedScore.get(it);
                    boolean bl3 = (itemRankInfo != null ? itemRankInfo.getMlRank() : null) == null;
                    if (!bl3) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Iterable<LookupElement> sort(@NotNull Iterable<? extends LookupElement> items, @NotNull CompletionParameters parameters) {
        void $this$associateTo$iv$iv;
        Intrinsics.checkParameterIsNotNull(items, (String)"items");
        Intrinsics.checkParameterIsNotNull((Object)parameters, (String)"parameters");
        LookupEx lookupEx = LookupManager.getActiveLookup((Editor)parameters.getEditor());
        if (!(lookupEx instanceof LookupImpl)) {
            lookupEx = null;
        }
        LookupImpl lookupImpl = (LookupImpl)lookupEx;
        if (lookupImpl == null) {
            return items;
        }
        LookupImpl lookup = lookupImpl;
        MutableLookupStorage mutableLookupStorage = MutableLookupStorage.Companion.get(lookup);
        if (mutableLookupStorage == null) {
            return items;
        }
        MutableLookupStorage lookupStorage = mutableLookupStorage;
        if (!lookupStorage.shouldComputeFeatures()) {
            return items;
        }
        long startedTimestamp = System.currentTimeMillis();
        int prefixLength = LookupExtensionsKt.prefixLength(lookup);
        boolean bl = false;
        Map element2score = new LinkedHashMap();
        List elements = CollectionsKt.toList(items);
        Iterable $this$associate$iv = CollectionsKt.withIndex((Iterable)elements);
        boolean $i$f$associate = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
        Iterable iterable = $this$associate$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateTo = false;
        for (Object element$iv$iv : $this$associateTo$iv$iv) {
            Map map = destination$iv$iv;
            IndexedValue it = (IndexedValue)element$iv$iv;
            boolean bl2 = false;
            Pair pair = TuplesKt.to((Object)it.getValue(), (Object)it.getIndex());
            boolean bl3 = false;
            map.put(pair.getFirst(), pair.getSecond());
        }
        Map positionsBefore = destination$iv$iv;
        this.tryFillFromCache(element2score, elements, prefixLength);
        List itemsForScoring = element2score.size() == elements.size() ? CollectionsKt.emptyList() : elements;
        this.calculateScores(element2score, itemsForScoring, positionsBefore, prefixLength, lookup, lookupStorage, parameters);
        Iterable<LookupElement> finalRanking = this.sortByMlScores(elements, element2score, positionsBefore, lookupStorage);
        lookupStorage.getPerformanceTracker().sortingPerformed(itemsForScoring.size(), System.currentTimeMillis() - startedTimestamp);
        return finalRanking;
    }

    /*
     * WARNING - void declaration
     */
    private final void tryFillFromCache(Map<LookupElement, Double> element2score, List<? extends LookupElement> items, int prefixLength) {
        boolean bl = false;
        for (LookupElement element : (Iterable)items) {
            void position;
            ItemRankInfo cachedInfo = this.getCachedRankInfo(element, prefixLength, (int)position);
            if (cachedInfo == null) {
                return;
            }
            element2score.put(element, cachedInfo.getMlRank());
            ++position;
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void calculateScores(Map<LookupElement, Double> element2score, List<? extends LookupElement> items, Map<LookupElement, Integer> positionsBefore, int prefixLength, LookupImpl lookup, MutableLookupStorage lookupStorage, CompletionParameters parameters) {
        if (items.isEmpty()) {
            return;
        }
        RankingModelWrapper rankingModel = lookupStorage.getModel();
        Map<String, Object> commonSessionFactors = SessionFactorsUtils.INSTANCE.updateSessionFactors(lookupStorage, items);
        Map<String, String> contextFactors = lookupStorage.getContextFactors();
        RankingFeatures features2 = new RankingFeatures(lookupStorage.getUserFactors(), contextFactors, commonSessionFactors);
        Map map = lookup.getRelevanceObjects((Iterable)items, false);
        Intrinsics.checkExpressionValueIsNotNull((Object)map, (String)"lookup.getRelevanceObjects(items, false)");
        Map relevanceObjects = map;
        ModelTimeTracker tracker = new ModelTimeTracker();
        for (LookupElement lookupElement : items) {
            void relevance;
            int position = ((Number)MapsKt.getValue(positionsBefore, (Object)lookupElement)).intValue();
            List list = relevanceObjects.getOrDefault(lookupElement, CollectionsKt.emptyList());
            Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"relevanceObjects.getOrDe\u2026ult(element, emptyList())");
            Pair<Map<String, Object>, Map<String, Object>> pair = RelevanceUtil.INSTANCE.asRelevanceMaps(list);
            Map map2 = (Map)pair.component1();
            Map additional = (Map)pair.component2();
            SessionFactorsUtils.INSTANCE.saveElementFactorsTo(additional, lookupStorage, lookupElement);
            this.calculateAdditionalFeaturesTo(additional, lookupElement, prefixLength, position, items.size(), parameters);
            Double score2 = tracker.measure((Function0<Double>)((Function0)new Function0<Double>(this, rankingModel, lookupElement, position, features2, (Map)relevance, additional, prefixLength){
                final /* synthetic */ MLSorter this$0;
                final /* synthetic */ RankingModelWrapper $rankingModel;
                final /* synthetic */ LookupElement $element;
                final /* synthetic */ int $position;
                final /* synthetic */ RankingFeatures $features;
                final /* synthetic */ Map $relevance;
                final /* synthetic */ Map $additional;
                final /* synthetic */ int $prefixLength;

                @Nullable
                public final Double invoke() {
                    return MLSorter.access$calculateElementScore(this.this$0, this.$rankingModel, this.$element, this.$position, this.$features.withElementFeatures(this.$relevance, this.$additional), this.$prefixLength);
                }
                {
                    this.this$0 = mLSorter;
                    this.$rankingModel = rankingModelWrapper;
                    this.$element = lookupElement;
                    this.$position = n;
                    this.$features = rankingFeatures;
                    this.$relevance = map;
                    this.$additional = map2;
                    this.$prefixLength = n2;
                    super(0);
                }
            }));
            element2score.put(lookupElement, score2);
            additional.putAll(relevance);
            lookupStorage.fireElementScored(lookupElement, additional, score2);
        }
        tracker.finished(lookupStorage.getPerformanceTracker());
    }

    private final Iterable<LookupElement> sortByMlScores(List<? extends LookupElement> items, Map<LookupElement, Double> element2score, Map<LookupElement, Integer> positionsBefore, MutableLookupStorage lookupStorage) {
        boolean mlScoresUsed;
        block5: {
            boolean bl;
            Iterable $this$none$iv = element2score.values();
            boolean $i$f$none = false;
            if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$none$iv) {
                    Double it = (Double)element$iv;
                    boolean bl2 = false;
                    if (!(it == null)) continue;
                    bl = false;
                    break block5;
                }
                bl = mlScoresUsed = true;
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("ML sorting in completion used=" + mlScoresUsed + " for language=" + lookupStorage.getLanguage().getID());
        }
        if (mlScoresUsed) {
            lookupStorage.fireReorderedUsingMLScores();
            int topItemsCount = this.reorderOnlyTopItems ? 5 : Integer.MAX_VALUE;
            return this.addDiagnosticsIfNeeded(this.reorderByMLScores((Iterable<? extends LookupElement>)items, element2score, topItemsCount), positionsBefore, topItemsCount);
        }
        return items;
    }

    private final void calculateAdditionalFeaturesTo(Map<String, Object> additionalMap, LookupElement lookupElement, int prefixLength, int position, int itemsCount, CompletionParameters parameters) {
        additionalMap.put("position", position);
        additionalMap.put("relative_position", (double)position / (double)itemsCount);
        additionalMap.put("query_length", prefixLength);
        additionalMap.put("result_length", lookupElement.getLookupString().length());
        additionalMap.put("auto_popup", parameters.isAutoPopup());
        additionalMap.put("completion_type", parameters.getCompletionType().toString());
        additionalMap.put("invocation_count", parameters.getInvocationCount());
    }

    private final Iterable<LookupElement> reorderByMLScores(@NotNull Iterable<? extends LookupElement> $this$reorderByMLScores, Map<LookupElement, Double> element2score, int toReorder) {
        Iterable<? extends LookupElement> $this$sortedByDescending$iv = $this$reorderByMLScores;
        boolean $i$f$sortedByDescending = false;
        Iterable<? extends LookupElement> iterable = $this$sortedByDescending$iv;
        boolean bl = false;
        Comparator comparator = new Comparator<T>(element2score){
            final /* synthetic */ Map $element2score$inlined;
            {
                this.$element2score$inlined = map;
            }

            public final int compare(T a, T b) {
                boolean bl = false;
                LookupElement it = (LookupElement)b;
                boolean bl2 = false;
                Comparable comparable = (Double)MapsKt.getValue((Map)this.$element2score$inlined, (Object)it);
                it = (LookupElement)a;
                Comparable comparable2 = comparable;
                bl2 = false;
                Double d = (Double)MapsKt.getValue((Map)this.$element2score$inlined, (Object)it);
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)d);
            }
        };
        Iterable iterable2 = CollectionsKt.take((Iterable)CollectionsKt.sortedWith(iterable, (Comparator)comparator), (int)toReorder);
        boolean bl2 = false;
        LinkedHashSet linkedHashSet = new LinkedHashSet();
        LinkedHashSet result = (LinkedHashSet)CollectionsKt.toCollection((Iterable)iterable2, (Collection)linkedHashSet);
        CollectionsKt.addAll((Collection)result, $this$reorderByMLScores);
        return result;
    }

    /*
     * WARNING - void declaration
     */
    private final Iterable<LookupElement> addDiagnosticsIfNeeded(@NotNull Iterable<? extends LookupElement> $this$addDiagnosticsIfNeeded, Map<LookupElement, Integer> positionsBefore, int reordered) {
        CompletionMLRankingSettings completionMLRankingSettings = CompletionMLRankingSettings.getInstance();
        Intrinsics.checkExpressionValueIsNotNull((Object)completionMLRankingSettings, (String)"CompletionMLRankingSettings.getInstance()");
        if (completionMLRankingSettings.isShowDiffEnabled()) {
            Iterable<LookupElement> $this$forEachIndexed$iv = $this$addDiagnosticsIfNeeded;
            boolean $i$f$forEachIndexed = false;
            int index$iv = 0;
            for (LookupElement item$iv : $this$forEachIndexed$iv) {
                void element;
                int n = index$iv++;
                boolean bl = false;
                if (n < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                int n2 = n;
                LookupElement lookupElement = item$iv;
                int position = n2;
                boolean bl2 = false;
                int before = ((Number)MapsKt.getValue(positionsBefore, (Object)element)).intValue();
                if (before >= reordered && position >= reordered) continue;
                this.updateDiffValue((LookupElement)element, position - before);
            }
        }
        return $this$addDiagnosticsIfNeeded;
    }

    private final ItemRankInfo getCachedRankInfo(LookupElement element, int prefixLength, int position) {
        ItemRankInfo cached = this.cachedScore.get(element);
        if (cached != null && prefixLength == cached.getPrefixLength() && cached.getPositionBefore() == position) {
            return cached;
        }
        return null;
    }

    private final Double calculateElementScore(RankingModelWrapper ranker, LookupElement element, int position, RankingFeatures features2, int prefixLength) {
        Double mlRank = ranker != null && ranker.canScore(features2) ? ranker.score(features2) : null;
        ItemRankInfo info = new ItemRankInfo(position, mlRank, prefixLength);
        this.cachedScore.put(element, info);
        return info.getMlRank();
    }

    private final void updateDiffValue(@NotNull LookupElement $this$updateDiffValue, int newValue) {
        AtomicInteger atomicInteger = (AtomicInteger)$this$updateDiffValue.getUserData(ItemsDiffCustomizingContributor.Companion.getDIFF_KEY());
        if (atomicInteger == null) {
            AtomicInteger atomicInteger2 = new AtomicInteger();
            boolean bl = false;
            boolean bl2 = false;
            AtomicInteger $this$apply = atomicInteger2;
            boolean bl3 = false;
            $this$updateDiffValue.putUserData(ItemsDiffCustomizingContributor.Companion.getDIFF_KEY(), (Object)$this$apply);
            atomicInteger = atomicInteger2;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)atomicInteger, (String)"getUserData(ItemsDiffCus\u2026ributor.DIFF_KEY, this) }");
        AtomicInteger diff = atomicInteger;
        diff.set(newValue);
    }

    static {
        Companion = new Companion(null);
        Logger logger = Logger.getInstance((String)"#com.intellij.completion.sorting.MLSorter");
        Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"Logger.getInstance(\"#com\u2026letion.sorting.MLSorter\")");
        LOG = logger;
    }

    public static final /* synthetic */ Double access$calculateElementScore(MLSorter $this, RankingModelWrapper ranker, LookupElement element, int position, RankingFeatures features2, int prefixLength) {
        return $this.calculateElementScore(ranker, element, position, features2, prefixLength);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ\u001d\u0010\u000b\u001a\u0004\u0018\u00010\f2\u000e\u0010\r\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\f0\u000e\u00a2\u0006\u0002\u0010\u000fR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/intellij/completion/sorting/MLSorter$ModelTimeTracker;", "", "()V", "itemsScored", "", "timeSpent", "", "finished", "", "performanceTracker", "Lcom/intellij/stats/PerformanceTracker;", "measure", "", "scoringFun", "Lkotlin/Function0;", "(Lkotlin/jvm/functions/Function0;)Ljava/lang/Double;", "intellij.statsCollector"})
    private static final class ModelTimeTracker {
        private int itemsScored;
        private long timeSpent;

        @Nullable
        public final Double measure(@NotNull Function0<Double> scoringFun) {
            Intrinsics.checkParameterIsNotNull(scoringFun, (String)"scoringFun");
            long start = System.nanoTime();
            Double result = (Double)scoringFun.invoke();
            if (result != null) {
                ++this.itemsScored;
                this.timeSpent += System.nanoTime() - start;
            }
            return result;
        }

        public final void finished(@NotNull PerformanceTracker performanceTracker) {
            Intrinsics.checkParameterIsNotNull((Object)performanceTracker, (String)"performanceTracker");
            if (this.itemsScored != 0) {
                performanceTracker.itemsScored(this.itemsScored, TimeUnit.NANOSECONDS.toMillis(this.timeSpent));
            }
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/intellij/completion/sorting/MLSorter$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "REORDER_ONLY_TOP_K", "", "intellij.statsCollector"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

