/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.perforce.perforce;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.SimpleTextAttributes;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.ComboBoxModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.perforce.PerforceBundle;
import org.jetbrains.idea.perforce.perforce.PerforceChangeList;
import org.jetbrains.idea.perforce.perforce.PerforceRunner;
import org.jetbrains.idea.perforce.perforce.connections.P4Connection;

public class ChangeListChooser {
    private final JComboBox myChangeList;
    private final P4Connection myConnection;
    private final PerforceRunner myRunner;

    public ChangeListChooser(JComboBox changeLists, JButton newButton, Project project, final P4Connection connection) {
        this.myChangeList = changeLists;
        this.myConnection = connection;
        this.myRunner = PerforceRunner.getInstance(project);
        if (newButton != null) {
            newButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    String description = Messages.showInputDialog((String)PerforceBundle.message((String)"request.text.enter.change.description", (Object[])new Object[0]), (String)PerforceBundle.message((String)"request.title.create.new.change.list", (Object[])new Object[0]), (Icon)Messages.getQuestionIcon());
                    if (description != null) {
                        try {
                            long newChangeListNumber = ChangeListChooser.this.myRunner.createChangeList(description, connection, null);
                            ChangeListChooser.this.refreshChangeLists(newChangeListNumber);
                        }
                        catch (VcsException e1) {
                            Messages.showErrorDialog((String)PerforceBundle.message((String)"message.text.cannot.create.new.changelist", (Object[])new Object[]{e1.getLocalizedMessage()}), (String)PerforceBundle.message((String)"message.title.create.new.changelist", (Object[])new Object[0]));
                        }
                    }
                }
            });
        }
        this.myChangeList.setRenderer(new ColoredListCellRenderer(){

            protected void customizeCellRenderer(@NotNull JList list, Object value, int index, boolean selected, boolean hasFocus) {
                if (list == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (value instanceof PerforceChangeList) {
                    PerforceChangeList changeList = (PerforceChangeList)value;
                    String description = changeList.getComment();
                    if (description.length() > 30) {
                        description = description.substring(0, 25) + "...";
                    }
                    this.append("#" + changeList.getNumber() + " (" + description + ")", SimpleTextAttributes.REGULAR_ATTRIBUTES);
                } else if (value != null) {
                    this.append(value.toString(), SimpleTextAttributes.REGULAR_ATTRIBUTES);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "org/jetbrains/idea/perforce/perforce/ChangeListChooser$2", "customizeCellRenderer"));
            }
        });
    }

    private void refreshChangeLists(long newChangeListNumber) {
        long selected = newChangeListNumber > 0L ? newChangeListNumber : this.getChangeListNumber();
        try {
            this.fillChangeLists(this.myRunner.getPendingChangeLists(this.myConnection), selected);
        }
        catch (VcsException e1) {
            Messages.showErrorDialog((String)PerforceBundle.message((String)"message.text.cannot.load.changes", (Object[])new Object[]{e1.getLocalizedMessage()}), (String)PerforceBundle.message((String)"message.title.refresh.changes", (Object[])new Object[0]));
        }
    }

    public void fillChangeLists(List<PerforceChangeList> changeLists, long selection) {
        this.myChangeList.removeAllItems();
        this.myChangeList.addItem(ChangeListChooser.getDefault());
        Object selected = ChangeListChooser.getDefault();
        for (PerforceChangeList changeListInfo : changeLists) {
            this.myChangeList.addItem(changeListInfo);
            if (changeListInfo.getNumber() != selection) continue;
            selected = changeListInfo;
        }
        this.myChangeList.setSelectedItem(selected);
    }

    public long getChangeListNumber() {
        ComboBoxModel model = this.myChangeList.getModel();
        Object selectedItem = model.getSelectedItem();
        if (selectedItem instanceof PerforceChangeList) {
            return ((PerforceChangeList)selectedItem).getNumber();
        }
        return -1L;
    }

    private static String getDefault() {
        return PerforceBundle.message((String)"default.changelist.presentation", (Object[])new Object[0]);
    }
}

