/*
 * Decompiled with CFR 0.152.
 */
package org.angular2.lang;

import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ex.ProjectRootManagerEx;
import com.intellij.openapi.util.EmptyRunnable;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.testFramework.LightVirtualFileBase;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.HashSet;
import org.angular2.lang.Angular2ContextProvider;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class Angular2LangUtil {
    @NonNls
    public static final String ANGULAR_CORE_PACKAGE = "@angular/core";
    @NonNls
    public static final String ANGULAR_CLI_PACKAGE = "@angular/cli";
    @NonNls
    private static final Key<CachedValue<Boolean>> ANGULAR2_CONTEXT_CACHE_KEY = new Key("angular2.isContext.cache");
    @NonNls
    private static final Key<Boolean> ANGULAR2_PREV_CONTEXT_KEY = new Key("angular2.isContext.prev");
    @NonNls
    private static final Key<Object> ANGULAR2_CONTEXT_RELOAD_MARKER_KEY = new Key("angular2.isContext.reloadMarker");
    private static final Object reloadMonitor = new Object();

    public static boolean isAngular2Context(@NotNull PsiElement context) {
        if (context == null) {
            Angular2LangUtil.$$$reportNull$$$0(0);
        }
        if (!context.isValid()) {
            return false;
        }
        PsiFile psiFile = InjectedLanguageManager.getInstance((Project)context.getProject()).getTopLevelFile(context);
        if (psiFile == null) {
            return false;
        }
        VirtualFile file = psiFile.getOriginalFile().getVirtualFile();
        if (file == null || !file.isInLocalFileSystem()) {
            return Angular2LangUtil.isAngular2Context(psiFile.getProject());
        }
        return Angular2LangUtil.isAngular2Context(psiFile.getProject(), file);
    }

    public static boolean isAngular2Context(@NotNull Project project, @NotNull VirtualFile context) {
        if (project == null) {
            Angular2LangUtil.$$$reportNull$$$0(1);
        }
        if (context == null) {
            Angular2LangUtil.$$$reportNull$$$0(2);
        }
        if (ApplicationManager.getApplication().isUnitTestMode() && "disabled".equals(System.getProperty("angular.js"))) {
            return false;
        }
        while (context instanceof LightVirtualFileBase) {
            context = ((LightVirtualFileBase)context).getOriginalFile();
        }
        PsiDirectory psiDir = (PsiDirectory)ObjectUtils.doIfNotNull((Object)(context != null ? context.getParent() : null), dir -> dir.isValid() ? PsiManager.getInstance((Project)project).findDirectory(dir) : null);
        if (psiDir == null) {
            return false;
        }
        boolean currentState = (Boolean)CachedValuesManager.getCachedValue((PsiElement)psiDir, ANGULAR2_CONTEXT_CACHE_KEY, () -> {
            HashSet dependencies = new HashSet();
            for (Angular2ContextProvider provider : Angular2ContextProvider.ANGULAR_CONTEXT_PROVIDER_EP.getExtensionList()) {
                CachedValueProvider.Result<Boolean> result = provider.isAngular2Context(psiDir);
                if (result.getValue() == Boolean.TRUE) {
                    return result;
                }
                ContainerUtil.addAll(dependencies, (Object[])result.getDependencyItems());
            }
            return new CachedValueProvider.Result((Object)false, dependencies.toArray());
        });
        Angular2LangUtil.checkContextChange(psiDir, currentState);
        return currentState;
    }

    private static boolean isAngular2Context(@NotNull Project project) {
        if (project == null) {
            Angular2LangUtil.$$$reportNull$$$0(3);
        }
        if (project.getBaseDir() != null) {
            return Angular2LangUtil.isAngular2Context(project, project.getBaseDir());
        }
        return false;
    }

    private static void checkContextChange(@NotNull PsiDirectory psiDir, boolean currentState) {
        Boolean prevState;
        if (psiDir == null) {
            Angular2LangUtil.$$$reportNull$$$0(4);
        }
        if ((prevState = (Boolean)psiDir.getUserData(ANGULAR2_PREV_CONTEXT_KEY)) != null && prevState != currentState) {
            Angular2LangUtil.reloadProject(psiDir.getProject());
        }
        psiDir.putUserData(ANGULAR2_PREV_CONTEXT_KEY, (Object)currentState);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void reloadProject(@NotNull Project project) {
        if (project == null) {
            Angular2LangUtil.$$$reportNull$$$0(5);
        }
        Object object = reloadMonitor;
        synchronized (object) {
            if (project.getUserData(ANGULAR2_CONTEXT_RELOAD_MARKER_KEY) != null) {
                return;
            }
            project.putUserData(ANGULAR2_CONTEXT_RELOAD_MARKER_KEY, new Object());
        }
        ApplicationManager.getApplication().invokeLater(() -> WriteAction.run(() -> {
            ProjectRootManagerEx.getInstanceEx((Project)project).makeRootsChange(EmptyRunnable.getInstance(), false, true);
            project.putUserData(ANGULAR2_CONTEXT_RELOAD_MARKER_KEY, null);
        }), project.getDisposed());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: 
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiDir";
                break;
            }
        }
        objectArray2[1] = "org/angular2/lang/Angular2LangUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isAngular2Context";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "checkContextChange";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "reloadProject";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

