/*
 * Decompiled with CFR 0.152.
 */
package org.angular2.inspections.quickfixes;

import com.intellij.codeInspection.LocalQuickFixOnPsiElement;
import com.intellij.ide.util.PsiNavigationSupport;
import com.intellij.lang.javascript.formatter.JSCodeStyleSettings;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSObjectLiteralExpression;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.ObjectUtils;
import org.angular2.inspections.quickfixes.Angular2FixesPsiUtil;
import org.angular2.lang.Angular2Bundle;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class AddJSPropertyQuickFix
extends LocalQuickFixOnPsiElement {
    @NonNls
    private static final String CARET_MARKER = "___caret___";
    private final String myPropertyName;
    private final boolean myUseTemplateString;
    private final String myValue;
    private final int myCaretOffset;

    public AddJSPropertyQuickFix(@NotNull JSObjectLiteralExpression objectLiteral, @NotNull String name, @NotNull String value, int caretOffset, boolean useTemplateString) {
        if (objectLiteral == null) {
            AddJSPropertyQuickFix.$$$reportNull$$$0(0);
        }
        if (name == null) {
            AddJSPropertyQuickFix.$$$reportNull$$$0(1);
        }
        if (value == null) {
            AddJSPropertyQuickFix.$$$reportNull$$$0(2);
        }
        super((PsiElement)objectLiteral);
        this.myPropertyName = name;
        this.myUseTemplateString = useTemplateString;
        this.myValue = value;
        this.myCaretOffset = caretOffset;
    }

    @Nls(capitalization=Nls.Capitalization.Sentence)
    @NotNull
    public String getText() {
        String string = Angular2Bundle.message("angular.quickfix.decorator.add-property.name", this.myPropertyName);
        if (string == null) {
            AddJSPropertyQuickFix.$$$reportNull$$$0(3);
        }
        return string;
    }

    @Nls(capitalization=Nls.Capitalization.Sentence)
    @NotNull
    public String getFamilyName() {
        String string = Angular2Bundle.message("angular.quickfix.decorator.add-property.family", new Object[0]);
        if (string == null) {
            AddJSPropertyQuickFix.$$$reportNull$$$0(4);
        }
        return string;
    }

    public void invoke(@NotNull Project project, @NotNull PsiFile file, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
        JSObjectLiteralExpression objectLiteral;
        if (project == null) {
            AddJSPropertyQuickFix.$$$reportNull$$$0(5);
        }
        if (file == null) {
            AddJSPropertyQuickFix.$$$reportNull$$$0(6);
        }
        if (startElement == null) {
            AddJSPropertyQuickFix.$$$reportNull$$$0(7);
        }
        if (endElement == null) {
            AddJSPropertyQuickFix.$$$reportNull$$$0(8);
        }
        if ((objectLiteral = (JSObjectLiteralExpression)ObjectUtils.tryCast((Object)startElement, JSObjectLiteralExpression.class)) != null) {
            String quote = this.myUseTemplateString ? "`" : JSCodeStyleSettings.getQuote((PsiElement)objectLiteral);
            String value = quote + this.myValue.substring(0, this.myCaretOffset) + CARET_MARKER + this.myValue.substring(this.myCaretOffset) + quote;
            JSProperty added = Angular2FixesPsiUtil.reformatJSObjectLiteralProperty(Angular2FixesPsiUtil.insertJSObjectLiteralProperty(objectLiteral, this.myPropertyName, value));
            JSExpression valueExpression = added.getValue();
            assert (valueExpression != null);
            PsiDocumentManager documentManager = PsiDocumentManager.getInstance((Project)valueExpression.getProject());
            int caretOffset = valueExpression.getTextOffset() + valueExpression.getText().indexOf(CARET_MARKER);
            VirtualFile targetFile = added.getContainingFile().getVirtualFile();
            Document document = documentManager.getDocument(valueExpression.getContainingFile());
            assert (document != null);
            document.replaceString(caretOffset, caretOffset + CARET_MARKER.length(), (CharSequence)"");
            PsiDocumentManager.getInstance((Project)project).commitDocument(document);
            PsiNavigationSupport.getInstance().createNavigatable(project, targetFile, caretOffset).navigate(true);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "objectLiteral";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/angular2/inspections/quickfixes/AddJSPropertyQuickFix";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "startElement";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "endElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/angular2/inspections/quickfixes/AddJSPropertyQuickFix";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: {
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

