/*
 * Decompiled with CFR 0.152.
 */
package org.angular2.inspections;

import com.intellij.codeInsight.daemon.impl.analysis.RemoveAttributeIntentionFix;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.psi.PsiElement;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import java.util.HashSet;
import java.util.List;
import org.angular2.codeInsight.Angular2DeclarationsScope;
import org.angular2.codeInsight.attributes.Angular2ApplicableDirectivesProvider;
import org.angular2.codeInsight.attributes.Angular2AttributeDescriptor;
import org.angular2.codeInsight.template.Angular2TemplateElementsScopeProvider;
import org.angular2.entities.Angular2Directive;
import org.angular2.inspections.AngularHtmlLikeTemplateLocalInspectionTool;
import org.angular2.inspections.quickfixes.Angular2FixesFactory;
import org.angular2.lang.Angular2Bundle;
import org.angular2.lang.expr.psi.Angular2TemplateBinding;
import org.angular2.lang.expr.psi.Angular2TemplateBindings;
import org.angular2.lang.html.parser.Angular2AttributeNameParser;
import org.angular2.lang.html.parser.Angular2AttributeType;
import org.jetbrains.annotations.NotNull;

public class AngularUndefinedBindingInspection
extends AngularHtmlLikeTemplateLocalInspectionTool {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected void visitAngularAttribute(@NotNull ProblemsHolder holder, @NotNull XmlAttribute attribute, @NotNull Angular2AttributeDescriptor descriptor) {
        String messageKey;
        Angular2DeclarationsScope.DeclarationProximity proximity;
        if (holder == null) {
            AngularUndefinedBindingInspection.$$$reportNull$$$0(0);
        }
        if (attribute == null) {
            AngularUndefinedBindingInspection.$$$reportNull$$$0(1);
        }
        if (descriptor == null) {
            AngularUndefinedBindingInspection.$$$reportNull$$$0(2);
        }
        Angular2AttributeNameParser.AttributeInfo info = descriptor.getInfo();
        boolean templateTag = Angular2TemplateElementsScopeProvider.isTemplateTag(attribute.getParent());
        if (info.type == Angular2AttributeType.TEMPLATE_BINDINGS) {
            if (templateTag) {
                return;
            }
            AngularUndefinedBindingInspection.visitTemplateBindings(holder, attribute, Angular2TemplateBindings.get(attribute));
            return;
        }
        if (info.type == Angular2AttributeType.REFERENCE || info.type == Angular2AttributeType.VARIABLE) {
            return;
        }
        List<Angular2Directive> sourceDirectives = descriptor.getSourceDirectives();
        Angular2DeclarationsScope scope = new Angular2DeclarationsScope((PsiElement)attribute);
        if (descriptor.isImplied()) {
            if (!templateTag) return;
            proximity = Angular2DeclarationsScope.DeclarationProximity.NOT_REACHABLE;
        } else {
            HashSet<Angular2Directive> matchedDirectives = new HashSet<Angular2Directive>(new Angular2ApplicableDirectivesProvider(attribute.getParent()).getMatched());
            proximity = scope.getDeclarationsProximity(ContainerUtil.findAll(sourceDirectives, matchedDirectives::contains));
        }
        if (proximity == Angular2DeclarationsScope.DeclarationProximity.IN_SCOPE) {
            return;
        }
        SmartList quickFixes = new SmartList();
        if (proximity != Angular2DeclarationsScope.DeclarationProximity.NOT_REACHABLE) {
            Angular2FixesFactory.addUnresolvedDeclarationFixes((PsiElement)attribute, (List<LocalQuickFix>)quickFixes);
        }
        quickFixes.add(new RemoveAttributeIntentionFix(attribute.getName()));
        ProblemHighlightType severity = scope.isFullyResolved() ? ProblemHighlightType.GENERIC_ERROR_OR_WARNING : ProblemHighlightType.WEAK_WARNING;
        switch (info.type) {
            case EVENT: {
                if (templateTag) {
                    messageKey = "angular.inspection.template.embedded.event-not-emitted";
                    break;
                }
                messageKey = "angular.inspection.template.event-not-emitted";
                break;
            }
            case PROPERTY_BINDING: {
                if (templateTag) {
                    messageKey = "angular.inspection.template.embedded.property-not-provided";
                    break;
                }
                messageKey = "angular.inspection.template.property-not-provided";
                break;
            }
            case BANANA_BOX_BINDING: {
                messageKey = "angular.inspection.template.banana-box-binding-not-provided";
                break;
            }
            case REGULAR: {
                messageKey = proximity == Angular2DeclarationsScope.DeclarationProximity.NOT_REACHABLE ? "angular.inspection.template.unknown-attribute" : "angular.inspection.template.attribute-directive-out-of-scope";
                severity = ProblemHighlightType.WARNING;
                break;
            }
            default: {
                return;
            }
        }
        holder.registerProblem((PsiElement)attribute.getNameElement(), Angular2Bundle.message(messageKey, info.name, attribute.getParent().getName()), severity, quickFixes.toArray(LocalQuickFix.EMPTY_ARRAY));
    }

    private static void visitTemplateBindings(@NotNull ProblemsHolder holder, @NotNull XmlAttribute attribute, @NotNull Angular2TemplateBindings bindings) {
        List<Angular2Directive> matched;
        Angular2DeclarationsScope scope;
        Angular2DeclarationsScope.DeclarationProximity proximity;
        if (holder == null) {
            AngularUndefinedBindingInspection.$$$reportNull$$$0(3);
        }
        if (attribute == null) {
            AngularUndefinedBindingInspection.$$$reportNull$$$0(4);
        }
        if (bindings == null) {
            AngularUndefinedBindingInspection.$$$reportNull$$$0(5);
        }
        if ((proximity = (scope = new Angular2DeclarationsScope((PsiElement)attribute)).getDeclarationsProximity(matched = new Angular2ApplicableDirectivesProvider(bindings).getMatched())) != Angular2DeclarationsScope.DeclarationProximity.IN_SCOPE) {
            SmartList fixes = new SmartList();
            Angular2FixesFactory.addUnresolvedDeclarationFixes((PsiElement)bindings, (List<LocalQuickFix>)fixes);
            holder.registerProblem((PsiElement)attribute.getNameElement(), Angular2Bundle.message("angular.inspection.template.embedded.no-directive-matched", bindings.getTemplateName()), ProblemHighlightType.WEAK_WARNING, fixes.toArray(LocalQuickFix.EMPTY_ARRAY));
            return;
        }
        MultiMap input2DirectiveMap = new MultiMap();
        matched.forEach(dir -> dir.getInputs().forEach(input -> input2DirectiveMap.putValue((Object)input.getName(), dir)));
        for (Angular2TemplateBinding binding : bindings.getBindings()) {
            if (binding.keyIsVar() || binding.getExpression() == null || (proximity = scope.getDeclarationsProximity(input2DirectiveMap.get((Object)binding.getKey()))) == Angular2DeclarationsScope.DeclarationProximity.IN_SCOPE) continue;
            PsiElement element = (PsiElement)ObjectUtils.notNull((Object)binding.getKeyElement(), (Object)attribute.getNameElement());
            SmartList fixes = new SmartList();
            Angular2FixesFactory.addUnresolvedDeclarationFixes((PsiElement)binding, (List<LocalQuickFix>)fixes);
            holder.registerProblem(element, Angular2Bundle.message("angular.inspection.template.embedded.property-not-provided", binding.getKey()), scope.isFullyResolved() ? ProblemHighlightType.GENERIC_ERROR_OR_WARNING : ProblemHighlightType.WEAK_WARNING, fixes.toArray(LocalQuickFix.EMPTY_ARRAY));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attribute";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bindings";
                break;
            }
        }
        objectArray2[1] = "org/angular2/inspections/AngularUndefinedBindingInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "visitAngularAttribute";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "visitTemplateBindings";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

