/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cloudConfig;

import com.intellij.cloudConfig.CloudConfigManager;
import com.intellij.cloudConfig.CloudConfigStreamProviderKt;
import com.intellij.cloudConfig.ConfigList;
import com.intellij.configurationStore.StoreUtilKt;
import com.intellij.configurationStore.StreamProvider;
import com.intellij.idea.cloudConfig.CloudConfigClientUtil;
import com.intellij.openapi.components.RoamingType;
import com.intellij.openapi.components.State;
import com.intellij.openapi.util.io.BufferExposingByteArrayOutputStream;
import com.intellij.util.io.PathKt;
import java.io.Closeable;
import java.io.File;
import java.io.InputStream;
import java.io.Serializable;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\b\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J8\u0010\u0013\u001a\u00020\u00142\u0010\u0010\u0015\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00170\u00162\u001c\u0010\u0018\u001a\u0018\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0017\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00140\u0019H\u0002J\u0010\u0010\u001a\u001a\u00020\b2\u0006\u0010\u001b\u001a\u00020\u000bH\u0002J\u0010\u0010\u001c\u001a\u00020\u000f2\u0006\u0010\u001d\u001a\u00020\u000fH\u0002J\u0018\u0010\u001e\u001a\u00020\b2\u0006\u0010\u001d\u001a\u00020\u000f2\u0006\u0010\u001f\u001a\u00020 H\u0016J\u0010\u0010!\u001a\u00020\b2\u0006\u0010\u001d\u001a\u00020\u000fH\u0002J\u0018\u0010\"\u001a\u00020\b2\u0006\u0010\u001d\u001a\u00020\u000f2\u0006\u0010\u001f\u001a\u00020 H\u0016JL\u0010#\u001a\u00020\b2\u0006\u0010$\u001a\u00020\u000f2\u0006\u0010\u001f\u001a\u00020 2\u0012\u0010%\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\b0&2\u001e\u0010'\u001a\u001a\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020)\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0(H\u0016J.\u0010*\u001a\u00020\b2\u0006\u0010\u001d\u001a\u00020\u000f2\u0006\u0010\u001f\u001a\u00020 2\u0014\u0010+\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010)\u0012\u0004\u0012\u00020\u00140&H\u0016J(\u0010,\u001a\u00020\u00142\u0006\u0010\u001d\u001a\u00020\u000f2\u0006\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u0002002\u0006\u0010\u001f\u001a\u00020 H\u0016R\u0014\u0010\u0007\u001a\u00020\bX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\tR\u0016\u0010\n\u001a\n \f*\u0004\u0018\u00010\u000b0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u000f0\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00061"}, d2={"Lcom/intellij/cloudConfig/CloudConfigStreamProvider;", "Lcom/intellij/configurationStore/StreamProvider;", "configDir", "Ljava/io/File;", "myManager", "Lcom/intellij/cloudConfig/CloudConfigManager;", "(Ljava/io/File;Lcom/intellij/cloudConfig/CloudConfigManager;)V", "isExclusive", "", "()Z", "myConfigDir", "Ljava/nio/file/Path;", "kotlin.jvm.PlatformType", "myFileStorages", "Ljava/util/HashSet;", "", "myOSNames", "Ljava/util/HashMap;", "mySchemeStorages", "addConfigs", "", "storageClasses", "", "Ljava/lang/Class;", "f", "Lkotlin/Function2;", "checkFile", "file", "convertName", "fileSpec", "delete", "roamingType", "Lcom/intellij/openapi/components/RoamingType;", "findStorage", "isApplicable", "processChildren", "path", "filter", "Lkotlin/Function1;", "processor", "Lkotlin/Function3;", "Ljava/io/InputStream;", "read", "consumer", "write", "content", "", "size", "", "intellij.cloudConfig"})
public final class CloudConfigStreamProvider
implements StreamProvider {
    private final Path myConfigDir;
    private final HashSet<String> myFileStorages;
    private final HashSet<String> mySchemeStorages;
    private final HashMap<String, String> myOSNames;
    private final boolean isExclusive = true;
    private final CloudConfigManager myManager;

    public boolean isExclusive() {
        return this.isExclusive;
    }

    private final void addConfigs(List<? extends Class<?>> storageClasses, Function2<? super Class<?>, ? super String, Unit> f) {
        for (Class<?> storageClass : storageClasses) {
            State spec;
            if (StoreUtilKt.getStateSpec(storageClass) == null) {
                Intrinsics.throwNpe();
            }
            String name = CloudConfigStreamProviderKt.getFileConfig(spec);
            this.myFileStorages.add(name);
            f.invoke(storageClass, (Object)name);
            CharSequence charSequence = spec.additionalExportFile();
            boolean bl = false;
            if (!(charSequence.length() > 0)) continue;
            this.mySchemeStorages.add(spec.additionalExportFile());
            f.invoke(storageClass, (Object)spec.additionalExportFile());
        }
    }

    public boolean isApplicable(@NotNull String fileSpec, @NotNull RoamingType roamingType) {
        Intrinsics.checkParameterIsNotNull((Object)fileSpec, (String)"fileSpec");
        Intrinsics.checkParameterIsNotNull((Object)roamingType, (String)"roamingType");
        int index = StringsKt.indexOf$default((CharSequence)fileSpec, (char)'/', (int)0, (boolean)false, (int)6, null);
        if (index == -1) {
            return this.findStorage(fileSpec);
        }
        String string = fileSpec;
        int n = 0;
        CloudConfigStreamProvider cloudConfigStreamProvider = this;
        boolean bl = false;
        String string2 = string.substring(n, index);
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
        String string3 = string2;
        return cloudConfigStreamProvider.findStorage(string3);
    }

    private final boolean findStorage(String fileSpec) {
        return this.myFileStorages.contains(fileSpec) || this.mySchemeStorages.contains(fileSpec);
    }

    private final String convertName(String fileSpec) {
        int index = StringsKt.indexOf$default((CharSequence)fileSpec, (char)'/', (int)0, (boolean)false, (int)6, null);
        if (index == -1) {
            String string = this.myOSNames.get(fileSpec);
            if (string == null) {
                return fileSpec;
            }
            return string;
        }
        String string = fileSpec;
        int n = 0;
        Serializable serializable = this.myOSNames;
        boolean bl = false;
        String string2 = string;
        if (string2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        String string3 = string2.substring(n, index);
        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
        String string4 = string3;
        String firstName = ((HashMap)serializable).get(string4);
        if (firstName != null) {
            string = fileSpec;
            n = index + 1;
            serializable = new StringBuilder().append(firstName).append("/");
            bl = false;
            String string5 = string;
            if (string5 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            String string6 = string5.substring(n);
            Intrinsics.checkExpressionValueIsNotNull((Object)string6, (String)"(this as java.lang.String).substring(startIndex)");
            string4 = string6;
            return ((StringBuilder)serializable).append(string4).toString();
        }
        return fileSpec;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean read(@NotNull String fileSpec, @NotNull RoamingType roamingType, @NotNull Function1<? super InputStream, Unit> consumer) {
        Path path;
        Intrinsics.checkParameterIsNotNull((Object)fileSpec, (String)"fileSpec");
        Intrinsics.checkParameterIsNotNull((Object)roamingType, (String)"roamingType");
        Intrinsics.checkParameterIsNotNull(consumer, (String)"consumer");
        if (!this.isApplicable(fileSpec, roamingType)) {
            return false;
        }
        Path path2 = path = this.myConfigDir.resolve(this.convertName(fileSpec));
        Intrinsics.checkExpressionValueIsNotNull((Object)path2, (String)"path");
        if (this.checkFile(path2)) {
            Closeable closeable = PathKt.inputStream((Path)path);
            boolean bl = false;
            Throwable throwable = null;
            try {
                Object object = consumer.invoke((Object)closeable);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        } else {
            consumer.invoke(null);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public boolean processChildren(@NotNull String path, @NotNull RoamingType roamingType, @NotNull Function1<? super String, Boolean> filter, @NotNull Function3<? super String, ? super InputStream, ? super Boolean, Boolean> processor) {
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        Intrinsics.checkParameterIsNotNull((Object)roamingType, (String)"roamingType");
        Intrinsics.checkParameterIsNotNull(filter, (String)"filter");
        Intrinsics.checkParameterIsNotNull(processor, (String)"processor");
        if (!this.isApplicable(path, roamingType)) {
            return false;
        }
        Path path2 = this.myConfigDir.resolve(this.convertName(path));
        Intrinsics.checkExpressionValueIsNotNull((Object)path2, (String)"myConfigDir.resolve(convertName(path))");
        Path path3 = path2;
        Function1 filter$iv = (Function1)new Function1<Path, Boolean>(filter){
            final /* synthetic */ Function1 $filter;

            public final boolean invoke(@NotNull Path it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                return (Boolean)this.$filter.invoke((Object)((Object)it.getFileName()).toString());
            }
            {
                this.$filter = function1;
                super(1);
            }
        };
        boolean $i$f$directoryStreamIfExists = false;
        try {
            void $this$directoryStreamIfExists$iv;
            Closeable closeable = Files.newDirectoryStream((Path)$this$directoryStreamIfExists$iv, (DirectoryStream.Filter<? super Path>)new DirectoryStream.Filter<Path>(filter$iv){
                final /* synthetic */ Function1 $filter;
                {
                    this.$filter = function1;
                }

                public final boolean accept(Path it) {
                    Path path = it;
                    Intrinsics.checkExpressionValueIsNotNull((Object)path, (String)"it");
                    return (Boolean)this.$filter.invoke((Object)path);
                }
            });
            boolean bl = false;
            Throwable throwable = null;
            try {
                DirectoryStream it = (DirectoryStream)closeable;
                boolean bl2 = false;
                Iterator iterator = it.iterator();
                while (iterator.hasNext()) {
                    boolean bl3;
                    Path file;
                    Path path4 = file = (Path)iterator.next();
                    Intrinsics.checkExpressionValueIsNotNull((Object)path4, (String)"file");
                    if (!this.checkFile(path4)) continue;
                    Closeable closeable2 = PathKt.inputStream((Path)file);
                    boolean bl4 = false;
                    Throwable throwable2 = null;
                    try {
                        InputStream it2 = (InputStream)closeable2;
                        boolean bl5 = false;
                        bl3 = (Boolean)processor.invoke((Object)((Object)file.getFileName()).toString(), (Object)it2, (Object)false);
                    }
                    catch (Throwable throwable3) {
                        throwable2 = throwable3;
                        throw throwable3;
                    }
                    finally {
                        CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable2);
                    }
                    if (bl3) continue;
                    break;
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
        catch (NoSuchFileException noSuchFileException) {
        }
        return true;
    }

    public void write(@NotNull String fileSpec, @NotNull byte[] content, int size, @NotNull RoamingType roamingType) {
        Path file;
        Intrinsics.checkParameterIsNotNull((Object)fileSpec, (String)"fileSpec");
        Intrinsics.checkParameterIsNotNull((Object)content, (String)"content");
        Intrinsics.checkParameterIsNotNull((Object)roamingType, (String)"roamingType");
        String fileName = this.convertName(fileSpec);
        Path path = file = this.myConfigDir.resolve(fileName);
        Intrinsics.checkExpressionValueIsNotNull((Object)path, (String)"file");
        if (this.checkFile(path)) {
            int n = 0;
            String string = PathKt.readText((Path)file);
            boolean bl = false;
            String string2 = new String(content, n, size, Charsets.UTF_8);
            if (Intrinsics.areEqual((Object)string, (Object)string2)) {
                return;
            }
        }
        PathKt.write((Path)file, (byte[])content, (int)0, (int)size);
        this.myManager.editConfigFiles(fileName);
    }

    public boolean delete(@NotNull String fileSpec, @NotNull RoamingType roamingType) {
        Intrinsics.checkParameterIsNotNull((Object)fileSpec, (String)"fileSpec");
        Intrinsics.checkParameterIsNotNull((Object)roamingType, (String)"roamingType");
        if (!this.isApplicable(fileSpec, roamingType)) {
            return false;
        }
        String fileName = this.convertName(fileSpec);
        Path path = this.myConfigDir.resolve(fileName);
        Intrinsics.checkExpressionValueIsNotNull((Object)path, (String)"myConfigDir.resolve(fileName)");
        PathKt.delete$default((Path)path, (boolean)false, (int)1, null);
        this.myManager.editConfigFiles(fileName);
        return true;
    }

    private final boolean checkFile(Path file) {
        BasicFileAttributes attributes = PathKt.basicAttributesIfExists((Path)file);
        return attributes != null && !attributes.isDirectory() && attributes.size() > 0L && !PathKt.isHidden((Path)file);
    }

    public CloudConfigStreamProvider(@NotNull File configDir, @NotNull CloudConfigManager myManager) {
        Intrinsics.checkParameterIsNotNull((Object)configDir, (String)"configDir");
        Intrinsics.checkParameterIsNotNull((Object)myManager, (String)"myManager");
        this.myManager = myManager;
        this.myConfigDir = configDir.toPath();
        this.myFileStorages = new HashSet();
        this.mySchemeStorages = new HashSet();
        this.myOSNames = new HashMap();
        this.isExclusive = true;
        List<Class<?>> list = this.myManager.getAllClasses();
        Intrinsics.checkExpressionValueIsNotNull(list, (String)"myManager.allClasses");
        this.addConfigs(list, (Function2)new Function2<Class<?>, String, Unit>(){

            public final void invoke(@NotNull Class<?> clazz, @NotNull String name) {
                Intrinsics.checkParameterIsNotNull(clazz, (String)"clazz");
                Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
                if (ConfigList.isOSConfig(clazz)) {
                    myOSNames.put(name, CloudConfigClientUtil.getOS() + "." + name);
                }
            }
        });
    }

    public void write(@NotNull String path, @NotNull BufferExposingByteArrayOutputStream content, @NotNull RoamingType roamingType) {
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        Intrinsics.checkParameterIsNotNull((Object)content, (String)"content");
        Intrinsics.checkParameterIsNotNull((Object)roamingType, (String)"roamingType");
        StreamProvider.DefaultImpls.write((StreamProvider)this, (String)path, (BufferExposingByteArrayOutputStream)content, (RoamingType)roamingType);
    }

    public boolean getEnabled() {
        return StreamProvider.DefaultImpls.getEnabled((StreamProvider)this);
    }

    public boolean isDisableExportAction() {
        return StreamProvider.DefaultImpls.isDisableExportAction((StreamProvider)this);
    }
}

