/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.debugger.nashorn;

import com.intellij.debugger.SourcePosition;
import com.intellij.javascript.debugger.LocalFileSystemFileFinder;
import com.intellij.javascript.debugger.nashorn.NashornSourceMapHandler;
import com.intellij.javascript.debugger.sourcemap.PreloadedSourceMapList;
import com.intellij.javascript.debugger.sourcemap.SourceMapHelperKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.util.Url;
import com.intellij.xdebugger.XSourcePosition;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.debugger.Location;
import org.jetbrains.debugger.ScriptDebuggerUrls;
import org.jetbrains.debugger.SourceInfo;
import org.jetbrains.debugger.sourcemap.MappingEntry;
import org.jetbrains.debugger.sourcemap.SourceMap;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\u0012\u0010\u000f\u001a\u0004\u0018\u00010\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012J\u001a\u0010\u0013\u001a\u0004\u0018\u00010\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0017\u001a\u00020\u0018R\u001b\u0010\u0007\u001a\u00020\b8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000b\u0010\f\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/intellij/javascript/debugger/nashorn/NashornSourceMapHandler;", "", "project", "Lcom/intellij/openapi/project/Project;", "sourceMapList", "Lcom/intellij/javascript/debugger/sourcemap/PreloadedSourceMapList;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/javascript/debugger/sourcemap/PreloadedSourceMapList;)V", "fileFinder", "Lcom/intellij/javascript/debugger/LocalFileSystemFileFinder;", "getFileFinder", "()Lcom/intellij/javascript/debugger/LocalFileSystemFileFinder;", "fileFinder$delegate", "Lkotlin/Lazy;", "getProject", "()Lcom/intellij/openapi/project/Project;", "getGeneratedPosition", "Lcom/intellij/debugger/SourcePosition;", "sourcePosition", "Lcom/intellij/xdebugger/XSourcePosition;", "getSourceInfo", "Lorg/jetbrains/debugger/SourceInfo;", "generatedFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "generatedLocation", "Lcom/sun/jdi/Location;", "intellij.javascript.nashorn.debugger"})
public final class NashornSourceMapHandler {
    private final Lazy fileFinder$delegate;
    @NotNull
    private final Project project;
    private final PreloadedSourceMapList sourceMapList;

    private final LocalFileSystemFileFinder getFileFinder() {
        Lazy lazy = this.fileFinder$delegate;
        NashornSourceMapHandler nashornSourceMapHandler = this;
        Object var3_3 = null;
        boolean bl = false;
        return (LocalFileSystemFileFinder)lazy.getValue();
    }

    @Nullable
    public final SourcePosition getGeneratedPosition(@Nullable XSourcePosition sourcePosition) {
        if (sourcePosition != null && this.sourceMapList != null) {
            VirtualFile virtualFile = sourcePosition.getFile();
            Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile, (String)"sourcePosition.file");
            List rawLocations = SourceMapHelperKt.getRawLocations$default((Project)this.project, (PreloadedSourceMapList)this.sourceMapList, (VirtualFile)virtualFile, (int)sourcePosition.getLine(), null, null, (int)0, (int)112, null);
            if (!rawLocations.isEmpty()) {
                PsiFile file;
                Location location = (Location)rawLocations.get(0);
                LocalFileSystemFileFinder localFileSystemFileFinder = this.getFileFinder();
                Url url = location.getUrl();
                Intrinsics.checkExpressionValueIsNotNull((Object)url, (String)"location.url");
                VirtualFile virtualFile2 = localFileSystemFileFinder.findFile(url, this.project);
                PsiFile psiFile = file = virtualFile2 != null ? PsiManager.getInstance((Project)this.project).findFile(virtualFile2) : null;
                if (file != null) {
                    return SourcePosition.createFromLine((PsiFile)file, (int)location.getLine());
                }
            }
        }
        return null;
    }

    @Nullable
    public final SourceInfo getSourceInfo(@Nullable VirtualFile generatedFile, @NotNull com.sun.jdi.Location generatedLocation) {
        PreloadedSourceMapList preloadedSourceMapList;
        block8: {
            block7: {
                Intrinsics.checkParameterIsNotNull((Object)generatedLocation, (String)"generatedLocation");
                if (generatedFile == null) {
                    return null;
                }
                preloadedSourceMapList = this.sourceMapList;
                if (preloadedSourceMapList == null) break block7;
                String string = generatedFile.getPath();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"generatedFile.path");
                if ((preloadedSourceMapList = preloadedSourceMapList.getByScript(ScriptDebuggerUrls.newLocalFileUrl((String)string))) != null) break block8;
            }
            return null;
        }
        PreloadedSourceMapList sourceMap = preloadedSourceMapList;
        MappingEntry mappingEntry = SourceMapHelperKt.findMapping((SourceMap)sourceMap, (int)(generatedLocation.lineNumber() - 1), (int)0);
        if (mappingEntry == null) {
            return null;
        }
        MappingEntry mapping = mappingEntry;
        Url url = sourceMap.getSourceResolver().getSource(mapping);
        if (url == null) {
            return null;
        }
        Url sourceUrl = url;
        VirtualFile virtualFile = this.getFileFinder().findFile(sourceUrl, this.project);
        if (virtualFile == null) {
            return null;
        }
        VirtualFile sourceFile = virtualFile;
        return new SourceInfo(sourceFile, mapping.getSourceLine(), mapping.getSourceColumn(), 0, null, sourceUrl, 24, null);
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    public NashornSourceMapHandler(@NotNull Project project, @Nullable PreloadedSourceMapList sourceMapList) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        this.project = project;
        this.sourceMapList = sourceMapList;
        this.fileFinder$delegate = LazyKt.lazy((Function0)fileFinder.2.INSTANCE);
    }
}

