/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.vagrant;

import com.google.common.collect.Lists;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import com.intellij.execution.ExecutionException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.remote.RemoteConnector;
import com.intellij.remote.RemoteCredentials;
import com.intellij.remote.VagrantSupport;
import com.intellij.util.ConcurrencyUtil;
import com.intellij.util.PathMappingSettings;
import com.jetbrains.plugins.vagrant.VagrantFileConfig;
import com.jetbrains.plugins.vagrant.VagrantInstance;
import com.jetbrains.plugins.vagrant.VagrantManager;
import com.jetbrains.plugins.vagrant.VagrantService;
import com.jetbrains.plugins.vagrant.VagrantSshConfig;
import com.jetbrains.plugins.vagrant.VagrantUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VagrantSupportImpl
extends VagrantSupport {
    public ListenableFuture<RemoteCredentials> computeVagrantSettings(@Nullable Project project, @NotNull String vagrantFolder, @Nullable String machineName) {
        if (vagrantFolder == null) {
            VagrantSupportImpl.$$$reportNull$$$0(0);
        }
        return VagrantSupportImpl.compute(() -> {
            VagrantInstance vagrantInstance = VagrantService.getInstance().getVagrantInstance(vagrantFolder);
            VagrantSshConfig config = vagrantInstance.getSshConfig(machineName);
            return VagrantSshConfig.createRemoteCredentials(config);
        });
    }

    @NotNull
    public RemoteCredentials getCredentials(@NotNull String vagrantFolder, @Nullable String machineName) throws IOException {
        if (vagrantFolder == null) {
            VagrantSupportImpl.$$$reportNull$$$0(1);
        }
        RemoteCredentials remoteCredentials = VagrantUtil.getVagrantCredentials(vagrantFolder, machineName);
        if (remoteCredentials == null) {
            VagrantSupportImpl.$$$reportNull$$$0(2);
        }
        return remoteCredentials;
    }

    public boolean checkVagrantRunning(@NotNull String vagrantFolder, @Nullable String machineName, boolean askToRunIfDown) {
        if (vagrantFolder == null) {
            VagrantSupportImpl.$$$reportNull$$$0(3);
        }
        return VagrantUtil.checkVagrantRunning(vagrantFolder, machineName, askToRunIfDown);
    }

    public void runVagrant(@NotNull String vagrantFolder, @Nullable String machineName) throws ExecutionException {
        if (vagrantFolder == null) {
            VagrantSupportImpl.$$$reportNull$$$0(4);
        }
        VagrantUtil.runVagrant(vagrantFolder, machineName);
    }

    @Nullable
    public final PathMappingSettings getMappedFolders(@NotNull String vagrantFolder) {
        VagrantFileConfig config;
        if (vagrantFolder == null) {
            VagrantSupportImpl.$$$reportNull$$$0(5);
        }
        if ((config = VagrantFileConfig.findInFolder(vagrantFolder)) == null) {
            return null;
        }
        return config.getCustomMappings();
    }

    public Collection<? extends RemoteConnector> getVagrantInstancesConnectors(@NotNull Project project) {
        if (project == null) {
            VagrantSupportImpl.$$$reportNull$$$0(6);
        }
        ArrayList result = Lists.newArrayList();
        for (VagrantInstance vi : VagrantManager.getInstance(project).listInstances()) {
            result.add(vi.toRemoteConnector(project));
        }
        return result;
    }

    public boolean isVagrantInstance(@Nullable VirtualFile dir) {
        return dir != null && dir.findChild("Vagrantfile") != null;
    }

    public List<String> getMachineNames(@NotNull String instanceFolder) {
        if (instanceFolder == null) {
            VagrantSupportImpl.$$$reportNull$$$0(7);
        }
        return VagrantService.getInstance().getVagrantInstance(instanceFolder).getVagrantMachines();
    }

    @Nullable
    public String findVagrantFolder(@NotNull Project project) {
        VagrantFileConfig config;
        VagrantInstance instance;
        if (project == null) {
            VagrantSupportImpl.$$$reportNull$$$0(8);
        }
        if ((instance = VagrantManager.getInstance(project).currentInstance()) != null && (config = instance.getVagrantFile()) != null) {
            return instance.getFolder();
        }
        for (VirtualFile file : ProjectRootManager.getInstance((Project)project).getContentRoots()) {
            if (!this.isVagrantInstance(file)) continue;
            return file.getPath();
        }
        return null;
    }

    private static <T> ListenableFuture<T> compute(Callable<T> callable) {
        return ExecutorServiceHolder.ourThreadExecutorsService.submit(callable);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vagrantFolder";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/plugins/vagrant/VagrantSupportImpl";
                break;
            }
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "instanceFolder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/plugins/vagrant/VagrantSupportImpl";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getCredentials";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "computeVagrantSettings";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getCredentials";
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "checkVagrantRunning";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "runVagrant";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getMappedFolders";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getVagrantInstancesConnectors";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getMachineNames";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "findVagrantFolder";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class ExecutorServiceHolder {
        private static final ListeningExecutorService ourThreadExecutorsService = MoreExecutors.listeningDecorator((ExecutorService)ConcurrencyUtil.newSingleThreadExecutor((String)"Vagrant support"));

        private ExecutorServiceHolder() {
        }
    }
}

