/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.history;

import com.intellij.openapi.vcs.FilePath;
import com.intellij.vcs.log.VcsLogDataPack;
import com.intellij.vcs.log.VcsLogFilterCollection;
import com.intellij.vcs.log.history.FileHistory;
import com.intellij.vcs.log.history.FileHistoryFilterer;
import com.intellij.vcs.log.history.FileHistoryKt;
import com.intellij.vcs.log.history.MaybeDeletedFilePath;
import com.intellij.vcs.log.visible.VisiblePack;
import gnu.trove.THashSet;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u000e\u001a\u0004\u0018\u00010\u000f*\u00020\u00072\u0006\u0010\u0010\u001a\u00020\u0005H\u0007J\u0016\u0010\u0011\u001a\u0004\u0018\u00010\u000f*\u00020\u00072\u0006\u0010\u0010\u001a\u00020\u0005H\u0007J\u0012\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0013*\u00020\u0007H\u0007J\f\u0010\u0014\u001a\u00020\u0015*\u00020\u0007H\u0007J\u0014\u0010\u0016\u001a\u00020\u0015*\u00020\u00072\u0006\u0010\u0010\u001a\u00020\u0005H\u0007R$\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004*\u00020\u00078BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0015\u0010\n\u001a\u00020\u000b*\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0017"}, d2={"Lcom/intellij/vcs/log/history/FileHistoryPaths;", "", "()V", "commitsToPathsMap", "", "", "Lcom/intellij/vcs/log/history/MaybeDeletedFilePath;", "Lcom/intellij/vcs/log/VcsLogDataPack;", "getCommitsToPathsMap", "(Lcom/intellij/vcs/log/VcsLogDataPack;)Ljava/util/Map;", "fileHistory", "Lcom/intellij/vcs/log/history/FileHistory;", "getFileHistory", "(Lcom/intellij/vcs/log/VcsLogDataPack;)Lcom/intellij/vcs/log/history/FileHistory;", "filePath", "Lcom/intellij/openapi/vcs/FilePath;", "commit", "filePathOrDefault", "filePaths", "", "hasPathsInformation", "", "isDeletedInCommit", "intellij.platform.vcs.log.impl"})
public final class FileHistoryPaths {
    public static final FileHistoryPaths INSTANCE;

    @NotNull
    public final FileHistory getFileHistory(@NotNull VcsLogDataPack $this$fileHistory) {
        FileHistory fileHistory;
        Intrinsics.checkParameterIsNotNull((Object)$this$fileHistory, (String)"$this$fileHistory");
        if (!($this$fileHistory instanceof VisiblePack)) {
            return FileHistoryKt.getEMPTY_HISTORY();
        }
        Object t = ((VisiblePack)$this$fileHistory).getAdditionalData();
        if (!(t instanceof FileHistory)) {
            t = null;
        }
        if ((fileHistory = (FileHistory)t) == null) {
            fileHistory = FileHistoryKt.getEMPTY_HISTORY();
        }
        return fileHistory;
    }

    private final Map<Integer, MaybeDeletedFilePath> getCommitsToPathsMap(@NotNull VcsLogDataPack $this$commitsToPathsMap) {
        return this.getFileHistory($this$commitsToPathsMap).getCommitsToPathsMap();
    }

    @JvmStatic
    public static final boolean hasPathsInformation(@NotNull VcsLogDataPack $this$hasPathsInformation) {
        Intrinsics.checkParameterIsNotNull((Object)$this$hasPathsInformation, (String)"$this$hasPathsInformation");
        if (!($this$hasPathsInformation instanceof VisiblePack)) {
            return false;
        }
        return ((VisiblePack)$this$hasPathsInformation).getAdditionalData() instanceof FileHistory;
    }

    @JvmStatic
    @Nullable
    public static final FilePath filePath(@NotNull VcsLogDataPack $this$filePath, int commit) {
        Intrinsics.checkParameterIsNotNull((Object)$this$filePath, (String)"$this$filePath");
        MaybeDeletedFilePath maybeDeletedFilePath = INSTANCE.getCommitsToPathsMap($this$filePath).get(commit);
        return maybeDeletedFilePath != null ? maybeDeletedFilePath.getFilePath() : null;
    }

    @JvmStatic
    @Nullable
    public static final FilePath filePathOrDefault(@NotNull VcsLogDataPack $this$filePathOrDefault, int commit) {
        Intrinsics.checkParameterIsNotNull((Object)$this$filePathOrDefault, (String)"$this$filePathOrDefault");
        MaybeDeletedFilePath maybeDeletedFilePath = INSTANCE.getCommitsToPathsMap($this$filePathOrDefault).get(commit);
        if (maybeDeletedFilePath == null || (maybeDeletedFilePath = maybeDeletedFilePath.getFilePath()) == null) {
            VcsLogFilterCollection vcsLogFilterCollection = $this$filePathOrDefault.getFilters();
            Intrinsics.checkExpressionValueIsNotNull((Object)vcsLogFilterCollection, (String)"filters");
            maybeDeletedFilePath = FileHistoryFilterer.Companion.getFilePath(vcsLogFilterCollection);
        }
        return maybeDeletedFilePath;
    }

    @JvmStatic
    public static final boolean isDeletedInCommit(@NotNull VcsLogDataPack $this$isDeletedInCommit, int commit) {
        Intrinsics.checkParameterIsNotNull((Object)$this$isDeletedInCommit, (String)"$this$isDeletedInCommit");
        MaybeDeletedFilePath maybeDeletedFilePath = INSTANCE.getCommitsToPathsMap($this$isDeletedInCommit).get(commit);
        return maybeDeletedFilePath != null ? maybeDeletedFilePath.getDeleted() : false;
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    @NotNull
    public static final Set<FilePath> filePaths(@NotNull VcsLogDataPack $this$filePaths) {
        void var2_2;
        void $this$mapTo$iv;
        Intrinsics.checkParameterIsNotNull((Object)$this$filePaths, (String)"$this$filePaths");
        Iterable iterable = INSTANCE.getCommitsToPathsMap($this$filePaths).values();
        Collection destination$iv = (Collection)new THashSet(FileHistoryKt.FILE_PATH_HASHING_STRATEGY);
        boolean $i$f$mapTo = false;
        for (Object item$iv : $this$mapTo$iv) {
            void it;
            MaybeDeletedFilePath maybeDeletedFilePath = (MaybeDeletedFilePath)item$iv;
            Collection collection = destination$iv;
            boolean bl = false;
            FilePath filePath = it.getFilePath();
            collection.add(filePath);
        }
        return (Set)var2_2;
    }

    private FileHistoryPaths() {
    }

    static {
        FileHistoryPaths fileHistoryPaths;
        INSTANCE = fileHistoryPaths = new FileHistoryPaths();
    }
}

