/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.data;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.SmartList;
import com.intellij.vcs.log.CommitId;
import com.intellij.vcs.log.VcsLogProvider;
import com.intellij.vcs.log.VcsLogRefs;
import com.intellij.vcs.log.VcsRef;
import com.intellij.vcs.log.data.CompressedRefs;
import com.intellij.vcs.log.data.VcsLogStorage;
import gnu.trove.TIntObjectHashMap;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RefsModel
implements VcsLogRefs {
    private static final Logger LOG = Logger.getInstance(RefsModel.class);
    @NotNull
    private final VcsLogStorage myStorage;
    @NotNull
    private final Map<VirtualFile, CompressedRefs> myRefs;
    @NotNull
    private final TIntObjectHashMap<VcsRef> myBestRefForHead;
    @NotNull
    private final TIntObjectHashMap<VirtualFile> myRootForHead;

    public RefsModel(@NotNull Map<VirtualFile, CompressedRefs> refs, @NotNull Set<Integer> heads, @NotNull VcsLogStorage storage, @NotNull Map<VirtualFile, VcsLogProvider> providers) {
        if (refs == null) {
            RefsModel.$$$reportNull$$$0(0);
        }
        if (heads == null) {
            RefsModel.$$$reportNull$$$0(1);
        }
        if (storage == null) {
            RefsModel.$$$reportNull$$$0(2);
        }
        if (providers == null) {
            RefsModel.$$$reportNull$$$0(3);
        }
        this.myRefs = refs;
        this.myStorage = storage;
        this.myBestRefForHead = new TIntObjectHashMap();
        this.myRootForHead = new TIntObjectHashMap();
        for (int head : heads) {
            CommitId commitId = this.myStorage.getCommitId(head);
            if (commitId == null) continue;
            VirtualFile root = commitId.getRoot();
            this.myRootForHead.put(head, (Object)root);
            Optional bestRef = this.myRefs.get(root).refsToCommit(head).stream().min(providers.get(root).getReferenceManager().getBranchLayoutComparator());
            if (bestRef.isPresent()) {
                this.myBestRefForHead.put(head, bestRef.get());
                continue;
            }
            LOG.debug("No references at head " + commitId);
        }
    }

    @Nullable
    public VcsRef bestRefToHead(int headIndex) {
        return (VcsRef)this.myBestRefForHead.get(headIndex);
    }

    @NotNull
    public VirtualFile rootAtHead(int headIndex) {
        VirtualFile virtualFile = (VirtualFile)this.myRootForHead.get(headIndex);
        if (virtualFile == null) {
            RefsModel.$$$reportNull$$$0(4);
        }
        return virtualFile;
    }

    @NotNull
    public Map<VirtualFile, CompressedRefs> getAllRefsByRoot() {
        Map<VirtualFile, CompressedRefs> map2 = this.myRefs;
        if (map2 == null) {
            RefsModel.$$$reportNull$$$0(5);
        }
        return map2;
    }

    @NotNull
    public List<VcsRef> refsToCommit(int index) {
        if (this.myRefs.size() <= 10) {
            for (CompressedRefs refs : this.myRefs.values()) {
                if (!refs.contains(index)) continue;
                SmartList<VcsRef> smartList = refs.refsToCommit(index);
                if (smartList == null) {
                    RefsModel.$$$reportNull$$$0(6);
                }
                return smartList;
            }
            List<VcsRef> list = Collections.emptyList();
            if (list == null) {
                RefsModel.$$$reportNull$$$0(7);
            }
            return list;
        }
        CommitId id = this.myStorage.getCommitId(index);
        if (id == null) {
            List<VcsRef> list = Collections.emptyList();
            if (list == null) {
                RefsModel.$$$reportNull$$$0(8);
            }
            return list;
        }
        VirtualFile root = id.getRoot();
        SmartList<VcsRef> smartList = this.myRefs.get(root).refsToCommit(index);
        if (smartList == null) {
            RefsModel.$$$reportNull$$$0(9);
        }
        return smartList;
    }

    @NotNull
    public Collection<VcsRef> getBranches() {
        Collection collection = this.myRefs.values().stream().flatMap(CompressedRefs::streamBranches).collect(Collectors.toList());
        if (collection == null) {
            RefsModel.$$$reportNull$$$0(10);
        }
        return collection;
    }

    @NotNull
    public Stream<VcsRef> stream() {
        assert (!ApplicationManager.getApplication().isDispatchThread());
        Stream<VcsRef> stream = this.myRefs.values().stream().flatMap(CompressedRefs::stream);
        if (stream == null) {
            RefsModel.$$$reportNull$$$0(11);
        }
        return stream;
    }

    @NotNull
    public static RefsModel createEmptyInstance(@NotNull VcsLogStorage storage) {
        if (storage == null) {
            RefsModel.$$$reportNull$$$0(12);
        }
        return new RefsModel(Collections.emptyMap(), Collections.emptySet(), storage, Collections.emptyMap());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refs";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "heads";
                break;
            }
            case 2: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "storage";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "providers";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/vcs/log/data/RefsModel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/vcs/log/data/RefsModel";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "rootAtHead";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllRefsByRoot";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "refsToCommit";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getBranches";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "stream";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "createEmptyInstance";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

