/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.configurable;

import com.intellij.ide.ui.OptionsSearchTopHitProvider;
import com.intellij.ide.ui.PublicFieldBasedOptionDescription;
import com.intellij.ide.ui.PublicMethodBasedOptionDescription;
import com.intellij.ide.ui.search.BooleanOptionDescription;
import com.intellij.ide.ui.search.OptionDescription;
import com.intellij.openapi.application.ApplicationBundle;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsApplicationSettings;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsConfiguration;
import com.intellij.openapi.vcs.changes.ChangeListManagerImpl;
import com.intellij.openapi.vcs.contentAnnotation.VcsContentAnnotationSettings;
import com.intellij.openapi.vcs.readOnlyHandler.ReadonlyStatusHandlerImpl;
import com.intellij.openapi.vfs.ReadonlyStatusHandler;
import com.intellij.vcs.commit.CommitWorkflowManager;
import com.intellij.vcs.commit.message.CommitMessageInspectionProfile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public final class VcsOptionsTopHitProvider
implements OptionsSearchTopHitProvider.ProjectLevelProvider {
    @NotNull
    public String getId() {
        return "vcs";
    }

    @NotNull
    public Collection<OptionDescription> getOptions(@NotNull Project project) {
        if (project == null) {
            VcsOptionsTopHitProvider.$$$reportNull$$$0(0);
        }
        if (ProjectLevelVcsManager.getInstance((Project)project).getAllVcss().length == 0) {
            List<OptionDescription> list = Collections.emptyList();
            if (list == null) {
                VcsOptionsTopHitProvider.$$$reportNull$$$0(1);
            }
            return list;
        }
        VcsConfiguration vcs = VcsConfiguration.getInstance((Project)project);
        if (vcs == null) {
            List<OptionDescription> list = Collections.emptyList();
            if (list == null) {
                VcsOptionsTopHitProvider.$$$reportNull$$$0(2);
            }
            return list;
        }
        ArrayList<BooleanOptionDescription> options = new ArrayList<BooleanOptionDescription>();
        String id = "project.propVCSSupport.Mappings";
        options.add(VcsOptionsTopHitProvider.option(vcs, id, "Version Control: Limit history by " + vcs.MAXIMUM_HISTORY_ROWS + " rows", "LIMIT_HISTORY"));
        options.add(VcsOptionsTopHitProvider.option(vcs, id, "Version Control: " + VcsBundle.message((String)"checkbox.show.dirty.recursively", (Object[])new Object[0]), "SHOW_DIRTY_RECURSIVELY"));
        VcsContentAnnotationSettings vcsCA = VcsContentAnnotationSettings.getInstance((Project)project);
        if (vcsCA != null) {
            options.add(VcsOptionsTopHitProvider.option(vcsCA, id, "Version Control: Show changed in last " + vcsCA.getLimitDays() + " days", "isShow", "setShow"));
        }
        options.add(VcsOptionsTopHitProvider.nonModalCommitOption());
        options.add(VcsOptionsTopHitProvider.option(vcs, id, "Commit message: Show right margin at " + CommitMessageInspectionProfile.getBodyRightMargin(project) + " columns", "USE_COMMIT_MESSAGE_MARGIN"));
        options.add(VcsOptionsTopHitProvider.option(vcs, id, "Commit message: " + ApplicationBundle.message((String)"checkbox.wrap.typing.on.right.margin", (Object[])new Object[0]), "WRAP_WHEN_TYPING_REACHES_RIGHT_MARGIN"));
        id = "project.propVCSSupport.Confirmation";
        ReadonlyStatusHandler vcsROSH = ReadonlyStatusHandler.getInstance((Project)project);
        if (vcsROSH instanceof ReadonlyStatusHandlerImpl) {
            options.add(VcsOptionsTopHitProvider.option(((ReadonlyStatusHandlerImpl)vcsROSH).getState(), id, VcsBundle.message((String)"checkbox.show.clear.read.only.status.dialog", (Object[])new Object[0]), "SHOW_DIALOG"));
        }
        options.add(VcsOptionsTopHitProvider.option(vcs, id, "Confirmation: " + VcsBundle.message((String)"checkbox.changelist.move.offer", (Object[])new Object[0]), "OFFER_MOVE_TO_ANOTHER_CHANGELIST_ON_PARTIAL_COMMIT"));
        options.add(VcsOptionsTopHitProvider.option(vcs, id, "Confirmation: " + VcsBundle.message((String)"checkbox.force.non.empty.messages", (Object[])new Object[0]), "FORCE_NON_EMPTY_COMMENT"));
        options.add(VcsOptionsTopHitProvider.option(vcs, id, "Confirmation: " + VcsBundle.message((String)"checkbox.clear.initial.commit.message", (Object[])new Object[0]), "CLEAR_INITIAL_COMMIT_MESSAGE"));
        id = "project.propVCSSupport.Shelf";
        options.add(VcsOptionsTopHitProvider.option(vcs, id, VcsBundle.message((String)"vcs.shelf.store.base.content", (Object[])new Object[0]), "INCLUDE_TEXT_INTO_SHELF"));
        if (!project.isDefault()) {
            options.add(VcsOptionsTopHitProvider.tracker(project, "Changelists: " + VcsBundle.message((String)"settings.show.conflict.resolve.dialog.checkbox", (Object[])new Object[0]), "SHOW_DIALOG"));
            options.add(VcsOptionsTopHitProvider.tracker(project, "Changelists: " + VcsBundle.message((String)"settings.highlight.files.with.conflicts.checkbox", (Object[])new Object[0]), "HIGHLIGHT_CONFLICTS"));
            options.add(VcsOptionsTopHitProvider.tracker(project, "Changelists: " + VcsBundle.message((String)"settings.highlight.files.from.non.active.changelist.checkbox", (Object[])new Object[0]), "HIGHLIGHT_NON_ACTIVE_CHANGELIST"));
        }
        Collection<OptionDescription> collection = Collections.unmodifiableCollection(options);
        if (collection == null) {
            VcsOptionsTopHitProvider.$$$reportNull$$$0(3);
        }
        return collection;
    }

    private static BooleanOptionDescription option(final Object instance, String id, String option2, String field) {
        return new PublicFieldBasedOptionDescription(option2, id, field){

            public Object getInstance() {
                return instance;
            }
        };
    }

    private static BooleanOptionDescription option(final Object instance, String id, String option2, String getter, String setter) {
        return new PublicMethodBasedOptionDescription(option2, id, getter, setter){

            public Object getInstance() {
                return instance;
            }
        };
    }

    private static BooleanOptionDescription tracker(final Project project, String option2, String field) {
        return new PublicFieldBasedOptionDescription(option2, "project.propVCSSupport.ChangelistConflict", field){

            public Object getInstance() {
                return ChangeListManagerImpl.getInstanceImpl(project).getConflictTracker().getOptions();
            }

            protected void fireUpdated() {
                ChangeListManagerImpl.getInstanceImpl(project).getConflictTracker().optionsChanged();
            }
        };
    }

    @NotNull
    private static BooleanOptionDescription nonModalCommitOption() {
        String option2 = VcsBundle.message((String)"commit.dialog.configurable", (Object[])new Object[0]) + ": " + VcsBundle.message((String)"settings.commit.without.dialog", (Object[])new Object[0]);
        return new BooleanOptionDescription(option2, "project.propVCSSupport.CommitDialog"){

            public boolean isOptionEnabled() {
                return VcsApplicationSettings.getInstance().COMMIT_FROM_LOCAL_CHANGES;
            }

            public void setOptionState(boolean enabled) {
                CommitWorkflowManager.setCommitFromLocalChanges(enabled);
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vcs/configurable/VcsOptionsTopHitProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vcs/configurable/VcsOptionsTopHitProvider";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getOptions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getOptions";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

