/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.ignore.cache;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.changes.ignore.lang.Syntax;
import com.intellij.openapi.vcs.changes.ignore.psi.IgnoreEntry;
import com.intellij.util.containers.ContainerUtil;
import java.util.concurrent.ConcurrentMap;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PatternCache
implements Disposable {
    private final ConcurrentMap<String, String> GLOBS_CACHE;
    private final ConcurrentMap<String, Pattern> PATTERNS_CACHE;

    public PatternCache(@NotNull Project project) {
        if (project == null) {
            PatternCache.$$$reportNull$$$0(0);
        }
        this.GLOBS_CACHE = ContainerUtil.newConcurrentMap();
        this.PATTERNS_CACHE = ContainerUtil.newConcurrentMap();
        Disposer.register((Disposable)project, (Disposable)this);
    }

    @Nullable
    public Pattern createPattern(@NotNull String rule, @NotNull Syntax syntax) {
        if (rule == null) {
            PatternCache.$$$reportNull$$$0(1);
        }
        if (syntax == null) {
            PatternCache.$$$reportNull$$$0(2);
        }
        return this.createPattern(rule, syntax, false);
    }

    @Nullable
    public Pattern createPattern(@NotNull IgnoreEntry entry) {
        if (entry == null) {
            PatternCache.$$$reportNull$$$0(3);
        }
        return this.createPattern(entry, false);
    }

    @Nullable
    public Pattern createPattern(@NotNull IgnoreEntry entry, boolean acceptChildren) {
        if (entry == null) {
            PatternCache.$$$reportNull$$$0(4);
        }
        return this.createPattern(entry.getValue(), entry.getSyntax(), acceptChildren);
    }

    @Nullable
    public Pattern createPattern(@NotNull String rule, @NotNull Syntax syntax, boolean acceptChildren) {
        if (rule == null) {
            PatternCache.$$$reportNull$$$0(5);
        }
        if (syntax == null) {
            PatternCache.$$$reportNull$$$0(6);
        }
        String regex = this.getRegex(rule, syntax, acceptChildren);
        return this.getOrCreatePattern(regex);
    }

    @NotNull
    public String getRegex(@NotNull String rule, @NotNull Syntax syntax, boolean acceptChildren) {
        if (rule == null) {
            PatternCache.$$$reportNull$$$0(7);
        }
        if (syntax == null) {
            PatternCache.$$$reportNull$$$0(8);
        }
        String string = syntax.equals((Object)Syntax.GLOB) ? this.createRegex(rule, acceptChildren) : rule;
        if (string == null) {
            PatternCache.$$$reportNull$$$0(9);
        }
        return string;
    }

    @Nullable
    public Pattern getOrCreatePattern(@NotNull String regex) {
        if (regex == null) {
            PatternCache.$$$reportNull$$$0(10);
        }
        try {
            if (!this.PATTERNS_CACHE.containsKey(regex)) {
                this.PATTERNS_CACHE.put(regex, Pattern.compile(regex));
            }
            return (Pattern)this.PATTERNS_CACHE.get(regex);
        }
        catch (PatternSyntaxException e) {
            return null;
        }
    }

    @Nullable
    public Pattern getPattern(@NotNull String regex) {
        if (regex == null) {
            PatternCache.$$$reportNull$$$0(11);
        }
        return (Pattern)this.PATTERNS_CACHE.get(regex);
    }

    @NotNull
    private String createRegex(@NotNull String glob, boolean acceptChildren) {
        char[] chars;
        String cached;
        if (glob == null) {
            PatternCache.$$$reportNull$$$0(12);
        }
        if ((cached = (String)this.GLOBS_CACHE.get(glob = glob.trim())) != null) {
            String string = cached;
            if (string == null) {
                PatternCache.$$$reportNull$$$0(13);
            }
            return string;
        }
        StringBuilder sb = new StringBuilder("^");
        boolean escape = false;
        boolean star = false;
        boolean doubleStar = false;
        boolean bracket = false;
        int beginIndex = 0;
        if (StringUtil.startsWith((CharSequence)glob, (CharSequence)"**")) {
            sb.append("(?:[^/]*?/)*");
            beginIndex = 2;
            doubleStar = true;
        } else if (StringUtil.startsWith((CharSequence)glob, (CharSequence)"*/")) {
            sb.append("[^/]*");
            beginIndex = 1;
            star = true;
        } else if (StringUtil.equals((CharSequence)"*", (CharSequence)glob)) {
            sb.append(".*");
        } else if (StringUtil.startsWithChar((CharSequence)glob, (char)'*')) {
            sb.append(".*?");
        } else if (StringUtil.startsWithChar((CharSequence)glob, (char)'/')) {
            beginIndex = 1;
        } else {
            int slashes = StringUtil.countChars((CharSequence)glob, (char)'/');
            if (slashes == 0 || slashes == 1 && StringUtil.endsWithChar((CharSequence)glob, (char)'/')) {
                sb.append("(?:[^/]*?/)*");
            }
        }
        block7: for (char ch : chars = glob.substring(beginIndex).toCharArray()) {
            if (bracket && ch != ']') {
                sb.append(ch);
                continue;
            }
            if (doubleStar) {
                doubleStar = false;
                if (ch == '/') {
                    sb.append("(?:[^/]*/)*?");
                    continue;
                }
                sb.append("[^/]*?");
            }
            if (ch == '*') {
                if (escape) {
                    sb.append("\\*");
                    escape = false;
                    star = false;
                    continue;
                }
                if (star) {
                    char prev;
                    char c = prev = sb.length() > 0 ? sb.charAt(sb.length() - 1) : (char)'\u0000';
                    if (prev == '\u0000' || prev == '^' || prev == '/') {
                        doubleStar = true;
                    } else {
                        sb.append("[^/]*?");
                    }
                    star = false;
                    continue;
                }
                star = true;
                continue;
            }
            if (star) {
                sb.append("[^/]*?");
                star = false;
            }
            switch (ch) {
                case '\\': {
                    if (escape) {
                        sb.append("\\\\");
                        escape = false;
                        continue block7;
                    }
                    escape = true;
                    continue block7;
                }
                case '?': {
                    if (escape) {
                        sb.append("\\?");
                        escape = false;
                        continue block7;
                    }
                    sb.append('.');
                    continue block7;
                }
                case '[': {
                    if (escape) {
                        sb.append('\\');
                        escape = false;
                    } else {
                        bracket = true;
                    }
                    sb.append(ch);
                    continue block7;
                }
                case ']': {
                    if (!bracket) {
                        sb.append('\\');
                    }
                    sb.append(ch);
                    bracket = false;
                    escape = false;
                    continue block7;
                }
                case '$': 
                case '%': 
                case '(': 
                case ')': 
                case '+': 
                case '.': 
                case '@': 
                case '^': 
                case '|': {
                    sb.append('\\');
                    sb.append(ch);
                    escape = false;
                    continue block7;
                }
                default: {
                    escape = false;
                    sb.append(ch);
                }
            }
        }
        if (star || doubleStar) {
            if (StringUtil.endsWithChar((CharSequence)sb, (char)'/')) {
                sb.append(acceptChildren ? ".+" : "[^/]+/?");
            } else {
                sb.append("[^/]*/?");
            }
        } else if (StringUtil.endsWithChar((CharSequence)sb, (char)'/')) {
            if (acceptChildren) {
                sb.append("[^/]*");
            }
        } else {
            sb.append(acceptChildren ? "(?:/.*)?" : "/?");
        }
        sb.append('$');
        this.GLOBS_CACHE.put(glob, sb.toString());
        String string = sb.toString();
        if (string == null) {
            PatternCache.$$$reportNull$$$0(14);
        }
        return string;
    }

    public void dispose() {
        this.clearCache();
    }

    public void clearCache() {
        this.GLOBS_CACHE.clear();
        this.PATTERNS_CACHE.clear();
    }

    public static PatternCache getInstance(@NotNull Project project) {
        if (project == null) {
            PatternCache.$$$reportNull$$$0(15);
        }
        return (PatternCache)ServiceManager.getService((Project)project, PatternCache.class);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 9: 
            case 13: 
            case 14: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 9: 
            case 13: 
            case 14: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rule";
                break;
            }
            case 2: 
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "syntax";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "entry";
                break;
            }
            case 9: 
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vcs/changes/ignore/cache/PatternCache";
                break;
            }
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "regex";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "glob";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vcs/changes/ignore/cache/PatternCache";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getRegex";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "createRegex";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createPattern";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getRegex";
                break;
            }
            case 9: 
            case 13: 
            case 14: {
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getOrCreatePattern";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getPattern";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "createRegex";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 9: 
            case 13: 
            case 14: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

