/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.dialogs;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.CommonShortcuts;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.DumbAwareToggleAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.util.NamedRunnable;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.VcsDirtyScopeManager;
import com.intellij.openapi.vcs.ui.VcsBalloonProblemNotifier;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.ui.PopupHandler;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.table.JBTable;
import com.intellij.util.IconUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.SvnVcs;
import org.jetbrains.idea.svn.api.Depth;
import org.jetbrains.idea.svn.api.Revision;
import org.jetbrains.idea.svn.api.Target;
import org.jetbrains.idea.svn.api.Url;
import org.jetbrains.idea.svn.dialogs.SetKeywordsDialog;
import org.jetbrains.idea.svn.dialogs.SetPropertyDialog;
import org.jetbrains.idea.svn.properties.PropertyConsumer;
import org.jetbrains.idea.svn.properties.PropertyData;
import org.jetbrains.idea.svn.properties.PropertyValue;

public class PropertiesComponent
extends JPanel {
    public static final String ID = "SVN Properties";
    private JTable myTable;
    private JTextArea myTextArea;
    private boolean myIsFollowSelection = true;
    private File myFile;
    private SvnVcs myVcs;
    private JSplitPane mySplitPane;
    private final CloseAction myCloseAction = new CloseAction();
    private final RefreshAction myRefreshAction = new RefreshAction();
    private ActionGroup myPopupActionGroup;

    public PropertiesComponent() {
        this.init();
    }

    public void init() {
        this.setLayout(new BorderLayout());
        this.myTable = new JBTable();
        this.myTextArea = new JTextArea(0, 0);
        this.myTextArea.setEditable(false);
        JScrollPane scrollPane = ScrollPaneFactory.createScrollPane((Component)this.myTable);
        this.mySplitPane = new JSplitPane(0, true, scrollPane, ScrollPaneFactory.createScrollPane((Component)this.myTextArea));
        this.add((Component)this.mySplitPane, "Center");
        this.add((Component)this.createToolbar(), "West");
        DefaultTableModel model = new DefaultTableModel(PropertiesComponent.createTableModel(new HashMap<String, String>()), new Object[]{"Name", "Value"}){

            @Override
            public boolean isCellEditable(int row, int column) {
                return false;
            }
        };
        this.myTable.setModel(model);
        this.myTable.setShowVerticalLines(true);
        this.myTable.setSelectionMode(0);
        this.myTable.getSelectionModel().addListSelectionListener(e -> {
            int index = this.myTable.getSelectedRow();
            if (index >= 0) {
                Object value = this.myTable.getValueAt(index, 1);
                if (value instanceof String) {
                    this.myTextArea.setText((String)value);
                } else {
                    this.myTextArea.setText("");
                }
            } else {
                this.myTextArea.setText("");
            }
        });
        this.myPopupActionGroup = this.createPopup();
        PopupHandler.installPopupHandler((JComponent)this.myTable, (ActionGroup)this.myPopupActionGroup, (String)"unknown", (ActionManager)ActionManager.getInstance());
        PopupHandler.installPopupHandler((JComponent)scrollPane, (ActionGroup)this.myPopupActionGroup, (String)"unknown", (ActionManager)ActionManager.getInstance());
        this.myCloseAction.registerCustomShortcutSet(KeymapUtil.getActiveKeymapShortcuts((String)"CloseActiveTab"), this);
        this.myRefreshAction.registerCustomShortcutSet(CommonShortcuts.getRerun(), this);
    }

    public void setFile(SvnVcs vcs, File file) {
        boolean firstTime;
        TreeMap<String, String> props = new TreeMap<String, String>();
        boolean bl = firstTime = this.myFile == null;
        if (file != null) {
            this.myFile = file;
            this.myVcs = vcs;
            PropertiesComponent.collectProperties(vcs, file, props);
        }
        DefaultTableModel model = (DefaultTableModel)this.myTable.getModel();
        model.setDataVector(PropertiesComponent.createTableModel(props), new Object[]{"Name", "Value"});
        this.myTable.getColumnModel().setColumnSelectionAllowed(false);
        this.myTable.getColumnModel().getColumn(1).setCellRenderer(new DefaultTableCellRenderer(){

            @Override
            protected void setValue(Object value) {
                if (value != null) {
                    if (value.toString().indexOf(13) >= 0) {
                        value = value.toString().substring(0, value.toString().indexOf(13)) + " [...]";
                    }
                    if (value.toString().indexOf(10) >= 0) {
                        value = value.toString().substring(0, value.toString().indexOf(10)) + " [...]";
                    }
                }
                super.setValue(value);
            }
        });
        if (firstTime) {
            this.mySplitPane.setDividerLocation(0.5);
        }
        if (this.myTable.getRowCount() > 0) {
            this.myTable.getSelectionModel().setSelectionInterval(0, 0);
        }
    }

    private static void collectProperties(@NotNull SvnVcs vcs, @NotNull File file, final @NotNull Map<String, String> props) {
        if (vcs == null) {
            PropertiesComponent.$$$reportNull$$$0(0);
        }
        if (file == null) {
            PropertiesComponent.$$$reportNull$$$0(1);
        }
        if (props == null) {
            PropertiesComponent.$$$reportNull$$$0(2);
        }
        try {
            PropertyConsumer handler = new PropertyConsumer(){

                @Override
                public void handleProperty(File path, PropertyData property) {
                    PropertyValue value = property.getValue();
                    if (value != null) {
                        props.put(property.getName(), PropertyValue.toString(property.getValue()));
                    }
                }

                @Override
                public void handleProperty(Url url, PropertyData property) {
                }

                @Override
                public void handleProperty(long revision, PropertyData property) {
                }
            };
            vcs.getFactory(file).createPropertyClient().list(Target.on(file, Revision.UNDEFINED), Revision.WORKING, Depth.EMPTY, handler);
        }
        catch (VcsException e) {
            props.clear();
        }
    }

    private static Object[][] createTableModel(Map<String, String> model) {
        Object[][] result = new Object[model.size()][2];
        int index = 0;
        for (String name : model.keySet()) {
            String value = model.get(name);
            if (value == null) {
                value = "";
            }
            result[index][0] = name;
            result[index][1] = value;
            ++index;
        }
        return result;
    }

    private JComponent createToolbar() {
        DefaultActionGroup group = new DefaultActionGroup();
        group.add((AnAction)new AddPropertyAction());
        group.add((AnAction)new EditPropertyAction());
        group.add((AnAction)new DeletePropertyAction());
        group.addSeparator();
        group.add((AnAction)new SetKeywordsAction());
        group.addSeparator();
        group.add((AnAction)new FollowSelectionAction());
        group.add((AnAction)this.myRefreshAction);
        group.add((AnAction)this.myCloseAction);
        return ActionManager.getInstance().createActionToolbar("SvnProperties", (ActionGroup)group, false).getComponent();
    }

    private DefaultActionGroup createPopup() {
        DefaultActionGroup group = new DefaultActionGroup();
        group.add((AnAction)new AddPropertyAction());
        group.add((AnAction)new EditPropertyAction());
        group.add((AnAction)new DeletePropertyAction());
        group.addSeparator();
        group.add((AnAction)new SetKeywordsAction());
        group.addSeparator();
        group.add((AnAction)this.myRefreshAction);
        return group;
    }

    private String getSelectedPropertyName() {
        int row = this.myTable.getSelectedRow();
        if (row < 0) {
            return null;
        }
        return (String)this.myTable.getValueAt(row, 0);
    }

    private void updateFileStatus(boolean recursive) {
        if (this.myFile != null && this.myVcs != null) {
            String url = "file://" + this.myFile.getPath().replace(File.separatorChar, '/');
            VirtualFile file = VirtualFileManager.getInstance().findFileByUrl(url);
            if (file != null) {
                VcsDirtyScopeManager dirtyScopeManager = VcsDirtyScopeManager.getInstance((Project)this.myVcs.getProject());
                if (recursive && file.isDirectory()) {
                    dirtyScopeManager.dirDirtyRecursively(file);
                } else {
                    dirtyScopeManager.fileDirty(file);
                }
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "vcs";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "file";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "props";
                break;
            }
        }
        objectArray[1] = "org/jetbrains/idea/svn/dialogs/PropertiesComponent";
        objectArray[2] = "collectProperties";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private class FollowSelectionAction
    extends DumbAwareToggleAction {
        private FollowSelectionAction() {
        }

        public boolean isSelected(@NotNull AnActionEvent e) {
            if (e == null) {
                FollowSelectionAction.$$$reportNull$$$0(0);
            }
            return PropertiesComponent.this.myIsFollowSelection;
        }

        public void setSelected(@NotNull AnActionEvent e, boolean state) {
            if (e == null) {
                FollowSelectionAction.$$$reportNull$$$0(1);
            }
            if (state && !PropertiesComponent.this.myIsFollowSelection) {
                this.updateSelection(e);
            }
            PropertiesComponent.this.myIsFollowSelection = state;
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                FollowSelectionAction.$$$reportNull$$$0(2);
            }
            super.update(e);
            e.getPresentation().setIcon(AllIcons.General.AutoscrollFromSource);
            e.getPresentation().setText("Follow Selection");
            e.getPresentation().setDescription("Follow Selection");
            if (PropertiesComponent.this.myIsFollowSelection) {
                this.updateSelection(e);
            }
        }

        private void updateSelection(AnActionEvent e) {
            File f;
            if (PropertiesComponent.this.myVcs == null) {
                return;
            }
            VirtualFile vf = (VirtualFile)e.getData(CommonDataKeys.VIRTUAL_FILE);
            if (vf != null && !(f = VfsUtilCore.virtualToIoFile((VirtualFile)vf)).equals(PropertiesComponent.this.myFile)) {
                PropertiesComponent.this.setFile(PropertiesComponent.this.myVcs, f);
                Project p = e.getProject();
                ToolWindowManager.getInstance((Project)p).getToolWindow(PropertiesComponent.ID).setTitle(f.getName());
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "e";
            objectArray2[1] = "org/jetbrains/idea/svn/dialogs/PropertiesComponent$FollowSelectionAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isSelected";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "setSelected";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class EditPropertyAction
    extends BasePropertyAction {
        private EditPropertyAction() {
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                EditPropertyAction.$$$reportNull$$$0(0);
            }
            e.getPresentation().setText("Edit Property");
            e.getPresentation().setDescription("Edit selected property value");
            e.getPresentation().setIcon(AllIcons.Actions.EditSource);
            e.getPresentation().setEnabled(PropertiesComponent.this.myFile != null && PropertiesComponent.this.getSelectedPropertyName() != null);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                EditPropertyAction.$$$reportNull$$$0(1);
            }
            Project project = e.getProject();
            SetPropertyDialog dialog = new SetPropertyDialog(project, new File[]{PropertiesComponent.this.myFile}, PropertiesComponent.this.getSelectedPropertyName(), PropertiesComponent.this.myFile.isDirectory());
            boolean recursive = false;
            if (dialog.showAndGet()) {
                recursive = dialog.isRecursive();
                this.setProperty(dialog.getPropertyName(), dialog.getPropertyValue(), recursive, false);
            }
            this.updateFileView(recursive);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "e";
            objectArray2[1] = "org/jetbrains/idea/svn/dialogs/PropertiesComponent$EditPropertyAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class AddPropertyAction
    extends BasePropertyAction {
        private AddPropertyAction() {
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                AddPropertyAction.$$$reportNull$$$0(0);
            }
            e.getPresentation().setText("Add Property");
            e.getPresentation().setDescription("Add new property");
            e.getPresentation().setIcon(IconUtil.getAddIcon());
            e.getPresentation().setEnabled(PropertiesComponent.this.myFile != null);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                AddPropertyAction.$$$reportNull$$$0(1);
            }
            Project project = e.getProject();
            SetPropertyDialog dialog = new SetPropertyDialog(project, new File[]{PropertiesComponent.this.myFile}, null, PropertiesComponent.this.myFile.isDirectory());
            boolean recursive = false;
            if (dialog.showAndGet()) {
                recursive = dialog.isRecursive();
                this.setProperty(dialog.getPropertyName(), dialog.getPropertyValue(), recursive, false);
            }
            this.updateFileView(recursive);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "e";
            objectArray2[1] = "org/jetbrains/idea/svn/dialogs/PropertiesComponent$AddPropertyAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class DeletePropertyAction
    extends BasePropertyAction {
        private DeletePropertyAction() {
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                DeletePropertyAction.$$$reportNull$$$0(0);
            }
            e.getPresentation().setText("Delete Property");
            e.getPresentation().setDescription("Delete selected property");
            e.getPresentation().setIcon(AllIcons.General.Remove);
            e.getPresentation().setEnabled(PropertiesComponent.this.myFile != null && PropertiesComponent.this.getSelectedPropertyName() != null);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                DeletePropertyAction.$$$reportNull$$$0(1);
            }
            this.setProperty(PropertiesComponent.this.getSelectedPropertyName(), null, false, true);
            this.updateFileView(false);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "e";
            objectArray2[1] = "org/jetbrains/idea/svn/dialogs/PropertiesComponent$DeletePropertyAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class SetKeywordsAction
    extends BasePropertyAction {
        private SetKeywordsAction() {
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                SetKeywordsAction.$$$reportNull$$$0(0);
            }
            e.getPresentation().setText("Edit Keywords");
            e.getPresentation().setDescription("Manage svn:keywords property");
            e.getPresentation().setIcon(AllIcons.Actions.Properties);
            e.getPresentation().setEnabled(PropertiesComponent.this.myFile != null && PropertiesComponent.this.myFile.isFile());
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                SetKeywordsAction.$$$reportNull$$$0(1);
            }
            Project project = e.getProject();
            PropertyValue propValue = null;
            try {
                propValue = PropertiesComponent.this.myVcs.getFactory(PropertiesComponent.this.myFile).createPropertyClient().getProperty(Target.on(PropertiesComponent.this.myFile), "svn:keywords", false, Revision.WORKING);
            }
            catch (VcsException vcsException) {
                // empty catch block
            }
            SetKeywordsDialog dialog = new SetKeywordsDialog(project, propValue);
            if (dialog.showAndGet()) {
                this.setProperty("svn:keywords", dialog.getKeywords(), false, false);
            }
            this.updateFileView(false);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "e";
            objectArray2[1] = "org/jetbrains/idea/svn/dialogs/PropertiesComponent$SetKeywordsAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private abstract class BasePropertyAction
    extends DumbAwareAction {
        private BasePropertyAction() {
        }

        protected void setProperty(@Nullable String property, @Nullable String value, boolean recursive, boolean force) {
            if (!StringUtil.isEmpty((String)property)) {
                try {
                    PropertiesComponent.this.myVcs.getFactory(PropertiesComponent.this.myFile).createPropertyClient().setProperty(PropertiesComponent.this.myFile, property, PropertyValue.create(value), Depth.allOrEmpty(recursive), force);
                }
                catch (VcsException error) {
                    VcsBalloonProblemNotifier.showOverChangesView((Project)PropertiesComponent.this.myVcs.getProject(), (String)("Can not set property: " + error.getMessage()), (MessageType)MessageType.ERROR, (NamedRunnable[])new NamedRunnable[0]);
                }
            }
        }

        protected void updateFileView(boolean recursive) {
            PropertiesComponent.this.setFile(PropertiesComponent.this.myVcs, PropertiesComponent.this.myFile);
            PropertiesComponent.this.updateFileStatus(recursive);
        }
    }

    private class RefreshAction
    extends DumbAwareAction {
        private RefreshAction() {
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                RefreshAction.$$$reportNull$$$0(0);
            }
            e.getPresentation().setText("Refresh");
            e.getPresentation().setDescription("Reload properties");
            e.getPresentation().setIcon(AllIcons.Actions.Refresh);
            e.getPresentation().setEnabled(PropertiesComponent.this.myFile != null);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                RefreshAction.$$$reportNull$$$0(1);
            }
            PropertiesComponent.this.setFile(PropertiesComponent.this.myVcs, PropertiesComponent.this.myFile);
            PropertiesComponent.this.updateFileStatus(false);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "e";
            objectArray2[1] = "org/jetbrains/idea/svn/dialogs/PropertiesComponent$RefreshAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class CloseAction
    extends DumbAwareAction {
        private CloseAction() {
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                CloseAction.$$$reportNull$$$0(0);
            }
            e.getPresentation().setText("Close");
            e.getPresentation().setDescription("Close this tool window");
            e.getPresentation().setIcon(AllIcons.Actions.Cancel);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                CloseAction.$$$reportNull$$$0(1);
            }
            Project p = (Project)e.getData(CommonDataKeys.PROJECT);
            ToolWindowManager.getInstance((Project)p).unregisterToolWindow(PropertiesComponent.ID);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "e";
            objectArray2[1] = "org/jetbrains/idea/svn/dialogs/PropertiesComponent$CloseAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

