/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing.impl;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.SystemProperties;
import com.intellij.util.indexing.IndexId;

public class DebugAssertions {
    private static final Logger LOG = Logger.getInstance(DebugAssertions.class);
    public static final ThreadLocal<IndexId<?, ?>> DEBUG_INDEX_ID = new ThreadLocal();
    public static volatile boolean DEBUG = SystemProperties.getBooleanProperty("intellij.idea.indices.debug", false);
    public static final boolean EXTRA_SANITY_CHECKS = SystemProperties.getBooleanProperty("intellij.idea.indices.debug.extra.sanity", false);

    public static void assertTrue(boolean value) {
        if (!value) {
            LOG.assertTrue(false);
        }
    }

    public static void assertTrue(boolean value, String message, Object ... args) {
        if (!value) {
            DebugAssertions.error(message, args);
        }
    }

    public static void error(String message, Object ... args) {
        LOG.error(String.format(message, args));
    }
}

