/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.containers;

import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.jetbrains.annotations.NotNull;

class SequenceIterator<T>
implements Iterator<T> {
    private final Iterator<T>[] myIterators;
    private int myCurrentIndex;

    @SafeVarargs
    SequenceIterator(Iterator<? extends T> ... iterators) {
        if (iterators == null) {
            SequenceIterator.$$$reportNull$$$0(0);
        }
        this.myIterators = new Iterator[iterators.length];
        System.arraycopy(iterators, 0, this.myIterators, 0, iterators.length);
    }

    SequenceIterator(@NotNull Collection<? extends Iterator<? extends T>> iterators) {
        if (iterators == null) {
            SequenceIterator.$$$reportNull$$$0(1);
        }
        this(iterators.toArray(new Iterator[0]));
    }

    @Override
    public boolean hasNext() {
        for (int index = this.myCurrentIndex; index < this.myIterators.length; ++index) {
            Iterator<T> iterator = this.myIterators[index];
            if (iterator == null || !iterator.hasNext()) continue;
            this.myCurrentIndex = index;
            return true;
        }
        return false;
    }

    @Override
    public T next() {
        if (this.hasNext()) {
            return this.myIterators[this.myCurrentIndex].next();
        }
        throw new NoSuchElementException("Iterator has no more elements");
    }

    @Override
    public void remove() {
        if (this.myCurrentIndex >= this.myIterators.length) {
            throw new IllegalStateException();
        }
        this.myIterators[this.myCurrentIndex].remove();
    }

    @NotNull
    public static <T> SequenceIterator<T> create(@NotNull Iterator<T> first, @NotNull Iterator<T> second) {
        if (first == null) {
            SequenceIterator.$$$reportNull$$$0(2);
        }
        if (second == null) {
            SequenceIterator.$$$reportNull$$$0(3);
        }
        return new SequenceIterator<T>(first, second);
    }

    @NotNull
    public static <T> SequenceIterator<T> create(@NotNull Iterator<T> first, @NotNull Iterator<T> second, @NotNull Iterator<T> third) {
        if (first == null) {
            SequenceIterator.$$$reportNull$$$0(4);
        }
        if (second == null) {
            SequenceIterator.$$$reportNull$$$0(5);
        }
        if (third == null) {
            SequenceIterator.$$$reportNull$$$0(6);
        }
        return new SequenceIterator<T>(first, second, third);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "iterators";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "first";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "second";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "third";
                break;
            }
        }
        objectArray2[1] = "com/intellij/util/containers/SequenceIterator";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "create";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

