/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.util;

import com.intellij.ide.DataManager;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.NonPhysicalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiEditorUtil;
import com.intellij.psi.util.PsiEditorUtilBaseKt;
import com.intellij.psi.util.PsiUtilCore;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeoutException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.Promise;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u0007"}, d2={"Lcom/intellij/psi/util/PsiEditorUtilBase;", "Lcom/intellij/psi/util/PsiEditorUtil;", "()V", "findEditorByPsiElement", "Lcom/intellij/openapi/editor/Editor;", "element", "Lcom/intellij/psi/PsiElement;", "intellij.platform.lang"})
public final class PsiEditorUtilBase
implements PsiEditorUtil {
    public static final PsiEditorUtilBase INSTANCE;

    @Override
    @Nullable
    public Editor findEditorByPsiElement(@NotNull PsiElement element) {
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
        PsiFile psiFile = element.getContainingFile();
        VirtualFile virtualFile2 = PsiUtilCore.getVirtualFile(element);
        if (virtualFile2 == null) {
            return null;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile2, (String)"PsiUtilCore.getVirtualFile(element) ?: return null");
        VirtualFile virtualFile3 = virtualFile2;
        PsiFile psiFile2 = psiFile;
        Intrinsics.checkExpressionValueIsNotNull((Object)psiFile2, (String)"psiFile");
        Project project = psiFile2.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"psiFile.project");
        Project project2 = project;
        if (virtualFile3.isInLocalFileSystem() || virtualFile3.getFileSystem() instanceof NonPhysicalFileSystem) {
            FileEditor[] editors;
            FileEditor[] fileEditorManager;
            FileEditor[] fileEditorArray = fileEditorManager = FileEditorManager.getInstance(project2);
            if (fileEditorManager == null || (fileEditorArray = fileEditorArray.getEditors(virtualFile3)) == null) {
                fileEditorArray = new FileEditor[]{};
            }
            for (FileEditor fileEditor : editors = fileEditorArray) {
                if (!(fileEditor instanceof TextEditor)) continue;
                return ((TextEditor)fileEditor).getEditor();
            }
        }
        DataManager dataManager = DataManager.getInstance();
        Intrinsics.checkExpressionValueIsNotNull((Object)dataManager, (String)"DataManager.getInstance()");
        Promise<DataContext> promise2 = dataManager.getDataContextFromFocusAsync();
        Intrinsics.checkExpressionValueIsNotNull(promise2, (String)"DataManager.getInstance(\u2026dataContextFromFocusAsync");
        Promise<DataContext> asyncResult = promise2;
        if (asyncResult.isSucceeded()) {
            Document document;
            Editor editor = null;
            try {
                DataContext dataContext = asyncResult.blockingGet(-1);
                DataKey<Editor> dataKey = CommonDataKeys.EDITOR;
                int n = 0;
                boolean bl = false;
                bl = false;
                int n2 = 0;
                if (dataContext == null) {
                    boolean bl2 = false;
                    String string = "Required value was null.";
                    throw (Throwable)new IllegalArgumentException(string.toString());
                }
                DataContext dataContext2 = dataContext;
                editor = dataKey.getData(dataContext2);
            }
            catch (TimeoutException timeoutException) {
                PsiEditorUtilBaseKt.access$getLOG$p().error((Throwable)timeoutException);
            }
            catch (ExecutionException executionException) {
                PsiEditorUtilBaseKt.access$getLOG$p().error((Throwable)executionException);
            }
            if (editor != null && (document = PsiDocumentManager.getInstance(project2).getCachedDocument(psiFile)) == editor.getDocument()) {
                return editor;
            }
        }
        return null;
    }

    private PsiEditorUtilBase() {
    }

    static {
        PsiEditorUtilBase psiEditorUtilBase;
        INSTANCE = psiEditorUtilBase = new PsiEditorUtilBase();
    }
}

