/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.options;

import com.intellij.ide.ui.UINumericRange;
import com.intellij.openapi.extensions.BaseExtensionPointName;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.options.ConfigurableEP;
import com.intellij.openapi.options.UnnamedConfigurable;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import java.awt.Component;
import java.util.Collection;
import javax.swing.JComponent;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface Configurable
extends UnnamedConfigurable {
    public static final ExtensionPointName<ConfigurableEP<Configurable>> APPLICATION_CONFIGURABLE = new ExtensionPointName("com.intellij.applicationConfigurable");
    public static final ExtensionPointName<ConfigurableEP<Configurable>> PROJECT_CONFIGURABLE = new ExtensionPointName("com.intellij.projectConfigurable");

    @Nls(capitalization=Nls.Capitalization.Title)
    @Contract(pure=true)
    public String getDisplayName();

    @Nullable
    @NonNls
    @Contract(pure=true)
    default public String getHelpTopic() {
        return null;
    }

    default public boolean isModified(@NotNull JTextField textField, @NotNull String value) {
        if (textField == null) {
            Configurable.$$$reportNull$$$0(0);
        }
        if (value == null) {
            Configurable.$$$reportNull$$$0(1);
        }
        return !StringUtil.equals((CharSequence)textField.getText().trim(), (CharSequence)value);
    }

    default public boolean isModified(@NotNull JTextField textField, int value, @NotNull UINumericRange range) {
        if (textField == null) {
            Configurable.$$$reportNull$$$0(2);
        }
        if (range == null) {
            Configurable.$$$reportNull$$$0(3);
        }
        try {
            int currentValue = Integer.parseInt(textField.getText().trim());
            return range.fit(currentValue) == currentValue && currentValue != value;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    default public boolean isModified(@NotNull JToggleButton toggleButton, boolean value) {
        if (toggleButton == null) {
            Configurable.$$$reportNull$$$0(4);
        }
        return toggleButton.isSelected() != value;
    }

    default public <T> boolean isModified(@NotNull ComboBox<T> comboBox, T value) {
        if (comboBox == null) {
            Configurable.$$$reportNull$$$0(5);
        }
        return !Comparing.equal((Object)comboBox.getSelectedItem(), value);
    }

    default public JComponent getPreferredFocusedComponent() {
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "textField";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "value";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[0] = "range";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[0] = "toggleButton";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[0] = "comboBox";
                break;
            }
        }
        objectArray[1] = "com/intellij/openapi/options/Configurable";
        objectArray[2] = "isModified";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static interface TopComponentProvider {
        default public boolean isAvailable() {
            return true;
        }

        @NotNull
        public Component getCenterComponent(@NotNull TopComponentController var1);
    }

    public static interface TopComponentController {
        public void setLeftComponent(@Nullable Component var1);

        public void showProgress(boolean var1);
    }

    public static interface WithEpDependencies {
        @NotNull
        public Collection<BaseExtensionPointName<?>> getDependencies();
    }

    public static interface VariableProjectAppLevel {
        public boolean isProjectLevel();
    }

    public static interface NoMargin {
    }

    public static interface NoScroll {
    }

    @FunctionalInterface
    public static interface Composite {
        public Configurable @NotNull [] getConfigurables();
    }
}

