/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.remote.run.target;

import com.intellij.docker.agent.DockerAgentDeploymentConfig;
import com.intellij.docker.agent.DockerAgentSourceType;
import com.intellij.docker.agent.settings.DockerAgentContainerInspection;
import com.intellij.docker.agent.settings.DockerEnvVar;
import com.intellij.docker.agent.settings.DockerEnvVarImpl;
import com.intellij.docker.agent.settings.DockerPortBinding;
import com.intellij.docker.agent.settings.DockerVolumeBinding;
import com.intellij.docker.agent.settings.DockerVolumeBindingImpl;
import com.intellij.docker.remote.run.runtime.DockerExecProcess;
import com.intellij.docker.remote.run.runtime.RemoteDockerApplicationRuntime;
import com.intellij.docker.remote.run.runtime.RemoteDockerRuntime;
import com.intellij.docker.remote.run.target.DockerEnvironmentFactory;
import com.intellij.docker.remote.run.target.DockerRemoteRequest;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.target.TargetEnvironment;
import com.intellij.execution.target.TargetEnvironmentRequest;
import com.intellij.execution.target.TargetPlatform;
import com.intellij.execution.target.TargetedCommandLine;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.remote.RemoteSdkException;
import com.intellij.remoteServer.util.ServerRuntimeException;
import com.intellij.util.ArrayUtil;
import com.intellij.util.execution.ParametersListUtil;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.UUID;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;

public class DockerEnvironment
implements TargetEnvironment {
    private final DockerEnvironmentFactory myRunner;
    private final RemoteDockerApplicationRuntime myImage;
    private final DockerRemoteRequest myRequest;

    DockerEnvironment(DockerEnvironmentFactory runner, RemoteDockerApplicationRuntime image, DockerRemoteRequest request) {
        this.myRunner = runner;
        this.myImage = image;
        this.myRequest = request;
    }

    public TargetEnvironmentRequest getRequest() {
        return this.myRequest;
    }

    @NotNull
    public TargetPlatform getRemotePlatform() {
        TargetPlatform targetPlatform = this.myRunner.getTargetPlatform();
        if (targetPlatform == null) {
            DockerEnvironment.$$$reportNull$$$0(0);
        }
        return targetPlatform;
    }

    @NotNull
    public Process createProcess(@NotNull TargetedCommandLine commandLine, @NotNull ProgressIndicator indicator) throws ExecutionException {
        DockerExecProcess dockerExecProcess;
        if (commandLine == null) {
            DockerEnvironment.$$$reportNull$$$0(1);
        }
        if (indicator == null) {
            DockerEnvironment.$$$reportNull$$$0(2);
        }
        try {
            Collection<DockerVolumeBinding> volumeBindings = DockerEnvironment.prepareVolumes(this.myRequest);
            final String[] resolvedCommand = ArrayUtil.toStringArray((Collection)commandLine.collectCommandsSynchronously());
            final DockerVolumeBinding[] uniqueBindings = volumeBindings.toArray(new DockerVolumeBinding[0]);
            String inputFilePath = commandLine.getInputFilePath();
            if (inputFilePath != null) {
                // empty if block
            }
            final Map environmentVariables = commandLine.getEnvironmentVariables();
            DockerAgentDeploymentConfig.Adapter deployConfig2 = new DockerAgentDeploymentConfig.Adapter(){

                public String[] getImageTags() {
                    return new String[]{DockerEnvironment.this.myImage.getAgentApplication().getImageId()};
                }

                public DockerPortBinding[] getPortBindings() {
                    return null;
                }

                public DockerEnvVar[] getEnvVars() {
                    return (DockerEnvVar[])environmentVariables.entrySet().stream().map(e -> new DockerEnvVarImpl((String)e.getKey(), (String)e.getValue())).toArray(DockerEnvVar[]::new);
                }

                public DockerVolumeBinding[] getVolumeBindings() {
                    return uniqueBindings;
                }

                public String[] getCommand() {
                    return resolvedCommand;
                }

                public String sourceType() {
                    return DockerAgentSourceType.IMAGE.name();
                }

                public String[] getCustomRunOptions() {
                    LinkedList<String> result = new LinkedList<String>(DockerEnvironment.this.myRequest.getPortsAsCliOptions());
                    result.add("--security-opt=seccomp:unconfined");
                    String runCliOptions = DockerEnvironment.this.myRequest.getTargetConfiguration().getValues().getContainerConfig().getRunCliOptions();
                    if (!StringUtil.isEmptyOrSpaces((String)runCliOptions)) {
                        result.addAll(ParametersListUtil.parse((String)runCliOptions));
                    }
                    return ArrayUtil.toStringArray(result);
                }

                public boolean isCreateContainerOnly() {
                    return true;
                }
            };
            RemoteDockerApplicationRuntime myContainer = RemoteDockerApplicationRuntime.createWithPullImage((RemoteDockerRuntime)this.myRunner.getDocker(), (DockerAgentDeploymentConfig)deployConfig2);
            myContainer.startAndAttach();
            Map<Integer, DockerPortBinding> actualPortMappings = DockerEnvironment.loadPortMappings(myContainer);
            this.myRequest.getRemotePortsToBind().forEach(portValue -> portValue.localPortBound((DockerPortBinding)actualPortMappings.get(portValue.getContainerPort())));
            dockerExecProcess = DockerExecProcess.Factory.newProcess(myContainer, false);
        }
        catch (RemoteSdkException | ServerRuntimeException | IOException e) {
            throw new ExecutionException("Can't run process: " + e.getMessage(), e);
        }
        if (dockerExecProcess == null) {
            DockerEnvironment.$$$reportNull$$$0(3);
        }
        return dockerExecProcess;
    }

    private static Map<Integer, DockerPortBinding> loadPortMappings(RemoteDockerApplicationRuntime container) throws ServerRuntimeException {
        DockerAgentContainerInspection inspection = container.inspect();
        return Stream.of(inspection.getPortBindings()).collect(Collectors.toMap(DockerPortBinding::getContainerPort, Function.identity(), (oldValue, newValue) -> newValue));
    }

    private static Collection<DockerVolumeBinding> prepareVolumes(DockerRemoteRequest request) {
        HashMap<File, DockerVolumeBinding> result = new HashMap<File, DockerVolumeBinding>();
        String mountRoot = "/tmp/" + UUID.randomUUID().toString() + "/";
        for (DockerRemoteRequest.MountedFileValue remoteValue : request.getFilesToTransfer()) {
            DockerVolumeBinding binding;
            File volumeRoot = remoteValue.getVolumeRoot();
            if (result.containsKey(volumeRoot)) {
                binding = (DockerVolumeBinding)result.get(volumeRoot);
            } else {
                String containerPath = mountRoot + result.size() + "/" + volumeRoot.getName();
                binding = new DockerVolumeBindingImpl(containerPath, volumeRoot.getPath(), false);
                result.put(volumeRoot, binding);
            }
            remoteValue.volumeAttached(binding);
        }
        return result.values();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/docker/remote/run/target/DockerEnvironment";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commandLine";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getRemotePlatform";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/docker/remote/run/target/DockerEnvironment";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createProcess";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createProcess";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

