/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.dialects.mongo.js;

import com.intellij.lang.PsiBuilder;
import com.intellij.lang.WhitespacesBinders;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Key;
import com.intellij.psi.tree.IElementType;
import com.intellij.sql.dialects.mongo.js.ES6Parser;
import com.intellij.sql.dialects.mongo.js.ExpressionParser;
import com.intellij.sql.dialects.mongo.js.FunctionParser;
import com.intellij.sql.dialects.mongo.js.JSElementTypes;
import com.intellij.sql.dialects.mongo.js.JavaScriptParser;
import com.intellij.sql.dialects.mongo.js.JavaScriptParserBase;
import com.intellij.util.ArrayUtil;
import java.util.ArrayList;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StatementParser
extends JavaScriptParserBase {
    protected static final Logger LOG = Logger.getInstance(StatementParser.class);
    public static final Key<String> withinInterfaceKey = Key.create((String)"within.interface");
    public static final String[] SHOW_COMMANDS = new String[]{"collections", "users", "roles", "profile", "profile", "dbs"};

    protected StatementParser(JavaScriptParser parser) {
        super(parser);
    }

    public void parseSourceElement() {
        IElementType tokenType = this.builder.getTokenType();
        boolean acceptES6ExportImports = this.isAcceptES6ExportImports();
        FunctionParser functionParser = this.myJavaScriptParser.getFunctionParser();
        if (functionParser.isFunctionDeclarationStart()) {
            functionParser.parseFunctionDeclaration();
        } else if (acceptES6ExportImports && tokenType == JSElementTypes.IMPORT_KEYWORD && this.builder.lookAhead(1) != JSElementTypes.LPAR && this.builder.lookAhead(1) != JSElementTypes.DOT) {
            this.parseES6ImportStatement();
        } else if (!acceptES6ExportImports || tokenType != JSElementTypes.EXPORT_KEYWORD || !this.tryParseES6ExportStatement()) {
            this.doParseStatement(true);
        }
    }

    protected boolean isAcceptES6ExportImports() {
        return true;
    }

    private void parsePackageBodyStatement() {
        this.doParseStatement(true);
    }

    public void parseStatement() {
        this.doParseStatement(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    protected void doParseStatement(boolean canHaveClasses) {
        firstToken = this.builder.getTokenType();
        if (firstToken == null) {
            this.builder.error("statement expected");
            return;
        }
        if (firstToken == JSElementTypes.LBRACE) {
            this.parseBlock();
            return;
        }
        if (firstToken == JSElementTypes.SEMICOLON) {
            this.parseEmptyStatement();
            return;
        }
        if (firstToken == JSElementTypes.IF_KEYWORD) {
            this.parseIfStatement();
            return;
        }
        if (firstToken == JSElementTypes.DO_KEYWORD || firstToken == JSElementTypes.WHILE_KEYWORD || firstToken == JSElementTypes.FOR_KEYWORD) {
            this.parseIterationStatement();
            return;
        }
        if (firstToken == JSElementTypes.CONTINUE_KEYWORD) {
            this.parseContinueStatement();
            return;
        }
        if (firstToken == JSElementTypes.BREAK_KEYWORD) {
            this.parseBreakStatement();
            return;
        }
        if (firstToken == JSElementTypes.RETURN_KEYWORD) {
            this.parseReturnStatement();
            return;
        }
        if (firstToken == JSElementTypes.WITH_KEYWORD) {
            this.parseWithStatement();
            return;
        }
        if (firstToken == JSElementTypes.YIELD_KEYWORD) {
            this.parseExpressionStatement();
            return;
        }
        if (firstToken == JSElementTypes.SWITCH_KEYWORD) {
            this.parseSwitchStatement();
            return;
        }
        if (firstToken == JSElementTypes.THROW_KEYWORD) {
            this.parseThrowStatement();
            return;
        }
        if (firstToken == JSElementTypes.TRY_KEYWORD) {
            this.parseTryStatement();
            return;
        }
        if (firstToken == JSElementTypes.INCLUDE_KEYWORD) {
            this.parseIncludeDirective();
            return;
        }
        if (firstToken == JSElementTypes.DEBUGGER_KEYWORD) {
            stmt = this.builder.mark();
            this.builder.advanceLexer();
            this.forceCheckForSemicolon();
            stmt.done(JSElementTypes.DEBUGGER_STATEMENT);
            return;
        }
        if (firstToken == JSElementTypes.IDENTIFIER) {
            if ("use".equals(this.builder.getTokenText()) && this.parseUseStatement()) {
                return;
            }
            if ("show".equals(this.builder.getTokenText()) && this.parseShowStatement()) {
                return;
            }
        }
        functionParser = this.myJavaScriptParser.getFunctionParser();
        if (JSElementTypes.IDENTIFIER == firstToken || this.isModifier(firstToken) || JSElementTypes.AT == firstToken && functionParser.hasSupportDecorators()) {
            marker = this.builder.mark();
            methodEmptiness = (String)this.builder.getUserData(FunctionParser.methodsEmptinessKey);
            if (!functionParser.parseAttributesList()) {
                marker.rollbackTo();
            } else {
                try {
                    if (this.builder.eof()) {
                        marker.drop();
                        return;
                    }
                    tokenType = this.builder.getTokenType();
                    if (tokenType == JSElementTypes.FUNCTION_KEYWORD) {
                        functionParser.parseFunctionNoMarker(FunctionParser.Context.SOURCE_ELEMENT, marker);
                        return;
                    }
                    if (this.isExportDefault()) {
                        this.parseES6ExportDefaultAssignmentNoMarker(marker);
                        return;
                    }
                    if (JSElementTypes.VAR_MODIFIERS.contains(tokenType)) {
                        this.parseVarStatementNoMarker(false, marker);
                        return;
                    }
                    if (this.parseDialectSpecificSourceElements()) {
                        return;
                    }
                    if (tokenType == JSElementTypes.CLASS_KEYWORD || tokenType == JSElementTypes.INTERFACE_KEYWORD) {
                        this.parseClassOrInterfaceNoMarker(marker);
                        return;
                    }
                    if (tokenType == JSElementTypes.DECORATOR_KEYWORD && this.builder.lookAhead(1) == JSElementTypes.AT) {
                        this.parseES6DecoratorDeclaration(marker);
                        return;
                    }
                    if (tokenType == JSElementTypes.LBRACE) {
                        if (canHaveClasses) {
                            this.parseBlockOrFunctionBody(BlockType.PACKAGE_OR_CLASS_BODY);
                        } else {
                            while (this.builder.getTokenType() != JSElementTypes.RBRACE) {
                                if (this.builder.eof()) {
                                    this.builder.error("missing }");
                                    marker.done(JSElementTypes.CONDITIONAL_COMPILE_BLOCK_STATEMENT);
                                    return;
                                }
                                this.parseStatement();
                            }
                        }
                        marker.done(JSElementTypes.CONDITIONAL_COMPILE_BLOCK_STATEMENT);
                        return;
                    }
                    this.builder.putUserData(FunctionParser.methodsEmptinessKey, null);
                    if (firstToken == JSElementTypes.IDENTIFIER) {
                        marker.rollbackTo();
                    }
                    if (JSElementTypes.COLON_COLON == this.builder.getTokenType()) {
                        marker.rollbackTo();
                        if (!this.parseExpressionStatement()) ** GOTO lbl129
                        return;
                    }
                    this.builder.error("declaration expected");
                    marker.drop();
                }
                finally {
                    this.builder.putUserData(FunctionParser.methodsEmptinessKey, (Object)methodEmptiness);
                }
            }
        } else {
            if (firstToken == JSElementTypes.CLASS_KEYWORD || firstToken == JSElementTypes.INTERFACE_KEYWORD) {
                marker = this.startAttributeListOwner();
                this.parseClassOrInterfaceNoMarker(marker);
                return;
            }
            if (firstToken == JSElementTypes.DECORATOR_KEYWORD && this.builder.lookAhead(1) == JSElementTypes.AT) {
                marker = this.startAttributeListOwner();
                this.parseES6DecoratorDeclaration(marker);
                return;
            }
            if (firstToken == JSElementTypes.LET_KEYWORD && this.builder.lookAhead(1) == JSElementTypes.LPAR) {
                this.parseLetBlock();
                return;
            }
            if (JSElementTypes.VAR_MODIFIERS.contains(firstToken)) {
                marker = this.startAttributeListOwner();
                this.parseVarStatementNoMarker(false, marker);
                return;
            }
        }
lbl129:
        // 6 sources

        if (functionParser.isFunctionDeclarationStart()) {
            functionParser.parseFunctionDeclaration();
            return;
        }
        if (this.isIdentifierToken(firstToken)) {
            labeledStatement = this.builder.mark();
            this.builder.advanceLexer();
            if (this.builder.getTokenType() == JSElementTypes.COLON) {
                this.builder.advanceLexer();
                this.parseStatement();
                labeledStatement.done(JSElementTypes.LABELED_STATEMENT);
                return;
            }
            labeledStatement.rollbackTo();
        }
        if (firstToken != JSElementTypes.LBRACE && firstToken != JSElementTypes.FUNCTION_KEYWORD && this.parseExpressionStatement()) {
            return;
        }
        this.builder.error("statement expected");
        this.builder.advanceLexer();
    }

    private boolean parseUseStatement() {
        if (this.rawLookup(JSElementTypes.WHITE_SPACE) != JSElementTypes.IDENTIFIER) {
            return false;
        }
        PsiBuilder.Marker stmt = this.builder.mark();
        this.builder.advanceLexer();
        while (this.builder.getTokenType() != JSElementTypes.IDENTIFIER) {
            this.builder.advanceLexer();
        }
        if (!this.builder.eof()) {
            PsiBuilder.Marker idMarker = this.builder.mark();
            this.builder.advanceLexer();
            idMarker.done(JSElementTypes.REFERENCE_EXPRESSION);
        }
        stmt.done(JSElementTypes.USE_STATEMENT);
        return true;
    }

    private boolean parseShowStatement() {
        if (this.rawLookup(JSElementTypes.WHITE_SPACE) != JSElementTypes.IDENTIFIER) {
            return false;
        }
        PsiBuilder.Marker stmt = this.builder.mark();
        this.builder.advanceLexer();
        while (this.builder.getTokenType() != JSElementTypes.IDENTIFIER) {
            this.builder.advanceLexer();
        }
        String text = this.builder.getTokenText();
        if (!ArrayUtil.contains((String)text, (String[])SHOW_COMMANDS)) {
            this.builder.error("One of: " + Arrays.toString(SHOW_COMMANDS) + " expected. But found " + text);
        }
        this.builder.advanceLexer();
        stmt.done(JSElementTypes.SHOW_STATEMENT);
        return true;
    }

    @Nullable
    private IElementType rawLookup(IElementType ... toSkip) {
        int i2 = 1;
        IElementType type = this.builder.rawLookup(i2);
        while (type != null) {
            if (!ArrayUtil.contains((Object)type, (Object[])toSkip)) {
                return type;
            }
            type = this.builder.rawLookup(++i2);
        }
        return null;
    }

    protected boolean isModifier(IElementType token) {
        return JSElementTypes.MODIFIERS.contains(token);
    }

    public boolean isExportDefault() {
        return this.builder.getTokenType() == JSElementTypes.EXPORT_KEYWORD && this.builder.lookAhead(1) == JSElementTypes.DEFAULT_KEYWORD;
    }

    protected boolean parseDialectSpecificSourceElements() {
        return false;
    }

    public void parseClassNoMarker(PsiBuilder.Marker block, boolean mayOmitName, boolean isExpression) {
        LOG.assertTrue(JSElementTypes.CLASS_KEYWORD == this.builder.getTokenType());
        this.builder.advanceLexer();
        IElementType classStartToken = this.builder.getTokenType();
        if (this.isPossibleClassName(classStartToken)) {
            this.myJavaScriptParser.buildTokenElement(JSElementTypes.REFERENCE_EXPRESSION);
        } else if (!mayOmitName) {
            this.builder.error("name expected");
            if (!this.canProceedClassParsing(classStartToken)) {
                block.drop();
                return;
            }
        }
        this.parseReferencesList();
        if (this.builder.getTokenType() != JSElementTypes.LBRACE) {
            this.builder.error("{ expected");
        } else {
            this.builder.advanceLexer();
            while (this.builder.getTokenType() != JSElementTypes.RBRACE) {
                if (this.builder.eof()) {
                    this.builder.error("missing }");
                    break;
                }
                this.parseClassMember();
            }
            this.builder.advanceLexer();
        }
        block.done(isExpression ? this.getClassExpressionElementType() : this.getClassElementType());
        block.setCustomEdgeTokenBinders(INCLUDE_DOC_COMMENT_AT_LEFT, WhitespacesBinders.DEFAULT_RIGHT_BINDER);
    }

    public boolean canProceedClassParsing(IElementType elementType) {
        return elementType == JSElementTypes.EXTENDS_KEYWORD || elementType == JSElementTypes.LBRACE;
    }

    protected boolean isPossibleClassName(IElementType firstElement) {
        return this.isIdentifierToken(firstElement);
    }

    protected void parseReferencesList() {
        if (this.builder.getTokenType() == JSElementTypes.EXTENDS_KEYWORD) {
            this.parseReferenceList(this.getClassExtendListElementType());
        }
        if (this.builder.getTokenType() == JSElementTypes.IMPLEMENTS_KEYWORD) {
            this.parseReferenceList(JSElementTypes.IMPLEMENTS_LIST);
        }
    }

    protected IElementType getClassElementType() {
        return JSElementTypes.CLASS;
    }

    protected IElementType getClassExpressionElementType() {
        return JSElementTypes.CLASS_EXPRESSION;
    }

    protected IElementType getClassExtendListElementType() {
        return JSElementTypes.ES6_EXTENDS_LIST;
    }

    protected void parseClassMember() {
        ES6Parser es6Parser = new ES6Parser(this.builder);
        es6Parser.getStatementParser().parseClassMember();
    }

    protected PsiBuilder.Marker startAttributeListOwner() {
        PsiBuilder.Marker marker = this.builder.mark();
        PsiBuilder.Marker modifierListMarker = this.builder.mark();
        modifierListMarker.done(this.myJavaScriptParser.getFunctionParser().getAttributeListElementType());
        return marker;
    }

    protected boolean parseExpressionStatement() {
        PsiBuilder.Marker exprStatement = this.builder.mark();
        if (this.myJavaScriptParser.getExpressionParser().parseExpressionOptional()) {
            this.forceCheckForSemicolon();
            exprStatement.done(JSElementTypes.EXPRESSION_STATEMENT);
            exprStatement.setCustomEdgeTokenBinders(INCLUDE_DOC_COMMENT_AT_LEFT_NO_EXTRA_LINEBREAK, WhitespacesBinders.DEFAULT_RIGHT_BINDER);
            return true;
        }
        exprStatement.drop();
        return false;
    }

    private void parseLetBlock() {
        LOG.assertTrue(this.builder.getTokenType() == JSElementTypes.LET_KEYWORD);
        PsiBuilder.Marker marker = this.builder.mark();
        this.builder.advanceLexer();
        LOG.assertTrue(this.builder.getTokenType() == JSElementTypes.LPAR);
        this.parseLetDeclarations();
        this.parseBlock();
        marker.done(JSElementTypes.LET_STATEMENT);
    }

    boolean parseLetDeclarations() {
        if (this.builder.getTokenType() != JSElementTypes.LPAR) {
            this.builder.error("( expected");
            return false;
        }
        this.builder.advanceLexer();
        boolean parsedSuccessfully = this.myJavaScriptParser.getExpressionParser().parseAssignmentExpression(true);
        if (parsedSuccessfully) {
            while (this.builder.getTokenType() == JSElementTypes.COMMA) {
                this.builder.advanceLexer();
                parsedSuccessfully = this.myJavaScriptParser.getExpressionParser().parseAssignmentExpression(true);
                if (parsedSuccessfully) continue;
            }
        }
        return StatementParser.checkMatches(this.builder, JSElementTypes.RPAR, ") expected") && parsedSuccessfully;
    }

    public void parseIncludeDirective() {
        LOG.assertTrue(this.builder.getTokenType() == JSElementTypes.INCLUDE_KEYWORD);
        PsiBuilder.Marker useNSStatement = this.builder.mark();
        this.builder.advanceLexer();
        StatementParser.checkMatches(this.builder, JSElementTypes.STRING_LITERAL, "string literal expected");
        this.checkForSemicolon();
        useNSStatement.done((IElementType)JSElementTypes.INCLUDE_DIRECTIVE);
    }

    protected void parseClassOrInterfaceNoMarker(@NotNull PsiBuilder.Marker clazz) {
        if (clazz == null) {
            StatementParser.$$$reportNull$$$0(0);
        }
        if (this.builder.getTokenType() == JSElementTypes.CLASS_KEYWORD) {
            this.parseClassNoMarker(clazz, false, false);
        } else {
            assert (this.builder.getTokenType() == JSElementTypes.INTERFACE_KEYWORD);
            this.parseInterfaceNoMarker(clazz);
        }
    }

    protected void parseES6DecoratorDeclaration(@NotNull PsiBuilder.Marker decoratorMark) {
        if (decoratorMark == null) {
            StatementParser.$$$reportNull$$$0(1);
        }
        decoratorMark.drop();
        this.builder.error("statement expected");
        this.builder.advanceLexer();
    }

    protected void parseInterfaceNoMarker(@NotNull PsiBuilder.Marker clazz) {
        if (clazz == null) {
            StatementParser.$$$reportNull$$$0(2);
        }
        clazz.drop();
        if (!this.parseExpressionStatement()) {
            this.builder.error("statement expected");
            this.builder.advanceLexer();
        }
    }

    public void parseReferenceList(IElementType doneToken) {
        PsiBuilder.Marker referenceList = this.builder.mark();
        this.builder.advanceLexer();
        if (this.parseReferenceListMember()) {
            while (this.builder.getTokenType() == JSElementTypes.COMMA) {
                this.builder.advanceLexer();
                if (!this.isIdentifierToken(this.builder.getTokenType())) {
                    this.builder.error("type name expected");
                } else if (this.parseReferenceListMember()) continue;
                break;
            }
        } else {
            this.builder.error("type name expected");
        }
        referenceList.done(doneToken);
    }

    protected boolean parseReferenceListMember() {
        PsiBuilder.Marker startRefMember = this.builder.mark();
        boolean result2 = this.myJavaScriptParser.getExpressionParser().parseQualifiedTypeName();
        if (result2) {
            startRefMember.done((IElementType)JSElementTypes.EXTENDS_LIST_MEMBER);
        } else {
            startRefMember.drop();
        }
        return result2;
    }

    private void parseTryStatement() {
        LOG.assertTrue(this.builder.getTokenType() == JSElementTypes.TRY_KEYWORD);
        PsiBuilder.Marker statement = this.builder.mark();
        this.builder.advanceLexer();
        this.parseBlock();
        while (this.builder.getTokenType() == JSElementTypes.CATCH_KEYWORD) {
            this.parseCatchBlock();
        }
        if (this.builder.getTokenType() == JSElementTypes.FINALLY_KEYWORD) {
            this.builder.advanceLexer();
            this.parseBlock();
        }
        statement.done(JSElementTypes.TRY_STATEMENT);
    }

    private void parseCatchBlock() {
        LOG.assertTrue(this.builder.getTokenType() == JSElementTypes.CATCH_KEYWORD);
        PsiBuilder.Marker block = this.builder.mark();
        this.builder.advanceLexer();
        if (this.builder.getTokenType() == JSElementTypes.LPAR) {
            this.builder.advanceLexer();
            IElementType identifierType = this.builder.getTokenType();
            IElementType parameterElementType = this.myJavaScriptParser.getFunctionParser().getParameterType();
            if (this.myJavaScriptParser.getFunctionParser().willParseDestructuringAssignment()) {
                this.myJavaScriptParser.getExpressionParser().parseDestructuringElement(parameterElementType, false, false);
            } else if (this.isIdentifierToken(identifierType)) {
                PsiBuilder.Marker param = this.builder.mark();
                this.builder.advanceLexer();
                if (!this.myJavaScriptParser.getTypeParser().tryParseType() && this.builder.getTokenType() == JSElementTypes.IF_KEYWORD) {
                    this.builder.advanceLexer();
                    StatementParser.checkMatches(this.builder, identifierType, "identifier expected");
                    StatementParser.checkMatches(this.builder, JSElementTypes.INSTANCEOF_KEYWORD, "'instanceof' expected");
                    StatementParser.checkMatches(this.builder, JSElementTypes.IDENTIFIER, "identifier expected");
                }
                param.done(parameterElementType);
            } else {
                this.builder.error("parameter name expected");
            }
            StatementParser.checkMatches(this.builder, JSElementTypes.RPAR, ") expected");
        }
        this.parseBlock();
        block.done(JSElementTypes.CATCH_BLOCK);
    }

    private void parseThrowStatement() {
        LOG.assertTrue(this.builder.getTokenType() == JSElementTypes.THROW_KEYWORD);
        PsiBuilder.Marker statement = this.builder.mark();
        this.builder.advanceLexer();
        if (!StatementParser.hasSemanticLinefeedBefore(this.builder)) {
            this.myJavaScriptParser.getExpressionParser().parseExpression();
            this.checkForSemicolon();
        } else {
            this.builder.error("expression expected");
        }
        statement.done(JSElementTypes.THROW_STATEMENT);
    }

    private void parseSwitchStatement() {
        LOG.assertTrue(this.builder.getTokenType() == JSElementTypes.SWITCH_KEYWORD);
        PsiBuilder.Marker statement = this.builder.mark();
        this.builder.advanceLexer();
        StatementParser.checkMatches(this.builder, JSElementTypes.LPAR, "( expected");
        this.myJavaScriptParser.getExpressionParser().parseExpression();
        StatementParser.checkMatches(this.builder, JSElementTypes.RPAR, ") expected");
        boolean hadLBrace = StatementParser.checkMatches(this.builder, JSElementTypes.LBRACE, "{ expected");
        while (this.builder.getTokenType() != JSElementTypes.RBRACE) {
            if (this.builder.eof()) {
                this.builder.error("unexpected end of file");
                statement.done(JSElementTypes.SWITCH_STATEMENT);
                return;
            }
            this.parseCaseOrDefaultClause();
        }
        if (hadLBrace) {
            this.builder.advanceLexer();
        }
        statement.done(JSElementTypes.SWITCH_STATEMENT);
    }

    private void parseCaseOrDefaultClause() {
        IElementType token;
        IElementType firstToken = this.builder.getTokenType();
        PsiBuilder.Marker clause = this.builder.mark();
        if (firstToken != JSElementTypes.CASE_KEYWORD && firstToken != JSElementTypes.DEFAULT_KEYWORD) {
            this.builder.error("catch or default expected");
        }
        this.builder.advanceLexer();
        if (firstToken == JSElementTypes.CASE_KEYWORD) {
            this.myJavaScriptParser.getExpressionParser().parseExpression();
        }
        StatementParser.checkMatches(this.builder, JSElementTypes.COLON, ": expected");
        while ((token = this.builder.getTokenType()) != null && token != JSElementTypes.CASE_KEYWORD && token != JSElementTypes.DEFAULT_KEYWORD && token != JSElementTypes.RBRACE) {
            this.parseStatement();
        }
        clause.done(JSElementTypes.CASE_CLAUSE);
    }

    private void parseWithStatement() {
        LOG.assertTrue(this.builder.getTokenType() == JSElementTypes.WITH_KEYWORD);
        PsiBuilder.Marker statement = this.builder.mark();
        this.builder.advanceLexer();
        StatementParser.checkMatches(this.builder, JSElementTypes.LPAR, "( expected");
        this.myJavaScriptParser.getExpressionParser().parseExpression();
        StatementParser.checkMatches(this.builder, JSElementTypes.RPAR, ") expected");
        this.parseStatement();
        statement.done(JSElementTypes.WITH_STATEMENT);
    }

    private void parseReturnStatement() {
        LOG.assertTrue(this.builder.getTokenType() == JSElementTypes.RETURN_KEYWORD);
        PsiBuilder.Marker statement = this.builder.mark();
        this.builder.advanceLexer();
        boolean hasNewLine = StatementParser.hasSemanticLinefeedBefore(this.builder);
        if (!hasNewLine) {
            this.myJavaScriptParser.getExpressionParser().parseExpressionOptional();
        }
        this.forceCheckForSemicolon();
        statement.done((IElementType)JSElementTypes.RETURN_STATEMENT);
    }

    private void parseBreakStatement() {
        LOG.assertTrue(this.builder.getTokenType() == JSElementTypes.BREAK_KEYWORD);
        this.parseBreakAndContinue(JSElementTypes.BREAK_STATEMENT);
    }

    private void parseContinueStatement() {
        LOG.assertTrue(this.builder.getTokenType() == JSElementTypes.CONTINUE_KEYWORD);
        this.parseBreakAndContinue(JSElementTypes.CONTINUE_STATEMENT);
    }

    private void parseBreakAndContinue(@NotNull IElementType elementType) {
        if (elementType == null) {
            StatementParser.$$$reportNull$$$0(3);
        }
        PsiBuilder.Marker statement = this.builder.mark();
        this.builder.advanceLexer();
        if (!StatementParser.hasSemanticLinefeedBefore(this.builder) && this.isIdentifierToken(this.builder.getTokenType())) {
            this.builder.advanceLexer();
        }
        this.forceCheckForSemicolon();
        statement.done(elementType);
    }

    private void parseIterationStatement() {
        IElementType tokenType = this.builder.getTokenType();
        if (tokenType == JSElementTypes.DO_KEYWORD) {
            this.parseDoWhileStatement();
        } else if (tokenType == JSElementTypes.WHILE_KEYWORD) {
            this.parseWhileStatement();
        } else if (tokenType == JSElementTypes.FOR_KEYWORD) {
            this.parseForStatement();
        } else {
            LOG.error("Unknown iteration statement");
        }
    }

    private void parseForStatement() {
        LOG.assertTrue(this.builder.getTokenType() == JSElementTypes.FOR_KEYWORD);
        PsiBuilder.Marker statement = this.builder.mark();
        boolean forin = this.parseForLoopHeader();
        this.parseStatement();
        statement.done(forin ? JSElementTypes.FOR_IN_STATEMENT : JSElementTypes.FOR_STATEMENT);
    }

    public boolean parseForLoopHeader() {
        boolean hasEach;
        LOG.assertTrue(this.builder.getTokenType() == JSElementTypes.FOR_KEYWORD);
        this.builder.advanceLexer();
        boolean bl = hasEach = this.builder.getTokenType() == JSElementTypes.EACH_KEYWORD;
        if (hasEach) {
            this.builder.advanceLexer();
        }
        return this.parseForLoopHeaderCondition();
    }

    protected boolean parseForLoopHeaderCondition() {
        boolean empty;
        StatementParser.checkMatches(this.builder, JSElementTypes.LPAR, "( expected");
        if (JSElementTypes.VAR_MODIFIERS.contains(this.builder.getTokenType())) {
            this.parseVarStatementNoMarker(true, this.startAttributeListOwner());
            empty = false;
        } else {
            empty = !this.myJavaScriptParser.getExpressionParser().parseExpressionOptional(false, false);
        }
        boolean forInOrOf = false;
        if (this.builder.getTokenType() == JSElementTypes.SEMICOLON) {
            this.builder.advanceLexer();
            this.myJavaScriptParser.getExpressionParser().parseExpressionOptional();
            if (this.builder.getTokenType() == JSElementTypes.SEMICOLON) {
                this.builder.advanceLexer();
            } else {
                this.builder.error("; expected");
            }
            this.myJavaScriptParser.getExpressionParser().parseExpressionOptional();
        } else if (this.builder.getTokenType() == JSElementTypes.IN_KEYWORD || this.builder.getTokenType() == JSElementTypes.OF_KEYWORD) {
            forInOrOf = true;
            if (empty) {
                this.builder.error("left hand side expression or variable declaration expected before 'in'");
            }
            this.builder.advanceLexer();
            this.myJavaScriptParser.getExpressionParser().parseExpression();
        } else {
            this.builder.error("'in' or ; expected");
        }
        StatementParser.checkMatches(this.builder, JSElementTypes.RPAR, ") expected");
        return forInOrOf;
    }

    private void parseWhileStatement() {
        LOG.assertTrue(this.builder.getTokenType() == JSElementTypes.WHILE_KEYWORD);
        PsiBuilder.Marker statement = this.builder.mark();
        this.builder.advanceLexer();
        StatementParser.checkMatches(this.builder, JSElementTypes.LPAR, "( expected");
        this.myJavaScriptParser.getExpressionParser().parseExpression();
        StatementParser.checkMatches(this.builder, JSElementTypes.RPAR, ") expected");
        this.parseStatement();
        statement.done(JSElementTypes.WHILE_STATEMENT);
    }

    private void parseDoWhileStatement() {
        LOG.assertTrue(this.builder.getTokenType() == JSElementTypes.DO_KEYWORD);
        PsiBuilder.Marker statement = this.builder.mark();
        this.builder.advanceLexer();
        this.parseStatement();
        StatementParser.checkMatches(this.builder, JSElementTypes.WHILE_KEYWORD, "while expected");
        StatementParser.checkMatches(this.builder, JSElementTypes.LPAR, "( expected");
        this.myJavaScriptParser.getExpressionParser().parseExpression();
        StatementParser.checkMatches(this.builder, JSElementTypes.RPAR, ") expected");
        this.checkForSemicolon();
        statement.done(JSElementTypes.DOWHILE_STATEMENT);
    }

    private void parseIfStatement() {
        PsiBuilder.Marker ifStatement;
        ArrayList<PsiBuilder.Marker> ifMarkers;
        block5: {
            ifMarkers = null;
            while (true) {
                LOG.assertTrue(this.builder.getTokenType() == JSElementTypes.IF_KEYWORD);
                ifStatement = this.builder.mark();
                this.parseIfStatementHeader();
                this.parseStatement();
                if (this.builder.getTokenType() != JSElementTypes.ELSE_KEYWORD) break block5;
                this.builder.advanceLexer();
                if (this.builder.getTokenType() != JSElementTypes.IF_KEYWORD) break;
                if (ifMarkers == null) {
                    ifMarkers = new ArrayList<PsiBuilder.Marker>();
                }
                if (ifMarkers.size() < 100) {
                    ifMarkers.add(ifStatement);
                    continue;
                }
                ifStatement.drop();
            }
            this.parseStatement();
        }
        ifStatement.done(JSElementTypes.IF_STATEMENT);
        if (ifMarkers != null) {
            for (int i2 = ifMarkers.size() - 1; i2 >= 0; --i2) {
                ((PsiBuilder.Marker)ifMarkers.get(i2)).done(JSElementTypes.IF_STATEMENT);
            }
        }
    }

    public void parseIfStatementHeader() {
        LOG.assertTrue(this.builder.getTokenType() == JSElementTypes.IF_KEYWORD);
        this.builder.advanceLexer();
        StatementParser.checkMatches(this.builder, JSElementTypes.LPAR, "( expected");
        this.myJavaScriptParser.getExpressionParser().parseExpression();
        while (this.builder.getTokenType() == JSElementTypes.OROR || this.builder.getTokenType() == JSElementTypes.EQEQ) {
            this.builder.advanceLexer();
        }
        StatementParser.checkMatches(this.builder, JSElementTypes.RPAR, ") expected");
    }

    protected void parseEmptyStatement() {
        LOG.assertTrue(this.builder.getTokenType() == JSElementTypes.SEMICOLON);
        PsiBuilder.Marker statement = this.builder.mark();
        this.builder.advanceLexer();
        statement.done(JSElementTypes.EMPTY_STATEMENT);
    }

    protected void parseVarStatementNoMarker(boolean inForInitializationContext, @NotNull PsiBuilder.Marker var) {
        if (var == null) {
            StatementParser.$$$reportNull$$$0(4);
        }
        IElementType declType = this.builder.getTokenType();
        LOG.assertTrue(JSElementTypes.VAR_MODIFIERS.contains(declType));
        if (this.builder.getUserData(withinInterfaceKey) != null) {
            this.builder.error("Interface should have no variable declarations");
        }
        this.builder.advanceLexer();
        this.parseVarList(inForInitializationContext);
        if (!inForInitializationContext) {
            this.forceCheckForSemicolon();
        }
        var.done((IElementType)JSElementTypes.VAR_STATEMENT);
        var.setCustomEdgeTokenBinders(INCLUDE_DOC_COMMENT_AT_LEFT, WhitespacesBinders.DEFAULT_RIGHT_BINDER);
    }

    protected void parseVarList(boolean inForInitializationContext) {
        boolean first2 = true;
        do {
            if (first2) {
                first2 = false;
            } else {
                StatementParser.checkMatches(this.builder, JSElementTypes.COMMA, ", expected");
            }
            this.parseVarDeclaration(!inForInitializationContext);
        } while (this.builder.getTokenType() == JSElementTypes.COMMA);
    }

    public boolean checkForSemicolon() {
        IElementType tokenType = this.builder.getTokenType();
        if (tokenType == JSElementTypes.SEMICOLON) {
            this.builder.advanceLexer();
            return true;
        }
        return false;
    }

    public void forceCheckForSemicolon() {
        boolean b = this.checkForSemicolon();
        if (!b && !StatementParser.hasSemanticLinefeedBefore(this.builder)) {
            this.builder.error("Expecting newline or semicolon");
        }
    }

    public void parseVarDeclaration(boolean allowIn) {
        if (this.myJavaScriptParser.getFunctionParser().willParseDestructuringAssignment()) {
            this.myJavaScriptParser.getExpressionParser().parseDestructuringElement(this.getVariableElementType(), true, false);
            return;
        }
        PsiBuilder.Marker var = this.builder.mark();
        if (!this.parseVarName(var)) {
            return;
        }
        this.myJavaScriptParser.getTypeParser().tryParseType();
        if (this.builder.getTokenType() == JSElementTypes.EQ) {
            this.parseVariableInitializer(allowIn);
        }
        var.done(this.getVariableElementType());
        var.setCustomEdgeTokenBinders(INCLUDE_DOC_COMMENT_AT_LEFT, WhitespacesBinders.DEFAULT_RIGHT_BINDER);
    }

    public IElementType getVariableElementType() {
        return JSElementTypes.VARIABLE;
    }

    protected boolean parseVarName(PsiBuilder.Marker var) {
        if (!this.isIdentifierToken(this.builder.getTokenType())) {
            this.builder.error("variable name expected");
            this.builder.advanceLexer();
            var.drop();
            return false;
        }
        this.builder.advanceLexer();
        return true;
    }

    protected void parseVariableInitializer(boolean allowIn) {
        LOG.assertTrue(this.builder.getTokenType() == JSElementTypes.EQ);
        this.builder.advanceLexer();
        if (!this.myJavaScriptParser.getExpressionParser().parseAssignmentExpression(allowIn)) {
            this.builder.error("expression expected");
        }
    }

    public void parseBlock() {
        this.parseBlockOrFunctionBody(BlockType.BLOCK);
    }

    public boolean parseFunctionBody() {
        return this.parseBlockOrFunctionBody(BlockType.FUNCTION_BODY);
    }

    protected boolean checkIdentifier() {
        if (this.isIdentifierToken(this.builder.getTokenType())) {
            this.builder.advanceLexer();
            return true;
        }
        this.builder.error("identifier expected");
        return false;
    }

    protected boolean checkIdentifierName() {
        IElementType type = this.builder.getTokenType();
        if (JSElementTypes.IDENTIFIER_NAMES.contains(type)) {
            this.builder.advanceLexer();
            return true;
        }
        this.builder.error("name expected");
        return false;
    }

    protected void parseES6FromDeclaration() {
        if (this.builder.getTokenType() != JSElementTypes.FROM_KEYWORD) {
            this.builder.error("'from' expected");
            return;
        }
        PsiBuilder.Marker marker = this.builder.mark();
        this.builder.advanceLexer();
        if (!JSElementTypes.STRING_LITERALS.contains(this.builder.getTokenType())) {
            this.builder.error("string literal expected");
            marker.done((IElementType)JSElementTypes.FROM_CLAUSE);
            return;
        }
        String literalError = ExpressionParser.validateLiteralText(this.builder.getTokenText());
        this.builder.advanceLexer();
        if (literalError != null) {
            this.builder.error(literalError);
        }
        marker.done((IElementType)JSElementTypes.FROM_CLAUSE);
    }

    protected boolean tryParseES6ExportStatement() {
        return this.tryParseES6ExportStatement(this.builder.mark());
    }

    protected boolean tryParseES6ExportStatement(PsiBuilder.Marker marker) {
        LOG.assertTrue(this.builder.getTokenType() == JSElementTypes.EXPORT_KEYWORD);
        IElementType lookAhead = this.builder.lookAhead(1);
        if (lookAhead == JSElementTypes.MULT || lookAhead == JSElementTypes.LBRACE || this.isExportDefaultBinding()) {
            this.builder.advanceLexer();
            this.parseES6ExportDeclarationBody(marker);
            return true;
        }
        if (lookAhead == JSElementTypes.DEFAULT_KEYWORD) {
            this.parseES6ExportDefaultAssignmentNoMarker(marker);
            return true;
        }
        marker.drop();
        return false;
    }

    protected boolean isExportDefaultBinding() {
        IElementType identifier = this.builder.lookAhead(1);
        if (!this.isIdentifierToken(identifier) && identifier != JSElementTypes.DEFAULT_KEYWORD) {
            return false;
        }
        IElementType lookAhead = this.builder.lookAhead(2);
        return lookAhead == JSElementTypes.FROM_KEYWORD || lookAhead == JSElementTypes.COMMA;
    }

    protected void parseES6ImportStatement() {
        boolean needError;
        PsiBuilder.Marker marker = this.builder.mark();
        LOG.assertTrue(this.builder.getTokenType() == JSElementTypes.IMPORT_KEYWORD);
        this.builder.advanceLexer();
        if (JSElementTypes.STRING_LITERALS.contains(this.builder.getTokenType())) {
            needError = false;
            this.builder.advanceLexer();
        } else {
            if (this.builder.getTokenType() != JSElementTypes.FROM_KEYWORD || !JSElementTypes.STRING_LITERALS.contains(this.builder.lookAhead(1))) {
                needError = !this.parseES6ImportClause();
            } else {
                needError = false;
                this.builder.error("import binding or specifier expected");
            }
            this.parseES6FromDeclaration();
        }
        if (needError) {
            this.builder.error("identifier, string literal or { expected");
        }
        this.forceCheckForSemicolon();
        marker.done((IElementType)JSElementTypes.IMPORT_DECLARATION);
    }

    protected boolean parseES6ImportClause() {
        boolean parsedAnything = false;
        boolean expectedComma = false;
        if (this.isIdentifierToken(this.builder.getTokenType())) {
            parsedAnything = true;
            PsiBuilder.Marker importedBinding = this.builder.mark();
            this.builder.advanceLexer();
            importedBinding.done((IElementType)JSElementTypes.IMPORTED_BINDING);
            if (this.builder.getTokenType() == JSElementTypes.COMMA) {
                this.builder.advanceLexer();
            } else {
                expectedComma = true;
            }
        }
        if (this.builder.getTokenType() == JSElementTypes.LBRACE || this.builder.getTokenType() == JSElementTypes.MULT) {
            parsedAnything = true;
            if (expectedComma) {
                this.builder.error(", expected");
            }
            if (this.builder.getTokenType() == JSElementTypes.LBRACE) {
                PsiBuilder.Marker list = this.builder.mark();
                this.parseES6ImportOrExportNamedList(true);
                list.done((IElementType)JSElementTypes.NAMED_IMPORTS);
            } else {
                this.parseES6NamespaceImport();
            }
        }
        return parsedAnything;
    }

    protected void parseES6NamespaceImport() {
        LOG.assertTrue(this.builder.getTokenType() == JSElementTypes.MULT);
        PsiBuilder.Marker importedBinding = this.builder.mark();
        this.builder.advanceLexer();
        if (StatementParser.checkMatches(this.builder, JSElementTypes.AS_KEYWORD, "'as' expected") && this.isIdentifierToken(this.builder.getTokenType())) {
            this.builder.advanceLexer();
        }
        importedBinding.done((IElementType)JSElementTypes.IMPORTED_BINDING);
    }

    protected void parseES6ImportOrExportNamedList(boolean isImportClause) {
        PsiBuilder.Marker marker = this.builder.mark();
        if (!this.tryParseES6ImportOrExportNamedList(isImportClause, false)) {
            marker.rollbackTo();
            this.tryParseES6ImportOrExportNamedList(isImportClause, true);
        } else {
            marker.drop();
        }
    }

    private boolean tryParseES6ImportOrExportNamedList(boolean isImportClause, boolean stopOnFirstError) {
        assert (this.builder.getTokenType() == JSElementTypes.LBRACE);
        this.builder.advanceLexer();
        while (true) {
            if (this.builder.getTokenType() == JSElementTypes.RBRACE) {
                this.builder.advanceLexer();
                break;
            }
            if (this.builder.getTokenType() == JSElementTypes.COMMA) {
                this.builder.error("import specifier expected");
                this.builder.advanceLexer();
                continue;
            }
            this.advanceIfAt();
            if (!this.parseES6ImportOrExportSpecifier(isImportClause, this.builder.mark(), stopOnFirstError)) {
                return false;
            }
            IElementType nextToken = this.builder.getTokenType();
            if (nextToken == JSElementTypes.COMMA) {
                this.builder.advanceLexer();
                continue;
            }
            if (nextToken == JSElementTypes.RBRACE) continue;
            if (stopOnFirstError) {
                this.builder.error(", or } expected");
                break;
            }
            this.builder.error(", expected");
        }
        return true;
    }

    protected boolean parseES6ImportOrExportSpecifier(boolean isImport, @NotNull PsiBuilder.Marker marker, boolean stopOnFirstError) {
        IElementType firstToken;
        if (marker == null) {
            StatementParser.$$$reportNull$$$0(5);
        }
        if (JSElementTypes.IDENTIFIER_NAMES.contains(firstToken = this.builder.getTokenType())) {
            boolean aliasRequired;
            boolean bl = aliasRequired = !this.isIdentifierToken(firstToken) && firstToken != JSElementTypes.DEFAULT_KEYWORD;
            if (stopOnFirstError && aliasRequired && this.builder.lookAhead(1) != JSElementTypes.AS_KEYWORD) {
                marker.drop();
                this.builder.error("name expected");
                return false;
            }
            this.builder.advanceLexer();
            if (this.builder.getTokenType() == JSElementTypes.AS_KEYWORD) {
                PsiBuilder.Marker alias = this.builder.mark();
                this.builder.advanceLexer();
                this.advanceIfAt();
                if (isImport) {
                    this.checkIdentifier();
                } else {
                    this.checkIdentifierName();
                }
                alias.done((IElementType)(isImport ? JSElementTypes.IMPORT_SPECIFIER_ALIAS : JSElementTypes.EXPORT_SPECIFIER_ALIAS));
            } else if (aliasRequired) {
                this.builder.error("'as' expected");
            }
            marker.done((IElementType)(isImport ? JSElementTypes.IMPORT_SPECIFIER : JSElementTypes.EXPORT_SPECIFIER));
            marker.setCustomEdgeTokenBinders(INCLUDE_DOC_COMMENT_AT_LEFT, WhitespacesBinders.DEFAULT_RIGHT_BINDER);
            return true;
        }
        marker.drop();
        this.builder.error("name expected");
        return false;
    }

    private void advanceIfAt() {
        if (this.builder.getTokenType() == JSElementTypes.AT && JSElementTypes.IDENTIFIER_NAMES.contains(this.builder.lookAhead(1))) {
            this.builder.advanceLexer();
        }
    }

    protected void parseES6ExportDeclarationBody(PsiBuilder.Marker exportDeclaration) {
        boolean isFromRequired = false;
        boolean isNextElementRequired = true;
        if (JSElementTypes.IDENTIFIER_NAMES.contains(this.builder.getTokenType())) {
            PsiBuilder.Marker exportedDefaultBinding = this.builder.mark();
            this.builder.advanceLexer();
            exportedDefaultBinding.done((IElementType)JSElementTypes.EXPORTED_DEFAULT_BINDING);
            isFromRequired = true;
            if (this.builder.getTokenType() == JSElementTypes.COMMA) {
                this.builder.advanceLexer();
            } else {
                isNextElementRequired = false;
            }
        }
        if (this.builder.getTokenType() == JSElementTypes.MULT) {
            isFromRequired = true;
            if (this.isNamespaceExport()) {
                PsiBuilder.Marker namespaceExport = this.builder.mark();
                this.builder.advanceLexer();
                this.builder.advanceLexer();
                this.checkIdentifierName();
                namespaceExport.done(JSElementTypes.NAMESPACE_EXPORT);
            } else {
                this.builder.advanceLexer();
            }
        } else if (this.builder.getTokenType() == JSElementTypes.LBRACE) {
            this.parseES6ImportOrExportNamedList(false);
        } else if (isNextElementRequired) {
            this.builder.error("* or { expected");
        }
        if (isFromRequired || this.builder.getTokenType() == JSElementTypes.FROM_KEYWORD) {
            this.parseES6FromDeclaration();
        }
        this.forceCheckForSemicolon();
        exportDeclaration.done((IElementType)JSElementTypes.EXPORT_DECLARATION);
    }

    protected boolean isNamespaceExport() {
        return this.builder.lookAhead(1) == JSElementTypes.AS_KEYWORD;
    }

    private void parseES6ExportDefaultAssignmentNoMarker(PsiBuilder.Marker marker) {
        LOG.assertTrue(this.builder.getTokenType() == JSElementTypes.EXPORT_KEYWORD);
        this.builder.advanceLexer();
        LOG.assertTrue(this.builder.getTokenType() == JSElementTypes.DEFAULT_KEYWORD);
        this.builder.advanceLexer();
        this.parseES6ExportDefaultAssignmentBody();
        this.forceCheckForSemicolon();
        marker.done((IElementType)JSElementTypes.EXPORT_DEFAULT_ASSIGNMENT);
        marker.setCustomEdgeTokenBinders(INCLUDE_DOC_COMMENT_AT_LEFT, WhitespacesBinders.DEFAULT_RIGHT_BINDER);
    }

    protected void parseES6ExportDefaultAssignmentBody() {
        if (this.builder.getTokenType() == JSElementTypes.CLASS_KEYWORD) {
            PsiBuilder.Marker classMarker = this.builder.mark();
            PsiBuilder.Marker modifierList = this.builder.mark();
            modifierList.done(this.myJavaScriptParser.getFunctionParser().getAttributeListElementType());
            this.parseClassNoMarker(classMarker, true, true);
        } else if (this.builder.getTokenType() == JSElementTypes.FUNCTION_KEYWORD) {
            this.myJavaScriptParser.getFunctionParser().parseFunctionExpression();
        } else {
            this.myJavaScriptParser.getExpressionParser().parseAssignmentExpression(false);
        }
    }

    protected boolean parseBlockOrFunctionBody(@NotNull BlockType type) {
        if (type == null) {
            StatementParser.$$$reportNull$$$0(6);
        }
        if (type == BlockType.PACKAGE_OR_CLASS_BODY) {
            if (this.builder.getTokenType() != JSElementTypes.LBRACE) {
                this.builder.error("{ expected");
                return false;
            }
            this.builder.advanceLexer();
            while (this.builder.getTokenType() != JSElementTypes.RBRACE) {
                if (this.builder.eof()) {
                    this.builder.error("missing }");
                    return false;
                }
                this.parsePackageBodyStatement();
            }
            this.builder.advanceLexer();
            return true;
        }
        return this.parseBlockBodyDeeply(type);
    }

    public boolean parseBlockBodyDeeply(@NotNull BlockType type) {
        if (type == null) {
            StatementParser.$$$reportNull$$$0(7);
        }
        if (this.builder.getTokenType() != JSElementTypes.LBRACE) {
            this.builder.error("{ expected");
            return false;
        }
        this.builder.advanceLexer();
        boolean rBraceFound = false;
        while (!this.builder.eof()) {
            if (this.builder.getTokenType() == JSElementTypes.RBRACE) {
                this.builder.advanceLexer();
                rBraceFound = true;
                break;
            }
            if (type == BlockType.FUNCTION_BODY || type == BlockType.ARROW_FUNCTION_BODY) {
                this.parseSourceElement();
                continue;
            }
            assert (type == BlockType.BLOCK);
            this.parseStatement();
        }
        if (!rBraceFound) {
            this.builder.error("missing }");
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clazz";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "decoratorMark";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementType";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "var";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "marker";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
        }
        objectArray2[1] = "com/intellij/sql/dialects/mongo/js/StatementParser";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "parseClassOrInterfaceNoMarker";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "parseES6DecoratorDeclaration";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "parseInterfaceNoMarker";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "parseBreakAndContinue";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "parseVarStatementNoMarker";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "parseES6ImportOrExportSpecifier";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "parseBlockOrFunctionBody";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "parseBlockBodyDeeply";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static enum BlockType {
        FUNCTION_BODY,
        ARROW_FUNCTION_BODY,
        BLOCK,
        PACKAGE_OR_CLASS_BODY;

    }
}

