/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.dialects.generic;

import com.intellij.lang.Language;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.sql.dialects.generic.GenericDialect;
import com.intellij.sql.dialects.generic.GenericSqlCodeStyleMainPanel;
import com.intellij.sql.dialects.sql92.Sql92Dialect;
import com.intellij.sql.formatter.settings.SqlCodeStyleMainPanel;
import com.intellij.sql.formatter.settings.SqlCodeStyleSettings;
import com.intellij.sql.formatter.settings.SqlCodeStyleSettingsUtil;
import com.intellij.sql.formatter.settings.SqlCodeStyles;
import com.intellij.sql.formatter.settings.SqlLanguageCodeStyleSettingsProvider;
import com.intellij.sql.psi.SqlLanguage;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GenericCodeStyleSettingsProvider
extends SqlLanguageCodeStyleSettingsProvider {
    public GenericCodeStyleSettingsProvider() {
        super((Language)SqlLanguage.INSTANCE, SqlCodeStyleSettings.class);
    }

    @Nullable
    public String getLanguageName() {
        return "General";
    }

    public SqlCodeStyleSettings createCustomSettings(CodeStyleSettings settingsContainer) {
        return new SqlCodeStyleSettings("Sql", settingsContainer);
    }

    public List<Language> getApplicableLanguages() {
        return SqlCodeStyles.getSettingsDialects().filter(d -> d != SqlLanguage.INSTANCE).filter(Language.class).toList();
    }

    @Nullable
    public PsiFile createFileFromText(Project project, String text) {
        return SqlCodeStyleSettingsUtil.createSqlFileForCodeStyleSettingsPreview((Project)project, (String)text, (SqlLanguageDialect)Sql92Dialect.INSTANCE);
    }

    @NotNull
    protected SqlCodeStyleMainPanel createSettingsPanel(CodeStyleSettings theSettings, CodeStyleSettings currentSettings) {
        return new GenericSqlCodeStyleMainPanel(currentSettings, theSettings);
    }

    static {
        SqlCodeStyles.registerGenericDialect((SqlLanguageDialect)GenericDialect.INSTANCE, (SqlLanguageDialect)Sql92Dialect.INSTANCE);
    }
}

