/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.snowflake.model;

import com.intellij.database.dialects.snowflake.model.SFlakeRoutineArgument;
import com.intellij.database.dialects.snowflake.model.SFlakeSchema;
import com.intellij.database.dialects.snowflake.model.SFlakeSourceAware;
import com.intellij.database.model.DasRoutine;
import com.intellij.database.model.ModelConsts;
import com.intellij.database.model.NameValueConsumer;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicModElement;
import com.intellij.database.model.basic.BasicModMajorObject;
import com.intellij.database.model.basic.BasicModRoutine;
import com.intellij.database.model.basic.BasicOverloadable;
import com.intellij.database.model.families.ModFamily;
import com.intellij.database.model.families.ModPositioningNamingFamily;
import com.intellij.database.model.families.NamingFamily;
import com.intellij.database.model.meta.BasicMetaProperty;
import com.intellij.database.model.meta.BasicMetaType;
import com.intellij.database.model.properties.PropertyConverter;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface SFlakeRoutine
extends SFlakeSourceAware,
BasicModMajorObject,
BasicOverloadable,
BasicModRoutine {
    public static final BasicMetaProperty<DasRoutine.Kind> ROUTINE_KIND = BasicMetaProperty.create((String)"RoutineKind", (BasicMetaType)BasicMetaType.Types.DAS_ROUTINE_KIND, (Object)DasRoutine.Kind.NONE, SFlakeRoutine.class, (boolean)false);
    public static final BasicMetaProperty<String> LANGUAGE = BasicMetaProperty.create((String)"Language", (BasicMetaType)BasicMetaType.Types.STRING, null, SFlakeRoutine.class, (boolean)false);
    public static final BasicMetaProperty<Boolean> SECURE = BasicMetaProperty.create((String)"Secure", (BasicMetaType)BasicMetaType.Types.BOOLEAN, (Object)false, SFlakeRoutine.class, (boolean)false);
    public static final BasicMetaProperty<Boolean> IMMUTABLE = BasicMetaProperty.create((String)"Immutable", (BasicMetaType)BasicMetaType.Types.BOOLEAN, (Object)true, SFlakeRoutine.class, (boolean)false);
    public static final BasicMetaProperty<Boolean> CALLED_ON_NULL = BasicMetaProperty.create((String)"CalledOnNull", (BasicMetaType)BasicMetaType.Types.BOOLEAN, (Object)false, SFlakeRoutine.class, (boolean)false);
    public static final BasicMetaProperty<Boolean> EXECUTE_AS_OWNER = BasicMetaProperty.create((String)"ExecuteAsOwner", (BasicMetaType)BasicMetaType.Types.BOOLEAN, (Object)false, SFlakeRoutine.class, (boolean)false);

    @Nullable
    default public SFlakeSchema getSchema() {
        return this.getParent();
    }

    @Nullable
    public SFlakeSchema getParent();

    default public @Nullable NamingFamily<@NotNull ? extends SFlakeRoutine> getParentFamily() {
        return null;
    }

    @NotNull
    public @NotNull ModPositioningNamingFamily<@NotNull ? extends SFlakeRoutineArgument> getArguments();

    @NotNull
    default public List<ObjectKind> getFamilyKinds() {
        List<ObjectKind> list = Collections.singletonList(ObjectKind.ARGUMENT);
        if (list == null) {
            SFlakeRoutine.$$$reportNull$$$0(0);
        }
        return list;
    }

    @NotNull
    default public List<? extends ModFamily<? extends BasicModElement>> getFamilies() {
        List<ModPositioningNamingFamily<? extends SFlakeRoutineArgument>> list = Collections.singletonList(this.getArguments());
        if (list == null) {
            SFlakeRoutine.$$$reportNull$$$0(1);
        }
        return list;
    }

    @Nullable
    public String getComment();

    @Nullable
    public String getLanguage();

    public boolean isSecure();

    public boolean isImmutable();

    public boolean isCalledOnNull();

    public boolean isExecuteAsOwner();

    default public void exportProperties(@NotNull NameValueConsumer<String> consumer) {
        boolean executeAsOwner;
        boolean calledOnNull;
        boolean immutable;
        boolean secure;
        String language;
        DasRoutine.Kind routineKind;
        int sourceTextLength;
        boolean outdated;
        String comment;
        boolean nameQuoted;
        boolean nameScripted;
        boolean nameSurrogate;
        String name2;
        if (consumer == null) {
            SFlakeRoutine.$$$reportNull$$$0(2);
        }
        if ((name2 = this.getName()) != null && name2 != ModelConsts.NO_NAME) {
            consumer.accept("Name", (Object)PropertyConverter.export((String)name2));
        }
        if (nameSurrogate = this.isNameSurrogate()) {
            consumer.accept("NameSurrogate", (Object)PropertyConverter.export((boolean)nameSurrogate));
        }
        if (nameScripted = this.isNameScripted()) {
            consumer.accept("NameScripted", (Object)PropertyConverter.export((boolean)nameScripted));
        }
        if (nameQuoted = this.isNameQuoted()) {
            consumer.accept("NameQuoted", (Object)PropertyConverter.export((boolean)nameQuoted));
        }
        if ((comment = this.getComment()) != null) {
            consumer.accept("Comment", (Object)PropertyConverter.export((String)comment));
        }
        if (outdated = this.isOutdated()) {
            consumer.accept("Outdated", (Object)PropertyConverter.export((boolean)outdated));
        }
        if ((sourceTextLength = this.getSourceTextLength()) != 0) {
            consumer.accept("SourceTextLength", (Object)PropertyConverter.export((int)sourceTextLength));
        }
        if ((routineKind = this.getRoutineKind()) != null && routineKind != DasRoutine.Kind.NONE) {
            consumer.accept("RoutineKind", (Object)PropertyConverter.export((Enum)routineKind));
        }
        if ((language = this.getLanguage()) != null) {
            consumer.accept("Language", (Object)PropertyConverter.export((String)language));
        }
        if (secure = this.isSecure()) {
            consumer.accept("Secure", (Object)PropertyConverter.export((boolean)secure));
        }
        if (!(immutable = this.isImmutable())) {
            consumer.accept("Immutable", (Object)PropertyConverter.export((boolean)immutable));
        }
        if (calledOnNull = this.isCalledOnNull()) {
            consumer.accept("CalledOnNull", (Object)PropertyConverter.export((boolean)calledOnNull));
        }
        if (executeAsOwner = this.isExecuteAsOwner()) {
            consumer.accept("ExecuteAsOwner", (Object)PropertyConverter.export((boolean)executeAsOwner));
        }
    }

    public void setRoutineKind(@NotNull DasRoutine.Kind var1);

    public void setLanguage(@Nullable String var1);

    public void setSecure(boolean var1);

    public void setImmutable(boolean var1);

    public void setCalledOnNull(boolean var1);

    public void setExecuteAsOwner(boolean var1);

    default public void importProperties(@NotNull Map<String, String> _properties) {
        if (_properties == null) {
            SFlakeRoutine.$$$reportNull$$$0(3);
        }
        String name2 = _properties.get("Name");
        String nameSurrogate = _properties.get("NameSurrogate");
        String nameScripted = _properties.get("NameScripted");
        String nameQuoted = _properties.get("NameQuoted");
        String comment = _properties.get("Comment");
        String outdated = _properties.get("Outdated");
        String sourceTextLength = _properties.get("SourceTextLength");
        String routineKind = _properties.get("RoutineKind");
        String language = _properties.get("Language");
        String secure = _properties.get("Secure");
        String immutable = _properties.get("Immutable");
        String calledOnNull = _properties.get("CalledOnNull");
        String executeAsOwner = _properties.get("ExecuteAsOwner");
        this.setName(name2 != null ? PropertyConverter.importString((String)name2) : ModelConsts.NO_NAME);
        this.setNameSurrogate(nameSurrogate != null ? PropertyConverter.importBoolean((String)nameSurrogate) : false);
        this.setNameScripted(nameScripted != null ? PropertyConverter.importBoolean((String)nameScripted) : false);
        this.setNameQuoted(nameQuoted != null ? PropertyConverter.importBoolean((String)nameQuoted) : false);
        this.setComment(comment != null ? PropertyConverter.importString((String)comment) : null);
        this.setOutdated(outdated != null ? PropertyConverter.importBoolean((String)outdated) : false);
        this.setSourceTextLength(sourceTextLength != null ? PropertyConverter.importInt((String)sourceTextLength) : 0);
        this.setRoutineKind(routineKind != null ? PropertyConverter.importDasRoutineKind((String)routineKind) : DasRoutine.Kind.NONE);
        this.setLanguage(language != null ? PropertyConverter.importString((String)language) : null);
        this.setSecure(secure != null ? PropertyConverter.importBoolean((String)secure) : false);
        this.setImmutable(immutable != null ? PropertyConverter.importBoolean((String)immutable) : true);
        this.setCalledOnNull(calledOnNull != null ? PropertyConverter.importBoolean((String)calledOnNull) : false);
        this.setExecuteAsOwner(executeAsOwner != null ? PropertyConverter.importBoolean((String)executeAsOwner) : false);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dialects/snowflake/model/SFlakeRoutine";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "_properties";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyKinds";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilies";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dialects/snowflake/model/SFlakeRoutine";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "exportProperties";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "importProperties";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

