/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.postgresgreenplumbase.model;

import com.intellij.database.dialects.postgresgreenplumbase.model.PgGPlumBaseDatabase;
import com.intellij.database.dialects.postgresgreenplumbase.model.PgGPlumBaseRoutine;
import com.intellij.database.dialects.postgresgreenplumbase.model.PgGPlumBaseSchema;
import com.intellij.database.dialects.postgresgreenplumbase.model.PgGPlumBaseSequence;
import com.intellij.database.dialects.postgresgreenplumbase.model.PgGPlumBaseTable;
import com.intellij.database.dialects.postgresgreenplumbase.model.PgGPlumBaseTableColumn;
import com.intellij.database.dialects.postgresgreenplumbase.model.PgGPlumBaseTrigger;
import com.intellij.database.model.CasingProvider;
import com.intellij.database.model.DataType;
import com.intellij.database.model.basic.BasicDatabase;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicSchema;
import com.intellij.database.util.DasUtil;
import com.intellij.openapi.util.Condition;
import java.util.Set;
import java.util.function.Predicate;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=2, d1={"\u0000D\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u000e\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000b\u001a\u0012\u0010\f\u001a\u00020\r*\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010\u001a\n\u0010\u0011\u001a\u00020\u0006*\u00020\u0001\u001a\f\u0010\u0012\u001a\u0004\u0018\u00010\u0013*\u00020\u0014\u001a\n\u0010\u0015\u001a\u00020\u0016*\u00020\u0017\u001a\n\u0010\u0018\u001a\u00020\u0016*\u00020\u0001\"\u0017\u0010\u0000\u001a\u0004\u0018\u00010\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0004\"\u0017\u0010\u0005\u001a\u0004\u0018\u00010\u0006*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0019"}, d2={"callRoutine", "Lcom/intellij/database/dialects/postgresgreenplumbase/model/PgGPlumBaseRoutine;", "Lcom/intellij/database/dialects/postgresgreenplumbase/model/PgGPlumBaseTrigger;", "getCallRoutine", "(Lcom/intellij/database/dialects/postgresgreenplumbase/model/PgGPlumBaseTrigger;)Lcom/intellij/database/dialects/postgresgreenplumbase/model/PgGPlumBaseRoutine;", "callRoutineName", "", "getCallRoutineName", "(Lcom/intellij/database/dialects/postgresgreenplumbase/model/PgGPlumBaseTrigger;)Ljava/lang/String;", "pgFloatToString", "f", "", "addSuccessor", "", "Lcom/intellij/database/dialects/postgresgreenplumbase/model/PgGPlumBaseTable;", "id", "", "costAsString", "getSchemaOfDataType", "Lcom/intellij/database/dialects/postgresgreenplumbase/model/PgGPlumBaseSchema;", "Lcom/intellij/database/dialects/postgresgreenplumbase/model/PgGPlumBaseTableColumn;", "hasDefaultCacheSize", "", "Lcom/intellij/database/dialects/postgresgreenplumbase/model/PgGPlumBaseSequence;", "isCostDefined", "intellij.database.dialects.postgresgreenplumbase"})
@JvmName(name="PgGPlumBaseUtil")
public final class PgGPlumBaseUtil {
    public static final void addSuccessor(@NotNull PgGPlumBaseTable $this$addSuccessor, long id) {
        Intrinsics.checkParameterIsNotNull((Object)$this$addSuccessor, (String)"$this$addSuccessor");
        Set<Long> set = $this$addSuccessor.getSuccessorIds();
        Intrinsics.checkExpressionValueIsNotNull(set, (String)"this.successorIds");
        Set<Long> ids = set;
        if (!ids.contains(id)) {
            $this$addSuccessor.setSuccessorIds(SetsKt.plus(ids, (Object)id));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isCostDefined(@NotNull PgGPlumBaseRoutine $this$isCostDefined) {
        Intrinsics.checkParameterIsNotNull((Object)$this$isCostDefined, (String)"$this$isCostDefined");
        if (Float.compare($this$isCostDefined.getCost(), 0.0f) == 0) return false;
        if (StringsKt.equals((String)$this$isCostDefined.getLanguageName(), (String)"c", (boolean)true)) {
            if (Float.compare($this$isCostDefined.getCost(), 1.0f) == 0) return false;
            return true;
        }
        if (Float.compare($this$isCostDefined.getCost(), 100) == 0) return false;
        return true;
    }

    @NotNull
    public static final String costAsString(@NotNull PgGPlumBaseRoutine $this$costAsString) {
        Intrinsics.checkParameterIsNotNull((Object)$this$costAsString, (String)"$this$costAsString");
        return PgGPlumBaseUtil.pgFloatToString($this$costAsString.getCost());
    }

    public static final boolean hasDefaultCacheSize(@NotNull PgGPlumBaseSequence $this$hasDefaultCacheSize) {
        Intrinsics.checkParameterIsNotNull((Object)$this$hasDefaultCacheSize, (String)"$this$hasDefaultCacheSize");
        long l = $this$hasDefaultCacheSize.getCacheSize();
        return 0L <= l && 1L >= l;
    }

    @Nullable
    public static final PgGPlumBaseSchema getSchemaOfDataType(@NotNull PgGPlumBaseTableColumn $this$getSchemaOfDataType) {
        BasicSchema basicSchema;
        Intrinsics.checkParameterIsNotNull((Object)$this$getSchemaOfDataType, (String)"$this$getSchemaOfDataType");
        DataType dataType = $this$getSchemaOfDataType.getDataType();
        Intrinsics.checkExpressionValueIsNotNull((Object)dataType, (String)"dataType");
        DataType type = dataType;
        if (type.schemaName == null) {
            return $this$getSchemaOfDataType.getSchema();
        }
        String string = type.schemaName;
        CasingProvider casingProvider = BasicElement.getCasingProvider((BasicElement)((BasicElement)$this$getSchemaOfDataType));
        if (casingProvider == null) {
            casingProvider = DasUtil.NO_CASING_PROVIDER;
        }
        Condition condition = DasUtil.byName((String)string, (CasingProvider)casingProvider);
        Intrinsics.checkExpressionValueIsNotNull((Object)condition, (String)"DasUtil.byName<DasObject\u2026sUtil.NO_CASING_PROVIDER)");
        Condition nameCondition = condition;
        BasicDatabase basicDatabase = $this$getSchemaOfDataType.getDatabase();
        if (!((basicDatabase != null && (basicDatabase = basicDatabase.getSchemas()) != null ? (BasicSchema)basicDatabase.find((Predicate)new Predicate<BasicSchema>(nameCondition){
            final /* synthetic */ Condition $nameCondition;

            public final boolean test(BasicSchema it) {
                return this.$nameCondition.value((Object)it);
            }
            {
                this.$nameCondition = condition;
            }
        }) : (basicSchema = null)) instanceof PgGPlumBaseSchema)) {
            basicSchema = null;
        }
        return (PgGPlumBaseSchema)basicSchema;
    }

    @NotNull
    public static final String pgFloatToString(float f) {
        float f2 = f;
        boolean bl = false;
        return Float.isInfinite(f2) ? "infinity" : String.valueOf((long)f);
    }

    @Nullable
    public static final PgGPlumBaseRoutine getCallRoutine(@NotNull PgGPlumBaseTrigger $this$callRoutine) {
        PgGPlumBaseDatabase database;
        Intrinsics.checkParameterIsNotNull((Object)$this$callRoutine, (String)"$this$callRoutine");
        long id = $this$callRoutine.getCallRoutineId();
        if (id == 0L) {
            return null;
        }
        PgGPlumBaseSchema pgGPlumBaseSchema = $this$callRoutine.getSchema();
        if (pgGPlumBaseSchema == null) {
            return null;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)pgGPlumBaseSchema, (String)"schema ?: return null");
        PgGPlumBaseSchema schema = pgGPlumBaseSchema;
        PgGPlumBaseRoutine routine = (PgGPlumBaseRoutine)schema.getRoutines().getByObjectId(id);
        if (routine == null && (database = schema.getDatabase()) != null) {
            for (PgGPlumBaseSchema s : database.getSchemas()) {
                if (s == schema) continue;
                PgGPlumBaseSchema pgGPlumBaseSchema2 = s;
                Intrinsics.checkExpressionValueIsNotNull((Object)pgGPlumBaseSchema2, (String)"s");
                routine = (PgGPlumBaseRoutine)pgGPlumBaseSchema2.getRoutines().getByObjectId(id);
                if (routine == null) continue;
                break;
            }
        }
        return routine;
    }

    @Nullable
    public static final String getCallRoutineName(@NotNull PgGPlumBaseTrigger $this$callRoutineName) {
        Intrinsics.checkParameterIsNotNull((Object)$this$callRoutineName, (String)"$this$callRoutineName");
        PgGPlumBaseRoutine pgGPlumBaseRoutine = PgGPlumBaseUtil.getCallRoutine($this$callRoutineName);
        return pgGPlumBaseRoutine != null ? pgGPlumBaseRoutine.getName() : null;
    }
}

