/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.oracle.model;

import com.intellij.database.dialects.oracle.model.OraBody;
import com.intellij.database.dialects.oracle.model.OraPackage;
import com.intellij.database.dialects.oracle.model.OraSchema;
import com.intellij.database.model.NameValueConsumer;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicModElement;
import com.intellij.database.model.families.ModFamily;
import com.intellij.database.model.families.SingletonFamily;
import com.intellij.database.model.properties.PropertyConverter;
import com.intellij.database.model.properties.SourceError;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface OraPackageBody
extends OraBody {
    @Nullable
    default public OraPackage getPackage() {
        return this.getParent();
    }

    @Nullable
    public OraPackage getParent();

    @Nullable
    default public OraPackage getMajorObject() {
        return this.getPackage();
    }

    default public @Nullable SingletonFamily<@NotNull ? extends OraPackageBody> getParentFamily() {
        return null;
    }

    @Nullable
    public OraSchema getSchema();

    @NotNull
    default public List<ObjectKind> getFamilyKinds() {
        List<ObjectKind> list = Collections.emptyList();
        if (list == null) {
            OraPackageBody.$$$reportNull$$$0(0);
        }
        return list;
    }

    @NotNull
    default public List<? extends ModFamily<? extends BasicModElement>> getFamilies() {
        List list = Collections.emptyList();
        if (list == null) {
            OraPackageBody.$$$reportNull$$$0(1);
        }
        return list;
    }

    @Override
    @NotNull
    public List<SourceError> getErrors();

    @Override
    @NotNull
    public Set<Long> getDependsOnIds();

    default public void exportProperties(@NotNull NameValueConsumer<String> consumer) {
        Date modifiedTimestamp;
        Date createdTimestamp;
        Set<Long> dependsOnIds;
        boolean withDebugInfo;
        boolean obfuscated;
        boolean invalid;
        List<SourceError> errors;
        int sourceTextLength;
        boolean outdated;
        long objectId;
        if (consumer == null) {
            OraPackageBody.$$$reportNull$$$0(2);
        }
        if ((objectId = this.getObjectId()) != Long.MIN_VALUE) {
            consumer.accept("ObjectId", (Object)PropertyConverter.export((long)objectId));
        }
        if (outdated = this.isOutdated()) {
            consumer.accept("Outdated", (Object)PropertyConverter.export((boolean)outdated));
        }
        if ((sourceTextLength = this.getSourceTextLength()) != 0) {
            consumer.accept("SourceTextLength", (Object)PropertyConverter.export((int)sourceTextLength));
        }
        if (!(errors = this.getErrors()).isEmpty()) {
            consumer.accept("Errors", (Object)PropertyConverter.exportListOfSourceError(errors));
        }
        if (invalid = this.isInvalid()) {
            consumer.accept("Invalid", (Object)PropertyConverter.export((boolean)invalid));
        }
        if (obfuscated = this.isObfuscated()) {
            consumer.accept("Obfuscated", (Object)PropertyConverter.export((boolean)obfuscated));
        }
        if (withDebugInfo = this.isWithDebugInfo()) {
            consumer.accept("WithDebugInfo", (Object)PropertyConverter.export((boolean)withDebugInfo));
        }
        if (!(dependsOnIds = this.getDependsOnIds()).isEmpty()) {
            consumer.accept("DependsOnIds", (Object)PropertyConverter.exportSetOfLong(dependsOnIds));
        }
        if ((createdTimestamp = this.getCreatedTimestamp()) != null) {
            consumer.accept("CreatedTimestamp", (Object)PropertyConverter.export((Date)createdTimestamp));
        }
        if ((modifiedTimestamp = this.getModifiedTimestamp()) != null) {
            consumer.accept("ModifiedTimestamp", (Object)PropertyConverter.export((Date)modifiedTimestamp));
        }
    }

    @Override
    public void setErrors(@NotNull List<SourceError> var1);

    @Override
    default public void setErrors(SourceError ... errors) {
        this.setErrors(Arrays.asList(errors));
    }

    @Override
    public void setDependsOnIds(@NotNull Set<Long> var1);

    default public void importProperties(@NotNull Map<String, String> _properties) {
        if (_properties == null) {
            OraPackageBody.$$$reportNull$$$0(3);
        }
        String objectId = _properties.get("ObjectId");
        String outdated = _properties.get("Outdated");
        String sourceTextLength = _properties.get("SourceTextLength");
        String errors = _properties.get("Errors");
        String invalid = _properties.get("Invalid");
        String obfuscated = _properties.get("Obfuscated");
        String withDebugInfo = _properties.get("WithDebugInfo");
        String dependsOnIds = _properties.get("DependsOnIds");
        String createdTimestamp = _properties.get("CreatedTimestamp");
        String modifiedTimestamp = _properties.get("ModifiedTimestamp");
        this.setObjectId(objectId != null ? PropertyConverter.importLong((String)objectId) : Long.MIN_VALUE);
        this.setOutdated(outdated != null ? PropertyConverter.importBoolean((String)outdated) : false);
        this.setSourceTextLength(sourceTextLength != null ? PropertyConverter.importInt((String)sourceTextLength) : 0);
        this.setErrors(errors != null ? PropertyConverter.importListOfSourceError((String)errors) : Collections.emptyList());
        this.setInvalid(invalid != null ? PropertyConverter.importBoolean((String)invalid) : false);
        this.setObfuscated(obfuscated != null ? PropertyConverter.importBoolean((String)obfuscated) : false);
        this.setWithDebugInfo(withDebugInfo != null ? PropertyConverter.importBoolean((String)withDebugInfo) : false);
        this.setDependsOnIds(dependsOnIds != null ? PropertyConverter.importSetOfLong((String)dependsOnIds) : Collections.emptySet());
        this.setCreatedTimestamp(createdTimestamp != null ? PropertyConverter.importDate((String)createdTimestamp) : null);
        this.setModifiedTimestamp(modifiedTimestamp != null ? PropertyConverter.importDate((String)modifiedTimestamp) : null);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dialects/oracle/model/OraPackageBody";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "_properties";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyKinds";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilies";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dialects/oracle/model/OraPackageBody";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "exportProperties";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "importProperties";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

