/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.mysql;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.dataSource.DataSourceConfigurable;
import com.intellij.database.dataSource.DataSourceUiUtil;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dialects.DatabaseErrorHandler;
import com.intellij.database.dialects.mysqlbase.MysqlBaseErrorHandler;
import com.intellij.database.view.ui.DatabaseConfigEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.ui.TableUtil;
import com.intellij.ui.table.TableView;
import com.intellij.util.Consumer;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.util.regex.Pattern;
import javax.swing.JComponent;
import javax.swing.JTable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MysqlErrorHandler
extends MysqlBaseErrorHandler {
    private static final Pattern UNRECOGNIZED_TIME_ZONE = Pattern.compile("The server time zone value '.*' is unrecognized");

    @Override
    @NotNull
    public String getErrorMessage(@Nullable LocalDataSource dataSource, @NotNull Throwable original, @NotNull Throwable cause, @Nullable Consumer<? super DatabaseErrorHandler.Fix> fixes) {
        String message;
        if (original == null) {
            MysqlErrorHandler.$$$reportNull$$$0(0);
        }
        if (cause == null) {
            MysqlErrorHandler.$$$reportNull$$$0(1);
        }
        if ((message = cause.getMessage()) != null) {
            if (UNRECOGNIZED_TIME_ZONE.matcher(message).find()) {
                String string = DatabaseBundle.message((String)"error.message.mysql.invalid.timezone", (Object[])new Object[0]);
                if (string == null) {
                    MysqlErrorHandler.$$$reportNull$$$0(2);
                }
                return string;
            }
            if (message.contains("javax.net.ssl.SSLHandshakeException") && message.contains("protocol_version")) {
                if (fixes != null && dataSource != null) {
                    fixes.consume((Object)new TlsVersionFix(dataSource));
                }
                String string = message + "\n" + DatabaseBundle.message((String)"error.message.mysql.tls.protocol.version", (Object[])new Object[0]);
                if (string == null) {
                    MysqlErrorHandler.$$$reportNull$$$0(3);
                }
                return string;
            }
        }
        String string = super.getErrorMessage(dataSource, original, cause, fixes);
        if (string == null) {
            MysqlErrorHandler.$$$reportNull$$$0(4);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "original";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cause";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dialects/mysql/MysqlErrorHandler";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dialects/mysql/MysqlErrorHandler";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getErrorMessage";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getErrorMessage";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class TlsVersionFix
    implements DatabaseErrorHandler.Fix {
        private final LocalDataSource myDataSource;
        private static final String TLS_PROTOCOLS = "enabledTLSProtocols";

        TlsVersionFix(LocalDataSource dataSource) {
            if (dataSource == null) {
                TlsVersionFix.$$$reportNull$$$0(0);
            }
            this.myDataSource = dataSource;
        }

        public String getName() {
            return this.areProtocolsSet() ? "Enable all protocols" : "Remove protocol list";
        }

        private boolean areProtocolsSet() {
            return StringUtil.isEmptyOrSpaces((String)((String)this.myDataSource.getDriverProperties().get(TLS_PROTOCOLS)));
        }

        public boolean isSilent() {
            return false;
        }

        public void apply(@Nullable DatabaseConfigEditor editor) {
            if (editor == null) {
                return;
            }
            DataSourceUiUtil.modify((DatabaseConfigEditor)editor, (LocalDataSource)this.myDataSource, ds -> {
                if (this.areProtocolsSet()) {
                    ds.getDriverProperties().put(TLS_PROTOCOLS, "TLSv1, TLSv1.1, TLSv1.2, TLSv1.3");
                } else {
                    ds.getDriverProperties().remove(TLS_PROTOCOLS);
                }
            }).doWhenDone(() -> {
                DataSourceConfigurable configurable = (DataSourceConfigurable)editor.getConfigurable((Object)this.myDataSource, false, DataSourceConfigurable.class);
                if (configurable == null) {
                    MysqlErrorHandler.this.LOG.warn("Unable to find configurable");
                    return;
                }
                JComponent panel2 = configurable.selectAdvancedPanel();
                IdeFocusManager.getInstance((Project)configurable.getProject()).doWhenFocusSettlesDown(() -> {
                    TableView props = (TableView)UIUtil.uiTraverser((Component)panel2).filter(TableView.class).first();
                    if (props != null) {
                        for (int i2 = 0; i2 < props.getRowCount(); ++i2) {
                            if (!TLS_PROTOCOLS.equals(props.getModel().getValueAt(i2, 0))) continue;
                            props.setRowSelectionInterval(i2, i2);
                            TableUtil.scrollSelectionToVisible((JTable)props);
                            break;
                        }
                    }
                });
            });
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataSource", "com/intellij/database/dialects/mysql/MysqlErrorHandler$TlsVersionFix", "<init>"));
        }
    }
}

