/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.mssql.plan;

import com.intellij.database.dialects.base.plan.AbstractXmlPlanModelBuilder;
import com.intellij.database.dialects.mssql.plan.MsRawPlanData;
import com.intellij.database.plan.PlanModel;
import com.intellij.database.plan.PlanRetrievalException;
import com.intellij.openapi.util.Pair;
import com.intellij.util.ObjectUtils;
import java.io.IOException;
import java.io.StringReader;
import java.math.BigDecimal;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPathExpression;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class MsPlanModelBuilder
extends AbstractXmlPlanModelBuilder<MsRawPlanData, Element> {
    private static final Map<String, PlanModel.NodeType> LOGICAL_MAPPING = new HashMap<String, PlanModel.NodeType>();
    private static final Map<Pair<PlanModel.NodeType, String>, PlanModel.NodeType> PHYSICAL_MAPPING = new HashMap<Pair<PlanModel.NodeType, String>, PlanModel.NodeType>();
    private static final Map<String, PlanModel.NodeType> STATEMENT_MAPPING = new HashMap<String, PlanModel.NodeType>();
    private final XPathExpression STATEMENTS_QUERY = this.compileXPath("//Statements/StmtSimple");
    private final XPathExpression FIRST_OP_QUERY = this.compileXPath("QueryPlan/RelOp");
    private final XPathExpression ACCESS_OBJECT_QUERY = this.compileXPath("*/Object");
    private final XPathExpression RUNTIME_QUERY = this.compileXPath("RunTimeInformation/RunTimeCountersPerThread");
    private final XPathExpression SUB_OPS_QUERY = this.compileXPath("*/RelOp");

    public MsPlanModelBuilder() {
        super(EnumSet.of(PlanModel.Feature.STARTUP_COST));
    }

    @Override
    @NotNull
    public MsRawPlanData createData() {
        return new MsRawPlanData();
    }

    @Override
    protected void parseData() {
        this.parseXmls(((MsRawPlanData)this.myData).xmls);
    }

    private void parseXmls(@NotNull List<String> xmls) {
        if (xmls == null) {
            MsPlanModelBuilder.$$$reportNull$$$0(0);
        }
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = dbf.newDocumentBuilder();
            this.openNode(null);
            for (String xml : xmls) {
                Document doc = builder.parse(new InputSource(new StringReader(xml)));
                NodeList statements2 = MsPlanModelBuilder.queryElements(this.STATEMENTS_QUERY, doc.getDocumentElement());
                if (statements2.getLength() == 0) continue;
                for (int i2 = 0; i2 < statements2.getLength(); ++i2) {
                    Element statement = (Element)statements2.item(i2);
                    this.parseStatement(statement);
                }
            }
            this.closeNode(new PlanModel.GenericNode(PlanModel.NodeType.ROOT, null));
        }
        catch (ParserConfigurationException e) {
            throw new PlanRetrievalException("Failed to configure XML parser", (Throwable)e);
        }
        catch (SAXException e) {
            throw new PlanRetrievalException("Failed to parse XML", (Throwable)e);
        }
        catch (IOException e) {
            throw new PlanRetrievalException("Failed to parse XML", (Throwable)e);
        }
    }

    @Override
    @NotNull
    protected String parseRawDescription(final @NotNull Element element) {
        if (element == null) {
            MsPlanModelBuilder.$$$reportNull$$$0(1);
        }
        String string = new Object(){
            final StringBuilder sb = new StringBuilder();
            {
                this.visit("", element);
            }

            void visit(String prefix, Element el) {
                int i2;
                NamedNodeMap attributes2 = el.getAttributes();
                for (i2 = 0; i2 < attributes2.getLength(); ++i2) {
                    Attr attr = (Attr)attributes2.item(i2);
                    this.sb.append(prefix).append(attr.getName()).append(" = ").append(attr.getValue()).append(";\n");
                }
                for (i2 = 0; i2 < el.getChildNodes().getLength(); ++i2) {
                    Element child = (Element)ObjectUtils.tryCast((Object)el.getChildNodes().item(i2), Element.class);
                    if (child == null || "RelOp".equals(child.getTagName()) || "OutputList".equals(child.getTagName()) || "DefinedValues".equals(child.getTagName())) continue;
                    this.visit(prefix + child.getTagName() + ".", child);
                }
            }
        }.sb.toString();
        if (string == null) {
            MsPlanModelBuilder.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Override
    @Nullable
    protected String parseAccessRelation(@NotNull Element element) {
        Element obj2;
        if (element == null) {
            MsPlanModelBuilder.$$$reportNull$$$0(3);
        }
        if ((obj2 = MsPlanModelBuilder.queryElement(this.ACCESS_OBJECT_QUERY, element)) == null) {
            this.unsupportedFormat();
        }
        return obj2.getAttribute("Schema") + "." + obj2.getAttribute("Table");
    }

    @Override
    @Nullable
    protected BigDecimal parsePlanNumRows(@NotNull Element element) {
        if (element == null) {
            MsPlanModelBuilder.$$$reportNull$$$0(4);
        }
        try {
            if ("RelOp".equals(element.getTagName())) {
                return new BigDecimal(element.getAttribute("EstimateRows"));
            }
            return new BigDecimal(element.getAttribute("StatementEstRows"));
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    @Override
    @Nullable
    protected String parseAccessIndex(@NotNull Element element) {
        Element obj2;
        if (element == null) {
            MsPlanModelBuilder.$$$reportNull$$$0(5);
        }
        if ((obj2 = MsPlanModelBuilder.queryElement(this.ACCESS_OBJECT_QUERY, element)) == null) {
            this.unsupportedFormat();
        }
        return obj2.getAttribute("Index");
    }

    @Override
    protected void parsePlan(@NotNull Element state2) {
        if (state2 == null) {
            MsPlanModelBuilder.$$$reportNull$$$0(6);
        }
        this.openNode(null);
        this.parseSubPlans(state2);
        String logOp = state2.getAttribute("LogicalOp");
        String phyOp = state2.getAttribute("PhysicalOp");
        PlanModel.NodeType type = LOGICAL_MAPPING.get(logOp);
        type = (PlanModel.NodeType)ObjectUtils.chooseNotNull((Object)PHYSICAL_MAPPING.get(Pair.create((Object)type, (Object)phyOp)), (Object)type);
        if (type == null) {
            type = PlanModel.NodeType.UNKNOWN;
        }
        String text = phyOp.equals(logOp) ? phyOp : logOp + " - " + phyOp;
        PlanModel.GenericNode node = this.createNode(state2, type, text);
        this.closeNode(node);
    }

    @Override
    protected void parseSubPlans(@NotNull Element element) {
        if (element == null) {
            MsPlanModelBuilder.$$$reportNull$$$0(7);
        }
        NodeList sub = MsPlanModelBuilder.queryElements(this.SUB_OPS_QUERY, element);
        for (int i2 = 0; i2 < sub.getLength(); ++i2) {
            this.parsePlan((Element)sub.item(i2));
        }
    }

    @Override
    protected void parseStatement(@NotNull Element element) {
        String stmtType;
        PlanModel.NodeType type;
        if (element == null) {
            MsPlanModelBuilder.$$$reportNull$$$0(8);
        }
        this.openNode(null);
        Element plan = this.querySingleElement(this.FIRST_OP_QUERY, element);
        if (plan != null) {
            this.parsePlan(plan);
        }
        if ((type = STATEMENT_MAPPING.get(stmtType = element.getAttribute("StatementType"))) == null) {
            type = PlanModel.NodeType.STATEMENT;
        }
        this.closeNode(this.createNode(element, type, type == PlanModel.NodeType.STATEMENT ? stmtType : null));
    }

    @Override
    @Nullable
    protected Double parseTotalCost(@NotNull Element element) {
        if (element == null) {
            MsPlanModelBuilder.$$$reportNull$$$0(9);
        }
        try {
            if ("RelOp".equals(element.getTagName())) {
                return Double.valueOf(element.getAttribute("EstimatedTotalSubtreeCost"));
            }
            return Double.valueOf(element.getAttribute("StatementSubTreeCost"));
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    @Override
    protected void parseActualInfo(@NotNull Element element, @NotNull PlanModel.GenericNode node) {
        String elapsed;
        Element runtime;
        if (element == null) {
            MsPlanModelBuilder.$$$reportNull$$$0(10);
        }
        if (node == null) {
            MsPlanModelBuilder.$$$reportNull$$$0(11);
        }
        if ((runtime = this.querySingleElement(this.RUNTIME_QUERY, element)) != null) {
            this.myActual = true;
        }
        node.setActualTotalTime((elapsed = MsPlanModelBuilder.getAttr(runtime, "ActualElapsedms")) == null ? null : Double.valueOf(Double.parseDouble(elapsed)));
        node.setActualStartupTime(null);
        String rows = MsPlanModelBuilder.getAttr(runtime, "ActualRows");
        node.setActualNumRows(rows == null ? null : new BigDecimal(rows));
    }

    @Override
    @Nullable
    protected Double parseStartupCost(@NotNull Element element) {
        if (element == null) {
            MsPlanModelBuilder.$$$reportNull$$$0(12);
        }
        return null;
    }

    @Override
    protected boolean parseSubqueryCorrelated(@NotNull Element element) {
        if (element == null) {
            MsPlanModelBuilder.$$$reportNull$$$0(13);
        }
        return false;
    }

    @Override
    protected boolean parseSubqueryScalar(@NotNull Element element) {
        if (element == null) {
            MsPlanModelBuilder.$$$reportNull$$$0(14);
        }
        return false;
    }

    static {
        LOGICAL_MAPPING.put("Aggregate", PlanModel.NodeType.AGGREGATE);
        LOGICAL_MAPPING.put("Assert", PlanModel.NodeType.OPERATION);
        LOGICAL_MAPPING.put("Async Concat", PlanModel.NodeType.UNION_ALL);
        LOGICAL_MAPPING.put("Batch Hash Table Build", PlanModel.NodeType.TRANSFORM);
        LOGICAL_MAPPING.put("Bitmap Create", PlanModel.NodeType.TRANSFORM);
        LOGICAL_MAPPING.put("Clustered Index Scan", PlanModel.NodeType.FULL_INDEX_SCAN);
        LOGICAL_MAPPING.put("Clustered Index Seek", PlanModel.NodeType.INDEX_SCAN);
        LOGICAL_MAPPING.put("Clustered Update", PlanModel.NodeType.UNKNOWN);
        LOGICAL_MAPPING.put("Collapse", PlanModel.NodeType.TRANSFORM);
        LOGICAL_MAPPING.put("Compute Scalar", PlanModel.NodeType.VALUE);
        LOGICAL_MAPPING.put("Concatenation", PlanModel.NodeType.UNION_ALL);
        LOGICAL_MAPPING.put("Constant Scan", PlanModel.NodeType.VALUE);
        LOGICAL_MAPPING.put("Cross Join", PlanModel.NodeType.NESTED_LOOPS);
        LOGICAL_MAPPING.put("Delete", PlanModel.NodeType.STATEMENT);
        LOGICAL_MAPPING.put("Deleted Scan", PlanModel.NodeType.ACCESS);
        LOGICAL_MAPPING.put("Distinct Sort", PlanModel.NodeType.SORT_UNIQUE);
        LOGICAL_MAPPING.put("Distinct", PlanModel.NodeType.UNIQUE);
        LOGICAL_MAPPING.put("Distribute Streams", PlanModel.NodeType.TRANSFORM);
        LOGICAL_MAPPING.put("Eager Spool", PlanModel.NodeType.TEMPORARY);
        LOGICAL_MAPPING.put("Filter", PlanModel.NodeType.FILTER);
        LOGICAL_MAPPING.put("Flow Distinct", PlanModel.NodeType.UNIQUE);
        LOGICAL_MAPPING.put("Full Outer Join", PlanModel.NodeType.JOIN);
        LOGICAL_MAPPING.put("Gather Streams", PlanModel.NodeType.TRANSFORM);
        LOGICAL_MAPPING.put("Generic", PlanModel.NodeType.UNKNOWN);
        LOGICAL_MAPPING.put("Index Scan", PlanModel.NodeType.FULL_INDEX_SCAN);
        LOGICAL_MAPPING.put("Index Seek", PlanModel.NodeType.INDEX_SCAN);
        LOGICAL_MAPPING.put("Inner Join", PlanModel.NodeType.JOIN);
        LOGICAL_MAPPING.put("Insert", PlanModel.NodeType.INSERT);
        LOGICAL_MAPPING.put("Inserted Scan", PlanModel.NodeType.ACCESS);
        LOGICAL_MAPPING.put("Lazy Spool", PlanModel.NodeType.TEMPORARY);
        LOGICAL_MAPPING.put("Left Anti Semi Join", PlanModel.NodeType.JOIN);
        LOGICAL_MAPPING.put("Left Outer Join", PlanModel.NodeType.JOIN);
        LOGICAL_MAPPING.put("Left Semi Join", PlanModel.NodeType.JOIN);
        LOGICAL_MAPPING.put("Log Row Scan", PlanModel.NodeType.OPERATION);
        LOGICAL_MAPPING.put("Merge Interval", PlanModel.NodeType.TRANSFORM);
        LOGICAL_MAPPING.put("Parameter Table Scan", PlanModel.NodeType.ACCESS);
        LOGICAL_MAPPING.put("Partial Aggregate", PlanModel.NodeType.AGGREGATE);
        LOGICAL_MAPPING.put("Print", PlanModel.NodeType.UNKNOWN);
        LOGICAL_MAPPING.put("Remote Delete", PlanModel.NodeType.DELETE);
        LOGICAL_MAPPING.put("Remote Index Scan", PlanModel.NodeType.FULL_INDEX_SCAN);
        LOGICAL_MAPPING.put("Remote Index Seek", PlanModel.NodeType.INDEX_SCAN);
        LOGICAL_MAPPING.put("Remote Insert", PlanModel.NodeType.INSERT);
        LOGICAL_MAPPING.put("Remote Query", PlanModel.NodeType.SELECT);
        LOGICAL_MAPPING.put("Remote Scan", PlanModel.NodeType.SEQ_SCAN);
        LOGICAL_MAPPING.put("Remote Update", PlanModel.NodeType.UPDATE);
        LOGICAL_MAPPING.put("Repartition Streams", PlanModel.NodeType.TRANSFORM);
        LOGICAL_MAPPING.put("RID Lookup", PlanModel.NodeType.ROWID_ACCESS);
        LOGICAL_MAPPING.put("Right Anti Semi Join", PlanModel.NodeType.JOIN);
        LOGICAL_MAPPING.put("Right Outer Join", PlanModel.NodeType.JOIN);
        LOGICAL_MAPPING.put("Right Semi Join", PlanModel.NodeType.JOIN);
        LOGICAL_MAPPING.put("Segment", PlanModel.NodeType.TRANSFORM);
        LOGICAL_MAPPING.put("Sequence", PlanModel.NodeType.SEQUENTIALLY);
        LOGICAL_MAPPING.put("Sort", PlanModel.NodeType.SORT);
        LOGICAL_MAPPING.put("Split", PlanModel.NodeType.TRANSFORM);
        LOGICAL_MAPPING.put("Switch", PlanModel.NodeType.TRANSFORM);
        LOGICAL_MAPPING.put("Table-valued function", PlanModel.NodeType.TABLE_FUNCTION);
        LOGICAL_MAPPING.put("Table Scan", PlanModel.NodeType.SEQ_SCAN);
        LOGICAL_MAPPING.put("Top", PlanModel.NodeType.TRANSFORM);
        LOGICAL_MAPPING.put("TopN Sort", PlanModel.NodeType.TRANSFORM);
        LOGICAL_MAPPING.put("UDX", PlanModel.NodeType.TRANSFORM);
        LOGICAL_MAPPING.put("Union", PlanModel.NodeType.UNION);
        LOGICAL_MAPPING.put("Update", PlanModel.NodeType.UPDATE);
        LOGICAL_MAPPING.put("Merge", PlanModel.NodeType.MERGE);
        LOGICAL_MAPPING.put("Merge Stats", PlanModel.NodeType.UNKNOWN);
        LOGICAL_MAPPING.put("Local Stats", PlanModel.NodeType.UNKNOWN);
        LOGICAL_MAPPING.put("Window Spool", PlanModel.NodeType.TEMPORARY);
        PHYSICAL_MAPPING.put((Pair<PlanModel.NodeType, String>)Pair.create((Object)PlanModel.NodeType.JOIN, (Object)"Nested Loops"), PlanModel.NodeType.NESTED_LOOPS);
        PHYSICAL_MAPPING.put((Pair<PlanModel.NodeType, String>)Pair.create((Object)PlanModel.NodeType.JOIN, (Object)"Merge Join"), PlanModel.NodeType.MERGE_JOIN);
        PHYSICAL_MAPPING.put((Pair<PlanModel.NodeType, String>)Pair.create((Object)PlanModel.NodeType.JOIN, (Object)"Hash Match"), PlanModel.NodeType.HASH_JOIN);
        STATEMENT_MAPPING.put("SELECT", PlanModel.NodeType.SELECT);
        STATEMENT_MAPPING.put("MERGE", PlanModel.NodeType.MERGE);
        STATEMENT_MAPPING.put("DELETE", PlanModel.NodeType.DELETE);
        STATEMENT_MAPPING.put("INSERT", PlanModel.NodeType.INSERT);
        STATEMENT_MAPPING.put("UPDATE", PlanModel.NodeType.UPDATE);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "xmls";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dialects/mssql/plan/MsPlanModelBuilder";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dialects/mssql/plan/MsPlanModelBuilder";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "parseRawDescription";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "parseXmls";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "parseRawDescription";
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "parseAccessRelation";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "parsePlanNumRows";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "parseAccessIndex";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "parsePlan";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "parseSubPlans";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "parseStatement";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "parseTotalCost";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "parseActualInfo";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "parseStartupCost";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "parseSubqueryCorrelated";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "parseSubqueryScalar";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

