/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.mssql.model;

import com.intellij.database.dialects.mssql.model.MsExtendedPropertiesHolder;
import com.intellij.database.dialects.mssql.model.MsMixinDatabase;
import com.intellij.database.dialects.mssql.model.MsRoot;
import com.intellij.database.dialects.mssql.model.MsSchema;
import com.intellij.database.model.ModelConsts;
import com.intellij.database.model.NameValueConsumer;
import com.intellij.database.model.NameValueType;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicModElement;
import com.intellij.database.model.basic.BasicModIdentifiedElement;
import com.intellij.database.model.families.ModFamily;
import com.intellij.database.model.families.ModNamingIdentifyingFamily;
import com.intellij.database.model.families.NamingIdentifyingFamily;
import com.intellij.database.model.meta.BasicMetaProperty;
import com.intellij.database.model.meta.BasicMetaType;
import com.intellij.database.model.properties.PropertyConverter;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface MsDatabase
extends MsExtendedPropertiesHolder,
MsMixinDatabase,
BasicModIdentifiedElement {
    public static final BasicMetaProperty<Boolean> CURRENT = BasicMetaProperty.create((String)"Current", (BasicMetaType)BasicMetaType.Types.BOOLEAN, (Object)false, MsDatabase.class, (boolean)true);
    public static final BasicMetaProperty<String> COLLATION = BasicMetaProperty.create((String)"Collation", (BasicMetaType)BasicMetaType.Types.STRING, null, MsDatabase.class, (boolean)false);
    public static final BasicMetaProperty<String> FINGERPRINT = BasicMetaProperty.create((String)"Fingerprint", (BasicMetaType)BasicMetaType.Types.STRING, null, MsDatabase.class, (boolean)true);

    @Nullable
    default public MsRoot getRoot() {
        return this.getParent();
    }

    @Nullable
    public MsRoot getParent();

    default public @Nullable NamingIdentifyingFamily<@NotNull ? extends MsDatabase> getParentFamily() {
        return null;
    }

    @NotNull
    public @NotNull ModNamingIdentifyingFamily<@NotNull ? extends MsSchema> getSchemas();

    @NotNull
    default public List<ObjectKind> getFamilyKinds() {
        List<ObjectKind> list = Collections.singletonList(ObjectKind.SCHEMA);
        if (list == null) {
            MsDatabase.$$$reportNull$$$0(0);
        }
        return list;
    }

    @NotNull
    default public List<? extends ModFamily<? extends BasicModElement>> getFamilies() {
        List<ModNamingIdentifyingFamily<? extends MsSchema>> list = Collections.singletonList(this.getSchemas());
        if (list == null) {
            MsDatabase.$$$reportNull$$$0(1);
        }
        return list;
    }

    @Nullable
    public String getComment();

    @Override
    @NotNull
    public List<NameValueType> getExtendedProperties();

    @Nullable
    public String getCollation();

    @Nullable
    public String getFingerprint();

    default public void exportProperties(@NotNull NameValueConsumer<String> consumer) {
        String fingerprint;
        String collation;
        boolean current;
        List<NameValueType> extendedProperties;
        boolean outdated;
        String comment;
        boolean nameQuoted;
        boolean nameScripted;
        boolean nameSurrogate;
        String name2;
        long objectId;
        if (consumer == null) {
            MsDatabase.$$$reportNull$$$0(2);
        }
        if ((objectId = this.getObjectId()) != Long.MIN_VALUE) {
            consumer.accept("ObjectId", (Object)PropertyConverter.export((long)objectId));
        }
        if ((name2 = this.getName()) != null && name2 != ModelConsts.NO_NAME) {
            consumer.accept("Name", (Object)PropertyConverter.export((String)name2));
        }
        if (nameSurrogate = this.isNameSurrogate()) {
            consumer.accept("NameSurrogate", (Object)PropertyConverter.export((boolean)nameSurrogate));
        }
        if (nameScripted = this.isNameScripted()) {
            consumer.accept("NameScripted", (Object)PropertyConverter.export((boolean)nameScripted));
        }
        if (nameQuoted = this.isNameQuoted()) {
            consumer.accept("NameQuoted", (Object)PropertyConverter.export((boolean)nameQuoted));
        }
        if ((comment = this.getComment()) != null) {
            consumer.accept("Comment", (Object)PropertyConverter.export((String)comment));
        }
        if (outdated = this.isOutdated()) {
            consumer.accept("Outdated", (Object)PropertyConverter.export((boolean)outdated));
        }
        if (!(extendedProperties = this.getExtendedProperties()).isEmpty()) {
            consumer.accept("ExtendedProperties", (Object)PropertyConverter.exportListOfNameValueType(extendedProperties));
        }
        if (current = this.isCurrent()) {
            consumer.accept("Current", (Object)PropertyConverter.export((boolean)current));
        }
        if ((collation = this.getCollation()) != null) {
            consumer.accept("Collation", (Object)PropertyConverter.export((String)collation));
        }
        if ((fingerprint = this.getFingerprint()) != null) {
            consumer.accept("Fingerprint", (Object)PropertyConverter.export((String)fingerprint));
        }
    }

    @Override
    public void setExtendedProperties(@NotNull List<NameValueType> var1);

    @Override
    default public void setExtendedProperties(NameValueType ... extendedProperties) {
        this.setExtendedProperties(Arrays.asList(extendedProperties));
    }

    public void setCollation(@Nullable String var1);

    public void setFingerprint(@Nullable String var1);

    default public void importProperties(@NotNull Map<String, String> _properties) {
        if (_properties == null) {
            MsDatabase.$$$reportNull$$$0(3);
        }
        String objectId = _properties.get("ObjectId");
        String name2 = _properties.get("Name");
        String nameSurrogate = _properties.get("NameSurrogate");
        String nameScripted = _properties.get("NameScripted");
        String nameQuoted = _properties.get("NameQuoted");
        String comment = _properties.get("Comment");
        String outdated = _properties.get("Outdated");
        String extendedProperties = _properties.get("ExtendedProperties");
        String current = _properties.get("Current");
        String collation = _properties.get("Collation");
        String fingerprint = _properties.get("Fingerprint");
        this.setObjectId(objectId != null ? PropertyConverter.importLong((String)objectId) : Long.MIN_VALUE);
        this.setName(name2 != null ? PropertyConverter.importString((String)name2) : ModelConsts.NO_NAME);
        this.setNameSurrogate(nameSurrogate != null ? PropertyConverter.importBoolean((String)nameSurrogate) : false);
        this.setNameScripted(nameScripted != null ? PropertyConverter.importBoolean((String)nameScripted) : false);
        this.setNameQuoted(nameQuoted != null ? PropertyConverter.importBoolean((String)nameQuoted) : false);
        this.setComment(comment != null ? PropertyConverter.importString((String)comment) : null);
        this.setOutdated(outdated != null ? PropertyConverter.importBoolean((String)outdated) : false);
        this.setExtendedProperties(extendedProperties != null ? PropertyConverter.importListOfNameValueType((String)extendedProperties) : Collections.emptyList());
        this.setCurrent(current != null ? PropertyConverter.importBoolean((String)current) : false);
        this.setCollation(collation != null ? PropertyConverter.importString((String)collation) : null);
        this.setFingerprint(fingerprint != null ? PropertyConverter.importString((String)fingerprint) : null);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dialects/mssql/model/MsDatabase";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "_properties";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyKinds";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilies";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dialects/mssql/model/MsDatabase";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "exportProperties";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "importProperties";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

