/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.derby;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.Dbms;
import com.intellij.database.dataSource.DatabaseConnection;
import com.intellij.database.dialects.DialectUtils;
import com.intellij.database.dialects.base.AbstractDatabaseDialect;
import com.intellij.database.dialects.base.TypeHelper;
import com.intellij.database.model.DasDataSource;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasRoutine;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.psi.DbTable;
import com.intellij.database.util.Case;
import com.intellij.database.util.Casing;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.DdlBuilder;
import com.intellij.database.util.ObjectPath;
import com.intellij.database.util.SearchPath;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import java.sql.SQLException;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DerbyDialect
extends AbstractDatabaseDialect {
    public DerbyDialect() {
        super(new TypeHelper.DerbyTypeHelper(), Casing.create((Case)Case.UPPER, (Case)Case.EXACT));
    }

    @NotNull
    public Dbms getDbms() {
        Dbms dbms = Dbms.DERBY;
        if (dbms == null) {
            DerbyDialect.$$$reportNull$$$0(0);
        }
        return dbms;
    }

    @NotNull
    public String getDisplayName() {
        return "Derby";
    }

    @Override
    public SearchPath tryToLoadSearchPath(@NotNull DasDataSource system, @NotNull DatabaseConnection connection) throws SQLException {
        Dbms dbms;
        String s;
        if (system == null) {
            DerbyDialect.$$$reportNull$$$0(1);
        }
        if (connection == null) {
            DerbyDialect.$$$reportNull$$$0(2);
        }
        return StringUtil.isEmpty((String)(s = DbImplUtil.concatStringResults((DatabaseConnection)connection, (Dbms)(dbms = connection.getDbms()), (String)"values (current schema)", (int)1, (DbImplUtil.ConcatenationProps)DbImplUtil.ConcatenationProps.NO_CONCAT))) ? null : SearchPath.of((ObjectPath)ObjectPath.create((String)s, (ObjectKind)ObjectKind.SCHEMA));
    }

    @Override
    public String sqlSetSearchPath(@NotNull SearchPath path) {
        if (path == null) {
            DerbyDialect.$$$reportNull$$$0(3);
        }
        ObjectPath current = path.getCurrent();
        if (current.kind != ObjectKind.SCHEMA) {
            return null;
        }
        return String.format("set schema %s", this.getNamingService().nameToScript(current.getName(), false, this.getCodeStyle().getQuotesPriority()));
    }

    @NotNull
    public DdlBuilder sqlDropSequence(@NotNull DdlBuilder builder, @NotNull DasObject sequence, boolean cascade) {
        if (builder == null) {
            DerbyDialect.$$$reportNull$$$0(4);
        }
        if (sequence == null) {
            DerbyDialect.$$$reportNull$$$0(5);
        }
        throw new UnsupportedOperationException(DatabaseBundle.message((String)"ddl.error.drop.sequence", (Object[])new Object[]{this.getDisplayName()}));
    }

    public Pair<String, DbImplUtil.ConcatenationProps> sqlViewDefinition(@NotNull DasObject element) {
        if (element == null) {
            DerbyDialect.$$$reportNull$$$0(6);
        }
        return Pair.create((Object)("select v.VIEWDEFINITION from sys.SYSVIEWS v, sys.SYSTABLES t, sys.SYSSCHEMAS s where v.TABLEID = t.TABLEID and s.SCHEMAID = t.SCHEMAID and UPPER(t.TABLENAME) = '" + StringUtil.toUpperCase((String)element.getName()) + "' and UPPER(s.SCHEMANAME) = '" + StringUtil.toUpperCase((String)DasUtil.getSchema((DasObject)element)) + "'"), (Object)DbImplUtil.ConcatenationProps.NO_CONCAT);
    }

    public boolean supportsProcedureDefinition() {
        return false;
    }

    @NotNull
    public Pair<String, DbImplUtil.ConcatenationProps> sqlProcedureDefinition(@NotNull DasRoutine element) {
        if (element == null) {
            DerbyDialect.$$$reportNull$$$0(7);
        }
        throw new UnsupportedOperationException("Not supported");
    }

    public boolean supportsCommonTableExpression() {
        return false;
    }

    @Override
    public boolean supportsTableInfo() {
        return true;
    }

    @Override
    @NotNull
    public Map<String, Object> tryToLoadTableInfo(@NotNull DbTable element, @NotNull DatabaseConnection connection) throws Exception {
        if (element == null) {
            DerbyDialect.$$$reportNull$$$0(8);
        }
        if (connection == null) {
            DerbyDialect.$$$reportNull$$$0(9);
        }
        Dbms dbms = connection.getDbms();
        Map map2 = DbImplUtil.resultRowAsMap((DatabaseConnection)connection, (String)String.format("SELECT tabname, card, collationname, create_time FROM syscat.tables WHERE owner = '%s' AND tabname LIKE '%s' ESCAPE '#'", DbImplUtil.escapeStr((String)DasUtil.getSchema((DasObject)element)), DbImplUtil.escapeSql((Object)element.getName(), (boolean)true, (Dbms)dbms)), (String[])new String[]{"CARD", "rows", "COLLATIONNAME", "collation", "CREATE_TIME", "created"});
        if (map2 == null) {
            DerbyDialect.$$$reportNull$$$0(10);
        }
        return map2;
    }

    public boolean supportsViewDefinition() {
        return true;
    }

    public boolean supportsEmptyTables() {
        return false;
    }

    @Override
    public boolean supportsInsertInto() {
        return true;
    }

    @NotNull
    public DdlBuilder qualifiedIdentifier(DdlBuilder builder, @NotNull String identifier, @Nullable DasObject object, @NotNull DasObject qualifier) {
        if (identifier == null) {
            DerbyDialect.$$$reportNull$$$0(11);
        }
        if (qualifier == null) {
            DerbyDialect.$$$reportNull$$$0(12);
        }
        DasObject schema = DasUtil.getSchemaObject((DasObject)qualifier);
        DasObject catalog = DasUtil.getCatalogObject((DasObject)qualifier);
        String pkgName = qualifier instanceof DasRoutine ? ((DasRoutine)qualifier).getPackageName() : null;
        DasObject pkg = pkgName == null ? null : qualifier.getDasParent();
        DdlBuilder ddlBuilder = builder.qualifiedRef(object, identifier, schema, DasUtil.getName((DasObject)schema), catalog, DasUtil.getName((DasObject)catalog), pkg, pkgName);
        if (ddlBuilder == null) {
            DerbyDialect.$$$reportNull$$$0(13);
        }
        return ddlBuilder;
    }

    @Override
    @NotNull
    public String getBinaryLiteralString(@NotNull byte[] binaryData) {
        if (binaryData == null) {
            DerbyDialect.$$$reportNull$$$0(14);
        }
        String string = "BLOB(x'" + DialectUtils.toHexString((byte[])binaryData) + "')";
        if (string == null) {
            DerbyDialect.$$$reportNull$$$0(15);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 14: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 14: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dialects/derby/DerbyDialect";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "system";
                break;
            }
            case 2: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "connection";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sequence";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "identifier";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifier";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "binaryData";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDbms";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dialects/derby/DerbyDialect";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "tryToLoadTableInfo";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "qualifiedIdentifier";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getBinaryLiteralString";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "tryToLoadSearchPath";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "sqlSetSearchPath";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "sqlDropSequence";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "sqlViewDefinition";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "sqlProcedureDefinition";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "tryToLoadTableInfo";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "qualifiedIdentifier";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getBinaryLiteralString";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 14: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

